//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: help.h,v 1.2 2001/11/20 15:19:31 muse Exp $
//
//  (C) Copyright 1999/2000 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef HELPWINDOW_H
#define HELPWINDOW_H

#include <qtextbrowser.h>
#include "desk.h"
#include <qstringlist.h>
#include <qmap.h>
#include <qdir.h>

class QComboBox;
class QPopupMenu;
class QListBox;
class QListView;
class QListBoxItem;
class QListViewItem;
class QTabWidget;

//---------------------------------------------------------
//   HelpWindow
//---------------------------------------------------------

class HelpWindow : public MainWindow
      {
      Q_OBJECT
      bool eventFilter(QObject* o, QEvent* e);
      void readHistory();
      void readBookmarks();

      QTextBrowser* browser;
      QComboBox* pathCombo;
      int tocId;
      QString selectedURL;
      QDir path;
      QStringList fileList, bookmarks;
      QMap<int, QString> mHistory, mBookmarks;
      QPopupMenu* bookm;
      QListBox* indexList;
      QListView* contentsList;
      QListBox* bookmarkList;
      QTabWidget* tab;

   private slots:
      void bookmarkSelected(QListBoxItem*);
      void contentsSelected(QListViewItem*);
      void toggleToc(bool);
      void textChanged();
      void openFile();
      void newWindow();
      void print();

      void pathSelected(const QString &);
      void bookmChosen(int);
      void addBookmark();

   public:
      HelpWindow(const QString& home_, const QString& path, QWidget* parent = 0, const char *name=0);
      ~HelpWindow();
      };

#endif

