//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: midirawdev.h,v 1.2 2001/11/20 15:19:32 muse Exp $
//  (C) Copyright 2000 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __MIDIRAWDEV_H__
#define __MIDIRAWDEV_H__

#include "midithread.h"
#include "mididev.h"
#include "midirawin.h"

const int IO_BUFFERSIZE = 128;

//---------------------------------------------------------
//   MidiRawDevice
//---------------------------------------------------------

class MidiRawDevice : public MidiDevice, public MidiRawIn {
      unsigned runState;

      unsigned char iobuffer[IO_BUFFERSIZE];
      unsigned char* rp;
      unsigned char* wp;

      void chnEvent2(int chn, int event, int p1, int p2);
      void chnEvent1(int chn, int event, int p1);
      void put(unsigned char);
      void flush();
      void processInput();

   protected:
      virtual void realtimeSystemInput(int data);
      virtual void mtcInputQuarter(int data);
      virtual void setSongPosition(int data);
      virtual void sysexReceived(const unsigned char* p, int n);
      virtual void eventReceived(int ch, int a, int b);
      virtual int read(unsigned char*, int) = 0;
      virtual int write(const unsigned char*, int) = 0;

   public:
      MidiRawDevice() {}
      MidiRawDevice(const QString& name);
      virtual ~MidiRawDevice() {}

      virtual QString open(int) = 0;
      virtual void close() = 0;
      virtual int selectWfd() = 0;
      virtual int selectRfd() = 0;
#if 0
      virtual void noteOn(int chn, int pitch, int velocity);
      virtual void noteOff(int chn, int pitch, int velocity);
      virtual void programChange(int chn, int prg);
      virtual void setCtrl(int chan, int ctrl, int val);
      virtual void bender(int chn, int val);
      virtual void polyPressure(int chn, int velo, int pressure);
      virtual void chnPressure(int chn, int pressure);
      virtual void sysex(const unsigned char* p, int n);
#endif
      virtual void putEvent(const MidiEvent*);

      virtual void putClock();
      virtual void putStart();
      virtual void putStop();
      virtual void putContinue();
      virtual void putSongpos(int);

      bool bytesToWrite() const         { return rp != wp; }
      };

#endif

