/*
 * Multi Gnome Terminal, 
 * (C) 2000 The Free Software Foundation 
 * using 
 * Michael Zucchi's zvt widget and 
 * Gnome Terminal sources
 * (C) 1998, 1999 The Free Software Foundation
 * 
 *
 * Multi Gnome Terminal author:
 *          De Michele Cristiano
 *
 * A NOTE ABOUT MULTIGNOMETERMINAL: 
 *   MultiGnomeTerminal development was started by De Michele Cristiano 
 *   on 03/08/2001 modifying gnome-core-1.4.0.4 sources of gnome-terminal.
 * 
 * Gnome Terminal authors:
 *          Miguel de Icaza (GNOME terminal)
 *          Erik Troan      (various configuration enhancements)
 *          Michael Zucchi  (zvt widget, various updates and enhancements)
 *
 * 
 * Other contributors of gnome-terminal: George Lebl, Jeff Garzik, Jay Painter,
 * Christopher Blizzard, Jens Lautenbacher, Tom Tromey, Tristan Tarant,
 * Jonathan Blandford, Cody Russell, Nat Friedman, Jacob Berkman,
 * John Harper, and Hans-Andreas Engel
 */
#include "mgt.h"

/* In case old gnome-libs */
#ifndef ZVT_TERM_DO_LASTLOG
#   define ZVT_TERM_DO_LASTLOG 4
#endif

extern void tb_new_shell(GtkWidget* w, GSList** ptl);
extern void tb_new_root(GtkWidget* w, GSList** ptl);
extern void tb_new_mc(GtkWidget* w, GSList** ptl);
extern void tb_remove_book(GtkWidget *w, GSList** ptl);
extern void tb_change_title(GtkWidget* w, GSList** ptl);
extern void tb_tab_right(GtkWidget* w, GSList** ptl);
extern void tb_tab_left(GtkWidget* w, GSList** ptl);
extern void tb_remove_book(GtkWidget *w, GSList** ptl);
extern void tb_change_title(GtkWidget* w, GSList** ptl);
extern void ok_close_app(GtkWidget* app);
extern void free_str_array(char** ptr);
extern void edit_commands(GtkWidget* w, gpointer data);

extern ZvtTerm* current_term(GSList** p_term_list);

/* The program environment */
extern char **environ;		

/* Initial geometry */
static char *initial_global_geometry = NULL;

/* Window icon */
/*static char *window_icon = GNOME_ICONDIR"/mgt/multignometerm.png";*/

char **env;
/* is there pixmap compiled into zvt */
gboolean zvt_pixmap_support = FALSE;

/* small hack? whether they specified --login 
   or --nologin on the command line */
gboolean cmdline_login;


/* Initial command */
char **initial_command = NULL;

/* This is the terminal associated with the initial command, or NULL
   if there isn't one.  */
GtkWidget *initial_term = NULL;

/* A list of all the open terminals */
GList *terminals = 0;

int use_terminal_factory   = FALSE;
int start_terminal_factory = FALSE;

/* current new terminal window id */
static int terminal_id = 0;


/*
 * These are the indices for the toggle items in the popup menu.  If
 * you change the popup menus, these macros MUST be updated to reflect
 * the changes.
 */
#define POPUP_MENU_INDEX_COMMANDS 3 
#define POPUP_MENU_TOGGLE_INDEX_MENUBAR 6 
#define POPUP_MENU_TOGGLE_INDEX_TOOLBAR 7
#define POPUP_MENU_TOGGLE_INDEX_BUTTONBAR 8

#define POPUP_MENU_TOGGLE_INDEX_SECURE  9
/* eek, multi-conditaional for backward compatability *sigh* */
#ifdef ZVT_TERM_MATCH_SUPPORT
# ifdef HAVE_ZVT_TERM_RESET
#  define POPUP_MENU_DYNAMIC_INDEX 12
#  define POPUP_MENU_LAST_INDEX 13
# else
#  define POPUP_MENU_DYNAMIC_INDEX 10
#  define POPUP_MENU_LAST_INDEX 11
# endif
#endif

/*
 * Exported interfaces, for Gtk modules that hook
 * into the gnome terminal
 */
void close_terminal_cmd   (void *unused, GSList **p_term_list);
void save_preferences_cmd (GtkWidget *widget, GSList **p_term_list);
void color_cmd            (void);
void toggle_menubar_cmd   (GtkWidget *widget, GSList **p_term_list);
void toggle_toolbar_cmd   (GtkWidget *widget, GSList **p_term_list);
void toggle_buttonbar_cmd   (GtkWidget *widget, GSList **p_term_list);

void paste_cmd            (GtkWidget *widget, GSList **p_term_list);
void preferences_cmd      (GtkWidget *widget, GSList **p_term_list);
void toggle_secure_keyboard_cmd (GtkWidget *w, GSList **p_term_list);

extern GtkWidget *new_terminal_cmd (char **cmd, struct terminal_config *cfg_in, const gchar *geometry, int termid, char** cmds_names_in, char** cmds_in);
GtkWidget *new_terminal     (GtkWidget *widget, GSList **p_term_list); 

static void parse_an_arg (poptContext state,
			  enum poptCallbackReason reason,
			  const struct poptOption *opt,
			  const char *arg, void *data);

void set_hints (GtkWidget *widget);

static void
about_terminal_cmd (void)
{
        static GtkWidget *about = NULL;

        const gchar *authors[] = {
      	     N_("Multi Gnome Terminal: "),
	     N_("    De Michele Cristiano(demichel@na.infn.it)"),
	     N_("MGT Contributors:"), 
	     N_("    Erik Bourget (ebourg@po-box.mcgill.ca)"),
	     N_("MGT Special Thanks:"),
	     N_("    Stefan Kost (s.kost@webmacher.de)"),
	     N_("    Jan Oberlaender (mindriot@gmx.net)"),
	     N_("Zvt terminal widget: "
		"    Michael Zucchi (zucchi@zedzone.mmc.com.au)"),
	     N_("Gnome Terminal Basic:"),
	     N_("    Miguel de Icaza (miguel@kernel.org)"),
	     N_("    Erik Troan (ewt@redhat.com)"),
		NULL
	};

	if (about != NULL)
	{
		gdk_window_show(about->window);
		gdk_window_raise(about->window);
		return;
	}

#ifdef ENABLE_NLS
	authors[0]=_(authors[0]);
	authors[1]=_(authors[1]);
	authors[2]=_(authors[2]);
#endif

        about = gnome_about_new (_("Multi Gnome Terminal"), VERSION,
				 "(C) 2001 the Free Software Foundation",
				 authors,
				 _("The enhanced GNOME terminal emulation program."),
				 NULL);
	gtk_signal_connect (GTK_OBJECT (about), "destroy",
			    GTK_SIGNAL_FUNC (gtk_widget_destroyed), &about);
        gtk_widget_show (about);
}

void terminal_config_free(struct terminal_config* cfg);

#if 0
static void
close_all_cmd (void)
{
	while (terminals)
		close_terminal_cmd (0, terminals->data);
}
#endif

/*
 * Keep a copy of the current font name
 */
void
gnome_term_set_font (ZvtTerm *term, char *font_name, const int use_bold, int sb)
{
	char *s;
	GdkFont *font;
	font = gdk_font_load (font_name);

	if (font) {
#ifdef ZVT_TERM_EMBOLDEN_SUPPORT
		if (zvt_term_get_capabilities(term) & ZVT_TERM_EMBOLDEN_SUPPORT &&
		    use_bold)
			zvt_term_set_fonts  (term, font, 0);
		else
#endif
			zvt_term_set_fonts  (term, font, font);
	}
	
	s = gtk_object_get_user_data (GTK_OBJECT (term));
	if (s)
		g_free (s);
	gtk_object_set_user_data (GTK_OBJECT (term), g_strdup (font_name));
	
}

/* This really should be in GTK+
 */
static gint
option_menu_get_history (GtkOptionMenu *option_menu)
{
	GtkWidget *active_widget;
	
	g_return_val_if_fail (GTK_IS_OPTION_MENU (option_menu), -1);
	
	active_widget = gtk_menu_get_active (GTK_MENU (option_menu->menu));

	if (active_widget)
		return g_list_index (GTK_MENU_SHELL (option_menu->menu)->children,
				     active_widget);
	else
		return -1;
}

/* Popular palettes */
gushort linux_red[] = { 0x0000, 0xaaaa, 0x0000, 0xaaaa, 0x0000, 0xaaaa, 0x0000, 0xaaaa,
			0x5555, 0xffff, 0x5555, 0xffff, 0x5555, 0xffff, 0x5555, 0xffff,
			0x0,    0x0 };
gushort linux_grn[] = { 0x0000, 0x0000, 0xaaaa, 0x5555, 0x0000, 0x0000, 0xaaaa, 0xaaaa,
			0x5555, 0x5555, 0xffff, 0xffff, 0x5555, 0x5555, 0xffff, 0xffff,
			0x0,    0x0 };
gushort linux_blu[] = { 0x0000, 0x0000, 0x0000, 0x0000, 0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa,
			0x5555, 0x5555, 0x5555, 0x5555, 0xffff, 0xffff, 0xffff, 0xffff,
			0x0,    0x0 };

gushort xterm_red[] = { 0x0000, 0x6767, 0x0000, 0x6767, 0x0000, 0x6767, 0x0000, 0x6868,
			0x2a2a, 0xffff, 0x0000, 0xffff, 0x0000, 0xffff, 0x0000, 0xffff,
			0x0,    0x0 };

gushort xterm_grn[] = { 0x0000, 0x0000, 0x6767, 0x6767, 0x0000, 0x0000, 0x6767, 0x6868,
			0x2a2a, 0x0000, 0xffff, 0xffff, 0x0000, 0x0000, 0xffff, 0xffff,
			0x0,    0x0 };
gushort xterm_blu[] = { 0x0000, 0x0000, 0x0000, 0x0000, 0x6767, 0x6767, 0x6767, 0x6868,
			0x2a2a, 0x0000, 0x0000, 0x0000, 0xffff, 0xffff, 0xffff, 0xffff,
			0x0,    0x0 };

gushort rxvt_red[] = { 0x0000, 0xffff, 0x0000, 0xffff, 0x0000, 0xffff, 0x0000, 0xffff,
		       0x0000, 0xffff, 0x0000, 0xffff, 0x0000, 0xffff, 0x0000, 0xffff,
			0x0,    0x0 };
gushort rxvt_grn[] = { 0x0000, 0x0000, 0xffff, 0xffff, 0x0000, 0x0000, 0xffff, 0xffff,
		       0x0000, 0x0000, 0xffff, 0xffff, 0x0000, 0x0000, 0xffff, 0xffff,
			0x0,    0x0 };
gushort rxvt_blu[] = { 0x0000, 0x0000, 0x0000, 0x0000, 0xffff, 0xffff, 0xffff, 0xffff,
		       0x0000, 0x0000, 0x0000, 0x0000, 0xffff, 0xffff, 0xffff, 0xffff,
			0x0,    0x0 };

/* point to the other tables */
gushort *scheme_red[] = { linux_red, xterm_red, rxvt_red, rxvt_red };
gushort *scheme_blue[] = { linux_blu, xterm_blu, rxvt_blu, rxvt_blu };
gushort *scheme_green[] = { linux_grn, xterm_grn, rxvt_grn, rxvt_grn };

void
set_color_scheme (ZvtTerm *term, struct terminal_config *color_cfg) 
{
	GdkColor c;
	gushort red[18],green[18],blue[18];
	int i;
	gushort *r, *b, *g;

	switch (color_cfg->color_type){
	default:		/* and 0 */
		color_cfg->color_type = 0;
	case PALETTE_LINUX:
	case PALETTE_XTERM:
	case PALETTE_RXVT:
		r = scheme_red[color_cfg->color_type];
		g = scheme_green[color_cfg->color_type];
		b = scheme_blue[color_cfg->color_type];
		for (i=0;i<18;i++) {
			red[i] = r[i];
			green[i] = g[i];
			blue[i] = b[i];
		}
		break;
	case PALETTE_CUSTOM:
		for (i=0;i<18;i++) {
			red[i] = color_cfg->palette[i].red;
			green[i] = color_cfg->palette[i].green;
			blue[i] = color_cfg->palette[i].blue;
		}
		break;
	}

	switch (color_cfg->color_set){
		/* White on black */
	case COLORS_WHITE_ON_BLACK:
		red   [16] = red [7];
		blue  [16] = blue [7];
		green [16] = green [7];
		red   [17] = red [0];
		blue  [17] = blue [0];
		green [17] = green [0];
		break;

		/* black on white */
	case COLORS_BLACK_ON_WHITE:
		red   [16] = red [0];
		blue  [16] = blue [0];
		green [16] = green [0];
		red   [17] = red [7];
		blue  [17] = blue [7];
		green [17] = green [7];
		break;
		
		/* Green on black */
	case COLORS_GREEN_ON_BLACK:
		red   [17] = 0;
		green [17] = 0;
		blue  [17] = 0;
		red   [16] = 0;
		green [16] = 0xffff;
		blue  [16] = 0;
		break;

		/* Black on light yellow */
	case COLORS_BLACK_ON_LIGHT_YELLOW:
		red   [16] = 0;
		green [16] = 0;
		blue  [16] = 0;
		red   [17] = 0xffff;
		green [17] = 0xffff;
		blue  [17] = 0xdddd;
		break;
		
		/* Custom foreground, custom background */
	case COLORS_CUSTOM:
		for (i=16;i<18;i++) {
			red[i] = color_cfg->palette[i].red;
			green[i] = color_cfg->palette[i].green;
			blue[i] = color_cfg->palette[i].blue;
		}
		break;
	}
	zvt_term_set_color_scheme (term, red, green, blue);
	c.pixel = term->colors [17];
	
	gdk_window_set_background (GTK_WIDGET (term)->window, &c);
	gtk_widget_queue_draw (GTK_WIDGET (term));
}

/* FINIRE!!!! */
extern GdkColor colors[];

static struct terminal_config * 
load_config (char *class)
{
	char *p;
	char *fore_color = NULL;
	char *back_color = NULL;
	struct terminal_config *cfg = g_malloc (sizeof (*cfg));
	int colour_count;
	char **colours;
	int i;

	/* It's very odd that these are here */
	cfg->font = NULL;
	cfg->class = g_strdup (class);

	cfg->scrollback = gnome_config_get_int ("scrollbacklines=100");
	cfg->font    = gnome_config_get_string ("font=" DEFAULT_FONT);
	cfg->wordclass  = gnome_config_get_string ("wordclass=-A-Za-z0-9,./?%&#");

	p = gnome_config_get_string ("tab_position=top");
	if (g_strcasecmp (p, "bottom") == 0)
    	  cfg->tab_position = GTK_POS_BOTTOM;
	else if(g_strcasecmp (p, "right") == 0)
	  cfg->tab_position = GTK_POS_RIGHT;
	else if(g_strcasecmp (p, "left") == 0)
	  cfg->tab_position = GTK_POS_LEFT;
	else
	  cfg->tab_position = GTK_POS_TOP;

	cfg->tab_hidden = gnome_config_get_bool ("tab_hidden=false");
#ifdef SHADING
	cfg->shading = gnome_config_get_int("shading=190");
	cfg->rtint = gnome_config_get_int("rtint=256");
	cfg->gtint = gnome_config_get_int("gtint=256");
	cfg->btint = gnome_config_get_int("btint=256");
	cfg->tintback = gnome_config_get_bool("tintback=false");
	cfg->image_mode = gnome_config_get_int("image_mode=0");
#endif
	p = gnome_config_get_string ("scrollpos=right");
	if (g_strcasecmp (p, "left") == 0)
		cfg->scrollbar_position = SCROLLBAR_LEFT;
	else if (g_strcasecmp (p, "right") == 0)
		cfg->scrollbar_position = SCROLLBAR_RIGHT;
	else
		cfg->scrollbar_position = SCROLLBAR_HIDDEN;
	p = gnome_config_get_string ("color_scheme=linux");
	if (g_strcasecmp (p, "linux") == 0)
		cfg->color_type = PALETTE_LINUX;
	else if (g_strcasecmp (p, "xterm") == 0)
		cfg->color_type = PALETTE_XTERM;
	else if (g_strcasecmp (p, "rxvt") == 0)
		cfg->color_type = PALETTE_RXVT;
	else if (g_strcasecmp (p, "custom") == 0)
		cfg->color_type = PALETTE_CUSTOM;
	else
		cfg->color_type = PALETTE_LINUX;
	
	cfg->keyboard_secured  = FALSE;

	cfg->maxch             = gnome_config_get_int  ("maxch=20");
	cfg->titled_tabs       = gnome_config_get_bool ("titled_tabs=0");
	cfg->bell              = gnome_config_get_bool ("bell_silenced=0");
	cfg->blink             = gnome_config_get_bool ("blinking=0");
	cfg->swap_keys         = gnome_config_get_bool ("swap_del_and_backspace=0");
#ifdef HAVE_ZVT_DEL_IS_DEL
	cfg->del_is_del        = gnome_config_get_bool ("del_is_del=0");
#endif

	cfg->login_by_default  = gnome_config_get_bool ("login_by_default=0");
	cfg->use_bold          = gnome_config_get_bool ("use_bold=true");

#ifdef ZVT_BACKGROUND_SCROLL
	cfg->scroll_background = gnome_config_get_bool ("scroll_background=0");
#endif
	/* Default colors in the case the color set is the custom one */
	fore_color = gnome_config_get_string ("foreground=gray");
	back_color = gnome_config_get_string ("background=black");
	cfg->color_set = gnome_config_get_int ("color_set=0");
	cfg->menubar_hidden = !gnome_config_get_bool ("menubar=true");
	/* ADD */
	cfg->toolbar_hidden = !gnome_config_get_bool ("toolbar=true");
	cfg->buttonbar_hidden = !gnome_config_get_bool ("buttonbar=false");
	cfg->close_confirm = !gnome_config_get_bool("close_confirm=true");
	/* ====== */
	cfg->scroll_key = gnome_config_get_bool ("scrollonkey=true");
	cfg->scroll_out = gnome_config_get_bool ("scrollonoutput=false");

	cfg->transparent = gnome_config_get_bool ("transparent=false");
	cfg->shaded = gnome_config_get_bool ("shaded=false");
	cfg->background_pixmap = gnome_config_get_bool ("background_pixmap=false");
	cfg->pixmap_file = gnome_config_get_string ("pixmap_file");
	cfg->window_title = NULL;
	cfg->window_icon = NULL;

	cfg->termname = NULL;
	cfg->terminal_id = 0;

	cfg->update_records = ZVT_TERM_DO_UTMP_LOG | ZVT_TERM_DO_WTMP_LOG | ZVT_TERM_DO_LASTLOG;

	if (g_strcasecmp (fore_color, back_color) == 0)
		/* don't let them set identical foreground and background colors */
		cfg->color_set = 0;
	else {
		if (!gdk_color_parse (fore_color, &cfg->palette[16])
		    || !gdk_color_parse (back_color, &cfg->palette[17])){
			/* or illegal colors */
			cfg->color_set = 0;
		}
	}
	/* ADDED here defaults for notify colors */
	cfg->palette[18].red = colors[4].red;
	cfg->palette[18].green = colors[4].green;
	cfg->palette[18].blue =colors[4].blue;
	cfg->palette[19].red = colors[12].red;
	cfg->palette[19].green = colors[12].green;
	cfg->palette[19].blue = colors[12].blue;

	/* load the palette, if none, then 'default' to safe (linux) pallete */
	gnome_config_get_vector("palette", &colour_count, &colours);
	for (i=0;i<20;i++) {
		if (i<colour_count)
			gdk_color_parse(colours[i], &cfg->palette[i]);
		else if (i<16) {
			cfg->palette[i].red = linux_red[i];
			cfg->palette[i].green = linux_grn[i];
			cfg->palette[i].blue = linux_blu[i];
		}
	}
	g_free(colours);

	return cfg;
}

void set_styles(struct terminal_config* cfg);
void set_tab_color (GtkWidget* term, struct terminal_config* cfg);

static struct terminal_config *
gather_changes (ZvtTerm *term)
{
	preferences_t *prefs = gtk_object_get_data (GTK_OBJECT (term), "prefs");
	gchar *p;
	gushort r, g, b;
	struct terminal_config *newcfg = g_malloc (sizeof (*newcfg));
	int i;
	int sp;
#ifdef SHADING
	GtkAdjustment* adj;
#endif
	memset (newcfg, 0, sizeof (*newcfg));
	p = gtk_entry_get_text(GTK_ENTRY(prefs->maxch)); 
	newcfg->maxch = atoi(p);		       
	newcfg->titled_tabs    = GTK_TOGGLE_BUTTON (prefs->titled_tabs)->active;
	newcfg->bell           = GTK_TOGGLE_BUTTON (prefs->bell_checkbox)->active;
	newcfg->blink          = GTK_TOGGLE_BUTTON (prefs->blink_checkbox)->active;
	newcfg->swap_keys      = GTK_TOGGLE_BUTTON (prefs->swapkeys_checkbox)->active;
#ifdef HAVE_ZVT_DEL_IS_DEL
	newcfg->del_is_del     = GTK_TOGGLE_BUTTON (prefs->del_is_del_checkbox)->active;
#endif
	newcfg->menubar_hidden = GTK_TOGGLE_BUTTON (prefs->menubar_checkbox)->active;
	/* ADD */
	newcfg->toolbar_hidden = GTK_TOGGLE_BUTTON (prefs->toolbar_checkbox)->active;
	newcfg->buttonbar_hidden = GTK_TOGGLE_BUTTON (prefs->buttonbar_checkbox)->active;
	newcfg->close_confirm = GTK_TOGGLE_BUTTON (prefs->close_dialog_checkbox)->active;
	
	newcfg->tab_hidden = 0;
	p = gtk_entry_get_text(GTK_ENTRY(prefs->tab_position));
	if (g_strcasecmp (p, "bottom") == 0)
		newcfg->tab_position = GTK_POS_BOTTOM;
	else if(g_strcasecmp (p, "right") == 0)
		newcfg->tab_position = GTK_POS_RIGHT;
	else if(g_strcasecmp (p, "left") == 0)
		newcfg->tab_position = GTK_POS_LEFT;
	else if (g_strcasecmp (p, "top") == 0)
		newcfg->tab_position = GTK_POS_TOP;
	else 
	  newcfg->tab_hidden = 1;
	
	newcfg->scroll_out     = GTK_TOGGLE_BUTTON (prefs->scroll_out_checkbox)->active;
	newcfg->scroll_key     = GTK_TOGGLE_BUTTON (prefs->scroll_kbd_checkbox)->active;
	newcfg->scrollback = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (prefs->scrollback_spin));
	newcfg->login_by_default = GTK_TOGGLE_BUTTON (prefs->login_by_default_checkbox)->active;
	newcfg->use_bold = GTK_TOGGLE_BUTTON(prefs->use_bold_checkbox)->active;

	newcfg->transparent = GTK_TOGGLE_BUTTON (prefs->transparent_checkbox)->active;
	newcfg->shaded = GTK_TOGGLE_BUTTON (prefs->shaded_checkbox)->active;
#ifdef SHADING
	newcfg->tintback = GTK_TOGGLE_BUTTON(prefs->tinted_checkbox)->active;
	adj = gtk_range_get_adjustment (GTK_RANGE(prefs->shaded_hscale));
	newcfg->shading = 256 - ((int) 256*((double)adj->value)/100);
	
	gnome_color_picker_get_i16 (GNOME_COLOR_PICKER (prefs->tinted_colorpicker),
				    &r, &g,
				    &b, NULL);

	newcfg->rtint = (int)( 256 * ((double)r) / 65535);
	newcfg->gtint = (int)( 256 * ((double)g) / 65535);
	newcfg->btint = (int)( 256 * ((double)b) / 65535);
	newcfg->image_mode = option_menu_get_history(GTK_OPTION_MENU (prefs->om_imgmode));
#endif
	newcfg->background_pixmap = GTK_TOGGLE_BUTTON (prefs->pixmap_checkbox)->active;
	newcfg->pixmap_file  = g_strdup (gtk_entry_get_text (GTK_ENTRY (prefs->pixmap_entry)));
	newcfg->wordclass = g_strdup (gtk_entry_get_text (GTK_ENTRY (prefs->wordclass_entry)));
	sp = option_menu_get_history (GTK_OPTION_MENU (prefs->scrollbar));
	newcfg->scrollbar_position = sp;
#ifdef ZVT_BACKGROUND_SCROLL
	newcfg->scroll_background = GTK_TOGGLE_BUTTON (prefs->pixmap_scrollable_checkbox)->active
		&& newcfg->background_pixmap;
#endif

	g_free (newcfg->font);
	newcfg->font  = g_strdup (gtk_entry_get_text (GTK_ENTRY (prefs->font_entry)));

	if (!strcmp (gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (prefs->class_box)->entry)),
			_("Default")))
		newcfg->class = g_strdup ("Config");
	else
		newcfg->class = g_strconcat ("Class-", gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (prefs->class_box)->entry)), NULL);

	newcfg->color_type = option_menu_get_history (GTK_OPTION_MENU (prefs->color_scheme));
	newcfg->color_set  = option_menu_get_history (GTK_OPTION_MENU (prefs->def_fore_back));

	/* MODIFIED 18->20 */
	for (i=0;i<20;i++) {
		gnome_color_picker_get_i16 (GNOME_COLOR_PICKER (prefs->palette[i]), &r, &g,
					    &b, NULL);
		newcfg->palette[i].red   = r;
		newcfg->palette[i].green = g;
		newcfg->palette[i].blue  = b;
	}

	set_styles(newcfg);	
	return newcfg;
}

struct terminal_config *
terminal_config_dup (struct terminal_config *cfg)
{
	struct terminal_config *n;

	n = g_malloc (sizeof (*n));
	*n = *cfg;
	n->class = g_strdup (cfg->class);
	n->font = g_strdup  (cfg->font);
	n->wordclass = g_strdup  (cfg->wordclass);
	n->termname = g_strdup  (cfg->termname);
	return n;
}

void
terminal_config_free (struct terminal_config *cfg)
{
	g_free (cfg->class);
	g_free (cfg->font);
	g_free (cfg->wordclass);
	g_free (cfg->termname);
	g_free (cfg);
}

/* prototype */
static void switch_terminal_class (ZvtTerm *term, struct terminal_config *newcfg);
void hide_toolbar(GnomeApp* app, gboolean htb);
void hide_buttonbar(GnomeApp* app, gboolean hbb);
void hide_menubar  (GnomeApp* app, gboolean hmb);

char * trunc_string (char * s, int len);

static int
apply_changes (ZvtTerm *term, struct terminal_config *newcfg)
{
	GtkWidget *scrollbar = gtk_object_get_data (GTK_OBJECT (term), "scrollbar");
	GtkWidget *box       = scrollbar->parent;
	GnomeApp *app = GNOME_APP (gtk_widget_get_toplevel (GTK_WIDGET (term)));
	GtkWidget *notebook = gtk_object_get_data(GTK_OBJECT(app), "notebook");
	GtkWidget* label1, *label2, *child;
	char* ttitle, *tname;
	GSList** ptl, *tmp;
	char tmp2[300];
	int n;
	struct _zvtprivate *zp;
#ifdef SHADING
	GdkImlibColorModifier mod, rmod, gmod, bmod;
#endif
	struct terminal_config *cfg = gtk_object_get_data (GTK_OBJECT (term), "config");
	gint w,h;

	w =  GTK_WIDGET(app)->allocation.width;
	h =  GTK_WIDGET(app)->allocation.height;

	terminal_config_free (cfg);
	cfg = terminal_config_dup (newcfg);
	
	gtk_object_set_data (GTK_OBJECT (term), "config", cfg);

	gnome_term_set_font (term, cfg->font, cfg->use_bold,cfg->scroll_background);
	
	ptl = gtk_object_get_data(GTK_OBJECT(app), "ptermlist");
	tmp = *ptl; 
	n=0;
	while (tmp)
	  {
	    if ( ZVT_TERM(tmp->data) == term)
	      break;
	    n++;
	    tmp = tmp->next;
	  }
	  
	child = gtk_notebook_get_nth_page(GTK_NOTEBOOK(notebook), n);
	label1 = gtk_notebook_get_tab_label(GTK_NOTEBOOK(notebook), child);
	label2 = gtk_notebook_get_menu_label(GTK_NOTEBOOK(notebook), child);
	ttitle = gtk_object_get_data(GTK_OBJECT(term),"termtitle");
	tname = gtk_object_get_data(GTK_OBJECT(term), "mtermname");
	if (cfg->titled_tabs)
	  {
	    sprintf(tmp2,"%d-%s", n, ttitle);
	    gtk_label_set_text(GTK_LABEL(label1), trunc_string(tmp2, cfg->maxch));
	    gtk_label_set_text(GTK_LABEL(label2), trunc_string(tmp2, cfg->maxch));	
	  }
	else
	  {
	    sprintf(tmp2, "%d-%s", n, tname);
	    gtk_label_set_text(GTK_LABEL(label1), tmp2);
	    gtk_label_set_text(GTK_LABEL(label2), tmp2);	
	  }


	zvt_term_set_wordclass (term, (guchar *)cfg->wordclass);
	zvt_term_set_bell(term, !cfg->bell);
	zvt_term_set_blink (term, cfg->blink);
	zvt_term_set_scroll_on_keystroke (term, cfg->scroll_key);
	zvt_term_set_scroll_on_output (term, cfg->scroll_out);
	zvt_term_set_scrollback (term, cfg->scrollback);
	
	zvt_term_set_del_key_swap (term, cfg->swap_keys);
#ifdef HAVE_ZVT_DEL_IS_DEL
	zvt_term_set_del_is_del (term, cfg->del_is_del);
#endif
#ifdef SHADING
	mod.contrast = mod.gamma = 256;
	mod.brightness = cfg->shading;
	rmod.contrast = rmod.gamma = 256;
	gmod.contrast = gmod.gamma = 256;
	bmod.contrast = bmod.gamma = 256;
	rmod.brightness = cfg->rtint;
	gmod.brightness = cfg->gtint;
	bmod.brightness = cfg->btint;
	term->tintback = cfg->tintback;
	if (!cfg->scroll_background)
	  {
	    zp = gtk_object_get_data(GTK_OBJECT(term), "_zvtprivate");
	    zp->scroll_position = 0;
	  }
	zvt_term_set_shading(term, mod, rmod, gmod, bmod);
	zvt_term_set_image_mode(term, cfg->image_mode); 
#endif
	if (zvt_pixmap_support && cfg->background_pixmap) {
		int flags;
#ifdef ZVT_BACKGROUND_SCROLL
		flags = cfg->shaded?ZVT_BACKGROUND_SHADED:0;
		flags |= cfg->scroll_background?ZVT_BACKGROUND_SCROLL:0;
#else
		flags = cfg->shaded;
#endif
		zvt_term_set_background (term,
					 cfg->pixmap_file,
					 cfg->transparent, flags);
	} else if (zvt_pixmap_support && cfg->transparent)
		zvt_term_set_background (term,
					 NULL,
					 cfg->transparent, cfg->shaded);
	else
		zvt_term_set_background (term, NULL, 0, 0);
	if (cfg->scrollbar_position == SCROLLBAR_HIDDEN)
	  {
	    	gtk_widget_hide (scrollbar);
	  }
	  else {
	    
    	    gtk_box_set_child_packing (GTK_BOX (box), scrollbar,
		      			   FALSE, TRUE, 0,
		      			   (cfg->scrollbar_position == SCROLLBAR_LEFT) ?
		      			   GTK_PACK_START : GTK_PACK_END);
		gtk_widget_show (scrollbar);
	  }
	set_color_scheme (term, cfg);
	

	/*gtk_widget_set_usize(GTK_WIDGET(app),w,h);*/
			    
	set_tab_color(GTK_WIDGET(term), cfg);
	return 0;
}

void save_preferences_cmd (GtkWidget *widget, GSList  **p_term_list);
#if 0
void reread_cmds(GtkWidget* app, char* class);
#endif

void apply_global_chgs(GtkWidget* term)
{
  GtkWidget *app, *notebook;
  struct terminal_config* cfg;

  cfg = gtk_object_get_data(GTK_OBJECT(term), "config");
  app = gtk_widget_get_toplevel(GTK_WIDGET(term));
  notebook = gtk_object_get_data(GTK_OBJECT(app), "notebook");

  if (cfg->menubar_hidden)
    hide_menubar (GNOME_APP(app), TRUE);
  else 
    hide_menubar (GNOME_APP(app), FALSE);
  if (cfg->toolbar_hidden)
    hide_toolbar(GNOME_APP(app), TRUE);
  else
    hide_toolbar(GNOME_APP(app), FALSE);
  
  if (cfg->buttonbar_hidden)
    {
      hide_buttonbar(GNOME_APP(app), TRUE);	    
    }
  else
    {	  
      hide_buttonbar(GNOME_APP(app), FALSE);	    

    }

  /* ADD 29/09/01 <erik> */
  gtk_notebook_set_show_tabs(GTK_NOTEBOOK(notebook), !cfg->tab_hidden);
 
  gtk_notebook_set_tab_pos(GTK_NOTEBOOK(notebook),
		   cfg->tab_position);
}

static void
apply_changes_cmd (GtkWidget *widget, int page, GSList** p_term_list)
{
        struct terminal_config *newcfg;
	GSList  *tmp;
	int w, h;
	GtkWidget* app, *notebook;
	ZvtTerm *term=NULL;
	/* Now commands are common to all term classes! */
	struct terminal_config *cfg;
	int reload_cmds = 0, n;
	if (page != -1) return;
	
	/* Apply setting to first term in p_term_list and then copy new cfg pointer
	   to all terms */
	tmp = *p_term_list;
	n = 0;	
	term = ZVT_TERM(tmp->data);
	w = term->vx->vt.width;
	h = term->vx->vt.height;
	app = gtk_widget_get_toplevel(GTK_WIDGET(term));
      	notebook = gtk_object_get_data(GTK_OBJECT(app), "notebook");
	GTK_WIDGET_UNSET_FLAGS(GTK_WIDGET(app),GTK_VISIBLE); 
	while (tmp)
	  {
	    term = ZVT_TERM(tmp->data);
	    cfg = gtk_object_get_data (GTK_OBJECT (term), "config");
	    newcfg = gather_changes(term);
	    newcfg->window_title = cfg->window_title;
	    newcfg->invoke_as_login_shell = cfg->invoke_as_login_shell; 
	    if (strcmp (cfg->class, newcfg->class)){
	      reload_cmds = 1;
	      switch_terminal_class (term, newcfg);
	    } else {
    	      apply_changes (term, newcfg);
	      terminal_config_free (newcfg);
    	    }
	    n++;
	    tmp = tmp->next;
	  }
	term = current_term(p_term_list);
	apply_global_chgs(GTK_WIDGET(term));
	GTK_WIDGET_SET_FLAGS(GTK_WIDGET(app),GTK_VISIBLE); 

	tmp = *p_term_list;
	while(tmp)
	  {
	    term = ZVT_TERM(tmp->data);
	    zvt_term_set_size(ZVT_TERM(term), w, h);
	    tmp = tmp->next;
	  }

	gtk_widget_queue_resize(GTK_WIDGET(notebook));
	set_hints(GTK_WIDGET(term));
	/*gtk_widget_queue_resize(GTK_WIDGET(app));*/
#if 0
	 if (reload_cmds)
	  {
	    app = gtk_widget_get_toplevel(GTK_WIDGET((*p_term_list)->data));
	    cfg = gtk_object_get_data (GTK_OBJECT ((*p_term_list)->data), "config");
	    reread_cmds(app, cfg->class);
	  }
#endif
	save_preferences_cmd (widget, p_term_list);
}

void rebuild_menubar_from_arrays(GnomeApp* app);
void rebuild_buttonbar_menu( GtkWidget  *window);

#if 0
void reread_cmds(GtkWidget* app, char* class)
{
  char** cmds, **cmds_names;
  int num_cmds;
  GSList* tmp;
  char *prefix = g_strdup_printf("/Terminal/%s/", class);
  
  /* cmds e cmds_names must initialized at window (app) creation */
  cmds_names = (char**) gtk_object_get_data(GTK_OBJECT(app), "cmds_names");
  cmds = (char**) gtk_object_get_data(GTK_OBJECT(app), "cmds");
  /* remove old arrays */ 
  free_str_array(cmds_names);
  free_str_array(cmds);
  gnome_config_push_prefix (prefix);
		
  /* Load all commands and their names */
  gnome_config_get_vector ("cmds", &num_cmds, &cmds);
  gnome_config_get_vector ("cmds_names", &num_cmds, &cmds_names);
  gnome_config_pop_prefix ();

  if ((cmds == NULL) || (cmds_names == NULL))
    {
      cmds = malloc(sizeof(char*));
      cmds_names = malloc(sizeof(char*));
      cmds[0] = NULL;
      cmds_names[0] = NULL;
    }
  else
    {
      if (num_cmds == 1)
	{
	  if (strlen(cmds[0])==0 && strlen(cmds_names[0])==0)
	    {
	      cmds[0] = NULL;
	      cmds_names[0] = NULL;
	    }
	}
    }
  gtk_object_set_data(GTK_OBJECT(app), "cmds_names", cmds_names);
  gtk_object_set_data(GTK_OBJECT(app), "cmds_list", cmds);
  rebuild_menubar_from_arrays(GNOME_APP(app));
  rebuild_buttonbar_menu(GTK_WIDGET(app));
}
#endif

static void
switch_terminal_cb (GnomeMessageBox *mbox, gint button, void *term)
{
       struct terminal_config *newcfg, *loaded_cfg, *cfg;

       newcfg = gtk_object_get_data (GTK_OBJECT (term), "newcfg");
       cfg = gtk_object_get_data (GTK_OBJECT (term), "config");
       
       if (button == 0){
		/* yes */
         	char *prefix = g_strdup_printf("/MultiTerminal/%s/", newcfg->class);
		gnome_config_push_prefix (prefix);
		loaded_cfg = load_config (newcfg->class);
		loaded_cfg->window_title = cfg->window_title;
		apply_changes (term, loaded_cfg);
		terminal_config_free (loaded_cfg);
		gnome_config_pop_prefix ();
	} else if (button == 1){
		/* no */
		apply_changes (term, newcfg);
	} else {
		/* cancel -- don't do anything about the 'apply' at all */
	}

}


static void
switch_terminal_closed (GtkWidget *w, void *data)
{
	ZvtTerm *term = ZVT_TERM (data);
	struct terminal_config *newcfg;

	newcfg = gtk_object_get_data (GTK_OBJECT (term), "newcfg");
	terminal_config_free (newcfg);
	gtk_object_set_data (GTK_OBJECT (term), "newcfg", NULL);
}

static void
switch_terminal_class (ZvtTerm *term, struct terminal_config *newcfg) 
{
	GtkWidget *mbox;
	preferences_t *prefs = gtk_object_get_data (GTK_OBJECT (term), "prefs");

	gtk_object_set_data (GTK_OBJECT (term), "newcfg", newcfg);

	if (!prefs->changed){
	    /* just do it! */
	    switch_terminal_cb (NULL, 0, term);
	    terminal_config_free (newcfg);
	    gtk_object_set_data (GTK_OBJECT (term), "newcfg", NULL);
	    return;
	}

	mbox = gnome_message_box_new (_("You have switched the class of this window. Do you\n "
				       "want to reconfigure this window to match the default\n"
				       "configuration of the new class?"),
				 GNOME_MESSAGE_BOX_QUESTION,
                                 GNOME_STOCK_BUTTON_YES,
                                 GNOME_STOCK_BUTTON_NO, GNOME_STOCK_BUTTON_CANCEL, NULL);

	gtk_signal_connect (GTK_OBJECT (mbox), "clicked", GTK_SIGNAL_FUNC (switch_terminal_cb),
			   term);
	gtk_signal_connect (GTK_OBJECT (mbox), "destroy", GTK_SIGNAL_FUNC (switch_terminal_closed),
			   term);

	gtk_widget_show (mbox);
}

/* this is the PREFS window destroy event ... */
static void
window_destroy (GtkWidget *w, GSList** p_term_list)
{
	ZvtTerm *term; 
	preferences_t *prefs;
	char *tmp;
	GSList* tt;

	tt = *p_term_list;
	
	term = ZVT_TERM(tt->data);
	/* NOTE: 
	   prefs is the same for all terminal in the same window (GnomeApp) */
	prefs = gtk_object_get_data (GTK_OBJECT (term), "prefs");

	gtk_signal_disconnect_by_data (GTK_OBJECT (prefs->pixmap_entry), prefs);
	g_free (prefs);

	tt = *p_term_list;
	while (tt)	
	  {
	    term = ZVT_TERM(tt->data);
	    gtk_object_set_data (GTK_OBJECT (term), "prefs", NULL);
	    tt = tt->next;
	  }

	tmp = gtk_object_get_data (GTK_OBJECT (term), "matchstr");
	if (tmp) {
	  g_free(tmp);
	  tt = *p_term_list;
	  while (tt)	
	    {
	      term = ZVT_TERM(tt->data);
	      gtk_object_set_data(GTK_OBJECT (term), "matchstr", NULL);
	      tt = tt->next;
	    }
	}	  
}
/* 
 * Set the sensitivity of the Image tab of the property  
 * dialog based on the values of the checkbuttons
 */

static void
check_image_options_sensitivity (preferences_t *prefs)
{
	gboolean has_background = GTK_TOGGLE_BUTTON (prefs->pixmap_checkbox)->active;
	gboolean has_transparency = GTK_TOGGLE_BUTTON (prefs->transparent_checkbox)->active;
	gboolean has_titledtabs = GTK_TOGGLE_BUTTON(prefs->titled_tabs)->active;	
#ifdef SHADING
	gboolean is_tinted = GTK_TOGGLE_BUTTON (prefs->tinted_checkbox)->active;
	gboolean is_shaded = GTK_TOGGLE_BUTTON (prefs->shaded_checkbox)->active;
	gtk_widget_set_sensitive (prefs->om_imgmode, has_background);
	gtk_widget_set_sensitive (prefs->tinted_checkbox,
				  has_background || has_transparency);
	gtk_widget_set_sensitive (prefs->tinted_colorpicker, (has_background ||
				  has_transparency) &&  (is_tinted));
	gtk_widget_set_sensitive (prefs->shaded_hscale, (has_background ||
				  has_transparency) && (is_shaded));
	gtk_widget_set_sensitive (prefs->perclbl, (has_background || has_transparency) 
				  && (is_shaded));
#endif	
	gtk_widget_set_sensitive (prefs->lbl_maxch, has_titledtabs);
	gtk_widget_set_sensitive (prefs->maxch, has_titledtabs);

	gtk_widget_set_sensitive (prefs->pixmap_label, has_background);
	gtk_widget_set_sensitive (prefs->pixmap_file_entry, has_background);
	gtk_widget_set_sensitive (prefs->shaded_checkbox,
				  has_background || has_transparency);
#ifdef ZVT_BACKGROUND_SCROLL
	gtk_widget_set_sensitive (prefs->pixmap_scrollable_checkbox,
				  has_background);
#endif
}

/*
 * Called when something has changed on the properybox
 */
static void
prop_changed (GtkWidget *w, preferences_t *prefs)
{
	if (w != GTK_WIDGET (GTK_COMBO (prefs->class_box)->entry)) 
		prefs->changed = 1;
	gnome_property_box_changed (GNOME_PROPERTY_BOX (prefs->prop_win));

	check_image_options_sensitivity (prefs);
}

static void
color_changed (GtkWidget *w, int r, int g, int b, int a, preferences_t *prefs)
{
	prop_changed (w, prefs);
}

static void
font_changed (GtkWidget *w, preferences_t *prefs)
{
	char *font;
	GtkWidget *peer;
	if (GNOME_IS_FONT_PICKER(w)){
		font = gnome_font_picker_get_font_name (GNOME_FONT_PICKER(w));
		peer = gtk_object_get_user_data (GTK_OBJECT(w));
		if (font)
		  gtk_entry_set_text (GTK_ENTRY(peer), font);
	} else {
		font = gtk_entry_get_text (GTK_ENTRY(w));
		peer = gtk_object_get_user_data (GTK_OBJECT(w));
		gnome_font_picker_set_font_name (GNOME_FONT_PICKER(peer), font);
		prop_changed (w, prefs);
	}
}


/*
static void
prop_changed_zvt (void *data, char *font_name) 
{ 
	ZvtTerm *term = ZVT_TERM (data); 
	preferences_t *prefs; 
	 
	prefs = gtk_object_get_data (GTK_OBJECT (term), "prefs"); 
	gtk_entry_set_text (GTK_ENTRY (prefs->font_entry), font_name); 
	gtk_entry_set_position (GTK_ENTRY (prefs->font_entry), 0); 
} 
*/ 

typedef struct {
	GnomePropertyBox *box;
	preferences_t	 *prefs;
} lambda_t;

static void
check_color_sensitivity (preferences_t *prefs)
{
	int idxc = option_menu_get_history (GTK_OPTION_MENU (prefs->def_fore_back));
	gboolean sensc = (idxc == COLORS_CUSTOM);
	int idx = option_menu_get_history (GTK_OPTION_MENU (prefs->color_scheme));
	gboolean sens = (idx == PALETTE_CUSTOM);

	int i;
	gtk_widget_set_sensitive (GTK_WIDGET (prefs->fore_label), sensc);
	gtk_widget_set_sensitive (GTK_WIDGET (prefs->back_label), sensc);
	gtk_widget_set_sensitive (GTK_WIDGET (prefs->palette_label), sens);
	for (i=0;i<18;i++)
		gtk_widget_set_sensitive (GTK_WIDGET (prefs->palette[i]), i<16?sens:sensc);
}

static void
set_active (GtkWidget *widget, lambda_t *t)
{
	check_color_sensitivity (t->prefs);
	t->prefs->changed = 1;
	gnome_property_box_changed (GNOME_PROPERTY_BOX (t->box));
}

static void
set_active_im (GtkWidget *widget, lambda_t *t)
{
	gnome_property_box_changed (GNOME_PROPERTY_BOX (t->box));
}


static void
create_option_menu_data (GtkWidget *omenu,
			 GnomePropertyBox *box, preferences_t *prefs, char **menu_list, int item,
			 GtkSignalFunc func)
{
	GtkWidget *menu;
	lambda_t *t;
	int i = 0;
       
	menu = gtk_menu_new ();
	while (*menu_list){
		GtkWidget *entry;

		entry = gtk_menu_item_new_with_label (_(*menu_list));
		gtk_widget_show (entry);
		gtk_menu_append (GTK_MENU (menu), entry);
		menu_list++;
		i++;
	}
	gtk_option_menu_set_menu (GTK_OPTION_MENU (omenu), menu);
	gtk_option_menu_set_history (GTK_OPTION_MENU (omenu), item);
	gtk_widget_show (omenu);
	t = g_new (lambda_t, 1);
	t->box   = box;
	t->prefs = prefs;

	gtk_signal_connect_full (GTK_OBJECT (menu), 
				 "deactivate",
				 GTK_SIGNAL_FUNC (set_active), NULL,
				 t, (GtkDestroyNotify)g_free,
				 FALSE, FALSE);
}

static void
create_option_menu (GtkWidget *omenu, GnomePropertyBox *box, preferences_t *prefs, char **menu_list, int item, GtkSignalFunc func)
{
	create_option_menu_data (omenu, box, prefs, menu_list, item, func);
}

char *color_scheme [] = {
	N_("Linux console"),
	N_("Color Xterm"),
	N_("rxvt"),
	N_("Custom"),
	NULL
};

char *fore_back_table [] = {
	N_("White on black"),
	N_("Black on white"),
	N_("Green on black"),
	N_("Black on light yellow"),
	N_("Custom colors"),
	NULL
};

char *scrollbar_position_list [] = {
	N_("Left"),
	N_("Right"),
	N_("Hidden"),
	NULL
};

#ifdef SHADING
char *image_modes [] = {
  N_("Scaled"),
  N_("Tiled"),
  NULL
};
#endif

/* called back to free the ColorSelector */
static void
free_cs (GtkWidget *widget, GnomeColorPicker *cp)
{
}

static void
save_preferences (GtkWidget *widget, ZvtTerm *term, 
		  struct terminal_config *cfg)
{
        /* MODIFIED 18->20 */
	char *colours[20];
	int i;
	char *scheme[4] = { "linux", "xterm", "rxvt", "custom" };
	
	if (cfg->font)
		gnome_config_set_string ("font", cfg->font);
	if (cfg->wordclass)
		gnome_config_set_string ("wordclass", cfg->wordclass);

	gnome_config_set_string ("tab_position",
				 cfg->tab_position == GTK_POS_BOTTOM ? "bottom" :
				 cfg->tab_position == GTK_POS_LEFT   ? "left"   :
				 cfg->tab_position == GTK_POS_RIGHT  ? "right"  : "top");
	gnome_config_set_bool ("tab_hidden", cfg->tab_hidden);
#ifdef SHADING
	gnome_config_set_int("shading", cfg->shading);
	gnome_config_set_int("rtint", cfg->rtint);
	gnome_config_set_int("gtint", cfg->gtint);
	gnome_config_set_int("btint", cfg->btint);
	gnome_config_set_bool("tintback", cfg->tintback);
	gnome_config_set_int("image_mode", cfg->image_mode);
#endif
	gnome_config_set_string ("scrollpos",
				 cfg->scrollbar_position == SCROLLBAR_LEFT ? "left" :
				 cfg->scrollbar_position == SCROLLBAR_RIGHT ? "right" : "hidden");
	gnome_config_set_int    ("maxch", cfg->maxch);
	gnome_config_set_bool   ("titled_tabs", cfg->titled_tabs);	
	gnome_config_set_bool   ("bell_silenced", cfg->bell);
	gnome_config_set_bool   ("blinking", cfg->blink);
	gnome_config_set_bool   ("swap_del_and_backspace", cfg->swap_keys);
#ifdef HAVE_ZVT_DEL_IS_DEL
	gnome_config_set_bool   ("del_is_del", cfg->del_is_del);
#endif
	gnome_config_set_bool   ("login_by_default", cfg->login_by_default);
	gnome_config_set_bool   ("use_bold", cfg->use_bold);
	gnome_config_set_int    ("scrollbacklines", cfg->scrollback);
	gnome_config_set_int    ("color_set", cfg->color_set);
	if (cfg->color_type>=4)
		cfg->color_type=4;
	gnome_config_set_string ("color_scheme", scheme[cfg->color_type]);
	gnome_config_set_bool   ("menubar", !cfg->menubar_hidden);
	/* ADD */
	gnome_config_set_bool   ("toolbar", !cfg->toolbar_hidden);
	gnome_config_set_bool   ("buttonbar", !cfg->buttonbar_hidden);
	gnome_config_set_bool   ("close_confirm", !cfg->close_confirm);
	gnome_config_set_bool   ("scrollonkey", cfg->scroll_key);
	gnome_config_set_bool   ("scrollonoutput", cfg->scroll_out);
	gnome_config_set_bool   ("transparent", cfg->transparent);
	gnome_config_set_bool   ("shaded", cfg->shaded);
#ifdef ZVT_BACKGROUND_SCROLL
	gnome_config_set_bool   ("scroll_background", cfg->scroll_background);
#endif
	gnome_config_set_bool   ("background_pixmap", cfg->background_pixmap);
	gnome_config_set_string ("pixmap_file", cfg->pixmap_file);

	/* MODIFIED 18->20 */
	for (i=0;i<20;i++)
		colours[i] = g_strdup_printf ("rgb:%04x/%04x/%04x", cfg->palette[i].red,
					      cfg->palette[i].green, cfg->palette[i].blue);
	gnome_config_set_vector ("palette", 20, (const char **)colours);
	for (i=0;i<20;i++)
		g_free(colours[i]);

	gnome_config_sync ();
}

void
save_preferences_cmd (GtkWidget *widget, GSList **p_term_list)
{
        GtkWidget *term = GTK_WIDGET((*p_term_list)->data);  
	struct terminal_config *cfg = 
		gtk_object_get_data (GTK_OBJECT (term), "config");
        char *prefix = g_strdup_printf ("/MultiTerminal/%s/", cfg->class);
	/* Consider one terminal because settings are the same for all terminals*/
	gnome_config_push_prefix (prefix);
    	g_free (prefix);
	save_preferences (widget, ZVT_TERM(term), cfg);
	gnome_config_pop_prefix ();
	
}

extern GdkColor colors[];

void default_cols(GtkWidget* w, gpointer data)
{
  preferences_t* prefs;
  prefs = (preferences_t*) data;
  gnome_color_picker_set_i16(GNOME_COLOR_PICKER(prefs->palette[18]), colors[4].red,
			     colors[4].green, colors[4].blue, 0);
  gnome_color_picker_set_i16(GNOME_COLOR_PICKER(prefs->palette[19]), colors[12].red,
			     colors[12].green, colors[12].blue, 0);
  gnome_property_box_changed (GNOME_PROPERTY_BOX (prefs->prop_win));
}
static void
phelp_cb (GtkWidget *w, gint tab, gpointer data)
{
	GnomeHelpMenuEntry help_entry = { "gnome-terminal",
					  "config.html" };
	char *pages[] = { "config.html#CONFIG-GENERAL",
			  "config.html#CONFIG-IMAGE",
			  "config.html#CONFIG-COLOUR",
			  "config.html#CONFIG-SCROLLING" };
	g_assert (tab < 4);
	help_entry.path = pages[tab];
	gnome_help_display(NULL, &help_entry);
}


void ok_remove_class(gchar* class, preferences_t* prefs)
{
  char *prefix = g_strdup_printf ("MultiTerminal/Class-%s/", class);
  GList *rl = NULL;
  void *iter;
  char *some_class;
  
  gnome_config_clean_section(prefix);
  gnome_config_sync();  
  iter = gnome_config_init_iterator_sections ("/MultiTerminal");
  
  rl = NULL; 
  while (gnome_config_iterator_next (iter, &some_class, NULL)){
    if (!strcmp (some_class, "Config") || !strncmp (some_class, "Class-", 6)){
      if (!strcmp (some_class, "Config")) 
	some_class = _("Default");
      else
	some_class += 6;
      printf("some_class: %s\n", some_class);
      rl = g_list_append (rl, some_class);
    }
  }
  if(rl)
    gtk_combo_set_popdown_strings (GTK_COMBO (prefs->class_box), rl);
  
  some_class = _("Default");
  gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (prefs->class_box)->entry), some_class);

  g_free(prefix);
}

void dlg_class_remove(gint reply, gpointer data)
{
  gchar* class;
  preferences_t* prefs;

  prefs = (preferences_t*) data; 

  class = gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (prefs->class_box)->entry));

  if (!reply)
    {
      ok_remove_class(class, prefs);   
    }
}


void remove_class_cb(GtkWidget* w, gpointer data)
{
  preferences_t* prefs;
  char* tclass;
  GtkWidget* conf_win;  
  
  prefs = (preferences_t*) data;

  tclass = gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (prefs->class_box)->entry));

  if (!strcmp (tclass, _("Default")) ||
      !strcmp (tclass, "multi-gnome-terminal"))
    {
      /* non si puo' eliminare la classe di default o multi-gnome-terminal*/
      conf_win = gnome_warning_dialog(_("You can't eliminate this Class!"));
      return ;
    }
 
  conf_win = gnome_ok_cancel_dialog_modal
    ("Really remove this Class?", dlg_class_remove, 
     (gpointer)prefs);
}
#include <ctype.h>
void 
insert_text_handler (GtkEditable *editable,
                      const gchar *text,
                      gint         length,
                      gint        *position,
                      gpointer     data)
 {
   int i;

   for (i=0; i<length; i++)
     if (!isdigit(text[i]))
       {
	  gtk_signal_emit_stop_by_name (GTK_OBJECT (editable), "insert_text");
	  return;
       }
 }

void
preferences_cmd (GtkWidget *widget, GSList **p_term_list)
{
	GtkWidget *picker, *b5, *b3, *b4, *b1, *b2, *label, *r;
	preferences_t *prefs = NULL;
	GList *class_list = NULL;
	void *iter;
	char *some_class, mch[10];
	struct terminal_config *cfg;
	int i;
	GtkWidget *transient_parent, *classrmv_but;
	GtkWidget* term;
	GladeXML *gui;
	gchar *glade_file;
	GSList *tmp; 
#ifdef SHADING
	GtkAdjustment* adj;
#endif
	
	term = GTK_WIDGET((*p_term_list)->data);
	/* Is a property window for this terminal already running? */
	if (gtk_object_get_data (GTK_OBJECT (term), "newcfg"))
		return;
	
        transient_parent = gtk_widget_get_toplevel (GTK_WIDGET (term));

	prefs = gtk_object_get_data (GTK_OBJECT (term), "prefs");
	
	if (prefs) {
	  
		if (transient_parent)
			gtk_window_set_transient_for (GTK_WINDOW (prefs->prop_win),
						      GTK_WINDOW (transient_parent));
		/* Raise and possibly uniconify the property box */
		gdk_window_show (prefs->prop_win->window);
		/* NOTE: modal now to avoid problems */
		/*gtk_window_set_modal(GTK_WINDOW(prefs->prop_win), TRUE);*/
	       	
		return;
	}

	cfg = gtk_object_get_data (GTK_OBJECT (term), "config");

	prefs = g_new0 (preferences_t, 1);
	prefs->changed = 0;

	glade_file = GNOME_TERMINAL_GLADEDIR "/multi-gnome-terminal.glade";

	gui = glade_xml_new (glade_file, "prefs");
	if (!gui) {
		g_warning ("Error loading `%s'", glade_file);
		return;
	}

	glade_xml_signal_autoconnect (gui);

	prefs->prop_win = glade_xml_get_widget (gui, "prefs");
	/* NOTE: modal to avoid problems */
	/*gtk_window_set_modal(GTK_WINDOW(prefs->prop_win), TRUE);*/

	tmp = *p_term_list;
	while (tmp)
	  {
	    term = GTK_WIDGET(tmp->data); 
	    gtk_object_set_data (GTK_OBJECT (term), "prefs", prefs);
	    tmp = tmp->next;
	  }

	term = GTK_WIDGET((*p_term_list)->data);

	if (transient_parent)
		gtk_window_set_transient_for (GTK_WINDOW (prefs->prop_win),
					      GTK_WINDOW (transient_parent));

	prefs->font_entry = glade_xml_get_widget (gui, "font-entry");
	gtk_entry_set_text (GTK_ENTRY (prefs->font_entry),
			    gtk_object_get_user_data (GTK_OBJECT (term)));
	gtk_entry_set_position (GTK_ENTRY (prefs->font_entry), 0);
	gtk_signal_connect (GTK_OBJECT (prefs->font_entry), "changed",
			    GTK_SIGNAL_FUNC (font_changed), prefs);
	gnome_dialog_editable_enters (GNOME_DIALOG (prefs->prop_win),
				      GTK_EDITABLE (prefs->font_entry));

	picker = glade_xml_get_widget (gui, "font-picker");
	gnome_font_picker_set_font_name(GNOME_FONT_PICKER(picker),
					gtk_entry_get_text(GTK_ENTRY (prefs->font_entry)));
	gnome_font_picker_set_mode(GNOME_FONT_PICKER (picker),
				   GNOME_FONT_PICKER_MODE_USER_WIDGET);

	gtk_signal_connect (GTK_OBJECT (picker), "font_set",
			    GTK_SIGNAL_FUNC (font_changed), prefs);
	label = gtk_label_new (_("Browse..."));
	gnome_font_picker_uw_set_widget(GNOME_FONT_PICKER(picker), GTK_WIDGET(label));
	gtk_widget_show (label);
	
	gtk_object_set_user_data(GTK_OBJECT(picker), GTK_OBJECT(prefs->font_entry)); 
	gtk_object_set_user_data (GTK_OBJECT(prefs->font_entry), GTK_OBJECT(picker)); 

	classrmv_but = glade_xml_get_widget (gui, "classrmv_but");
	gtk_signal_connect (GTK_OBJECT (classrmv_but), "clicked",
			    GTK_SIGNAL_FUNC (remove_class_cb), prefs);

	prefs->class_box = glade_xml_get_widget (gui, "class-box");

	iter = gnome_config_init_iterator_sections ("/MultiTerminal");
	while (gnome_config_iterator_next (iter, &some_class, NULL)){
		if (!strcmp (some_class, "Config") || !strncmp (some_class, "Class-", 6)){
			if (!strcmp (some_class, "Config")) 
				some_class = _("Default");
			else
				some_class += 6;

			class_list = g_list_append (class_list, some_class);
		}
	}
	if(class_list)
		gtk_combo_set_popdown_strings (GTK_COMBO (prefs->class_box), class_list);
	if (!strcmp (cfg->class, "Config")) 
		some_class = _("Default");
	else
		some_class = cfg->class + 6;
	gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (prefs->class_box)->entry), some_class);
	gtk_signal_connect (GTK_OBJECT (GTK_COMBO (prefs->class_box)->entry), "changed",
			    GTK_SIGNAL_FUNC (prop_changed), prefs);

	/* Toggle the use of bold */
	
	prefs->use_bold_checkbox = glade_xml_get_widget (gui, "use-bold-checkbox");
	
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (prefs->use_bold_checkbox),
	                              cfg->use_bold ? 1 : 0);

#ifdef ZVT_TERM_EMBOLDEN_SUPPORT
	if (!(zvt_term_get_capabilities(ZVT_TERM(term)) & ZVT_TERM_EMBOLDEN_SUPPORT))
#endif
		gtk_widget_set_sensitive (prefs->use_bold_checkbox, FALSE);

	gtk_signal_connect (GTK_OBJECT (prefs->use_bold_checkbox), "toggled",
	                    GTK_SIGNAL_FUNC (prop_changed), prefs);

	/* Blinking status */
	prefs->blink_checkbox = glade_xml_get_widget (gui, "blink-checkbox");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (prefs->blink_checkbox),
				      ZVT_TERM(term)->blink_enabled ? 1 : 0);
	gtk_signal_connect (GTK_OBJECT (prefs->blink_checkbox), "toggled",
			    GTK_SIGNAL_FUNC (prop_changed), prefs);

	/* Show menu bar */
	prefs->menubar_checkbox = glade_xml_get_widget (gui, "menubar-checkbox");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (prefs->menubar_checkbox),
				      cfg->menubar_hidden ? 1 : 0);
	gtk_signal_connect (GTK_OBJECT (prefs->menubar_checkbox), "toggled",
			    GTK_SIGNAL_FUNC (prop_changed), prefs);
#if 1
	/* Show tool bar */
	prefs->toolbar_checkbox = glade_xml_get_widget (gui, "toolbar-checkbox");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (prefs->toolbar_checkbox),
				      cfg->toolbar_hidden ? 1 : 0);

	gtk_signal_connect (GTK_OBJECT (prefs->toolbar_checkbox), "toggled",
			    GTK_SIGNAL_FUNC (prop_changed), prefs);

	/* Show button bar */
	prefs->buttonbar_checkbox = glade_xml_get_widget (gui, "buttonbar-checkbox");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (prefs->buttonbar_checkbox),
				      cfg->buttonbar_hidden ? 1 : 0);
	gtk_signal_connect (GTK_OBJECT (prefs->buttonbar_checkbox), "toggled",
			    GTK_SIGNAL_FUNC (prop_changed), prefs);

	prefs->titled_tabs = glade_xml_get_widget(gui, "titled-tabs");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (prefs->titled_tabs),
				      cfg->titled_tabs ? 1 : 0);
	
	gtk_signal_connect (GTK_OBJECT (prefs->titled_tabs), "toggled",
			    GTK_SIGNAL_FUNC(prop_changed), prefs);

	prefs->lbl_maxch = glade_xml_get_widget(gui, "lbl-maxch");
	
	prefs->maxch = glade_xml_get_widget(gui, "entry-maxch");
	sprintf(mch, "%d",cfg->maxch);
	gtk_entry_set_text(GTK_ENTRY(prefs->maxch), mch);
	gtk_signal_connect (GTK_OBJECT(prefs->maxch), "insert-text",
			    GTK_SIGNAL_FUNC( insert_text_handler ), prefs);
	gtk_signal_connect (GTK_OBJECT(prefs->maxch), "changed", 
				       GTK_SIGNAL_FUNC(prop_changed), prefs);	
#endif
	
	/* Toggle the bell */
	prefs->bell_checkbox = glade_xml_get_widget (gui, "bell-checkbox");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (prefs->bell_checkbox),
				      zvt_term_get_bell(ZVT_TERM(term)) ? 0 : 1);
	gtk_signal_connect (GTK_OBJECT (prefs->bell_checkbox), "toggled",
			    GTK_SIGNAL_FUNC (prop_changed), prefs);

	/* Swap keys */
	prefs->swapkeys_checkbox = glade_xml_get_widget (gui, "swapkeys-checkbox");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (prefs->swapkeys_checkbox),
				      cfg->swap_keys ? 1 : 0);
	gtk_signal_connect (GTK_OBJECT (prefs->swapkeys_checkbox), "toggled",
			    GTK_SIGNAL_FUNC (prop_changed), prefs);
	
#ifdef HAVE_ZVT_DEL_IS_DEL
	/* Delete key: Send DEL/^H or kdch1 (Esc[3~) */
	prefs->del_is_del_checkbox = glade_xml_get_widget (gui, "del-is-del-checkbox");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (prefs->del_is_del_checkbox),
				      cfg->del_is_del ? 1 : 0);
	gtk_signal_connect (GTK_OBJECT (prefs->del_is_del_checkbox), "toggled",
			    GTK_SIGNAL_FUNC (prop_changed), prefs);
#endif
	
	/* --login by default */
	prefs->login_by_default_checkbox = glade_xml_get_widget (gui, "login-by-default-checkbox");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (prefs->login_by_default_checkbox),
				      cfg->login_by_default ? 1 : 0);
	gtk_signal_connect (GTK_OBJECT (prefs->login_by_default_checkbox), "toggled",
			    GTK_SIGNAL_FUNC (prop_changed), prefs);
	
	prefs->close_dialog_checkbox = glade_xml_get_widget (gui, "close-dialog");

	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (prefs->close_dialog_checkbox),
				      cfg->close_confirm ? 1 : 0);

	gtk_signal_connect (GTK_OBJECT (prefs->close_dialog_checkbox), "toggled",
			    GTK_SIGNAL_FUNC (prop_changed), prefs);

	
	/* tab position */
	prefs->tab_position = glade_xml_get_widget (gui, "tab-position");

	if (cfg->tab_hidden)
  	  {
   	    gtk_entry_set_text (GTK_ENTRY(prefs->tab_position), "none");
	    
  	  }
	else
	  {
	    gtk_entry_set_text (GTK_ENTRY(prefs->tab_position),
	    			cfg->tab_position == GTK_POS_BOTTOM ? "bottom" :
	    			cfg->tab_position == GTK_POS_LEFT   ? "left"   :
	    			cfg->tab_position == GTK_POS_RIGHT  ? "right"  : "top");
	    
	  }

	gtk_signal_connect (GTK_OBJECT (prefs->tab_position), "changed",
			    GTK_SIGNAL_FUNC(prop_changed), prefs);


	/* Word selection class */
	prefs->wordclass_entry = glade_xml_get_widget (gui, "wordclass-entry");
	gtk_entry_set_text (GTK_ENTRY (prefs->wordclass_entry),
			    cfg->wordclass);
	gtk_signal_connect (GTK_OBJECT (prefs->wordclass_entry), "changed",
			    GTK_SIGNAL_FUNC (prop_changed), prefs);
	gnome_dialog_editable_enters (GNOME_DIALOG (prefs->prop_win),
				      GTK_EDITABLE (prefs->wordclass_entry));


	/* Image page */
	/* if pixmap support isn't in zvt, we still create the widgets for
	   the page, so that we can query them later, but they won't be shown
	   so the user can't change them */
	if (!zvt_pixmap_support) {
		GtkWidget *image_table = glade_xml_get_widget (gui, "image-table");
		gtk_widget_hide (image_table);
	}
	
	r = glade_xml_get_widget (gui, "background-none-checkbox");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (r), FALSE);
	
	/* Background Pixmap checkbox */
	prefs->pixmap_checkbox = glade_xml_get_widget (gui, "pixmap-checkbox");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (prefs->pixmap_checkbox),
				      ZVT_TERM(term)->pixmap_filename ? 1 : 0);
	gtk_signal_connect (GTK_OBJECT (prefs->pixmap_checkbox), "toggled",
			    GTK_SIGNAL_FUNC (prop_changed), prefs);
	
	/* Background pixmap filename */
	prefs->pixmap_label = glade_xml_get_widget (gui, "pixmap-label");

	prefs->pixmap_file_entry = glade_xml_get_widget (gui, "pixmap-file-entry");
	prefs->pixmap_entry =
		gnome_file_entry_gtk_entry(GNOME_FILE_ENTRY(prefs->pixmap_file_entry));
	gtk_entry_set_text (GTK_ENTRY (prefs->pixmap_entry),
			    cfg->pixmap_file?cfg->pixmap_file:"");
	gtk_entry_set_position (GTK_ENTRY (prefs->pixmap_entry), 0);
	gtk_signal_connect (GTK_OBJECT (prefs->pixmap_entry), "changed",
			    GTK_SIGNAL_FUNC (prop_changed), prefs);

	prefs->perclbl = glade_xml_get_widget(gui, "perclbl");
	/* Scrollable pixmap */
#ifdef ZVT_BACKGROUND_SCROLL
	prefs->pixmap_scrollable_checkbox = glade_xml_get_widget (gui, "pixmap-scrollable-checkbox");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (prefs->pixmap_scrollable_checkbox),
				      cfg->scroll_background ? 1 : 0);
	gtk_signal_connect (GTK_OBJECT (prefs->pixmap_scrollable_checkbox), "toggled",
			    GTK_SIGNAL_FUNC (prop_changed), prefs);
#else
	gtk_widget_hide (glade_xml_get_widget (gui, "pixmap-scrollable-checkbox"));
#endif
#ifdef SHADING
	prefs->om_imgmode = glade_xml_get_widget(gui, "om_imgmode");
	create_option_menu (prefs->om_imgmode,
			    GNOME_PROPERTY_BOX (prefs->prop_win), prefs,
			    image_modes, cfg->image_mode, GTK_SIGNAL_FUNC (set_active_im));

#endif	
	/* Transparency */
	prefs->transparent_checkbox = glade_xml_get_widget (gui, "transparent-checkbox");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (prefs->transparent_checkbox),
				      ZVT_TERM(term)->transparent ? 1 : 0);
	gtk_signal_connect (GTK_OBJECT (prefs->transparent_checkbox), "toggled",
			    GTK_SIGNAL_FUNC (prop_changed), prefs);
#ifdef SHADING
	prefs->tinted_checkbox = glade_xml_get_widget(gui, "tinted-checkbox");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (prefs->tinted_checkbox),
				      ZVT_TERM(term)->tintback ? 1 : 0);
	gtk_signal_connect (GTK_OBJECT (prefs->tinted_checkbox), "toggled",
			    GTK_SIGNAL_FUNC (prop_changed), prefs);
	prefs->tinted_colorpicker  = glade_xml_get_widget(gui, "tinted-colorpicker");
	b5 = prefs->tinted_colorpicker;
	gnome_color_picker_set_i16(GNOME_COLOR_PICKER(b5), 
				   (int) 65535*(((double)cfg->rtint) / 256),
				   (int) 65535*(((double)cfg->gtint) / 256), 
				   (int) 65535*(((double)cfg->btint) / 256), 0);
	gtk_signal_connect (GTK_OBJECT( b5 ), "destroy",
			    GTK_SIGNAL_FUNC (free_cs), prefs->tinted_colorpicker);
	gtk_signal_connect (GTK_OBJECT ( prefs->tinted_colorpicker ), "color_set",
			    GTK_SIGNAL_FUNC (color_changed), prefs);
	
	prefs->shaded_hscale = glade_xml_get_widget(gui, "shaded-hscale");
	adj = gtk_range_get_adjustment(GTK_RANGE(prefs->shaded_hscale));
	gtk_adjustment_set_value(adj, 
		(int)(100*(256 - (double)ZVT_TERM(term)->shading.brightness)/256));

	gtk_signal_connect(GTK_OBJECT(adj), "value-changed", 
			   GTK_SIGNAL_FUNC (prop_changed),
			   prefs);
	
	
#endif
	/* Shaded */
	prefs->shaded_checkbox = glade_xml_get_widget (gui, "shaded-checkbox");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (prefs->shaded_checkbox),
				      ZVT_TERM(term)->shaded ? 1 : 0);
	gtk_signal_connect (GTK_OBJECT (prefs->shaded_checkbox), "toggled",
			    GTK_SIGNAL_FUNC (prop_changed), prefs);

	check_image_options_sensitivity (prefs);

	/* Color page */
	
	/* Color palette */
	prefs->color_scheme = glade_xml_get_widget (gui, "color-scheme-optionmenu");
	create_option_menu (prefs->color_scheme,
			    GNOME_PROPERTY_BOX (prefs->prop_win), prefs,
			    color_scheme, cfg->color_type, GTK_SIGNAL_FUNC (set_active));
	gtk_object_set_user_data (GTK_OBJECT (prefs->color_scheme), GINT_TO_POINTER (cfg->color_type));

	/* QUI PER CAMBIARE COLORI RELATIVI ALLO  STATO DEL TERMINALE 
	   inoltre modificare il file multi-gnome-terminal.glade con glade */
	/* Foreground, background buttons */
	prefs->lbl_termchgn = glade_xml_get_widget(gui, "lbl_termchgn");
	prefs->palette[18] = glade_xml_get_widget(gui, "cp_changing");
	b3 = prefs->palette[18];
	gtk_signal_connect(GTK_OBJECT(b3), "destroy", GTK_SIGNAL_FUNC(free_cs), 
			   prefs->palette[18]);
	prefs->lbl_termchgd = glade_xml_get_widget(gui, "lbl_termchgd");
	prefs->palette[19] = glade_xml_get_widget(gui, "cp_changed");
	b4 = prefs->palette[19];
	gtk_signal_connect(GTK_OBJECT(b4), "destroy", GTK_SIGNAL_FUNC(free_cs), 
			   prefs->palette[19]);

	prefs->but_default = glade_xml_get_widget(gui, "but_default");	
	gtk_signal_connect(GTK_OBJECT(prefs->but_default), "clicked", 
			   GTK_SIGNAL_FUNC(default_cols), prefs);

	prefs->fore_label = glade_xml_get_widget (gui, "foreground-label");
	
	prefs->palette[16] = glade_xml_get_widget (gui, "foreground-colorpicker");
	b1 = prefs->palette[16];
	gtk_signal_connect (GTK_OBJECT (b1), "destroy", GTK_SIGNAL_FUNC (free_cs), prefs->palette[16]);

	prefs->back_label = glade_xml_get_widget (gui, "background-label");
	
	prefs->palette[17] = glade_xml_get_widget (gui, "background-colorpicker");
	b2 = prefs->palette[17];
	gtk_signal_connect (GTK_OBJECT (b2), "destroy", GTK_SIGNAL_FUNC (free_cs), prefs->palette[17]);

	prefs->palette_label = glade_xml_get_widget (gui, "palette-label");
	
	for (i=0;i<20;i++) {
		if (i<16) {
			gchar *widget_name;

			widget_name = g_strdup_printf ("palette-%d-colorpicker", i);
			prefs->palette[i] = glade_xml_get_widget (gui, widget_name);
			gtk_container_set_resize_mode(GTK_CONTAINER(prefs->palette[i]),
								    GTK_RESIZE_PARENT);
			g_free (widget_name);
		}
		gnome_color_picker_set_i16(GNOME_COLOR_PICKER(prefs->palette[i]), cfg->palette[i].red,
					   cfg->palette[i].green, cfg->palette[i].blue, 0);
		gtk_signal_connect (GTK_OBJECT (prefs->palette[i]), "color_set",
				    GTK_SIGNAL_FUNC (color_changed), prefs);
	}

	/* default foreground/background selector */
	prefs->def_fore_back = glade_xml_get_widget (gui, "fore-background-optionmenu");
	create_option_menu_data (prefs->def_fore_back,
				 GNOME_PROPERTY_BOX (prefs->prop_win), prefs,
				 fore_back_table, cfg->color_set, GTK_SIGNAL_FUNC (set_active));
	
	/* ADDED */
	gtk_widget_set_sensitive(GTK_WIDGET (prefs->lbl_termchgd), 1);
	gtk_widget_set_sensitive(GTK_WIDGET (prefs->lbl_termchgn), 1);

	check_color_sensitivity (prefs);

	
	/* Scrolling page */

	/* Scrollbar position */
	prefs->scrollbar = glade_xml_get_widget (gui, "scrollbar-optionmenu");
	create_option_menu (prefs->scrollbar,
			    GNOME_PROPERTY_BOX (prefs->prop_win), prefs,
			    scrollbar_position_list,
			    cfg->scrollbar_position, GTK_SIGNAL_FUNC (set_active));
	gtk_object_set_user_data(GTK_OBJECT(prefs->scrollbar), GINT_TO_POINTER(cfg->scrollbar_position));

	/* Scroll back */
	prefs->scrollback_spin = glade_xml_get_widget (gui, "scrollback-spin");
	gtk_spin_button_set_value (GTK_SPIN_BUTTON (prefs->scrollback_spin), (gfloat)cfg->scrollback);
	
	gtk_signal_connect (GTK_OBJECT (prefs->scrollback_spin), "changed",
			    GTK_SIGNAL_FUNC (prop_changed), prefs);
	gnome_dialog_editable_enters (GNOME_DIALOG (prefs->prop_win),
				      GTK_EDITABLE (prefs->scrollback_spin));

	/* Scroll on keystroke checkbox */
	prefs->scroll_kbd_checkbox = glade_xml_get_widget (gui, "scroll-kbd-checkbox");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (prefs->scroll_kbd_checkbox),
				      cfg->scroll_key);
	gtk_signal_connect (GTK_OBJECT (prefs->scroll_kbd_checkbox), "toggled",
			    GTK_SIGNAL_FUNC (prop_changed), prefs);

	/* Scroll on output checkbox */
	prefs->scroll_out_checkbox = glade_xml_get_widget (gui, "scroll-out-checkbox");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (prefs->scroll_out_checkbox),
				      cfg->scroll_out);
	gtk_signal_connect (GTK_OBJECT (prefs->scroll_out_checkbox), "toggled",
			    GTK_SIGNAL_FUNC (prop_changed), prefs);

	/* connect the property box signals */
	gtk_signal_connect (GTK_OBJECT (prefs->prop_win), "apply",
			    GTK_SIGNAL_FUNC (apply_changes_cmd), p_term_list);
	gtk_signal_connect (GTK_OBJECT (prefs->prop_win), "destroy",
			    GTK_SIGNAL_FUNC (window_destroy), p_term_list);
	gtk_signal_connect (GTK_OBJECT (prefs->prop_win), "help",
			    GTK_SIGNAL_FUNC (phelp_cb), NULL);

	gtk_object_unref (GTK_OBJECT (gui));
	

}

#define NEED_UNUSED_FUNCTIONS
#ifdef NEED_UNUSED_FUNCTIONS
static void
color_ok (GtkWidget *w)
{
	gtk_widget_destroy (gtk_widget_get_toplevel (w));
}

void
color_cmd (void)
{
	GtkWidget *c;
 
	c = gtk_color_selection_dialog_new (_("Color selector"));
	gtk_window_set_policy(GTK_WINDOW(c), FALSE, FALSE, TRUE);
	gtk_signal_connect (GTK_OBJECT (GTK_COLOR_SELECTION_DIALOG (c)->ok_button),
			    "clicked", GTK_SIGNAL_FUNC (color_ok), c);
	gtk_widget_hide (GTK_COLOR_SELECTION_DIALOG (c)->cancel_button);
	gtk_widget_hide (GTK_COLOR_SELECTION_DIALOG (c)->help_button);
	gtk_widget_show (c);

}
#endif

GnomeUIInfo gnome_terminal_terminal_menu [] = {
        GNOMEUIINFO_MENU_NEW_ITEM (N_("_New Window"), N_("Creates a new terminals window"), new_terminal, NULL),
	GNOMEUIINFO_SEPARATOR,
	GNOMEUIINFO_ITEM_STOCK(N_("Remove Terminal"), N_("Remove current terminal"), tb_remove_book, GNOME_STOCK_PIXMAP_REMOVE),
	GNOMEUIINFO_ITEM_STOCK(N_("Change Title"), N_("Change Title of current terminal"), tb_change_title,  GNOME_STOCK_MENU_PREF),
	GNOMEUIINFO_SEPARATOR,
	GNOMEUIINFO_TOGGLEITEM (N_("Show _menubar"), N_("Toggles whether or not the menubar is displayed."), toggle_menubar_cmd, NULL),
	GNOMEUIINFO_TOGGLEITEM (N_("Show _toolbar"), N_("Toggles whether or not the toolbar is displayed."), toggle_toolbar_cmd, NULL),
	GNOMEUIINFO_TOGGLEITEM (N_("Show _buttonbar"), N_("Toggles whether or not the buttonbar is displayed."), toggle_buttonbar_cmd, NULL),
	GNOMEUIINFO_SEPARATOR,
	GNOMEUIINFO_ITEM_STOCK (N_("_Close Window"), NULL, close_terminal_cmd,
	GNOME_STOCK_MENU_EXIT),
	GNOMEUIINFO_END
};


void
toggle_menubar_cmd (GtkWidget *widget, GSList **p_term_list)
{
	GnomeApp *app;
	GtkWidget* term=NULL;
	GtkCheckMenuItem *toggle_item;
	gint w, h;	
	GSList *tt;
	struct terminal_config *cfg=NULL;
	tt = *p_term_list;
	/* NOTE: set properly all terminals!!!*/
	while (tt)
	  {
	    term = GTK_WIDGET(tt->data);
	    cfg = gtk_object_get_data (GTK_OBJECT (term), "config");
	
	    cfg->menubar_hidden = ! cfg->menubar_hidden;
	    tt = tt->next;
	  }
 	app = GNOME_APP (gtk_widget_get_toplevel (GTK_WIDGET (term)));
	w = ZVT_TERM(term)->vx->vt.width;
       	h = ZVT_TERM(term)->vx->vt.height;
	/* the following set/unset avoid geometry problems 
	   if the menubar is created in hide_menubar,
	   maybe if GTK_VISIBLE flag is unset
	   some resize is not called and all works fine
	 */
	GTK_WIDGET_UNSET_FLAGS(GTK_WIDGET(app),GTK_VISIBLE); 
	if (cfg->menubar_hidden)
	  hide_menubar(app, TRUE);	  
  	else
	  hide_menubar (app, FALSE);

	/* update other toggle item */
	toggle_item = GTK_CHECK_MENU_ITEM (gnome_terminal_terminal_menu[FILE_MENU_TOGGLE_INDEX_TOOLBAR].widget);
	toggle_item->active = !cfg->toolbar_hidden;
	toggle_item = GTK_CHECK_MENU_ITEM (gnome_terminal_terminal_menu[FILE_MENU_TOGGLE_INDEX_BUTTONBAR].widget);
	toggle_item->active = !cfg->buttonbar_hidden;

	GTK_WIDGET_SET_FLAGS(GTK_WIDGET(app),GTK_VISIBLE); 

	/* term->p_term_list */
	save_preferences_cmd (widget, p_term_list);
	/* NOTE: here we put term instead of app because
	   in this way the term size is correctly set */
	term = GTK_WIDGET(current_term(p_term_list));
	zvt_term_set_size(ZVT_TERM(term), w, h);
	gtk_widget_queue_resize(GTK_WIDGET(app));
	gtk_widget_grab_focus(GTK_WIDGET(term));
}

void
toggle_toolbar_cmd (GtkWidget *widget, GSList **p_term_list)
{
	GnomeApp *app;
	GtkWidget* term=NULL;
	gint w, h;	
	GSList *tt;
	struct terminal_config *cfg=NULL;
	
	tt = *p_term_list;
	/* NOTE: set properly all terminals !!!*/
	while (tt)
	  {
	    term = GTK_WIDGET(tt->data);
	    cfg = gtk_object_get_data (GTK_OBJECT (term), "config");
	
	    cfg->toolbar_hidden = ! cfg->toolbar_hidden;
	    tt = tt->next;
	  }
       	
	app = GNOME_APP (gtk_widget_get_toplevel (GTK_WIDGET (term)));
	w = ZVT_TERM(term)->vx->vt.width;
       	h = ZVT_TERM(term)->vx->vt.height;
	GTK_WIDGET_UNSET_FLAGS(GTK_WIDGET(app),GTK_VISIBLE); 
	if (cfg->toolbar_hidden)
	  hide_toolbar (app, TRUE);
	else
	  hide_toolbar (app, FALSE);
	GTK_WIDGET_SET_FLAGS(GTK_WIDGET(app),GTK_VISIBLE); 
	/* term->p_term_list */
	save_preferences_cmd (widget, p_term_list);
	/*gtk_widget_queue_resize(GTK_WIDGET(app));*/
	term = GTK_WIDGET(current_term(p_term_list));
	zvt_term_set_size(ZVT_TERM(term), w, h);
	gtk_widget_queue_resize(GTK_WIDGET(app));
	gtk_widget_grab_focus(GTK_WIDGET(term));
}

void
toggle_buttonbar_cmd (GtkWidget *widget, GSList **p_term_list)
{
  GnomeApp *app;
  GtkWidget* term=NULL;
  gint w, h;	
  GSList *tt;
  struct terminal_config *cfg=NULL;
  
  tt = *p_term_list;
  /* NOTE:  set properly all terminals !!!*/
  while (tt)
    {
      term = GTK_WIDGET(tt->data);
      cfg = gtk_object_get_data (GTK_OBJECT (term), "config");
      
      cfg->buttonbar_hidden = ! cfg->buttonbar_hidden;
      tt = tt->next;
    }
       	
  app = GNOME_APP (gtk_widget_get_toplevel (GTK_WIDGET (term)));
  
  w = ZVT_TERM(term)->vx->vt.width;
  h = ZVT_TERM(term)->vx->vt.height;
  GTK_WIDGET_UNSET_FLAGS(GTK_WIDGET(app),GTK_VISIBLE); 
  if (cfg->buttonbar_hidden)
    hide_buttonbar(app, TRUE);
  else
    hide_buttonbar(app, FALSE);
  GTK_WIDGET_SET_FLAGS(GTK_WIDGET(app),GTK_VISIBLE); 
  /* term->p_term_list */
  save_preferences_cmd (widget, p_term_list);
  term = GTK_WIDGET(current_term(p_term_list));
  zvt_term_set_size(ZVT_TERM(term), w, h);
  gtk_widget_queue_resize(GTK_WIDGET(app));
}

#ifdef HAVE_ZVT_TERM_RESET
static void
reset_terminal_soft_cmd (GtkWidget *widget, GSList **p_term_list) 
{
  /* fare in modo di resettare il terminale attuale */
  ZvtTerm *term;
  term = current_term(p_term_list);
  zvt_term_reset(term, 0);
}


/* could also possible clear the buffer? */
static void
reset_terminal_hard_cmd (GtkWidget *widget, GSList **p_term_list) 
{
  ZvtTerm* term;
  term = current_term(p_term_list);
  zvt_term_reset(term, 1);
}
#endif
void
paste_cmd (GtkWidget *widget, GSList **p_term_list) 
{
	GdkAtom string_atom;
	GdkEvent *event;
	gint32 time;
	/* AGGIUNTA 17/08/01 */
	ZvtTerm* term;
	if (p_term_list == NULL)
	  return;
	
	term = current_term(p_term_list);
	
	string_atom = gdk_atom_intern ("STRING", FALSE);
	if (string_atom == GDK_NONE)
		return;

	event = gtk_get_current_event ();
	switch (event->type){
	case GDK_BUTTON_PRESS:
	case GDK_2BUTTON_PRESS:
	case GDK_BUTTON_RELEASE:
		time = event->button.time;
		break;

	case GDK_KEY_PRESS:
	case GDK_KEY_RELEASE:
		time = event->key.time;
		break;

	default:
		time = GDK_CURRENT_TIME;
	}
	
	gtk_selection_convert (GTK_WIDGET (term), GDK_SELECTION_PRIMARY, string_atom,
			       time);
}
void
toggle_secure_keyboard_cmd (GtkWidget *w, GSList **p_term_list) 
{
	struct terminal_config *cfg=NULL;
	/*
	   17/08/01: set secure keyboard for all terminals of the current window (GnomeApp)
	 */
	ZvtTerm *term=NULL;
	GSList *next;
	next = *p_term_list;
	
	/* NOTE: set properly all terminals */
	while (next)
	  { 
	    term = ZVT_TERM(next->data);
	    cfg = gtk_object_get_data (GTK_OBJECT (term), "config");
	    
	    cfg->keyboard_secured = ! cfg->keyboard_secured;
	    next = next->next;
	  }	 

       	if (cfg->keyboard_secured)
	  gdk_keyboard_grab (term->term_window, TRUE, GDK_CURRENT_TIME);
    	else
	  gdk_keyboard_ungrab (GDK_CURRENT_TIME);
	
}
#ifdef ZVT_TERM_MATCH_SUPPORT
static void
load_url_cmd (GtkWidget *widget, GSList  **p_term_list) 
{
	char *url;
	/* AGGIUNTA 17/08/01 */
	ZvtTerm* term;
	term = current_term(p_term_list);
	
	url = gtk_object_get_data (GTK_OBJECT (term), "matchstr");
	printf("URL: %s\n", url);	  
	if (url) {
  	  gnome_url_show(url);
	}

}
#endif
/* FILL THESE */
void
on_add_button_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
 GtkEntry *tn, *tc;
 GtkCList *l;
 char *riga[2], *name;
 int r;
 
 tn = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(button), "txt_name"));
 tc = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(button), "txt_command"));
 l = GTK_CLIST(gtk_object_get_data(GTK_OBJECT(button), "lista_cmd"));

 riga[0] = gtk_entry_get_text(tn);
 riga[1] = gtk_entry_get_text(tc);
 /* Get the number of rows in the clist object */

 if (!strlen(riga[0]) || !strlen(riga[1]))
   return;
 r = 0;
 while(gtk_clist_get_text(l, r, 0, &name))
   {
     if (!strcmp(name, riga[0]))
       {
	 gtk_clist_set_text(l, r, 1, riga[1]);
	 return;
       } 
     r++;
   }
 
 gtk_clist_append(l, riga);

}


void
on_remove_button_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkCList *l;
  int *p_cr;
  
  l = GTK_CLIST(gtk_object_get_data(GTK_OBJECT(button), "lista_cmd"));
  p_cr = gtk_object_get_data(GTK_OBJECT(l), "current_row");

  
  if (*p_cr >=0 )  
    {
      gtk_clist_remove(l, *p_cr);
    }
}


void
on_lista_cmd_select_row                (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  int *cr;
  cr = gtk_object_get_data(GTK_OBJECT(clist), "current_row");
  *cr = row;
}
#define	ROW_ELEMENT(clist, row)	(((row) == (clist)->rows - 1) ? \
				 (clist)->row_list_end : \
				 g_list_nth ((clist)->row_list, (row)))


void on_del_button_clicked   (GtkButton       *button,
	  				     gpointer         user_data)
{
  GtkEntry *tn, *tc;
  tn = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(button), "txt_name"));
  tc = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(button), "txt_command")); 
  gtk_entry_set_text(tn, "");
  gtk_entry_set_text(tc, "");

}

       
void on_chg_button_clicked                  (GtkButton       *button,
	  				     gpointer         user_data)
{
  GtkEntry *tn, *tc;
  GList* sl;
  GtkCList* l;
  GtkCListRow* lrow;
  int row;
  char *name,*command;

  l = GTK_CLIST(user_data);
  sl = l->selection;
  if (!sl)
    return;
  
  row = GPOINTER_TO_INT(sl->data);
  lrow = ROW_ELEMENT(l,row)->data;

  if (lrow)
    {
      tn = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(button), "txt_name"));
      tc = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(button), "txt_command"));  
      name = GTK_CELL_TEXT(lrow->cell[0])->text;
      command = GTK_CELL_TEXT(lrow->cell[1])->text;     
      gtk_entry_set_text(tn, name);
      gtk_entry_set_text(tc, command);
    }
}

void
on_cancel_button_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* win;
  win = gtk_widget_get_toplevel(GTK_WIDGET(button));
  gtk_widget_destroy(win);
}
/* If you change the menu you must change also the following define accordingly */
GnomeUIInfo custom_submenu_void [] =
{
  GNOMEUIINFO_END
};


extern void new_shell(GSList** p_term_list, guint action);
extern void new_root(GSList** p_term_list, guint action);
extern void new_mc(GSList** p_term_list, guint action);
extern void remove_term(GtkWidget* term);


void popup_remove_tab(GtkWidget *w, gpointer data)
{
  remove_term( GTK_WIDGET(current_term(((GSList**)data))));
}

extern void change_title_page(GtkWidget* widget, gpointer data, int page);

void popup_change_title(GtkWidget *w, gpointer data)
{
  GSList** ptl;
  ZvtTerm* ct;
  GtkWidget* nb, *app;
  ptl = (GSList**) data;
  ct = current_term(ptl);
  app = gtk_widget_get_toplevel(GTK_WIDGET(ct));
  nb = GTK_WIDGET(gtk_object_get_data(GTK_OBJECT(app), "notebook"));
  change_title_page(w, (gpointer) nb, -1);
}


#if 0
void popup_new_shell(GtkWidget* w, gpointer data)
{
  new_shell((GSList**) data,0);
}

void popup_new_root(GtkWidget* w, gpointer data)
{
  new_root((GSList**) data,0);
}

void popup_new_mc(GtkWidget* w, gpointer data)
{
  new_mc((GSList**) data,0);
}
#endif

/*
 * Warning:
 * 
 *   If you change the layout of the popup menus, you must update the
 *   value of the POPUP_MENU_TOGGLE_INDEX_* macros to reflect the new
 *   menu item indices.
 */

GnomeUIInfo gnome_terminal_popup_menu [] = {
        GNOMEUIINFO_MENU_NEW_ITEM (N_("_New Window"), N_("Creates a new terminal window"), new_terminal, NULL),
	GNOMEUIINFO_SEPARATOR,
	GNOMEUIINFO_MENU_NEW_ITEM (N_("Remove Tab"), N_("remove current tab"), popup_remove_tab, NULL),
	GNOMEUIINFO_MENU_NEW_ITEM (N_("Change Title"), N_("Change title of current tab"), popup_change_title, NULL),
	GNOMEUIINFO_SEPARATOR,
	GNOMEUIINFO_MENU_PREFERENCES_ITEM(preferences_cmd, NULL),
	GNOMEUIINFO_TOGGLEITEM (N_("_Show menubar"), N_("Toggles whether or not the menubar is displayed."),
				toggle_menubar_cmd, NULL),
	
	GNOMEUIINFO_TOGGLEITEM (N_("_Show toolbar"), N_("Toggles whether or not the toolbar is displayed."),
				toggle_toolbar_cmd, NULL),
	GNOMEUIINFO_TOGGLEITEM (N_("_Show buttonbar"), N_("Toggles whether or not the buttonbar is displayed."),
				toggle_buttonbar_cmd, NULL),

	GNOMEUIINFO_TOGGLEITEM (N_("_Secure keyboard"),
				N_("Toggles whether or not the keyboard is grabbed by the terminal."),
				toggle_secure_keyboard_cmd, NULL),
#ifdef HAVE_ZVT_TERM_RESET
	GNOMEUIINFO_ITEM_NONE (N_("_Reset Terminal"), NULL, reset_terminal_soft_cmd),
	GNOMEUIINFO_ITEM_NONE (N_("Reset and _Clear"), NULL, reset_terminal_hard_cmd),
#endif
#ifdef ZVT_TERM_MATCH_SUPPORT
	GNOMEUIINFO_END,	/* used as a free slot for dymanic menu item */
#endif
	GNOMEUIINFO_END
};
char *
my_gnome_unconditional_datadir_file (const char *filename)
{
  char *ret;
  ret = malloc(512*sizeof(char));
  strcpy(ret, GNOMEDATADIR);
  strcat(ret, "/share/");
  strcat(ret, filename);
  return ret;
}


gchar *
my_gnome_help_file_find_file (gchar *app, gchar *path)
{
	GList *language_list;
	GString *buf;
	
	gchar *res= NULL;
	gchar *p, c = 0;
	
	language_list= gnome_i18n_get_language_list ("LC_MESSAGES");
	while (!res && language_list)
	{
		const gchar *lang;
		
		lang= language_list->data;
		buf= g_string_new (NULL);
		g_string_sprintf (buf, "gnome/help/%s/%s/%s", app, lang, path);
		res= (gchar *)my_gnome_unconditional_datadir_file (buf->str);
		p = strrchr (res, '#');
		if (p) {
			c = *p;
			*p = '\0';
		}
		g_string_free (buf, TRUE);
		
		if (!g_file_exists (res))
		{
			g_free (res);
			res = NULL;
		}

		if (c && res){
			*p = c;
			c = 0;
		}
		
		language_list = language_list->next;
	}
	
	return res;
}


gchar *
my_gnome_help_file_path(gchar *app, gchar *path)
{
	gchar *res;
	GString *buf;
	
	res = my_gnome_help_file_find_file (app, path);
	
	/* If we found no document on the language depending datadirs, we
	   return a non existing file from a default datadir.  It's non
	   existing, because 'C' is always included in a language list.  */
	
	if (!res)
	{
		buf = g_string_new(NULL);
		g_string_sprintf(buf, "gnome/help/%s/C/%s", app, path);
		res = (gchar *)my_gnome_unconditional_datadir_file(buf->str);
		g_string_free(buf, TRUE);
	}
	
	return res;
}


void
my_gnome_help_display (void *ignore, GnomeHelpMenuEntry *ref)
{
	gchar *file, *url;
	
	g_assert(ref != NULL);
	g_assert(ref->path != NULL);
	g_assert(ref->name != NULL);

	file = my_gnome_help_file_path (ref->name, ref->path);
	
	if (!file)
		return;
	
	url = alloca (strlen (file)+10);
	strcpy (url,"ghelp:");
	strcat (url, file);
	gnome_help_goto (ignore, url);
	g_free (file);
}


void terminal_help_cb(GtkWidget* w, gpointer data)
{
  GnomeHelpMenuEntry help_entry = { "multi-gnome-terminal",
    "index.html" };
  
  my_gnome_help_display(NULL, &help_entry);
}

#ifdef ZVT_TERM_MATCH_SUPPORT
GnomeUIInfo gnome_terminal_popup_menu_url [] = {
	GNOMEUIINFO_ITEM_NONE (N_("_Open in browser"), NULL, load_url_cmd),
};
#endif
/* TODO: replace GNOMEUIINFO_HELP with a  GNOMEUUINFO_ITEM_INFO calling a callback
   which uses my_gnome_url_show */

/*	GNOMEUIINFO_HELP ("gnome-terminal"),*/
GnomeUIInfo gnome_terminal_help_menu [] = {
        GNOMEUIINFO_ITEM_NONE(N_("Terminal Help"), NULL, terminal_help_cb),
	GNOMEUIINFO_MENU_ABOUT_ITEM(about_terminal_cmd, NULL),
	GNOMEUIINFO_END
};

GnomeUIInfo gnome_terminal_edit [] = {
/*	GNOMEUIINFO_MENU_PASTE_ITEM(paste_cmd, NULL),*/
        GNOMEUIINFO_ITEM_NONE (N_("_Paste"), NULL, paste_cmd),
	GNOMEUIINFO_END
};

GnomeUIInfo gnome_terminal_settings_menu [] = {
        GNOMEUIINFO_MENU_PREFERENCES_ITEM(preferences_cmd, NULL),
	GNOMEUIINFO_ITEM_NONE (N_("_Edit Commands"), NULL, edit_commands),
#ifdef HAVE_ZVT_TERM_RESET
	GNOMEUIINFO_ITEM_NONE (N_("_Reset Terminal"), NULL, reset_terminal_soft_cmd),
	GNOMEUIINFO_ITEM_NONE (N_("Reset and _Clear"), NULL, reset_terminal_hard_cmd),
#endif
	GNOMEUIINFO_ITEM_NONE (N_("C_olor selector..."), NULL, color_cmd),
	GNOMEUIINFO_END
};

/* TENT: */
GnomeUIInfo gnome_terminal_toolbar[] = {
  GNOMEUIINFO_ITEM_STOCK(N_("Tab Left"), N_("Tab Left (CTRL-l Left)"), tb_tab_left,  GNOME_STOCK_PIXMAP_BACK),
  
  GNOMEUIINFO_ITEM_STOCK(N_("Tab Right"), N_("Tab Right (CTRL-l Right)"), tb_tab_right,  GNOME_STOCK_PIXMAP_FORWARD),
  GNOMEUIINFO_SEPARATOR,
  
  GNOMEUIINFO_ITEM_STOCK(N_("Remove"), N_("Remove Terminal"), tb_remove_book, GNOME_STOCK_PIXMAP_REMOVE),
  GNOMEUIINFO_ITEM_STOCK(N_("Title"), N_("Change Title"), tb_change_title,  GNOME_STOCK_PIXMAP_PROPERTIES),
  
  GNOMEUIINFO_END
};

GnomeUIInfo gnome_terminal_menu[] = {
   {
	GNOME_APP_UI_SUBTREE_STOCK, N_("File"), NULL,
	gnome_terminal_terminal_menu, NULL, NULL, (GnomeUIPixmapType) 0,
	NULL, 0, (GdkModifierType) 0, NULL
   },
   {
     GNOME_APP_UI_SUBTREE_STOCK, N_("New Tab"), NULL,
     NULL, NULL, NULL, (GnomeUIPixmapType) 0,
     NULL, 0, (GdkModifierType) 0, NULL
   },	 
   {
     GNOME_APP_UI_SUBTREE_STOCK, N_("Edit"), NULL,
     gnome_terminal_edit, NULL, NULL, (GnomeUIPixmapType) 0, NULL, 0,
     (GdkModifierType) 0, NULL
   },
   {
	GNOME_APP_UI_SUBTREE_STOCK, N_("Settings"), NULL,
        gnome_terminal_settings_menu, NULL, NULL,
	(GnomeUIPixmapType) 0, NULL, 0, (GdkModifierType) 0, NULL
   },
   {
	GNOME_APP_UI_SUBTREE_STOCK, N_("Help"), NULL,
	gnome_terminal_help_menu, NULL, NULL, (GnomeUIPixmapType) 0,
	NULL, 0, (GdkModifierType) 0, NULL
   },
   GNOMEUIINFO_END
};

/*
 * Puts in *shell a pointer to the full shell pathname
 * Puts in *name the invocation name for the shell
 * *shell is newly allocated 
 * *name is newly allocated
 */
void
get_shell_name (char **shell, char **name, gboolean isLogin)
{
	char *only_name;
	int len;

	*shell = gnome_util_user_shell ();
	g_assert (*shell != NULL);

	only_name = strrchr (*shell, '/');
	if (only_name != NULL)
		only_name++;
	else
		only_name = *shell;
	
	if (isLogin){
		len = strlen (only_name);
		
		*name  = g_malloc (len + 2);
		**name = '-';
		strcpy ((*name)+1, only_name); 
	} else {
		*name = g_strdup (only_name);
	}
}

void remove_book( GtkButton   *button, GtkNotebook *notebook );
void remove_term(GtkWidget* term);

void
terminal_kill (GtkWidget *widget, void *data)
{
  /* 
     With Exit only one terminal is closed */
  GtkWidget *notebook, *app = gtk_widget_get_toplevel (GTK_WIDGET (data));
  GSList** p_term_list;
  p_term_list = gtk_object_get_data(GTK_OBJECT(app),"ptermlist");
  notebook = gtk_object_get_data(GTK_OBJECT(app), "notebook");

  if (g_slist_length(*p_term_list)==1)
    {
      ok_close_app (GTK_WIDGET (app));
    }
  else
    {
      /* calling this func is wrong because can die also a terminal 
	 which is not the current one: FIX THIS BUG!!! */
      remove_term(widget);
    }
}

char * trunc_string (char * s, int len)
{
  if (strlen(s) < len)
    return s;

  s[len-1] = '\0';
  s[len-2] = s[len-3] = s[len-4] = '.';

  return s;


}

/* called for "title_changed" event.  Use it to change the window title */
void
title_changed(ZvtTerm *term, VTTITLE_TYPE type, char *newtitle)
{
	GnomeApp *window = GNOME_APP (gtk_widget_get_toplevel (GTK_WIDGET (term)));
	XTextProperty text_prop;
	Atom aprop;
	char *pchEndPropName;
	GtkWidget* app, *child, *label;
	GSList** ptl, *tmp;
	ZvtTerm* t;
	char *ttitle, xttitle[512], wt[512], *tname, wintitle[300], tmp2[300], *st;
	struct terminal_config* cfg;
	int len, wtlen, ntlen;

	GtkNotebook* nb;
	int n, ii, res;
	switch(type){
	case VTTITLE_WINDOW:
	case VTTITLE_WINDOWICON:
	  /* It makes no sense to change the window title in a multiterm
	     terminal so here we change tabs title instead */
	  app = gtk_widget_get_toplevel(GTK_WIDGET(term));
	  ptl = gtk_object_get_data(GTK_OBJECT(app), "ptermlist");
	  nb = gtk_object_get_data(GTK_OBJECT(app), "notebook");
	  tmp = *ptl;
	  n = 0;
	  /* find the number of the current tern */
	  while (tmp)
	    {
	      t = ZVT_TERM(tmp->data);
	      if (t == term)
		break;
	      tmp = tmp->next;
	      n++;
	    }
	  /* and now set tab and popup menu properly */
	  ttitle = gtk_object_get_data(GTK_OBJECT(term), "termtitle");
	  tname = gtk_object_get_data(GTK_OBJECT(term), "mtermname");
	  cfg = gtk_object_get_data(GTK_OBJECT(term), "config");
	  /* Some programs as vim stores the window title on start and
	     re-store that one on exit */
	  if (cfg->window_title)
	    strcpy(wt, trunc_string(cfg->window_title,256));
	  else
	    strcpy(wt, "MGT"); 
	  wtlen = strlen(wt);
	  ntlen = strlen(newtitle);
	  st = g_strndup(newtitle, wtlen);
	  /*printf("st: %s nt[wtlen+3]:%c\n", st, newtitle[wtlen+3]);*/
          if (!(!strcmp(st,wt) && newtitle[wtlen+1]=='-'
	      && newtitle[wtlen+3]=='[' && newtitle[ntlen-1]==']'))
	  /*if ((res = sscanf(newtitle, "%s - [ %d-%[^]]]",
		 cfg->window_title, &ii, ttitle)) < 2)*/
	    {
	      /* This delete an extra space otherwise added to the end of newtitle */
	      strcpy(ttitle, trunc_string(newtitle, 256));
	    }
	  else
	    {
	      strcpy(xttitle, trunc_string(newtitle+wtlen+3,256));
	      if (sscanf(xttitle, "[ %d-%[^]]]",
		     &ii, ttitle)<2)
		strcpy(ttitle, trunc_string(xttitle, 256));
	      else
		{
		  len = strlen(ttitle);
		  ttitle[len-1] = '\0';
		}
	    }
	  g_free(st);
	  /*printf("wt: %s tt: %s newt: %s\n", cfg->window_title, ttitle, newtitle);*/
	  
	  /* And now set also tab if needed */
	  if (cfg->titled_tabs)
	    {
	      sprintf(tmp2, "%d-%s", n, ttitle); 
	      
	      child = gtk_notebook_get_nth_page(GTK_NOTEBOOK(nb), n);
	      label = gtk_notebook_get_tab_label(GTK_NOTEBOOK(nb), child);
	      gtk_label_set_text(GTK_LABEL(label), trunc_string(tmp2, cfg->maxch));
	      label = gtk_notebook_get_menu_label(GTK_NOTEBOOK(nb), child);
	      gtk_label_set_text(GTK_LABEL(label), trunc_string(tmp2, cfg->maxch));
	    }

	  if (n == gtk_notebook_get_current_page(nb))
	    {  
	      sprintf(wintitle, "%s - [ %d-%s ]", wt, n, ttitle);
	      gtk_window_set_title((GtkWindow *)window, wintitle);
	    }
  	  break;
	/* this is a enumeration, so we can't #ifdef check it */
	/* case VTTITLE_XPROPERTY: */
	case 3:
		pchEndPropName = strchr(newtitle,'=');
		if (pchEndPropName)
			*pchEndPropName = '\0';
		aprop = XInternAtom(GDK_DISPLAY(), newtitle, False);
		if (pchEndPropName == NULL) {
			/* no "=value" given, so delete the property */
			XDeleteProperty(GDK_DISPLAY(),
					GDK_WINDOW_XWINDOW(GTK_WIDGET(window)->window),
					aprop);
		} else {
			text_prop.value = pchEndPropName+1;
			text_prop.encoding = XA_STRING;
			text_prop.format = 8;
			text_prop.nitems = strlen(text_prop.value);
			XSetTextProperty(GDK_DISPLAY(),
					 GDK_WINDOW_XWINDOW(GTK_WIDGET(window)->window),
					 &text_prop,aprop);
		}
		break;
	default:
		break;
	}
}

static gchar *
extract_filename (const gchar* uri)
{
	/* file uri with a hostname */
	if (strncmp (uri, "file://", strlen ("file://")) == 0) {
		char *hostname = g_strdup (&uri[strlen("file://")]);
		char *p = strchr (hostname, '/');
		char *path;
		char localhostname[1024];
		/* if we can't find the '/' this uri is bad */
		if(p == NULL) {
			g_free (hostname);
			return NULL;
		}
		/* if no hostname */
		if(p == hostname)
			return hostname;

		path = g_strdup (p);
		*p = '\0';

		/* if really local */
		if (g_strcasecmp (hostname, "localhost") == 0 ||
		    g_strcasecmp (hostname, "localhost.localdomain") == 0) {
			g_free (hostname);
			return path;
		}

		/* ok get the hostname */
		if (gethostname (localhostname,
				 sizeof (localhostname)) < 0) {
			strcpy (localhostname, "");
		}

		/* if really local */
		if (localhostname[0] &&
		    g_strcasecmp (hostname, localhostname) == 0) {
			g_free (hostname);
			return path;
		}
		
		g_free (hostname);
		g_free (path);
		return NULL;

	/* if the file doesn't have the //, we take it containing 
	   a local path */
	} else if (strncmp(uri, "file:", strlen("file:"))==0) {
		const char *path = &uri[strlen("file:")];
		/* if empty bad */
		if(!*path) return NULL;
		return g_strdup(path);
	}
	return NULL;
}

static void  
drag_data_received  (GtkWidget *widget, GdkDragContext *context, 
		     gint x, gint y,
		     GtkSelectionData *selection_data, guint info,
		     guint time)
{
	ZvtTerm *term = ZVT_TERM (widget);
	int col, row, the_char;
	struct terminal_config *cfg;
	GtkWidget *app;
	GSList **p_term_list;

	cfg = gtk_object_get_data (GTK_OBJECT (term), "config");

	switch (info) {
	case TARGET_STRING:
	{
		char *copy = g_malloc (selection_data->length+1);
		GList *uris, *l;

		strncpy (copy, selection_data->data, selection_data->length);
		copy [selection_data->length] = 0;
		
		uris = gnome_uri_list_extract_uris (copy);

		for (l = uris; l; l = l->next){
			char *data = l->data;

			if (strncmp (data, "file:", 5) == 0)
				data += 5;
			
			vt_writechild (&term->vx->vt, data, strlen (data));
			vt_writechild (&term->vx->vt, " ", 1);
		}
		g_free (copy);
		gnome_uri_list_free_strings (uris);
		break;
	}
	case TARGET_COLOR:
	{
		guint16 *data = (guint16 *)selection_data->data;
		preferences_t *prefs;
		int i;

		if (selection_data->length != 8)
			return;

		col = x / term->charwidth;
		row = y / term->charheight;

		/* Switch to custom colors and */
		cfg->color_set = COLORS_CUSTOM;
		/* Here by dragging a color you can set the foreground/background color
		   of the terminal */	   
		the_char = vt_get_attr_at (term->vx, col, row) & 0xff;
		if (the_char == ' ' || the_char == 0)
			i=17;
		else
			i=16;

		cfg->palette[i].red = data[0];
		cfg->palette[i].green = data[1];
		cfg->palette[i].blue = data[2];

		set_color_scheme (term, cfg);
		app = gtk_widget_get_toplevel(GTK_WIDGET(term));
		p_term_list = gtk_object_get_data(GTK_OBJECT(app), "ptermlist");
		save_preferences_cmd (widget, p_term_list);

		prefs  = gtk_object_get_data (GTK_OBJECT (term), "prefs");
		if (prefs) {
			for (i=16;i<18;i++)
				gnome_color_picker_set_i16 (GNOME_COLOR_PICKER (prefs->palette[i]),
							    cfg->palette[i].red,
							    cfg->palette[i].green,
							    cfg->palette[i].blue, 0);
			gtk_option_menu_set_history (GTK_OPTION_MENU (prefs->def_fore_back),
						     cfg->color_set);
			check_color_sensitivity (prefs);
		}
		break;
	}
	case TARGET_BGIMAGE:
	{
		char *filename = (char *)selection_data->data;
		preferences_t *prefs;
		gboolean back_set;
		gboolean back_reset;

		if (filename != NULL &&
		    strstr (filename, RESET_IMAGE_NAME) != NULL) {
			zvt_term_set_background (term, NULL, 0, 0);

			cfg->background_pixmap = FALSE;

			/* Switch to white on black colors */
			cfg->color_set = COLORS_WHITE_ON_BLACK;
		
			set_color_scheme (term, cfg);
			app = gtk_widget_get_toplevel(GTK_WIDGET(term));
			p_term_list = gtk_object_get_data(GTK_OBJECT(app), "ptermlist");
			save_preferences_cmd (widget, p_term_list);


			/*save_preferences_cmd (widget, term);*/

			back_set = FALSE;
			back_reset = TRUE;
		} else if (zvt_pixmap_support &&
			   filename != NULL) {
			int flags;

			cfg->background_pixmap = TRUE;
			cfg->transparent = FALSE;
			g_free (cfg->pixmap_file);
			cfg->pixmap_file = extract_filename (filename);

#ifdef ZVT_BACKGROUND_SCROLL
			flags = cfg->shaded?ZVT_BACKGROUND_SHADED:0;
			flags |= cfg->scroll_background?ZVT_BACKGROUND_SCROLL:0;
#else
			flags = cfg->shaded;
#endif
			zvt_term_set_background (term,
						 cfg->pixmap_file,
						 cfg->transparent, flags);
			back_set = TRUE;
			back_reset = FALSE;
		} else {
			zvt_term_set_background (term, NULL, 0, 0);
			cfg->background_pixmap = FALSE;

			back_set = FALSE;
			back_reset = FALSE;
		}

		prefs  = gtk_object_get_data (GTK_OBJECT (term), "prefs");
		if (prefs) {
			if (back_reset) {
				gtk_option_menu_set_history (GTK_OPTION_MENU (prefs->def_fore_back),
							     cfg->color_set);
				check_color_sensitivity (prefs);
			} else if (back_set) {
				gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (prefs->pixmap_checkbox), TRUE);
				gtk_entry_set_text (GTK_ENTRY (prefs->pixmap_entry),
						    cfg->pixmap_file ? cfg->pixmap_file : "");
			} else {
				gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (prefs->pixmap_checkbox), FALSE);
			}
		}

		gtk_widget_queue_draw (GTK_WIDGET (term));
		break;
	}
	}
}

void
configure_term_dnd (ZvtTerm *term)
{
	static GtkTargetEntry target_table[] = {
		{ "STRING",     0, TARGET_STRING },
		{ "text/plain", 0, TARGET_STRING },
		{ "application/x-color", 0, TARGET_COLOR },
		{ "property/bgimage",    0, TARGET_BGIMAGE }
	};

	gtk_signal_connect (GTK_OBJECT (term), "drag_data_received",
			    GTK_SIGNAL_FUNC(drag_data_received), NULL);

	gtk_drag_dest_set (GTK_WIDGET (term),
			   GTK_DEST_DEFAULT_MOTION |
			   GTK_DEST_DEFAULT_HIGHLIGHT |
			   GTK_DEST_DEFAULT_DROP,
			   target_table, 4,
			   GDK_ACTION_COPY);
}

/* change this if you change the button bar menu */
static GtkItemFactoryEntry popup_items[] = {
    { "/MAIN",            NULL,  NULL, 0, "<Branch>" },
    { "/MAIN/New Shell",    "", new_shell, 0, NULL },
    { "/MAIN/Root Shell",    "", new_root, 0, NULL },
    { "/MAIN/mc",    "", new_mc, 0, NULL },
    { "/MAIN/Separator", NULL, NULL, 0, "<Separator>" }
};

static gchar* attach_data_key = "gtk-menu-attach-data";
void new_shell_with_command_bb(GSList** ptl, gint action);


void build_popup_commands(GdkEventButton *event, GSList** ptl, ZvtTerm* term)
{
  GtkWidget* mainmenu, *submenu, *popupmenu;
  GtkItemFactoryEntry* cm;
  char str[64];
  GtkWidget* app;
  GtkAccelGroup* accel_group;
  GtkItemFactory* item_factory;
  int x, i, nmenu_items;
  char **cmds, **cmds_names; 
  /*
     GnomeUIInfo sm[] = { GNOME_APP_UI_ENDOFINFO, NULL, NULL, NULL, 
     NULL, NULL,(GnomeUIPixmapType) 0, NULL, 0,(GdkModifierType) 0, NULL };
     
     popupmenu = gnome_popup_menu_new(sm);*/
  app = gtk_widget_get_toplevel(GTK_WIDGET(term));
  cmds = (char**) gtk_object_get_data(GTK_OBJECT(app), "cmds_list");
  
  cmds_names = (char**) gtk_object_get_data(GTK_OBJECT(app), "cmds_names");
 
  mainmenu = gtk_object_get_data(GTK_OBJECT(app), "popup_factory_widget"); 
  cm =       gtk_object_get_data(GTK_OBJECT(app), "popup_factory");
  if (mainmenu)
    {
      x = 0;
      while(cmds[x])
	x++;
      /* 4 are the default items */
      nmenu_items = x + DEFAULT_BUTTONBAR_ITEMS;
      item_factory = gtk_item_factory_from_widget(mainmenu);
      
      x = 0;
      while(cm[x].path)
	x++;
      gtk_item_factory_delete_entries(item_factory, x, cm);
  
      if (cm)
	{
	  x = DEFAULT_BUTTONBAR_ITEMS;
	  
	  while(cm[x].path)
	    {
	      free(cm[x].path);
	      x++;
	    }
	  free(cm);
	}
    }
  else
   {
     accel_group = gtk_accel_group_new ();
     x = 0;
     while(cmds[x])
       x++;
     nmenu_items = x + DEFAULT_BUTTONBAR_ITEMS;
     item_factory = gtk_item_factory_new (GTK_TYPE_MENU_BAR, "<main>", 
				       accel_group);
   }
  
  cm = malloc(sizeof(GtkItemFactoryEntry)*(nmenu_items+1));
  gtk_object_set_data(GTK_OBJECT(app), "popup_factory", cm);
  
  memcpy(cm, popup_items, sizeof(GtkItemFactoryEntry)*DEFAULT_BUTTONBAR_ITEMS);
 
  /* and now we build the custom part */
  x = 0;
  while (cmds[x])
    {
      i = x + DEFAULT_BUTTONBAR_ITEMS;
      strcpy(str,"/MAIN/");
      strcat(str,cmds_names[x]);
      cm[i].path = malloc((strlen(str)+1)*sizeof(char));
      strcpy(cm[i].path, str);
      cm[i].accelerator = NULL;
      cm[i].callback = new_shell_with_command_bb;
      cm[i].callback_action = x;
      cm[i].item_type = NULL;
      x++;
    }

  cm[x+DEFAULT_BUTTONBAR_ITEMS].path = NULL; 
  
  gtk_item_factory_create_items (item_factory, nmenu_items, cm, ptl);
  submenu = gtk_item_factory_get_widget (item_factory, "/MAIN");
  mainmenu =gtk_item_factory_get_widget (item_factory, "<main>");
  gtk_object_set_data(GTK_OBJECT(app), "popup_factory_widget", mainmenu);  
  
  gnome_popup_menu_do_popup_modal (submenu, NULL, NULL, event, ptl);
	
  gtk_widget_destroy (submenu);
	
}

int
button_press (GtkWidget *widget, GdkEventButton *event, ZvtTerm *term)
{
	GtkWidget *menu;
	GnomeUIInfo *uiinfo;
	struct terminal_config *cfg;
	GtkCheckMenuItem *toggle_item;
	GtkWidget* app, *te;
	GSList** p_term_list, *tt;
#ifdef ZVT_TERM_MATCH_SUPPORT
	char *match;
	int x,y;
	GdkModifierType mask;
#endif

#ifdef ZVT_TERM_MATCH_SUPPORT
	gdk_window_get_pointer(widget->window, &x, &y, &mask);
	match = zvt_term_match_check(term, x/term->charwidth, y/term->charheight, 0);
	/* Terminal get focus clicking on it */
	gtk_widget_grab_focus(GTK_WIDGET(term));
	app = gtk_widget_get_toplevel(GTK_WIDGET(term));
	p_term_list = (GSList**) gtk_object_get_data(GTK_OBJECT(app), "ptermlist");

	/*
	if (event->type == GDK_2BUTTONPRESS && match)
	  {
	    gtk_signal_emit_stop_by_name (GTK_OBJECT (widget), "button_press_event");
	    gnome_url_show (match);
	    return TRUE;
	  }
	 */
	if (event->button == 1
	    && (event->state & GDK_CONTROL_MASK)
	    && match) {
		gtk_signal_emit_stop_by_name (GTK_OBJECT (widget), "button_press_event");
		gnome_url_show (match);
		return TRUE;
	}
	
	  
#endif /* ZVT_TERM_MATCH_SUPPORT */

	
	if ( ( (event->button != 1 && event->button != 2) || 
	       (event->state != GDK_CONTROL_MASK) )
	     && (event->button != 3 || 
	    (!(event->state & GDK_CONTROL_MASK) && !(event->state & GDK_MOD1_MASK)
	     && term->vx->selected)
	    || (term->vx->vt.mode & VTMODE_SEND_MOUSE)))
	  return FALSE;

	gtk_signal_emit_stop_by_name (GTK_OBJECT (widget), "button_press_event");

	if ( ((event->state & GDK_CONTROL_MASK) && event->button == 1) 
	  || ((event->state & GDK_CONTROL_MASK) && event->button == 2) )
	  {
	    build_popup_commands(event, p_term_list, term);
	    return TRUE;
	  }	  
#ifdef ZVT_TERM_MATCH_SUPPORT
	/* Here we have to change the code to put commands in the popup menu */
	/* construct the popup menu properly */
	if (match) {
		char *tmp;

		memcpy(&gnome_terminal_popup_menu[POPUP_MENU_DYNAMIC_INDEX],
		       &gnome_terminal_popup_menu_url[0],
		       sizeof(gnome_terminal_popup_menu_url));
		/*printf("DYNIDX: %d match: %s\n", POPUP_MENU_DYNAMIC_INDEX, match);*/
		/* BUG!!!: we must free match of every terminal */
		
		/*
		tmp = gtk_object_get_data(GTK_OBJECT (term), "matchstr");
		if (tmp)
			g_free(tmp);*/
		/* set all terminals */
		tt = *p_term_list;
		while (tt)
		  {
		    te = GTK_WIDGET(tt->data);
		    tmp = gtk_object_get_data(GTK_OBJECT(te), "matchstr");
		    if (tmp)
		      g_free(tmp);
		    gtk_object_set_data (GTK_OBJECT (te), "matchstr", g_strdup(match));
		    tt = tt->next;
		  }
	} else {
		/* make sure the optional menu isn't there */
		memcpy(&gnome_terminal_popup_menu[POPUP_MENU_DYNAMIC_INDEX],
		       &gnome_terminal_popup_menu[POPUP_MENU_LAST_INDEX],
		       sizeof(gnome_terminal_popup_menu[0]));
	}
#endif
	uiinfo = gnome_terminal_popup_menu;

	menu = gnome_popup_menu_new (gnome_terminal_popup_menu);
	

	cfg = gtk_object_get_data (GTK_OBJECT (term), "config");

	/*
	 * Set the toggle state for the "show menubar"
	 * menu item.
	 */
	toggle_item = GTK_CHECK_MENU_ITEM (uiinfo [POPUP_MENU_TOGGLE_INDEX_MENUBAR].widget);
	toggle_item->active = ! cfg->menubar_hidden;

	
	/*
	 * Set the toggle state for the "show toolbar"
	 * menu item.
	 */
	toggle_item = GTK_CHECK_MENU_ITEM (uiinfo [POPUP_MENU_TOGGLE_INDEX_TOOLBAR].widget);
	toggle_item->active = ! cfg->toolbar_hidden;
	
		
	/*
	 * Set the toggle state for the "show toolbar"
	 * menu item.
	 */
	toggle_item = GTK_CHECK_MENU_ITEM (uiinfo [POPUP_MENU_TOGGLE_INDEX_BUTTONBAR].widget);
	toggle_item->active = ! cfg->buttonbar_hidden;


	/*
	 * Set the toggle state for the secure keyboard
	 * menu item.
	 */
	toggle_item = GTK_CHECK_MENU_ITEM (uiinfo [POPUP_MENU_TOGGLE_INDEX_SECURE].widget);
	toggle_item->active = cfg->keyboard_secured;

	gnome_popup_menu_do_popup_modal (menu, NULL, NULL, event, p_term_list);
	
	gtk_widget_destroy (menu);

	/*
	 * The popup menu ungrabs the keyboard if it was grabbed,
	 * so we grab it again here.
	 */
	if (cfg->keyboard_secured)
		gdk_keyboard_grab (term->term_window, TRUE, GDK_CURRENT_TIME);

	return TRUE;
}

void
set_hints (GtkWidget *widget)
{
        ZvtTerm *term;
	GdkGeometry hints;
	GtkWidget *app;
	struct terminal_config* cfg;
	g_assert (widget != NULL);
	term = ZVT_TERM (widget);

	app = gtk_widget_get_toplevel(widget);
	g_assert (app != NULL);

#define PADDING 2
	hints.base_width = (GTK_WIDGET (term)->style->klass->xthickness * 2) + PADDING;
	hints.base_height =  (GTK_WIDGET (term)->style->klass->ythickness * 2);
	/* NOTE: This setting get problems only!!*/
	/* vedere nel cfg se e' uno scroll background e regolarsi di consegfuenza*/
	cfg = gtk_object_get_data(GTK_OBJECT(term), "config");
	hints.width_inc = term->charwidth;
    	hints.height_inc = term->charheight;
       	hints.min_width = hints.base_width + hints.width_inc;
	hints.min_height = hints.base_height + hints.height_inc;

	gtk_window_set_geometry_hints(GTK_WINDOW(app),
				      GTK_WIDGET(term),
				      &hints,
				      GDK_HINT_RESIZE_INC|GDK_HINT_MIN_SIZE|GDK_HINT_BASE_SIZE);
}

void set_all_undefined(GSList** ptl)
{
  GtkWidget *term;
  GSList* tmp;
  int *state,*new_out;
  tmp = *ptl;	
  while(tmp)
    {
      term = GTK_WIDGET(tmp->data);
      state = gtk_object_get_data(GTK_OBJECT(term), "term_state");
      new_out = gtk_object_get_data(GTK_OBJECT(term), "new_out");
      *new_out = FALSE;
      if (*state == UNCHANGED)
	*state = UNDEFINED;
      tmp = tmp->next;
    }
}

void
term_change_pos(GtkWidget *widget)
{
        /* AGGIUNTA 19/08/01 */
        GtkWidget* term;
        GSList **p_term_list;
	static int x=-999;
	static int y=-999;
	int nx,ny;
		

	p_term_list = gtk_object_get_data(GTK_OBJECT(widget), "ptermlist");

	term = GTK_WIDGET(current_term(p_term_list));

	/* widget -> term */
	if(!term->window ||
	   !ZVT_TERM(term)->transparent)
		return;
	

	gdk_window_get_position(term->window,&nx,&ny);

	if(nx!=x || ny!=y)
	  {
	    gtk_widget_queue_draw(term);
	    
	  }	
}

/* do this because there have been only 5 bug reports about this */
void
show_pty_error_dialog (int errcode)
{
	char *tmpmsg, *errmsg;
	GtkWidget *dialog;

	perror ("Error: unable to fork");

	tmpmsg = errcode ? 
		g_strdup_printf(_("The error was: %s"), g_strerror(errcode)) : 
		_("If you are using Linux 2.2.x with glibc 2.1.x, this\n"
		  "is probably due to incorrectly setup Unix98 ptys.\n\n"
		  "Please read linux/Documentation/Changes for how to\n"
		  "set them up correctly.");
	
	errmsg =  g_strdup_printf(_("There has been an error while "
				    "trying to log in.\n\n%s"), tmpmsg);
	
	
	dialog = gnome_message_box_new (errmsg,
					GNOME_MESSAGE_BOX_ERROR,
					GNOME_STOCK_BUTTON_OK, NULL);
							
	gnome_dialog_run_and_close (GNOME_DIALOG (dialog));

	if (errcode) g_free(tmpmsg);
	g_free(errmsg);
}

void set_all_terms_size(GSList** ptl, gint x, gint y);

gint term_xc, term_yc;

gint delete( GtkWidget *widget,
             GtkWidget *event,
             gpointer   data )
{
    gtk_main_quit();
    return(FALSE);
}

char **env_copy;
int winid_pos;
int term_pos;

GtkWidget *
new_terminal (GtkWidget *widget, GSList **p_term_list) 
{
	struct terminal_config *cfg;
	char **cmds, **cmds_names;
	/* AGGIUNTA 17/08/01 */
	ZvtTerm* term;
	GtkWidget* app, *retval;
	GtkCheckMenuItem *toggle_item;

	term = current_term(p_term_list);
	app = gtk_widget_get_toplevel(GTK_WIDGET(term));
	cfg = gtk_object_get_data (GTK_OBJECT (term), "config");
	cmds = gtk_object_get_data(GTK_OBJECT(app), "cmds_list");
	cmds_names = gtk_object_get_data(GTK_OBJECT(app), "cmds_names");

	retval = new_terminal_cmd (NULL, cfg, NULL, terminal_id++, cmds_names, cmds);

	if (!cfg->menubar_hidden)
	  {
	    /* set toggle items */
	    toggle_item = GTK_CHECK_MENU_ITEM (gnome_terminal_terminal_menu[FILE_MENU_TOGGLE_INDEX_MENUBAR].widget);
	    toggle_item->active = !cfg->menubar_hidden;
	    toggle_item = GTK_CHECK_MENU_ITEM (gnome_terminal_terminal_menu[FILE_MENU_TOGGLE_INDEX_TOOLBAR].widget);
	    toggle_item->active = !cfg->toolbar_hidden;
	    toggle_item = GTK_CHECK_MENU_ITEM (gnome_terminal_terminal_menu[FILE_MENU_TOGGLE_INDEX_BUTTONBAR].widget);
	    toggle_item->active = !cfg->buttonbar_hidden;
	  }	    
	return retval;
}

GtkWidget *
new_terminal_for_client (const char *geom)
{
  GtkWidget *app, *term, *w;
  GSList** ptl;
  struct terminal_config *cfg;
  char **cmds, **cmds_names;
  GtkCheckMenuItem *toggle_item;

  if (terminals != 0)
	{
		app = GTK_WIDGET(terminals->data);
		ptl = gtk_object_get_data(GTK_OBJECT(app), "ptermlist");
		term = GTK_WIDGET((*ptl)->data);
		cfg = gtk_object_get_data (GTK_OBJECT (term), "config");
		cmds = gtk_object_get_data(GTK_OBJECT(app), "cmds_list");
		cmds_names = gtk_object_get_data(GTK_OBJECT(app), "cmds_names");
		w = new_terminal_cmd (NULL, cfg, geom ? geom
     				      : initial_global_geometry,
				      terminal_id++, cmds_names, cmds);

		
		/* set toggle items */
		if (!cfg->menubar_hidden) {
		  toggle_item = GTK_CHECK_MENU_ITEM (gnome_terminal_terminal_menu[FILE_MENU_TOGGLE_INDEX_MENUBAR].widget);
		  toggle_item->active = !cfg->menubar_hidden;
		  toggle_item = GTK_CHECK_MENU_ITEM (gnome_terminal_terminal_menu[FILE_MENU_TOGGLE_INDEX_TOOLBAR].widget);
		  toggle_item->active = !cfg->toolbar_hidden;
		  toggle_item = GTK_CHECK_MENU_ITEM (gnome_terminal_terminal_menu[FILE_MENU_TOGGLE_INDEX_BUTTONBAR].widget);
		  toggle_item->active = !cfg->buttonbar_hidden;
		  
		}

		return w;
	}
	else
		return 0;
}

static void
load_factory_settings ()
{
	gchar *buf;

	buf = gnome_client_get_config_prefix (gnome_master_client ());
	gnome_config_push_prefix (buf);

	buf = g_strdup_printf ("factory/start=%d", start_terminal_factory);
	start_terminal_factory = gnome_config_get_int (buf);
	g_free (buf);

	buf = g_strdup_printf ("factory/use=%d", use_terminal_factory);
	use_terminal_factory = gnome_config_get_int (buf);
	g_free (buf);

	gnome_config_pop_prefix ();
}

static gboolean
load_session (char** cmds_names, char** cmds)
{
	int num_terms, i;
	gboolean def;
	gchar *file;
	
	file = gnome_client_get_config_prefix (gnome_master_client());

	gnome_config_push_prefix (file);
	num_terms = gnome_config_get_int_with_default ("dummy/num_terms", 
						       &def);
	gnome_config_pop_prefix ();

	if (def || ! num_terms)
		return FALSE;

	for (i = 0; i < num_terms; ++i){
		char *geom, **argv;
		struct terminal_config *cfg;
		char *class, *class_path;
		int argc;
		char *prefix = g_strdup_printf ("%s%d/", file, i);
		int termid;
		
		/* commands */
#if 0
		char** cmds, **cmds_names;
#endif

		gnome_config_push_prefix (prefix);

		/* NAUGHTY: The ICCCM requires that the WM stores
		   all session data on geometry! */
		geom = gnome_config_get_string ("geometry");
		gnome_config_get_vector ("command", &argc, &argv);
		
		class_path = g_strconcat ("class=", _("Default"), NULL);
		class = gnome_config_get_string(class_path);
		g_free (class_path);

		cfg = load_config (class);

		/* do this now, since it is only done in a session */
		cfg->invoke_as_login_shell = gnome_config_get_bool("invoke_as_login_shell");
		{
			char *ctmp;
			ctmp = gnome_config_get_string("termname=xterm");
			if(ctmp && *ctmp)
				cfg->termname = g_strconcat("TERM=", ctmp, NULL);
			else
				cfg->termname = g_strdup("TERM=xterm");
			g_free(ctmp);
		}
		cfg->window_title = gnome_config_get_string("window_title");
		cfg->window_icon = gnome_config_get_string("window_icon");
		if (gnome_config_get_bool ("do_utmp=true"))
			cfg->update_records |= ZVT_TERM_DO_UTMP_LOG;
		if (gnome_config_get_bool ("do_wtmp=true"))
			cfg->update_records |= ZVT_TERM_DO_WTMP_LOG;
		if (gnome_config_get_bool ("do_lastlog=true"))
			cfg->update_records |= ZVT_TERM_DO_LASTLOG;

		start_terminal_factory = gnome_config_get_bool ("start_terminal_factory=false");
		use_terminal_factory = gnome_config_get_bool ("use_terminal_factory=false");

		termid = gnome_config_get_int("terminal_id=-1");
		if (termid!=-1)
			terminal_id = termid;

		g_free(class);
		gnome_config_pop_prefix();
		
		
		new_terminal_cmd (argv, cfg, geom, terminal_id++, cmds_names, cmds);
#if 0
		free_str_array(cmds);
		free_str_array(cmds_names);
#endif
		g_free(cfg);
		g_free (geom);
		if (i==0) {
			/* need to save the initial argv, because of the weird
			   way it is used elsewhere, with the initial term */
			initial_command = argv;
		} else {
			g_strfreev (argv);
		}
	}
	return TRUE;
}

/* Save terminal in this session.  FIXME: should save all terminal
   windows, but currently does not.  */
static gint
save_session (GnomeClient *client, gint phase, GnomeSaveStyle save_style,
	      gint is_shutdown, GnomeInteractStyle interact_style,
	      gint is_fast, gpointer client_data)
{
	char *file = gnome_client_get_config_prefix (client);
	char *args[8];
	int i;
	GList *list;
	GSList** ptl;


	i = 0;
	for (list = terminals; list != NULL; list = list->next){
	
	        gint width, height, x, y;
		GString *geom;
		struct terminal_config *cfg;			
		ZvtTerm *term;
		GtkWidget *top;
		char *prefix;
		char *ctmp;
	  
		top = gtk_widget_get_toplevel (GTK_WIDGET (list->data));
		prefix = g_strdup_printf ("%s%d/", file, i);
		ptl = gtk_object_get_data(GTK_OBJECT(list->data), "ptermlist");

		term = ZVT_TERM((*ptl)->data);	

		cfg = gtk_object_get_data (GTK_OBJECT (term), "config");

		gnome_config_push_prefix (prefix);
		/*
		 * NAUGHTY: The ICCCM requires that the WM stores
		 * all session data on geometry!
		 */

		/*
		 * we can't use gnome_geometry_string because we need
		 * to calculate the terminal, not window size
		 */
		gdk_window_get_origin (top->window, &x, &y);

		width = 
		  (GTK_WIDGET (term)->allocation.width - 
		   (GTK_WIDGET (term)->style->klass->xthickness * 2)) /
		  term->charwidth;

		height = 
		  (GTK_WIDGET (term)->allocation.height - 
		   (GTK_WIDGET (term)->style->klass->ythickness * 2)) /
		  term->charheight;

		geom = g_string_new ("");
		g_string_sprintf (geom, "%dx%d%+d%+d", width, height, x, y);
		gnome_config_set_string ("geometry", geom->str);
		g_string_free (geom, TRUE);
		
		gnome_config_set_string("class", cfg->class);
		gnome_config_set_int("terminal_id", cfg->terminal_id);
		
		if (top == initial_term){
			int n;
			for (n = 0; initial_command[n]; ++n);
			gnome_config_set_vector ("command", n,
						 (const char * const*) initial_command);
		}
		    		
		save_preferences(list->data, term, cfg);
		/* do this now, since it is only done in a session */
		gnome_config_set_bool("invoke_as_login_shell", cfg->invoke_as_login_shell);

		ctmp = NULL;
		if(cfg->termname) {
			ctmp = strchr(cfg->termname, '=');
			if(ctmp) ctmp++;
		}
		if(!ctmp)
			ctmp = "xterm";
		gnome_config_set_string("termname", ctmp);

		gnome_config_set_string ("window_title",
					 cfg->window_title != NULL ?
					   cfg->window_title : _("MGT"));
		gnome_config_set_string ("window_icon",
					 cfg->window_icon != NULL ?
					   cfg->window_icon : GNOME_ICONDIR"/mgt/multignometerm.png");
		gnome_config_set_bool("do_utmp", (cfg->update_records & ZVT_TERM_DO_UTMP_LOG) != 0);
		gnome_config_set_bool("do_wtmp", (cfg->update_records & ZVT_TERM_DO_WTMP_LOG) != 0);
		gnome_config_set_bool("start_terminal_factory", 
				      start_terminal_factory);
		gnome_config_set_bool("use_terminal_factory",
				      use_terminal_factory);
		gnome_config_set_bool("do_lastlog", (cfg->update_records & ZVT_TERM_DO_LASTLOG) != 0);

		gnome_config_pop_prefix ();
		g_free (prefix);
		
		++i;
	}
	gnome_config_push_prefix (file);
	gnome_config_set_int ("dummy/num_terms", i);
	gnome_config_set_int ("factory/start", start_terminal_factory);
	gnome_config_set_int ("factory/use", use_terminal_factory);
	gnome_config_pop_prefix ();

#if 0
	/* What was the cfg variable ? */
	args[0] = gnome_master_client()->restart_command[0];
	args[1] = "--font";
	args[2] = cfg.font;
	args[3] = cfg.invoke_as_login_shell ? "--login" : "--nologin";
	args[4] = "--foreground";
	args[5] = g_strdup (get_color_string (cfg.user_fore));
	args[6] = "--background";
	args[7] = g_strdup (get_color_string (cfg.user_back));
	args[8] = NULL;

	g_free (args[5]);
	g_free (args[7]);
	gnome_client_set_restart_command (client, 8, args);
#endif
	gnome_config_sync ();

	args[0] = "rm";
	args[1] = gnome_config_get_real_path (file);
	args[2] = NULL;
	gnome_client_set_discard_command (client, 2, args);

	return TRUE;
}

/* Keys for the ARGP parser, should be negative */
enum {
	FONT_KEY      	    = -1,
	NOLOGIN_KEY   	    = -2,
	LOGIN_KEY     	    = -3,
	GEOMETRY_KEY  	    = -4,
	COMMAND_KEY   	    = 'e',
	FORE_KEY      	    = -6,
	BACK_KEY      	    = -7,
	CLASS_KEY     	    = -8,
	DOUTMP_KEY    	    = -9,
	DONOUTMP_KEY  	    = -10,
	DOWTMP_KEY    	    = -11,
	DONOWTMP_KEY  	    = -12,
        TITLE_KEY     	    = -13,
	TERM_KEY            = -14,
	START_FACTORY_KEY   = -15,
	USE_FACTORY_KEY     = -16,
	DOLASTLOG_KEY       = -17,
	DONOLASTLOG_KEY     = -18,
	ICON_KEY            = -19,
        PIXMAP_KEY          = -20,
        SHADED_KEY          = -21,
        NOSHADED_KEY        = -22,
        TRANSPARENT_KEY     = -23,
        SOLID_KEY           = -24,
#ifdef ZVT_BACKGROUND_SCROLL
        BGSCROLL_PIXMAP_KEY   = -25,
        BGNOSCROLL_PIXMAP_KEY = -26,
#endif

};

static struct poptOption cb_options [] = {
	{ NULL, '\0', POPT_ARG_CALLBACK, (gpointer)parse_an_arg, 0},

	{ "tclass", '\0', POPT_ARG_STRING, NULL, CLASS_KEY,
	  N_("Terminal class name"), N_("TCLASS")},

	{ "font", '\0', POPT_ARG_STRING, NULL, FONT_KEY,
	  N_("Specifies font name"), N_("FONT")},

	{ "nologin", '\0', POPT_ARG_NONE, NULL, NOLOGIN_KEY,
	  N_("Do not start up shells as login shells"), NULL},

	{ "login", '\0', POPT_ARG_NONE, NULL, LOGIN_KEY,
	  N_("Start up shells as login shells"), NULL},

	{ "geometry", '\0', POPT_ARG_STRING, NULL, GEOMETRY_KEY,
	  N_("Specifies the geometry for the main window"), N_("GEOMETRY")},

	{ "command", 'e', POPT_ARG_STRING, NULL, COMMAND_KEY,
	  N_("Execute this program instead of a shell"), N_("COMMAND")},

	{ "execute", 'x', POPT_ARG_STRING, NULL, COMMAND_KEY,
	  N_("Execute this program the same way as xterm does"), N_("COMMAND")},

	{ "foreground", '\0', POPT_ARG_STRING, NULL, FORE_KEY,
	  N_("Foreground color"), N_("COLOR")},

	{ "background", '\0', POPT_ARG_STRING, NULL, BACK_KEY,
	  N_("Background color"), N_("COLOR")},

	{ "solid", '\0', POPT_ARG_NONE, NULL, SOLID_KEY,
	  N_("Solid background"), N_("SOLID") },	

	{ "pixmap", '\0', POPT_ARG_STRING, NULL, PIXMAP_KEY,
	  N_("Background pixmap"), N_("PIXMAP")},

#ifdef ZVT_BACKGROUND_SCROLL
	{ "bgscroll", '\0', POPT_ARG_NONE, NULL, BGSCROLL_PIXMAP_KEY,
	  N_("Background pixmap scrolls"), N_("BGSCROLL")},

	{ "bgnoscroll", '\0', POPT_ARG_NONE, NULL, BGNOSCROLL_PIXMAP_KEY,
	  N_("Background pixmap does not scroll"), N_("BGNOSCROLL")},
#endif

	{ "shaded", '\0', POPT_ARG_NONE, NULL, SHADED_KEY,
	  N_("Shade background"), N_("SHADED") },	

	{ "noshaded", '\0', POPT_ARG_NONE, NULL, NOSHADED_KEY,
	  N_("Do not shade background"), N_("NOSHADED") },	

	{ "transparent", '\0', POPT_ARG_NONE, NULL, TRANSPARENT_KEY,
	  N_("Transparent background"), N_("TRANSPARENT") },	

	{ "utmp", '\0', POPT_ARG_NONE, NULL, DOUTMP_KEY,
	  N_("Update utmp entry"), N_("UTMP") },

	{ "noutmp", '\0', POPT_ARG_NONE, NULL, DONOUTMP_KEY,
	  N_("Do not update utmp entry"), N_("NOUTMP") },

	{ "wtmp", '\0', POPT_ARG_NONE, NULL, DOWTMP_KEY,
	  N_("Update wtmp entry"), N_("WTMP") },

	{ "nowtmp", '\0', POPT_ARG_NONE, NULL, DONOWTMP_KEY,
	  N_("Do not update wtmp entry"), N_("NOWTMP") },

	{ "lastlog", '\0', POPT_ARG_NONE, NULL, DOLASTLOG_KEY,
	  N_("Update lastlog entry"), N_("LASTLOG") },

	{ "nolastlog", '\0', POPT_ARG_NONE, NULL, DONOLASTLOG_KEY,
	  N_("Do not update lastlog entry"), N_("NOLASTLOG") },
	
	{ "title", 't', POPT_ARG_STRING, NULL, TITLE_KEY,
          N_("Set the window title"), N_("TITLE") },

	{ "icon", '\0', POPT_ARG_STRING, NULL, ICON_KEY,
	  N_("Set the window icon"), N_("ICON") },

	{ "termname", '\0', POPT_ARG_STRING, NULL, TERM_KEY,
          N_("Set the TERM variable"), N_("TERMNAME") },

	{ "start-factory-server", '\0', POPT_ARG_NONE, NULL, START_FACTORY_KEY,
	  N_("Try to start a TerminalFactory"), NULL },

	{ "use-factory", '\0', POPT_ARG_NONE, NULL, USE_FACTORY_KEY,
	  N_("Try to create the terminal with the TerminalFactory"), NULL },

	{ NULL, '\0', 0, NULL, 0}
};



static void
parse_an_arg (poptContext state,
	      enum poptCallbackReason reason,
	      const struct poptOption *opt,
	      const char *arg, void *data)
{
	struct terminal_config *cfg = data;

	int key = opt->val;

	switch (key){
	case CLASS_KEY:
		free (cfg->class);
		cfg->class = g_strconcat ("Class-", arg, NULL);
		start_terminal_factory = FALSE;
		use_terminal_factory = FALSE;
		break;
	case FONT_KEY:
		cfg->font = (char *)arg;
		start_terminal_factory = FALSE;
		use_terminal_factory = FALSE;
		break;
	case LOGIN_KEY:
		cfg->invoke_as_login_shell = 1;
		cmdline_login = TRUE;
		start_terminal_factory = FALSE;
		use_terminal_factory = FALSE;
		break;
	case NOLOGIN_KEY:
	        cfg->invoke_as_login_shell = 0;
		cmdline_login = TRUE;
		start_terminal_factory = FALSE;
		use_terminal_factory = FALSE;
	        break;
	case GEOMETRY_KEY:
		initial_global_geometry = (char *)arg;
		break;
	case COMMAND_KEY:
		  {
			  char **foo;
			  int x;
			  
			  poptParseArgvString((char *)arg,&x,&foo);
			  initial_command=malloc((x+1)*sizeof(char *));
			  initial_command[x]=NULL;
			  while (x>0) {
				  x--;
				  initial_command[x]=foo[x];
			  }
		
		start_terminal_factory = FALSE;
		use_terminal_factory = FALSE;
		break;
		  }
	case FORE_KEY:
		cfg->user_fore_str = arg;
		start_terminal_factory = FALSE;
		use_terminal_factory = FALSE;
		break;
	case BACK_KEY:
		cfg->user_back_str = arg;
		start_terminal_factory = FALSE;
		use_terminal_factory = FALSE;
		break;
	case SOLID_KEY:
		cfg->background_pixmap = 0;
		cfg->transparent = 0;
		cfg->have_user_background = 1;
		start_terminal_factory = FALSE;
		use_terminal_factory = FALSE;
		break;
	case PIXMAP_KEY:
		cfg->background_pixmap = 1;
		cfg->transparent = 0;
		cfg->pixmap_file = g_strdup(arg);
		cfg->have_user_background = 1;
		start_terminal_factory = FALSE;
		use_terminal_factory = FALSE;
		break;
#ifdef ZVT_BACKGROUND_SCROLL
	case BGSCROLL_PIXMAP_KEY:
		cfg->scroll_background = 1;
		cfg->have_user_scroll_bg = 1;
		start_terminal_factory = FALSE;
		use_terminal_factory = FALSE;
		break;
	case BGNOSCROLL_PIXMAP_KEY:
		cfg->scroll_background = 0;
		cfg->have_user_scroll_bg = 1;
		start_terminal_factory = FALSE;
		use_terminal_factory = FALSE;
		break;
#endif
	case SHADED_KEY:
		cfg->shaded = 1;
		cfg->have_user_shaded = 1;
		start_terminal_factory = FALSE;
		use_terminal_factory = FALSE;
		break;
	case NOSHADED_KEY:
		cfg->shaded = 0;
		cfg->have_user_shaded = 1;
		start_terminal_factory = FALSE;
		use_terminal_factory = FALSE;
		break;
	case TRANSPARENT_KEY:
		cfg->background_pixmap = 0;
		cfg->transparent = 1;
		cfg->have_user_background = 1;
		start_terminal_factory = FALSE;
		use_terminal_factory = FALSE;
		break;
	case DOUTMP_KEY:
		cfg->update_records_and &= ~ZVT_TERM_DO_UTMP_LOG;
		cfg->update_records_xor |= ZVT_TERM_DO_UTMP_LOG;
		start_terminal_factory = FALSE;
		use_terminal_factory = FALSE;
		break;
	case DONOUTMP_KEY:
		cfg->update_records_and &= ~ZVT_TERM_DO_UTMP_LOG;
		cfg->update_records_xor &= ~ZVT_TERM_DO_UTMP_LOG;
		start_terminal_factory = FALSE;
		use_terminal_factory = FALSE;
		break;
	case DOWTMP_KEY:
		cfg->update_records_and &= ~ZVT_TERM_DO_WTMP_LOG;
		cfg->update_records_xor |= ZVT_TERM_DO_WTMP_LOG;
		start_terminal_factory = FALSE;
		use_terminal_factory = FALSE;
		break;
	case DONOWTMP_KEY:
		cfg->update_records_and &= ~ZVT_TERM_DO_WTMP_LOG;
		cfg->update_records_xor &= ~ZVT_TERM_DO_WTMP_LOG;
		start_terminal_factory = FALSE;
		use_terminal_factory = FALSE;
		break;
	case DOLASTLOG_KEY:
		cfg->update_records_and &= ~ZVT_TERM_DO_LASTLOG;
		cfg->update_records_xor |= ZVT_TERM_DO_LASTLOG;
		break;
	case DONOLASTLOG_KEY:
		cfg->update_records_and &= ~ZVT_TERM_DO_LASTLOG;
		cfg->update_records_xor &= ~ZVT_TERM_DO_LASTLOG;
		break;
	case TITLE_KEY:
	        cfg->window_title = g_strdup(arg);
		start_terminal_factory = FALSE;
		use_terminal_factory = FALSE;
                break;
	case ICON_KEY:
		cfg->window_icon = g_strdup(arg);
		start_terminal_factory = FALSE;
		use_terminal_factory = FALSE;
		break;
	case TERM_KEY:
		cfg->termname = g_strdup_printf("TERM=%s", arg);
		start_terminal_factory = FALSE;
		use_terminal_factory = FALSE;
		break;
	case START_FACTORY_KEY:
		start_terminal_factory = TRUE;
		break;
	case USE_FACTORY_KEY:
		use_terminal_factory = TRUE;
		break;
	default:
		break;
	}
}

static gint
session_die (gpointer client_data)
{
  gtk_exit(0); /*gtk_main_quit ();*/
  return TRUE;
}

extern int check_changed_buffers(gpointer data);

int read_old_settings(char*** p_cmds, char***p_cmds_names, char* class,
		      struct terminal_config** p_cfg)
{
  /* This procedures read all setting from Terminal config file and put
     all in MultiTerminal file removing old entries from that one 
   In future MGT releases this casa */

  char *prefix;
  int n, num_cmds;
  
  if (!strcmp(class, "Config"))
    {
      /* Now multi-gnome-terminal class is the Default one */
      prefix = g_strdup_printf("/Terminal/Class-multi-gnome-terminal/");;
    }
  else
    {
       prefix = g_strdup_printf("/Terminal/Class-%s/", class);;
    }

  if (!gnome_config_has_section(prefix))
    {
      g_free(prefix);
      return 0;
    }
    
  gnome_config_push_prefix(prefix);
  
  *p_cfg = load_config (class);

  /* Load all commands and their names */
  gnome_config_get_vector ("cmds", &num_cmds, p_cmds);
  gnome_config_get_vector ("cmds_names", &num_cmds, p_cmds_names);
  if ((*p_cmds == NULL) || (*p_cmds_names == NULL))
    {
      *p_cmds = malloc(sizeof(char*));
      *p_cmds_names = malloc(sizeof(char*));
      (*p_cmds)[0] = NULL;
      (*p_cmds_names)[0] = NULL;
    }
  else
    {
      if (num_cmds == 1)
	{
	  if (strlen((*p_cmds)[0])==0 && strlen((*p_cmds_names)[0])==0)
	    {
	      (*p_cmds)[0] = NULL;
	      (*p_cmds_names)[0] = NULL;
	    }
	}
    }
  gnome_config_clean_section(prefix);
  gnome_config_sync(); 
  gnome_config_pop_prefix();
  g_free(prefix);
  prefix = g_strdup_printf("/MultiTerminal/%s/", class);
  gnome_config_push_prefix(prefix);
  save_preferences(NULL, NULL, *p_cfg);
  gnome_config_pop_prefix();
  g_free(prefix);
  prefix = g_strdup_printf("/MultiTerminal/Common/");
  gnome_config_push_prefix(prefix);	
  
  n = 0;
  while((*p_cmds_names)[n])
    n++;
  gnome_config_set_vector("cmds", n, (const char* const*) *p_cmds);
  gnome_config_set_vector("cmds_names", n, (const char* const*) *p_cmds_names);
  gnome_config_pop_prefix();
  g_free(prefix);
  
  return 1;
}
static int
main_terminal_program (int argc, char *argv [], char **environ)
{
	GnomeClient *client;
	char *program_name;
	char *class;
	struct terminal_config *default_config, *cmdline_config;
	int i, j;
	GtkWidget* app;
	CORBA_Object term=CORBA_OBJECT_NIL;
	CORBA_ORB orb;
	CORBA_Environment ev;
	int num_cmds;
	/* commands */
	char** cmds, **cmds_names;
	GtkCheckMenuItem *toggle_item;

	
	bindtextdomain (PACKAGE, GNOMELOCALEDIR);
	textdomain (PACKAGE);

	cmdline_login = FALSE;

	cmdline_config = g_new0 (struct terminal_config, 1);
	cmdline_config->update_records_and = ~0;
	
	cb_options[0].descrip = (char *)cmdline_config;

	/* pre-scan for -x and --execute options */
	for (i=1;i<argc;i++) {
		if (!strcmp (argv [i], "-x") || !(strcmp (argv [i], "--execute"))) {
			int last = i;
			i++;
			if (i == argc) {
				/* no arg!? let popt whinge about usage */
				break;
			}
			initial_command = malloc ((argc-i+1) * sizeof (char *));
			j = 0;
			while (i < argc) {
				initial_command [j] = argv [i];
				i++; 
				j++;
			}
			initial_command [j]=NULL;
			/* 'fool' popt into thinking we have less args */
			argc = last;
			use_terminal_factory = FALSE;
			break;
		}
	}

	CORBA_exception_init (&ev);
	orb = gnome_CORBA_init_with_popt_table ("MultiTerminal", VERSION,
						&argc, argv,
						cb_options, 0, NULL,
						0, &ev);
	env = environ;

	if (ev._major != CORBA_NO_EXCEPTION)
		exit (5);

	CORBA_exception_free (&ev);

	gnome_window_icon_set_default_from_file (GNOME_ICONDIR"/mgt/multignometerm.png");

	/* since -x gets stripped out of the commands, this
	   will make it override --use-factory */
	if (use_terminal_factory && initial_command)
		use_terminal_factory = FALSE;

	if(cmdline_config->user_back_str)
		gdk_color_parse (cmdline_config->user_back_str,
				 &cmdline_config->palette[17]);

	if(cmdline_config->user_fore_str)
		gdk_color_parse (cmdline_config->user_fore_str,
				 &cmdline_config->palette [16]);

	if (cmdline_config->class){
		class = g_strdup (cmdline_config->class);
	}
	else
	{
#if 0 
		/* program_invocation_short_name is broken on non-glibc machines at the moment */
		program = program_invocation_short_name;
#else
		program_name = strrchr (argv[0], '/');
		if (!program_name) 
			program_name = argv[0];
		else
			program_name++;
#endif
		
		if (getenv ("GNOME_TERMINAL_CLASS"))
			class = g_strconcat ("Class-", getenv ("GNOME_TERMINAL_CLASS"), 
					     NULL);
		else if (strcmp (program_name, "multi-gnome-terminal"))
			class = g_strconcat ("Class-", program_name, NULL);
		else
			class = g_strdup ("Config");

		/* The class of multignometerm is always Class-multi-gnome-term */
		/*class = g_strconcat ("Class-", program_name, NULL);*/

	}
	{
	  /* If we find class in old config file or class is "Config"  
	     read from new config file MultiTerminal */
	  if (!read_old_settings(&cmds, &cmds_names, class, &default_config) ||
	      !strcmp(class, "Config"))
	    {
	      char *prefix = g_strdup_printf ("MultiTerminal/%s/", class);
	      gnome_config_push_prefix (prefix);
	      default_config = load_config (class);
	      gnome_config_pop_prefix();
	      g_free (class);
	      g_free (prefix);

	      /* Common has all common settings as user defined commands
		 and shortcuts */	   
	      prefix = g_strdup_printf("MultiTerminal/%s/", "Common");
	      gnome_config_push_prefix(prefix);
	      gnome_config_get_vector ("cmds", &num_cmds, &cmds);
    	      gnome_config_get_vector ("cmds_names", &num_cmds, &cmds_names);
	      if ((cmds == NULL) || (cmds_names == NULL))
		{
		  cmds = malloc(sizeof(char*));
		  cmds_names = malloc(sizeof(char*));
		  cmds[0] = NULL;
		  cmds_names[0] = NULL;
		}
	      else
		{
		  if (num_cmds == 1)
		    {
		      if (strlen(cmds[0])==0 && strlen(cmds_names[0])==0)
			{
			  cmds[0] = NULL;
			  cmds_names[0] = NULL;
			}
		    }
		}
	      
	      gnome_config_pop_prefix();
	      g_free(prefix);
	      
	    }
		  
	}
      
	/* now to override the defaults */
	if (cmdline_config->font){
		free (default_config->font);
		default_config->font = g_strdup (cmdline_config->font);
	}

	/* override the title*/
	if (cmdline_config->window_title) {
	  default_config->window_title = cmdline_config->window_title;
	}

	/* override the icon*/
	if (cmdline_config->window_icon) {
	  default_config->window_icon = cmdline_config->window_icon;
	}
	
	if (cmdline_config->user_back_str){
		default_config->palette[17] = cmdline_config->palette[17];
		default_config->color_set = COLORS_CUSTOM;
	}
	if (cmdline_config->user_fore_str){
		default_config->palette[16] = cmdline_config->palette[16];
		default_config->color_set = COLORS_CUSTOM;
	}
	/* disallow identical foreground and background colors */
	if(default_config->color_set==COLORS_CUSTOM &&
	   gdk_color_equal(&default_config->palette[16], 
			   &default_config->palette[17])) {
		default_config->color_set = 0;		
	}

	if (cmdline_config->have_user_background){
		default_config->background_pixmap = cmdline_config->background_pixmap;
		if(cmdline_config->background_pixmap) {
			default_config->pixmap_file = cmdline_config->pixmap_file;
		}
		default_config->transparent = cmdline_config->transparent;
	}

#ifdef ZVT_BACKGROUND_SCROLL
	if (cmdline_config->have_user_scroll_bg){
		default_config->scroll_background = cmdline_config->scroll_background;
	}
#endif

	if (cmdline_config->have_user_shaded){
		default_config->shaded = cmdline_config->shaded;
	}

	/* if the default is different from the commandline, use the commandline */
	default_config->invoke_as_login_shell =
		cmdline_login ? cmdline_config->invoke_as_login_shell : 
		default_config->login_by_default;
	default_config->termname = g_strdup(cmdline_config->termname);

	default_config->update_records &= cmdline_config->update_records_and;
	default_config->update_records ^= cmdline_config->update_records_xor;

	terminal_config_free (cmdline_config);

	load_factory_settings ();

	if (start_terminal_factory) {
		corba_init_server (orb);
		if (!has_terminal_factory)
			corba_activate_server ();
	}
	
	if (!load_session (cmds_names, cmds)) {
		gboolean has_term = FALSE;
		if (use_terminal_factory) {
			CORBA_Environment ev;
			/*CORBA_Object term;*/
			
			CORBA_exception_init (&ev);
			term = create_terminal_via_factory
				(initial_global_geometry
				 ? initial_global_geometry : "80x24", &ev);
			if (ev._major != CORBA_NO_EXCEPTION)
				exit (5);
			if (term) {
			        CORBA_Object_release (term, &ev);
				has_term = TRUE;
			}
			CORBA_exception_free (&ev);
		}
		if (!has_term) {
			new_terminal_cmd (initial_command, default_config,
					  initial_global_geometry,
					  terminal_id++, cmds_names, cmds);
		}
	}
	if (term)
	  {
	    return 0;	  
	  }
	/* set toggle items */
    	if (!default_config->menubar_hidden) {
	  toggle_item = GTK_CHECK_MENU_ITEM (gnome_terminal_terminal_menu[FILE_MENU_TOGGLE_INDEX_MENUBAR].widget);
	  toggle_item->active = !default_config->menubar_hidden;
	  toggle_item = GTK_CHECK_MENU_ITEM (gnome_terminal_terminal_menu[FILE_MENU_TOGGLE_INDEX_TOOLBAR].widget);
	  toggle_item->active = !default_config->toolbar_hidden;
	      toggle_item = GTK_CHECK_MENU_ITEM (gnome_terminal_terminal_menu[FILE_MENU_TOGGLE_INDEX_BUTTONBAR].widget);
	      toggle_item->active = !default_config->buttonbar_hidden;
      	      
      	}
	free_str_array(cmds);
	free_str_array(cmds_names);
  
	terminal_config_free (default_config);

	if (!terminals)
		return 0;

	client = gnome_master_client ();
	gtk_signal_connect (GTK_OBJECT (client), "save_yourself",
			    GTK_SIGNAL_FUNC (save_session), NULL);
	gtk_signal_connect (GTK_OBJECT (client), "die",
			    GTK_SIGNAL_FUNC (session_die), NULL);

	glade_gnome_init ();
#if 0
	while(1)
	  {
	    if (gtk_main_iteration_do(FALSE)==FALSE)
	      {
		/*gtk_exit(0);*/
		break;
	      }
	  }
#endif
#if 0
	while(1)
	  {
	    while(gtk_events_pending())
	      {
		gtk_main_iteration();
	      }
	  }
#endif
	/* NOTA IMPORTANTE:
	   se si lascia il while nudo e crudo l'applicazione si succhia
	   il 100% della CPU, bisogna implementare il main loop in maniera 
	   piu' simile a gtk_main e dunque bisogna procurarsi i sorgenti delle 
	   librerie gtk! */ 
	gtk_timeout_add(1000, check_changed_buffers, (gpointer)&terminals);	
      	gtk_main ();

	return 0;
}

extern char **environ;

int
main (int argc, char *argv [])
{
	signal (SIGHUP, SIG_IGN);
	return main_terminal_program (argc, argv, environ);
}

/*
 * Local variables:
 * c-basic-offset: 8
 * End:
 */
