/*
 *   Copyright (C) 1991-1999 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#define CAT_LIST_WIDTH  180
#define CAT_LIST_HEIGHT 220  

#define SAT_LIST_WIDTH  180
#define SAT_LIST_HEIGHT 220

#define	MAP_WIDTH	780
#define	MAP_HEIGHT	400
#define	MAP_TEXT_HEIGHT	72

#define	LOC_HEIGHT	350
#define	LOC_WIDTH	430

#define	ELEM_HEIGHT	250
#define	ELEM_WIDTH	320

#define	TRACK_HEIGHT	350
#define	TRACK_WIDTH	550

#define	BORDER_WIDTH	10
#define	BORDER_ITEM	5

#define	LIST_HEIGHT	180
#define	LIST_WIDTH	180

#define	HELP_LIST_HEIGHT 200
#define	HELP_LIST_WIDTH	 350

#define	TEXT_HEIGHT	350
#define	TEXT_WIDTH	500

#define	TEXT_SAT	0
#define	TEXT_DATETIME	1
#define	TEXT_AZIMUTH	2
#define	TEXT_ELEVATION	3
#define	TEXT_MA		4
#define	TEXT_MODE	5
#define	TEXT_RANGE	6
#define	TEXT_ORBIT	7
#define	TEXT_SQUINT	8
#define	TEXT_FREQ1	9
#define	TEXT_FREQ2	10
#define	TEXT_ALOS1	11
#define	TEXT_ALOS2	12

#define	DATE_FORMAT_DDMMYYYY	0
#define	DATE_FORMAT_MMDDYYYY	1

#define	COLOUR_BACKGROUND	0
#define	COLOUR_CITIES		1
#define	COLOUR_FOOTPRINT	2
#define	COLOUR_LAND		3
#define	COLOUR_SATELLITE	4
#define	COLOUR_USER		5
#define MAX_COLOURS		6

#define MAX_CHOSEN		10

#ifndef TRUE
#define	TRUE		1
#endif

#ifndef FALSE
#define	FALSE		0
#endif

#ifndef PI
#define	PI		3.141592654
#endif

#define	R		6378.16

#define	F		(1.0/298.25)

struct Sat_Struct {
	char   Name[51];
	char   Category[21];
	int    Epoch_Year;
	double Epoch_Day;
	double Inclination;
	double Mean_Anomoly;
	double Mean_Motion;
	double Eccentricity;
	double Arg_Of_Perigee;
	double RAAN;
	long   Epoch_Orbit;
	double Drag;
	int    Aflag;
	double Alon;
	double Alat;
	int    Minus_Z;
	int    No_Modes;
	int    MA_Day[20];
	char   Mode[20][10];
	long   Catalogue_No;
	float  Frequency1;
	float  Frequency2;

	/* Temporary run-time data */
	double SSP_Longitude;
	double SSP_Latitude;
	double Half_Angle;
	double Elevation;
	double Range;
	double Elapsed_Time;

	int    Current;
	int    Display;
	int    Beep;
};

extern int Num_Chosen;
extern GSList *Sat_List;

struct User_Struct {
	char   Callsign[21];
	double Latitude;
	double Longitude;
	double Height;
	int    Time_Interval;
	int    List_Interval;
	int    Time_Offset;
	int    Map_No;
	GdkColor Colours[MAX_COLOURS];
	int    Date_Format;
};
extern struct User_Struct User_Data;

struct Loc_Struct {
	char   QTH[51];
	double Latitude;
	double Longitude;
	double Height;
};
extern GSList *Loc_List;

struct Map_Struct {
	float x1, y1;
	float x2, y2;
};

extern char *Files_Path;

extern GtkWidget *MapText;
extern GtkWidget *MapArea;

/************************************************************************/
/* In Mtrack.C								*/
/************************************************************************/

extern void YN_Box(char *, void (*)(void), void (*)(void));

extern void Error_Box(char *);

extern void Warning_Box(char *);

extern void Message_Box(char *);

extern void Info_Box(char *);

/************************************************************************/
/* In Colour.C								*/
/************************************************************************/

extern GdkColor Text_Bg_Colour;
extern GdkColor Text_Fg_Colour;

extern void ColourCb(GtkWidget *, gpointer);

extern void Allocate_Colours(void);

/************************************************************************/
/* In Data_Ed.C								*/
/************************************************************************/

extern void Add_Sat_Data(void);

extern void Update_Sat_Data(void);

extern void Delete_Sat_Data(void);

extern void Add_Loc_Data(void);

extern void Update_Loc_Data(void);

extern void Delete_Loc_Data(void);

extern void Update_User_Data(void);

extern void Update_Sat(struct Sat_Struct *);

/************************************************************************/
/* In Data_List.C							*/
/************************************************************************/

extern struct Sat_Struct *Find_Satellite_Name(char *);

extern struct Sat_Struct *Find_Satellite_Cat_No(int);

extern struct Sat_Struct *Find_Current(void);

extern struct Loc_Struct *Find_Location_Name(char *);

extern void Choose_Satellite(void (*)(struct Sat_Struct *));

extern void Choose_Location(void (*)(struct Loc_Struct *));

/************************************************************************/
/* In Get_Data.C							*/
/************************************************************************/

extern gint Sat_Comparison(gconstpointer, gconstpointer);

extern gint Loc_Comparison(gconstpointer, gconstpointer);

extern void Import_Sat_Data(void);

extern void Read_Sat_Data(void);

extern void Read_User_Data(void);

extern void Read_Loc_Data(void);

extern void Write_Sat_Data(void);

extern void Write_Loc_Data(void);

extern void Write_User_Data(void);

/************************************************************************/
/* In Help.C								*/
/************************************************************************/

extern void HelpCb(GtkWidget *, gpointer);

extern void AboutCb(GtkWidget *, gpointer);

/************************************************************************/
/* In Map.C								*/
/************************************************************************/

extern GdkGC *BackgroundGC;
extern GdkGC *CitiesGC;
extern GdkGC *FootprintGC;
extern GdkGC *LandGC;
extern GdkGC *SatelliteGC;
extern GdkGC *UserGC;

extern void MapCb(GtkWidget *, gpointer);
extern gint maparea_buttonpress_cb(GtkWidget *, GdkEventButton *,gpointer );

extern void Redraw_Satellites(void);

extern gint MapTextCb(GtkWidget *, GdkEventExpose *);

extern gint MapAreaCb(GtkWidget *, GdkEventExpose *);

extern void Clear_Text(void);

extern void Write_Text(int, char *);

extern void Refresh_Text(void);

extern void List_Sat(struct Sat_Struct *);

/************************************************************************/
/* In Track.C								*/
/************************************************************************/

extern void Track_Satellite(time_t);

extern void List_Satellite(struct Sat_Struct *, time_t, time_t, int, double);

extern double RAD(double);

extern double DEG(double);

extern void Show_Elements(struct Sat_Struct *);

extern void Show_Locations(struct Sat_Struct *);

