#ifndef PARSER_TYPES_H
#define PARSER_TYPES_H

#include <sys/cdefs.h>

__BEGIN_DECLS

#define RCS_NONE            (1 << 0)
#define RCS_BASEDELAY       (1 << 1)
#define RCS_INTERDELAY      (1 << 2)
#define RCS_INTERDELAY_LIST (1 << 3)
#define RCS_MAXDELAY        (1 << 4)
#define RCS_SYNC            (1 << 5)
#define RCS_MAILBOXPREFIX   (1 << 6)
#define RCS_SS              (1 << 7)

struct rc_setting
{
	union
	{
		int base_delay;
		int inter_delay;
		struct {
			int delay;
			struct str_list* mailboxes;
		} inter_delay_list;
		int max_delay;
		struct str_list* sync;
		char* mailbox_prefix[2];
		struct rc_store_setting* store_setting;
	};
	int type;
	struct rc_setting* prev;
};

struct rc_setting* create_rc_setting(void);


#define RCSS_NONE  (1 << 0)
#define RCSS_NAME  (1 << 1)
#define RCSS_WATCH (1 << 2)

struct rc_store_setting
{
	union
	{
		char* name;
		struct str_list* watch;
	};
	int type;
	struct rc_store_setting* prev;
};

struct rc_store_setting* create_rc_store_setting(void);


struct str_list
{
	char* str;
	struct str_list* prev;
};

struct str_list* create_str_list(void);

__END_DECLS

#endif // PARSER_TYPES_H
