/*
 *   Written by Bradley Broom (2002).
 *
 *   Copyright (c) 2002 Bradley Broom
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <stdlib.h>
#include <stdio.h>

#include "MRW_Private.h"

char *progname;

void
Usage ()
{
	fprintf (stderr, "Usage: %s < mrwfile\n", progname);
	exit (1);
}

int
main (int argc, char *argv[])
{
	mrw_header	hdr;
	char		*errmsg;
	int		pimOffset, pimLength;

	progname = argv[0];
	if (!LoadMRW (&hdr, stdin, &errmsg)) {
		fprintf (stderr, "%s: Unable to read MRW file:\n", progname);
		fprintf (stderr, "    %s\n", errmsg);
		Usage();
	}
	pimOffset = IFD_GetUndefined (hdr.mrw_ifd, IFDTAG_PIMOFFSET);
	pimLength = IFD_GetUndefinedLength (hdr.mrw_ifd, IFDTAG_PIMOFFSET);
	fprintf (stderr, "PIM offset = %d\n", pimOffset);
	fprintf (stderr, "PIM length = %d\n", pimLength);

	write (1, hdr.ttw.data + pimOffset, pimLength);

	exit (0);
}
