/* The GIMP -- an image manipulation program
 * Copyright (C) 1995 Spencer Kimball and Peter Mattis
 * Minolta Raw file plugin
 *
 * Copyright (C) 2004 Bradley Broom
 *
 * Based on the Gimp PostScript plugin.
 * Copyright (C) 1997-98 Peter Kirchgessner
 * (email: peter@kirchgessner.net, WWW: http://www.kirchgessner.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <time.h>
#include <math.h>
#include <unistd.h>

#include "../../config.h"
#include <glib/gthread.h>
#include <libgimp/gimp.h>
#include <libgimp/gimpui.h>

#include <MRI.h>
#include "PersistentVals.h"
#include "presets.h"
#include "mrwplugin-intl.h"

void
ui_set_preset (GtkWidget *widget, gpointer data)
{
	PersistentVals *pv = (PersistentVals *)data;

	pv->userBalance.rgain = pv->redBalance + 0.5;
	pv->userBalance.ggain = pv->greenBalance + 0.5;
	pv->userBalance.bgain = pv->blueBalance + 0.5;
}

