/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */

/* eel-gdk-extensions.c: GdkFont extensions.

   Copyright (C) 1999, 2000 Eazel, Inc.

   The Gnome Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The Gnome Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the Gnome Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   Authors: Darin Adler <darin@eazel.com>, 
            Pavel Cisler <pavel@eazel.com>,
            Ramiro Estrugo <ramiro@eazel.com>
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <stdio.h>
#include <string.h>

#include "eel-gdk-font-extensions.h"

#define d(x)

#define ELLIPSIS "..."

gchar *
eel_string_ellipsize_end (const char *string, GdkFont *font, int width)
{
	int truncated_length;
	char *result;
	int resulting_width;

	d(puts(__FUNCTION__));

	resulting_width = gdk_string_width (font, string);
	if (resulting_width <= width) {
		/* String is already short enough. */
		return g_strdup (string);
	}
	
	/* Account for the width of the ellipsis. */
	width -= gdk_string_width (font, ELLIPSIS);
	

	if (width < 0) {
		/* No room even for a an ellipsis. */
		return g_strdup ("");
	}
	
        for (truncated_length = strlen (string) - 1; truncated_length > 0; truncated_length--) {
        	resulting_width -= gdk_char_width (font, string[truncated_length]);
        	if (resulting_width <= width) {
			break;
        	}
        }
	
	result = g_malloc (truncated_length + strlen (ELLIPSIS) + 1);
	memcpy (result, string, truncated_length);
	strcpy (result + truncated_length, ELLIPSIS);

	return result;
}

