/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2000 CodeFactory AB
 * Copyright (C) 2000 Richard Hult <rhult@codefactory.se>
 * Copyright (C) 2001 Mikael Hallendal <micke@codefactory.se>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Richard Hult
 */

#ifndef __PROJECT_H__
#define __PROJECT_H__

#include <bonobo/bonobo-xobject.h>
#include <gtk/gtktypeutils.h>
#include "libmrproject/GNOME_MrProject.h"
#include "project-engine/task-manager.h"
#include "project-engine/resource-manager.h"
#include "project-engine/allocation-manager.h"

#define PROJECT_TYPE        (project_get_type ())
#define PROJECT(o)          (GTK_CHECK_CAST ((o), PROJECT_TYPE, Project))
#define PROJECT_CLASS(k)    (GTK_CHECK_CLASS_CAST((k), PROJECT_TYPE, ProjectClass))
#define IS_PROJECT(o)       (GTK_CHECK_TYPE ((o), PROJECT_TYPE))
#define IS_PROJECT_CLASS(k) (GTK_CHECK_CLASS_TYPE ((k), PROJECT_TYPE))

typedef struct _Project       Project;
typedef struct _ProjectPriv   ProjectPriv;

struct _Project {
	BonoboXObject        parent;
	BonoboEventSource   *event_source;
	TaskManager         *task_manager;
	ResourceManager     *resource_manager;
	AllocationManager   *allocation_manager;
	ProjectPriv         *priv;
};

typedef struct {
	BonoboXObjectClass                 parent_class;
	POA_GNOME_MrProject_Project__epv   epv;
	
	/* Methods. */
	void
	(*load)				(Project           *project,
					 const gchar       *uri,
					 CORBA_Environment *ev);
	
	void
	(*save)				(Project           *project,
					 const gchar       *uri,
					 CORBA_Environment *ev);
} ProjectClass;


GtkType		 project_get_type             (void);
 

#endif /* __PROJECT_H__ */

