#ifndef MR_HSCROLLBAR_H
#define MR_HSCROLLBAR_H

#include <gdk/gdk.h>
#include <gtk/gtkhscrollbar.h>

#define MR_HSCROLLBAR_TYPE    (mr_hscrollbar_get_type ())
#define MR_HSCROLLBAR(obj)    (GTK_CHECK_CAST((obj), MR_HSCROLLBAR_TYPE, MrHScrollbar))
#define IS_MR_HSCROLLBAR(obj) (GTK_CHECK_TYPE((obj), MR_HSCROLLBAR_TYPE))

typedef struct _MrHScrollbar       MrHScrollbar;
typedef struct _MrHScrollbarClass  MrHScrollbarClass;

typedef enum {
	MR_SCROLL_STEP_FORWARD,
	MR_SCROLL_STEP_BACKWARD,
	MR_SCROLL_CONT_FORWARD,
	MR_SCROLL_CONT_BACKWARD
} MrScrollType;

struct _MrHScrollbar
{
	GtkHScrollbar  hscrollbar;
};

struct _MrHScrollbarClass
{
	GtkHScrollbarClass parent_class;
};


GtkType    mr_hscrollbar_get_type (void);
GtkWidget* mr_hscrollbar_new      (GtkAdjustment *adjustment);


#endif /* MR_HSCROLLBAR_H */
