/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2000-2001 CodeFactory AB
 * Copyright (C) 2000-2001 Richard Hult <rhult@codefactory.se>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Richard Hult
 */

#ifndef __PROJECT_WINDOW_H__
#define __PROJECT_WINDOW_H__

#include <glib.h>
#include <gtk/gtktypeutils.h>
#include <gtk/gtkwidget.h>
#include <bonobo.h>
#include <bonobo/bonobo-win.h>

#define PROJECT_TYPE_WINDOW        (project_window_get_type())
#define PROJECT_WINDOW(o)          (GTK_CHECK_CAST((o), PROJECT_TYPE_WINDOW, ProjectWindow))
#define PROJECT_WINDOW_CLASS(k)    (GTK_CHECK_CLASS_CAST((k), PROJECT_TYPE_WINDOW, ProjectWindowClass))
#define IS_PROJECT_WINDOW(o)       (GTK_CHECK_TYPE((o), PROJECT_TYPE_WINDOW))
#define IS_PROJECT_WINDOW_CLASS(k) (GTK_CHECK_CLASS_TYPE((k), PROJECT_TYPE_WINDOW))

typedef struct _ProjectWindow        ProjectWindow;
typedef struct _ProjectWindowClass   ProjectWindowClass;
typedef struct _ProjectWindowPriv    ProjectWindowPriv;

#include "shell.h"

struct _ProjectWindow
{
	BonoboWindow	   parent_object;
	ProjectWindowPriv *priv;
};

struct _ProjectWindowClass
{
	BonoboWindowClass parent_class;
};

GtkType    project_window_get_type    (void);
GtkWidget *project_window_new	      (const gchar    *uri);
Shell     *project_window_get_shell   (ProjectWindow     *window);
void       project_window_add_control (ProjectWindow  *window,
				       GtkWidget      *widget,
				       gchar          *id,
				       GdkPixbuf      *pixbuf,
				       const gchar    *title);


#endif /* __PROJECT_WINDOW_H__ */

