/*
 * Copyright (C) 2001  CodeFactory AB
 * Copyright (C) 2001  Richard Hult
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Richard Hult <rhult@codefactory.se>
 *
 */

#ifndef __GANTT_MODEL_H__
#define __GANTT_MODEL_H__

#include <gtk/gtk.h>
#include <gal/e-table/e-tree.h>
#include <gal/e-table/e-tree-table-adapter.h>
#include <gal/e-table/e-tree-model.h>
#include "util/corba-utils.h"
#include "libmrproject/GNOME_MrProject.h"

#define TYPE_GANTT_MODEL			(gantt_model_get_type ())
#define GANTT_MODEL(obj)			(GTK_CHECK_CAST ((obj), TYPE_GANTT_MODEL, GanttModel))
#define GANTT_MODEL_CLASS(klass)		(GTK_CHECK_CLASS_CAST ((klass), TYPE_GANTT_MODEL, GanttModelClass))
#define IS_GANTT_MODEL(obj)			(GTK_CHECK_TYPE ((obj), TYPE_GANTT_MODEL))
#define IS_GANTT_MODEL_CLASS(klass)		(GTK_CHECK_CLASS_TYPE ((obj), TYPE_GANTT_MODEL))


typedef struct _GanttModel       GanttModel;
typedef struct _GanttModelClass  GanttModelClass;
typedef struct _GanttModelPriv   GanttModelPriv;

struct _GanttModel
{
	GtkObject       parent;
	ETreeModel     *etm;
	ETableModel    *etta;
	ETree          *e_tree;
	GanttModelPriv *priv;
};

struct _GanttModelClass
{
	GtkObjectClass parent_class;

	void (*task_changed)	              (GanttModel          *model,
					       GM_Task             *task);
	void (*scale_changed)	              (GanttModel          *model);
	void (*task_linked)	              (GanttModel          *model,
					       GM_Dependency       *dependency);
	void (*task_unlinked)	              (GanttModel          *model,
					       GM_Dependency      *dependency);

	void (*allocation_assigned)           (GanttModel          *model,
					       GM_Resource         *resource,
					       GM_Id                task_id);
	void (*allocation_unassigned)         (GanttModel          *model,
					       GM_Resource         *resource,
					       GM_Id                task_id);
        void (*allocated_resource_changed)    (GanttModel          *model,
                                               GM_Id                task_id,
                                               GM_Resource         *resource);
};


GtkType     gantt_model_get_type              (void);
GanttModel *gantt_model_new                   (ETreeModel          *etm,
					       ETreeTableAdapter   *etta,
					       ETree               *e_tree);
GM_Task    *gantt_model_get_task              (GanttModel          *model,
					       GM_Id                id);
GM_Task    *gantt_model_get_task_at_row       (GanttModel          *model,
					       gint                 row);
GM_Task    *gantt_model_get_task_at_path      (GanttModel          *model,
					       ETreePath            path);
GM_Id       gantt_model_get_task_above        (GanttModel          *model,
					       GM_Id                id);
GM_Id       gantt_model_get_prev_sibling      (GanttModel          *model,
					       GM_Id                id);
GM_Id       gantt_model_get_next_sibling      (GanttModel          *model,
					       GM_Id                id);
gint        gantt_model_task_get_child_offset (GanttModel          *model,
					       GM_Id                id);
ETreePath   gantt_model_get_path              (GanttModel          *model,
					       GM_Id                id);
gboolean    gantt_model_task_is_leaf          (GanttModel          *model,
					       GM_Id                id);
void        gantt_model_task_changed          (GanttModel          *model,
					       GM_Id                id);
void        gantt_model_update_task           (GanttModel          *model,
					       GM_Id                id,
					       GM_Task             *task);
void        gantt_model_task_moved            (GanttModel          *model,
					       GM_Id                id,
					       time_t               start,
					       GM_TaskEdge          edge);
void        gantt_model_task_duration_changed (GanttModel          *model,
					       GM_Id                task_id,
					       GM_Time              duration,
					       GM_TaskEdge          edge);
void        gantt_model_insert_task           (GanttModel          *model,
					       GM_Id                parent_id,
					       GM_Id                sibling_id,
					       GM_TaskOrderType     type,
					       GM_Task             *task);
void        gantt_model_remove_task           (GanttModel          *model,
					       GM_Id                id);
void        gantt_model_reposition_task       (GanttModel          *model,
					       GM_Id                task_id,
					       GM_Id                sibling_id,
					       GNOME_MrProject_TaskOrderType type);
void        gantt_model_reparent_task         (GanttModel          *model,
					       GM_Id                parent_id,
					       GM_Id                task_id,
					       gint                 position);
void        gantt_model_remove_tasks          (GanttModel          *model,
                                               GSList              *ids);
void        gantt_model_remove_all_tasks      (GanttModel          *model);
void        gantt_model_link                  (GanttModel          *model,
					       const GM_Dependency *dependency);
void        gantt_model_unlink                (GanttModel          *model,
					       const GM_Dependency *dependency);
void        gantt_model_assign_allocation     (GanttModel          *model,
					       const GM_Resource   *resource,
					       GM_Id                task_id);
void        gantt_model_unassign_allocation   (GanttModel          *model,
					       GM_Id                resource_id,
					       GM_Id                task_id);
void        gantt_model_update_allocated_resource (GanttModel      *model,
                                                   GM_Id            task_id,
                                                   GM_Resource     *resource);
GSList     *gantt_model_task_get_predecessors (GanttModel          *model,
					       GM_Id                id);
GSList     *gantt_model_task_get_successors   (GanttModel          *model,
					       GM_Id                id);
GSList     *gantt_model_task_get_resources    (GanttModel          *model,
					       GM_Id                id);
time_t      gantt_model_get_first_time        (GanttModel          *model);
time_t      gantt_model_get_last_time         (GanttModel          *model);
ETreePath   gantt_model_get_root_path         (GanttModel          *model);
gint        gantt_model_get_num_tasks         (GanttModel          *model);

#endif /* __GANTT_MODEL_H__ */
