/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2001 Thomas Nyberg <thomas@codefactory.se>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Thomas Nyberg
 */
#ifndef __MONTH_VIEW_TASK_ITEM_H__
#define __MONTH_VIEW_TASK_ITEM_H__


#include <glib.h>
#include <libgnomeui/gnome-canvas.h>
#include "month-view.h"

#define MONTH_VIEW_TASK_ITEM_TYPE          month_view_task_item_get_type ()
#define MONTH_VIEW_TASK_ITEM(obj)          GTK_CHECK_CAST (obj, MONTH_VIEW_TASK_ITEM_TYPE, MonthViewTaskItem)
#define MONTH_VIEW_TASK_ITEM_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, MONTH_VIEW_TASK_ITEM_TYPE, MonthViewTaskItemClass)
#define IS_MONTH_VIEW_TASK_ITEM(obj)       GTK_CHECK_TYPE (obj, MONTH_VIEW_TASK_ITEM_TYPE)


typedef struct _MonthViewTaskItem MonthViewTaskItem;
typedef struct _MonthViewTaskItemClass MonthViewTaskItemClass;

enum {
	MONTH_VIEW_TASK_ITEM_NO_ARROW    = 0,
	MONTH_VIEW_TASK_ITEM_ARROW_LEFT  = 1 << 0,
	MONTH_VIEW_TASK_ITEM_ARROW_RIGHT = 1 << 1,
};

struct _MonthViewTaskItem {
	GnomeCanvasItem parent;

	gint task_num;
	gint span_num;
	
	gint flag; /* should be some combination of the MONTH_VIRE_TASK_ITEM_ARROW_x */

	MonthView *month_view;
};

struct _MonthViewTaskItemClass {
	GnomeCanvasItemClass parent_class;
};


GtkType month_view_task_item_get_type (void);

#endif /* __MONTH_VIEW_TASK_ITEM_H__ */
