/* -*- Mode: C; c-basic-offset:4 ; indent-tabs-mode:nil ; -*- */
/*
 *  (C) 2012 NEC Corporation
 *      Author: Masamichi Takagi
 *      See COPYRIGHT in top-level directory.
 */

#include "ib_impl.h"

//#define MPID_NEM_IB_DEBUG_POLL
#ifdef dprintf  /* avoid redefinition with src/mpid/ch3/include/mpidimpl.h */
#undef dprintf
#endif
#ifdef MPID_NEM_IB_DEBUG_POLL
#define dprintf printf
#else
#define dprintf(...)
#endif

static int entered_drain_scq = 0;

#if 0
#define MPID_NEM_IB_SEND_PROGRESS_POLLINGSET MPID_nem_ib_send_progress(vc_ib);
#else
#define MPID_NEM_IB_SEND_PROGRESS_POLLINGSET {     \
   int n; \
   for(n = 0; n < MPID_nem_ib_npollingset; n++) { \
       MPIDI_VC_t *vc_n = MPID_nem_ib_pollingset[n]; \
       /*MPID_nem_ib_debug_current_vc_ib = vc_ib;*/   \
       MPID_nem_ib_send_progress(VC_IB(vc_n)); \
   } \
}
#endif
#if 1
#define MPID_NEM_IB_CHECK_AND_SEND_PROGRESS \
    if (!MPID_nem_ib_sendq_empty(vc_ib->sendq) && MPID_nem_ib_sendq_ready_to_send_head(vc_ib)) { \
    MPID_nem_ib_send_progress(vc_ib); \
}
#else
#define MPID_NEM_IB_CHECK_AND_SEND_PROGRESS MPID_NEM_IB_SEND_PROGRESS_POLLINGSET
#endif

#undef FUNCNAME
#define FUNCNAME MPID_nem_ib_drain_scq
#undef FCNAME
#define FCNAME MPIDI_QUOTE(FUNCNAME)
int MPID_nem_ib_drain_scq(int dont_call_progress)
{

    int mpi_errno = MPI_SUCCESS;
    int result;
    int i;
    struct ibv_wc cqe[MPID_NEM_IB_COM_MAX_CQ_HEIGHT_DRAIN];

    MPIDI_STATE_DECL(MPID_STATE_MPID_NEM_IB_DRAIN_SCQ);
    MPIDI_FUNC_ENTER(MPID_STATE_MPID_NEM_IB_DRAIN_SCQ);

    /* prevent a call path drain_scq -> send_progress -> drain_scq */
    if (entered_drain_scq) {
        printf("drain_scq,re-enter\n");
        goto fn_exit;
    }
    entered_drain_scq = 1;

#if 0   /*def HAVE_LIBDCFA */
    result = ibv_poll_cq(MPID_nem_ib_rc_shared_scq, 1, &cqe[0]);
#else
    result =
        ibv_poll_cq(MPID_nem_ib_rc_shared_scq, /*3 */ MPID_NEM_IB_COM_MAX_CQ_HEIGHT_DRAIN, &cqe[0]);
#endif

    MPIU_ERR_CHKANDJUMP(result < 0, mpi_errno, MPI_ERR_OTHER, "**netmod,ib,ibv_poll_cq");

    if (result > 0) {
        dprintf("poll,scq,result=%d\n", result);
    }
    for (i = 0; i < result; i++) {
        dprintf("drain_scq,i=%d\n", i);

        MPID_Request *req;
        MPID_Request_kind_t kind;
        int req_type, msg_type;

        /* Obtain sreq */
        req = (MPID_Request *) cqe[i].wr_id;

        kind = req->kind;
        req_type = MPIDI_Request_get_type(req);
        msg_type = MPIDI_Request_get_msg_type(req);

        dprintf("drain_scq,req=%p,req->ref_count=%d,cc_ptr=%d\n", req, req->ref_count,
                *req->cc_ptr);
        if (req->ref_count <= 0) {
            MPID_nem_ib_vc_area *vc_ib = VC_IB(req->ch.vc);
            printf("%d\n", *(int *) 0);
        }

#ifdef HAVE_LIBDCFA
        if (cqe[i].status != IBV_WC_SUCCESS) {
            dprintf("drain_scq,kind=%d,req_type=%d,msg_type=%d,cqe.status=%08x\n", kind, req_type,
                    msg_type, cqe[i].status);
        }
#else
        if (cqe[i].status != IBV_WC_SUCCESS) {
            dprintf("drain_scq,kind=%d,req_type=%d,msg_type=%d,comm=%p,cqe.status=%08x,%s\n", kind,
                    req_type, msg_type, req->comm, cqe[i].status, ibv_wc_status_str(cqe[i].status));
        }
#endif
        MPIU_ERR_CHKANDJUMP(cqe[i].status != IBV_WC_SUCCESS, mpi_errno, MPI_ERR_OTHER,
                            "**MPID_nem_ib_drain_scq");

        /*
         * packets generated by MPIDI_CH3_iStartMsgv has req_type of RECV
         * lmt_initiate_lmt, lmt_put_cts_to_sender, lmt_put_rts_to_receiver, lmt_send_put_done
         */
        if (
               //req_type == MPIDI_REQUEST_TYPE_SEND
               (req_type == MPIDI_REQUEST_TYPE_SEND ||
                req_type == MPIDI_REQUEST_TYPE_RECV || req_type == MPIDI_REQUEST_TYPE_SSEND)
               && msg_type == MPIDI_REQUEST_EAGER_MSG) {
            dprintf("drain_scq,send/recv,eager,req_type=%d,,comm=%p,opcode=%d\n", req_type,
                    req->comm, cqe[i].opcode);

            MPID_nem_ib_vc_area *vc_ib = VC_IB(req->ch.vc);
            dprintf("drain_scq,MPIDI_REQUEST_EAGER_MSG,%d->%d,sendq_empty=%d,ncom=%d,ncqe=%d,rdmabuf_occ=%d\n", MPID_nem_ib_myrank, req->ch.vc->pg_rank, MPID_nem_ib_sendq_empty(vc_ib->sendq), vc_ib->ibcom->ncom, MPID_nem_ib_ncqe, MPID_nem_ib_diff32(vc_ib->ibcom->sseq_num, vc_ib->ibcom->lsr_seq_num_tail));      /* moved before MPID_Request_release because this references req->ch.vc */

            /* free temporal buffer for eager-send non-contiguous data.
             * MPIDI_Request_create_sreq (in mpid_isend.c) sets req->dev.datatype
             * control message has a req_type of MPIDI_REQUEST_TYPE_RECV and
             * msg_type of MPIDI_REQUEST_EAGER_MSG because
             * control message send follows
             * MPIDI_CH3_iStartMsg/v-->MPID_nem_ib_iStartContigMsg-->MPID_nem_ib_iSendContig
             * and MPID_nem_ib_iSendContig set req->dev.state to zero.
             * see MPID_Request_create (in src/mpid/ch3/src/ch3u_request.c)
             * eager-short message has req->comm of zero
             */
            if (req_type == MPIDI_REQUEST_TYPE_SEND && req->comm) {
                /* exclude control messages by requiring MPIDI_REQUEST_TYPE_SEND
                 * exclude eager-short by requiring req->comm != 0 */
                int is_contig;
                MPID_Datatype_is_contig(req->dev.datatype, &is_contig);
                if (!is_contig && REQ_FIELD(req, lmt_pack_buf)) {
                    dprintf("drain_scq,eager-send,non-contiguous,free lmt_pack_buf=%p\n",
                            REQ_FIELD(req, lmt_pack_buf));
                    MPIU_Free(REQ_FIELD(req, lmt_pack_buf));
                }
            }

            /* decrement the number of entries in IB command queue */
            vc_ib->ibcom->ncom -= 1;
            MPID_nem_ib_ncqe -= 1;
            dprintf("drain_scq,eager-send,ncqe=%d\n", MPID_nem_ib_ncqe);
            MPIU_Assert(req->ref_count == 1 || req->ref_count == 2);

            /* ref_count is decremented in drain_scq and wait */
            if (*req->cc_ptr > 0) {
                dprintf("drain_scq,MPID_nem_ib_ncqe_nces=%d,cc_ptr=%d,pending_sends=%d\n",
                        MPID_nem_ib_ncqe_nces, *req->cc_ptr, VC_FIELD(req->ch.vc, pending_sends));
                MPID_nem_ib_ncqe_nces -= 1;

                int (*reqFn) (MPIDI_VC_t *, MPID_Request *, int *);

                (VC_FIELD(req->ch.vc, pending_sends)) -= 1;

                /* as in the template */
                reqFn = req->dev.OnDataAvail;
                if (!reqFn) {
                    MPIDI_CH3U_Request_complete(req);
                    MPIU_DBG_MSG(CH3_CHANNEL, VERBOSE, ".... complete");
                    dprintf("drain_scq,complete,req=%p,pcc incremented to %d\n", req,
                            MPIDI_CH3I_progress_completion_count.v);
                }
                else {
                    dprintf("drain_scq,reqFn isn't zero\n");
                    MPIDI_VC_t *vc = req->ch.vc;
                    int complete = 0;
                    mpi_errno = reqFn(vc, req, &complete);
                    if (mpi_errno)
                        MPIU_ERR_POP(mpi_errno);
                    /* not-completed case is not implemented */
                    MPIU_Assert(complete == TRUE);
                }
            }
            else {
                MPID_Request_release(req);
            }
            /* try to send from sendq */
            //dprintf("ib_poll,SCQ,!lmt,send_progress\n");
            if (!MPID_nem_ib_sendq_empty(vc_ib->sendq)) {
                dprintf("drain_scq,eager-send,ncom=%d,ncqe=%d,diff=%d\n",
                        vc_ib->ibcom->ncom < MPID_NEM_IB_COM_MAX_SQ_CAPACITY,
                        MPID_nem_ib_ncqe < MPID_NEM_IB_COM_MAX_CQ_CAPACITY,
                        MPID_nem_ib_diff32(vc_ib->ibcom->sseq_num,
                                           vc_ib->ibcom->lsr_seq_num_tail) <
                        MPID_NEM_IB_COM_RDMABUF_NSEG);

                MPID_Request *sreq = MPID_nem_ib_sendq_head(vc_ib->sendq);
                int msg_type_sreq = MPIDI_Request_get_msg_type(sreq);

                if (sreq->kind == MPID_REQUEST_SEND && msg_type_sreq == MPIDI_REQUEST_EAGER_MSG) {
                    dprintf("drain_scq,eager-send,head is eager-send\n");
                }
                else if (sreq->kind == MPID_REQUEST_RECV && msg_type_sreq == MPIDI_REQUEST_RNDV_MSG) {
                    dprintf("drain_scq,eager-send,head is lmt RDMA-read\n");
                }
                else if (sreq->kind == MPID_REQUEST_SEND && msg_type_sreq == MPIDI_REQUEST_RNDV_MSG) {
                    dprintf("drain_scq,eager-send,head is lmt RDMA-write\n");
                }
            }
            /*  call MPID_nem_ib_send_progress for all VCs in polling-set
             * instead of VC which releases CQ, command
             * when releasing them
             * because commands for VC-A are blocked by the command
             * for VC-B and waiting in the sendq
             */
            dprintf("drain_scq,eager-send,send_progress\n");
            //MPID_NEM_IB_SEND_PROGRESS_POLLINGSET;

            dprintf("drain_scq,eager-send,next\n");

        }
        else if (req_type == MPIDI_REQUEST_TYPE_GET_RESP && msg_type == MPIDI_REQUEST_EAGER_MSG) {
            dprintf("drain_scq,GET_RESP,eager,req_type=%d,,comm=%p,opcode=%d\n", req_type,
                    req->comm, cqe[i].opcode);

            MPID_nem_ib_vc_area *vc_ib = VC_IB(req->ch.vc);
            dprintf("drain_scq,MPIDI_REQUEST_EAGER_MSG,%d->%d,sendq_empty=%d,ncom=%d,ncqe=%d,rdmabuf_occ=%d\n", MPID_nem_ib_myrank, req->ch.vc->pg_rank, MPID_nem_ib_sendq_empty(vc_ib->sendq), vc_ib->ibcom->ncom, MPID_nem_ib_ncqe, MPID_nem_ib_diff32(vc_ib->ibcom->sseq_num, vc_ib->ibcom->lsr_seq_num_tail));      /* moved before MPID_Request_release because this references req->ch.vc */

            /* decrement the number of entries in IB command queue */
            vc_ib->ibcom->ncom -= 1;
            MPID_nem_ib_ncqe -= 1;
            dprintf("drain_scq,GET_RESP,ncqe=%d\n", MPID_nem_ib_ncqe);
            MPIU_Assert(req->ref_count == 1 || req->ref_count == 2);

            /* ref_count is decremented in drain_scq and wait */
            dprintf("drain_scq,MPID_nem_ib_ncqe_nces=%d,cc_ptr=%d,pending_sends=%d\n",
                    MPID_nem_ib_ncqe_nces, *req->cc_ptr, VC_FIELD(req->ch.vc, pending_sends));
            MPID_nem_ib_ncqe_nces -= 1;

            int (*reqFn) (MPIDI_VC_t *, MPID_Request *, int *);

            (VC_FIELD(req->ch.vc, pending_sends)) -= 1;

            /* as in the template */
            reqFn = req->dev.OnDataAvail;
            if (!reqFn) {
                MPIDI_CH3U_Request_complete(req);
                MPIU_DBG_MSG(CH3_CHANNEL, VERBOSE, ".... complete");
                dprintf("drain_scq,complete,req=%p,pcc incremented to %d\n", req,
                        MPIDI_CH3I_progress_completion_count.v);
            }
            else {
                dprintf("drain_scq,reqFn isn't zero\n");
                dprintf("drain_scq,GET_RESP,before dev.OnDataAvail,ref_count=%d\n", req->ref_count);
                MPIDI_VC_t *vc = req->ch.vc;
                int complete = 0;
                mpi_errno = reqFn(vc, req, &complete);
                if (mpi_errno)
                    MPIU_ERR_POP(mpi_errno);
                /* not-completed case is not implemented */
                MPIU_Assert(complete == TRUE);
            }

            //MPID_NEM_IB_SEND_PROGRESS_POLLINGSET;

            dprintf("drain_scq,GET_RESP,next\n");

        }
        else if (req_type == MPIDI_REQUEST_TYPE_RECV && msg_type == MPIDI_REQUEST_RNDV_MSG &&
                 cqe[i].opcode == IBV_WC_RDMA_READ) {
            /* lmt get */
            /* the case for lmt-put-done or lmt-put where
             * (1) sender finds end-flag won't change (2) sender sends RTS to receiver
             * (3) receiver gets (4) here
             * is distinguished by cqe[i].opcode
             */
            dprintf("drain_scq,recv,rndv,rdma-read,kind=%d,opcode=%d\n", kind, cqe[i].opcode);


            MPID_nem_ib_vc_area *vc_ib = VC_IB(req->ch.vc);
#if defined(MPID_NEM_IB_LMT_GET_CQE)

            /* unpack non-contiguous dt */
            int is_contig;
            MPID_Datatype_is_contig(req->dev.datatype, &is_contig);
            if (!is_contig) {
                dprintf("drain_scq,lmt,GET_CQE,unpack noncontiguous data to user buffer\n");

                /* see MPIDI_CH3U_Request_unpack_uebuf (in /src/mpid/ch3/src/ch3u_request.c) */
                /* or MPIDI_CH3U_Receive_data_found (in src/mpid/ch3/src/ch3u_handle_recv_pkt.c) */
                MPIDI_msg_sz_t unpack_sz = req->ch.lmt_data_sz;
                MPID_Segment seg;
                MPI_Aint last;

                MPID_Segment_init(req->dev.user_buf, req->dev.user_count, req->dev.datatype, &seg,
                                  0);
                last = unpack_sz;
                MPID_Segment_unpack(&seg, 0, &last, REQ_FIELD(req, lmt_pack_buf));
                if (last != unpack_sz) {
                    /* --BEGIN ERROR HANDLING-- */
                    /* received data was not entirely consumed by unpack()
                     * because too few bytes remained to fill the next basic
                     * datatype */
                    MPIR_STATUS_SET_COUNT(req->status, last);
                    req->status.MPI_ERROR =
                        MPIR_Err_create_code(MPI_SUCCESS, MPIR_ERR_RECOVERABLE, FCNAME, __LINE__,
                                             MPI_ERR_TYPE, "**MPID_nem_ib_poll", 0);
                    /* --END ERROR HANDLING-- */
                }
                dprintf("drain_scq,lmt,GET_CQE,ref_count=%d,lmt_pack_buf=%p\n", req->ref_count,
                        REQ_FIELD(req, lmt_pack_buf));
                MPID_nem_ib_stfree(REQ_FIELD(req, lmt_pack_buf), (size_t) req->ch.lmt_data_sz);
            }
            dprintf("drain_scq,lmt,GET_CQE,lmt_send_GET_DONE,rsr_seq_num_tail=%d\n",
                    vc_ib->ibcom->rsr_seq_num_tail);

            /* send done to sender. vc is stashed in MPID_nem_ib_lmt_start_recv (in ib_lmt.c) */
            MPID_nem_ib_lmt_send_GET_DONE(req->ch.vc, req);
#endif
            /* unmark "lmt is going on" */

            //dprintf("ib_poll,SCQ,lmt,%d->%d,sendq_empty=%d,ncom=%d,ncqe=%d,rdmabuf_occ=%d\n", MPID_nem_ib_myrank, req->ch.vc->pg_rank, MPID_nem_ib_sendq_empty(vc_ib->sendq), vc_ib->ibcom->ncom, MPID_nem_ib_ncqe, MPID_nem_ib_diff32(vc_ib->ibcom->sseq_num, vc_ib->ibcom->lsr_seq_num_tail)); /* moved before MPID_Request_release because this references req->ch.vc */

            /* decrement the number of entries in IB command queue */
            vc_ib->ibcom->ncom -= 1;
            MPID_nem_ib_ncqe -= 1;
            dprintf("drain_scq,rdma-read,ncqe=%d\n", MPID_nem_ib_ncqe);

#ifdef MPID_NEM_IB_LMT_GET_CQE
            dprintf("drain_scq,GET_CQE,Request_complete\n");
            /* mark completion on rreq */
            MPIDI_CH3U_Request_complete(req);
#else /* GET, and !GET_CQE */

            int is_contig;
            MPID_Datatype_is_contig(req->dev.datatype, &is_contig);
            if (!is_contig) {
                //if (req->ref_count == 1) {
                dprintf("drain_scq,GET&&!GET_CQE,ref_count=%d,lmt_pack_buf=%p\n", req->ref_count,
                        REQ_FIELD(req, lmt_pack_buf));
                /* debug, polling waits forever when freeing here. */
                //free(REQ_FIELD(req, lmt_pack_buf));
                //MPID_nem_ib_stfree(REQ_FIELD(req, lmt_pack_buf), (size_t)req->ch.lmt_data_sz);
                //dprintf("drain_scq,lmt,insert to free-list=%p\n", MPID_nem_ib_fl);
                //} else {
                //dprintf("drain_scq,GET&&!GET_CQE,ref_count=%d,lmt_pack_buf=%p\n", req->ref_count, REQ_FIELD(req, lmt_pack_buf));
                //}
            }

            /* lmt_start_recv increments ref_count
             * drain_scq and ib_poll is not ordered, so both can decrement ref_count */
            MPID_Request_release(req);
#endif
            /* try to send from sendq */
            if (!MPID_nem_ib_sendq_empty(vc_ib->sendq)) {
                dprintf("drain_scq,GET,ncom=%d,ncqe=%d,diff=%d\n",
                        vc_ib->ibcom->ncom < MPID_NEM_IB_COM_MAX_SQ_CAPACITY,
                        MPID_nem_ib_ncqe < MPID_NEM_IB_COM_MAX_CQ_CAPACITY,
                        MPID_nem_ib_diff32(vc_ib->ibcom->sseq_num,
                                           vc_ib->ibcom->lsr_seq_num_tail) <
                        MPID_NEM_IB_COM_RDMABUF_NSEG);
                MPID_Request *sreq = MPID_nem_ib_sendq_head(vc_ib->sendq);
                int msg_type_sreq = MPIDI_Request_get_msg_type(sreq);

                if (sreq->kind == MPID_REQUEST_SEND && msg_type_sreq == MPIDI_REQUEST_EAGER_MSG) {
                    dprintf("drain_scq,eager-send,head is eager-send\n");
                }
                else if (sreq->kind == MPID_REQUEST_RECV && msg_type_sreq == MPIDI_REQUEST_RNDV_MSG) {
                    dprintf("drain_scq,eager-send,head is lmt\n");
                }
            }
            //if (!MPID_nem_ib_sendq_empty(vc_ib->sendq) && MPID_nem_ib_sendq_ready_to_send_head(vc_ib)) {
            dprintf("drain_scq,GET,send_progress\n");
            fflush(stdout);
            //MPID_NEM_IB_SEND_PROGRESS_POLLINGSET
            //}
        }
        else {
            printf("drain_scq,unknown kind=%d,req_type=%d,msg_type=%d\n", kind, req_type, msg_type);
            assert(0);
#if 1   // lazy consulting of completion queue
            MPIU_ERR_CHKANDJUMP(1, mpi_errno, MPI_ERR_OTHER, "**MPID_nem_ib_drain_scq");
#else
            //printf("kind=%d\n", kind);
#endif
        }
    }
    if (!dont_call_progress) {
        MPID_NEM_IB_SEND_PROGRESS_POLLINGSET;
    }
  fn_exit:
    entered_drain_scq = 0;
    MPIDI_FUNC_EXIT(MPID_STATE_MPID_NEM_IB_DRAIN_SCQ);
    return mpi_errno;
  fn_fail:
    goto fn_exit;
}

#undef FUNCNAME
#define FUNCNAME MPID_nem_ib_drain_scq_lmt_put
#undef FCNAME
#define FCNAME MPIDI_QUOTE(FUNCNAME)
int MPID_nem_ib_drain_scq_lmt_put()
{

    int mpi_errno = MPI_SUCCESS;
    int result;
    int i;
    struct ibv_wc cqe[MPID_NEM_IB_COM_MAX_CQ_HEIGHT_DRAIN];

    MPIDI_STATE_DECL(MPID_STATE_MPID_NEM_IB_DRAIN_SCQ_LMT_PUT);
    MPIDI_FUNC_ENTER(MPID_STATE_MPID_NEM_IB_DRAIN_SCQ_LMT_PUT);

#if 0   /*def HAVE_LIBDCFA */
    result = ibv_poll_cq(MPID_nem_ib_rc_shared_scq_lmt_put, 1, &cqe[0]);
#else
    result =
        ibv_poll_cq(MPID_nem_ib_rc_shared_scq_lmt_put, MPID_NEM_IB_COM_MAX_CQ_HEIGHT_DRAIN,
                    &cqe[0]);
#endif
    MPIU_ERR_CHKANDJUMP(result < 0, mpi_errno, MPI_ERR_OTHER, "**netmod,ib,ibv_poll_cq");

    if (result > 0) {
        dprintf("drain_scq_lmt_put,found,result=%d\n", result);
    }
    for (i = 0; i < result; i++) {

        MPID_Request *req;
        MPID_Request_kind_t kind;
        int req_type, msg_type;

#ifdef HAVE_LIBDCFA
        if (cqe[i].status != IBV_WC_SUCCESS) {
            dprintf("drain_scq_lmt_put,status=%08x\n", cqe[i].status);
        }
#else
        if (cqe[i].status != IBV_WC_SUCCESS) {
            dprintf("drain_scq_lmt_put,status=%08x,%s\n", cqe[i].status,
                    ibv_wc_status_str(cqe[i].status));
        }
#endif
        MPIU_ERR_CHKANDJUMP(cqe[i].status != IBV_WC_SUCCESS, mpi_errno, MPI_ERR_OTHER,
                            "**MPID_nem_ib_drain_scq_lmt_put");

        /* Obtain sreq */
        req = (MPID_Request *) cqe[i].wr_id;
        dprintf("drain_scq_lmt_put,req=%p,req->ref_count=%d\n", req, req->ref_count);
        MPIU_Assert(req->ref_count > 0);

        kind = req->kind;
        req_type = MPIDI_Request_get_type(req);
        msg_type = MPIDI_Request_get_msg_type(req);


        if (req_type == MPIDI_REQUEST_TYPE_RECV && msg_type == MPIDI_REQUEST_RNDV_MSG) {
            /* lmt-put */
            /* MPIDI_Request_set_type is not performed when
             * MPID_Isend --> FDU_or_AEP --> recv_posted --> ib_poll --> PUTCTS packet-handler */

            dprintf("drain_scq_lmt_put,lmt-put found\n");

#if 0 /* moving to just after put */    /*implementing back-to-back put and done */
#endif

            /* decrement the number of entries in IB command queue */
            MPID_nem_ib_vc_area *vc_ib = VC_IB(req->ch.vc);
            vc_ib->ibcom->ncom_lmt_put -= 1;
            MPID_nem_ib_ncqe_lmt_put -= 1;
            dprintf("drain_scq_lmt_put,rndv,ncqe=%d\n", MPID_nem_ib_ncqe_lmt_put);      /*suspicious */
            int (*reqFn) (MPIDI_VC_t *, MPID_Request *, int *);

            (VC_FIELD(req->ch.vc, pending_sends)) -= 1;

            /* as in the template */
            reqFn = req->dev.OnDataAvail;
            if (!reqFn) {
                MPIDI_CH3U_Request_complete(req);       /* decrement cc, signal_completion, decrement ref_count, free */
                dprintf("drain_scq,lmt-put,req=%p,cc incremented to %d\n", req,
                        MPIDI_CH3I_progress_completion_count.v);
                MPIU_DBG_MSG(CH3_CHANNEL, VERBOSE, ".... complete");
            }
            else {
                MPIDI_VC_t *vc = req->ch.vc;
                int complete = 0;
                mpi_errno = reqFn(vc, req, &complete);
                if (mpi_errno)
                    MPIU_ERR_POP(mpi_errno);
                /* not-completed case is not implemented */
                MPIU_Assert(complete == TRUE);
                MPIU_Assert(0); /* decrement ref_count and free sreq causes problem */
            }
        }
        else {
            dprintf("drain_scq_lmt_put,unknown kind=%d,req_type=%d,msg_type=%d\n", kind, req_type,
                    msg_type);
#if 1   // lazy consulting of completion queue
            MPIU_ERR_CHKANDJUMP(1, mpi_errno, MPI_ERR_OTHER, "**MPID_nem_ib_drain_scq_lmt_put");
#else
            //printf("kind=%d\n", kind);
#endif
        }
    }

  fn_exit:
    MPIDI_FUNC_EXIT(MPID_STATE_MPID_NEM_IB_DRAIN_SCQ_LMT_PUT);
    return mpi_errno;
  fn_fail:
    goto fn_exit;
}

#undef FUNCNAME
#define FUNCNAME MPID_nem_ib_drain_scq_scratch_pad
#undef FCNAME
#define FCNAME MPIDI_QUOTE(FUNCNAME)
int MPID_nem_ib_drain_scq_scratch_pad()
{

    int mpi_errno = MPI_SUCCESS;
    int result;
    int i;
    struct ibv_wc cqe[MPID_NEM_IB_COM_MAX_CQ_HEIGHT_DRAIN];

    MPIDI_STATE_DECL(MPID_STATE_MPID_NEM_IB_DRAIN_SCQ_SCRATCH_PAD);
    MPIDI_FUNC_ENTER(MPID_STATE_MPID_NEM_IB_DRAIN_SCQ_SCRATCH_PAD);

#if 0   /*def HAVE_LIBDCFA */
    result = ibv_poll_cq(MPID_nem_ib_rc_shared_scq_scratch_pad, 1, &cqe[0]);
#else
    result =
        ibv_poll_cq(MPID_nem_ib_rc_shared_scq_scratch_pad, MPID_NEM_IB_COM_MAX_CQ_HEIGHT_DRAIN,
                    &cqe[0]);
#endif
    MPIU_ERR_CHKANDJUMP(result < 0, mpi_errno, MPI_ERR_OTHER, "**netmod,ib,ibv_poll_cq");

    if (result > 0) {
        dprintf("drain_scq_scratch_pad,found,result=%d\n", result);
    }
    for (i = 0; i < result; i++) {

#ifdef HAVE_LIBDCFA
        if (cqe[i].status != IBV_WC_SUCCESS) {
            dprintf("drain_scq_scratch_pad,status=%08x\n", cqe[i].status);
        }
#else
        if (cqe[i].status != IBV_WC_SUCCESS) {
            dprintf("drain_scq_scratch_pad,status=%08x,%s\n", cqe[i].status,
                    ibv_wc_status_str(cqe[i].status));
        }
#endif
        MPIU_ERR_CHKANDJUMP(cqe[i].status != IBV_WC_SUCCESS, mpi_errno, MPI_ERR_OTHER,
                            "**MPID_nem_ib_drain_scq_scratch_pad");

        MPID_nem_ib_com_t *ibcom_scratch_pad = (MPID_nem_ib_com_t *) cqe[i].wr_id;
        dprintf("drain_scq_scratch_pad,ibcom_scratch_pad=%p\n", ibcom_scratch_pad);
        ibcom_scratch_pad->ncom_scratch_pad -= 1;
        MPID_nem_ib_ncqe_scratch_pad -= 1;
    }

  fn_exit:
    MPIDI_FUNC_EXIT(MPID_STATE_MPID_NEM_IB_DRAIN_SCQ_SCRATCH_PAD);
    return mpi_errno;
  fn_fail:
    goto fn_exit;
}

#undef FUNCNAME
#define FUNCNAME MPID_nem_ib_poll_eager
#undef FCNAME
#define FCNAME MPIDI_QUOTE(FUNCNAME)
int MPID_nem_ib_poll_eager(MPIDI_VC_t * vc)
{

    int mpi_errno = MPI_SUCCESS;
    int ibcom_errno;
    int result;
    struct ibv_wc cqe[MPID_NEM_IB_COM_MAX_CQ_HEIGHT_DRAIN];
    uint64_t tscs, tsce;

    MPIDI_STATE_DECL(MPID_STATE_MPID_NEM_IB_POLL_EAGER);
    MPIDI_FUNC_ENTER(MPID_STATE_MPID_NEM_IB_POLL_EAGER);

    //MPID_nem_ib_tsc_poll = MPID_nem_ib_rdtsc();

    MPID_nem_ib_vc_area *vc_ib = VC_IB(vc);
    //dprintf("ib_poll,ld,rsr_seq_num_poll=%d\n", vc_ib->ibcom->rsr_seq_num_poll);
    volatile void *buf =
        (uint8_t *) vc_ib->ibcom->icom_mem[MPID_NEM_IB_COM_RDMAWR_TO] +
        MPID_NEM_IB_COM_RDMABUF_SZSEG * ((uint32_t) vc_ib->ibcom->rsr_seq_num_poll %
                                         MPID_NEM_IB_COM_RDMABUF_NSEG);
    volatile MPID_nem_ib_sz_hdrmagic_t *sz_hdrmagic = (MPID_nem_ib_sz_hdrmagic_t *) buf;
    if (sz_hdrmagic->magic != MPID_NEM_IB_COM_MAGIC) {
        goto fn_exit;
    }
    //dprintf("ib_poll_eager,buf=%p,sz=%d\n", buf, sz_hdrmagic->sz);

    /* unmark magic */
    sz_hdrmagic->magic = 0 /*0xdead */ ;
#if 0
    ibcom_errno = MPID_nem_ib_com_poll_cq(MPID_NEM_IB_COM_RC_SHARED_RCQ, &cqe, &result);
    MPIU_ERR_CHKANDJUMP(ibcom_errno, mpi_errno, MPI_ERR_OTHER, "**MPID_nem_ib_com_poll_cq");
#endif
    dprintf("ib_poll_eager,eager-send,found\n");

    //MPIU_ERR_CHKANDJUMP1(cqe.status != IBV_WC_SUCCESS, mpi_errno, MPI_ERR_OTHER, "**MPID_nem_ib_com_poll_cq", "**MPID_nem_ib_com_poll_cq %s", MPID_nem_ib_com_strerror(ibcom_errno));

    int sz_data_pow2;
    MPID_NEM_IB_SZ_DATA_POW2(sz_hdrmagic->sz);
    volatile MPID_nem_ib_tailmagic_t *tailmagic =
        (MPID_nem_ib_tailmagic_t *) ((uint8_t *) buf + sz_data_pow2);
    dprintf("poll,sz_data_pow2=%d,tailmagic=%p,sz=%d\n", sz_data_pow2, tailmagic, sz_hdrmagic->sz);
    int k = 0;
    //tsce = MPID_nem_ib_rdtsc(); printf("9,%ld\n", tsce - tscs); // 55 for 512-byte
    //tscs = MPID_nem_ib_rdtsc();
    //#define MPID_NEM_IB_TLBPREF_POLL 20
#ifdef MPID_NEM_IB_TLBPREF_POLL
    int tlb_pref_ahd = (uint64_t) tailmagic + 4096 * MPID_NEM_IB_TLBPREF_POLL - (uint64_t) buf;
#endif
    while (tailmagic->magic != MPID_NEM_IB_COM_MAGIC) {
        //k++;
#if 0   /* pre-fetch next RDMA-write-buf slot to cover TLB miss latency */
        __asm__ __volatile__
            ("movq %0, %%rsi;"
             "movq 0(%%rsi), %%rsi;"::"r"(vc_ib->ibcom->icom_mem[MPID_NEM_IB_COM_RDMAWR_TO] +
                                          MPID_NEM_IB_COM_RDMABUF_SZSEG *
                                          ((vc_ib->ibcom->rsr_seq_num_poll +
                                            1) % MPID_NEM_IB_COM_RDMABUF_NSEG)):"%rsi");
#endif
#ifdef MPID_NEM_IB_TLBPREF_POLL
        __asm__ __volatile__
            ("movq %0, %%rsi;" "movq 0(%%rsi), %%rax;"::"r"(buf + tlb_pref_ahd):"%rsi", "%rax");
        tlb_pref_ahd = (tlb_pref_ahd + 4096 * 20) % MPID_NEM_IB_COM_RDMABUF_SZ;
#endif
    }
    //tsce = MPID_nem_ib_rdtsc(); printf("0,%ld\n", tsce - tscs); // 20-60 for 512-byte
    //tscs = MPID_nem_ib_rdtsc();
    //dprintf("magic wait=%d\n", k);


    /* this reduces memcpy in MPIDI_CH3U_Receive_data_found */
    /* MPIDI_CH3_PktHandler_EagerSend (in ch3u_eager.c)
     * MPIDI_CH3U_Receive_data_found (in ch3u_handle_recv_pkt.c)
     * MPIU_Memcpy((char*)(rreq->dev.user_buf) + dt_true_lb, buf, data_sz);
     * 600 cycle for 512B!!! --> 284 cycle with prefetch
     */

#if 1
    void *rsi;
    for (rsi = (void *) buf; rsi < (uint8_t *) buf + sz_hdrmagic->sz;
         rsi = (uint8_t *) rsi + 64 * 4) {
#ifdef __MIC__
        __asm__ __volatile__
            ("movq %0, %%rsi;"
             "vprefetch0 0x00(%%rsi);"
             "vprefetch0 0x40(%%rsi);" "vprefetch0 0x80(%%rsi);" "vprefetch0 0xc0(%%rsi);"::"r"(rsi)
             :"%rsi");
#else
        __asm__ __volatile__
            ("movq %0, %%rsi;"
             "prefetchnta 0x00(%%rsi);"
             "prefetchnta 0x40(%%rsi);"
             "prefetchnta 0x80(%%rsi);" "prefetchnta 0xc0(%%rsi);"::"r"(rsi)
             :"%rsi");
#endif
    }
#endif

    MPIDI_CH3_Pkt_eager_send_t *pkt =
        (MPIDI_CH3_Pkt_eager_send_t *) ((uint8_t *) buf + sizeof(MPID_nem_ib_sz_hdrmagic_t));
    MPIU_Assert(sz_hdrmagic->sz >=
                sizeof(MPID_nem_ib_sz_hdrmagic_t) + sizeof(MPIDI_CH3_Pkt_t) +
                sizeof(MPID_nem_ib_tailmagic_t));
    MPIDI_CH3_Pkt_eager_send_t *pkt2 =
        (MPIDI_CH3_Pkt_eager_send_t *) ((uint8_t *) buf + sizeof(MPID_nem_ib_sz_hdrmagic_t) +
                                        sizeof(MPID_nem_ib_pkt_prefix_t));
    dprintf
        ("handle_pkt,before,%d<-%d,id=%d,pkt->type=%d,pcc=%d,MPIDI_NEM_PKT_END=%d,pkt=%p,subtype=%d\n",
         MPID_nem_ib_myrank, vc->pg_rank, vc_ib->ibcom->rsr_seq_num_poll, pkt->type,
         MPIDI_CH3I_progress_completion_count.v, MPIDI_NEM_PKT_END, pkt,
         ((MPID_nem_pkt_netmod_t *) pkt)->subtype);
    /* see MPIDI_CH3_PktHandler_EagerSend (in src/mpid/ch3/src/ch3u_eager.c) */
    mpi_errno =
        MPID_nem_handle_pkt(vc, (char *) ((uint8_t *) buf + sizeof(MPID_nem_ib_sz_hdrmagic_t)),
                            (MPIDI_msg_sz_t) (sz_hdrmagic->sz - sizeof(MPID_nem_ib_sz_hdrmagic_t) -
                                              sizeof(MPID_nem_ib_tailmagic_t)));
    if (mpi_errno) {
        MPIU_ERR_POP(mpi_errno);
    }
    //tsce = MPID_nem_ib_rdtsc(); printf("0,%ld\n", tsce - tscs); // 512-byte, 900 cyc (1100 w/o prefetch)

    /* Update occupation status of remote SR (send request) queue */
    /* this includes local RDMA-wr-to buf occupation
     * because MPID_nem_handle_pkt releases RDMA-wr-to buf by copying data out */
    /* responder releases resource and then embed largest sequence number into MPI message bound to initiator */
    //dprintf("after handle_pkt,rsr_seq_num_tail=%d\n", vc_ib->ibcom->rsr_seq_num_tail);
#if 1
    dprintf
        ("handle_pkt,after,%d<-%d,id=%d,pkt->type=%d,eagershort=%d,close=%d,rts=%d,piggy-backed-eagersend=%d\n",
         MPID_nem_ib_myrank, vc->pg_rank, vc_ib->ibcom->rsr_seq_num_poll, pkt->type,
         MPIDI_CH3_PKT_EAGERSHORT_SEND, MPIDI_CH3_PKT_CLOSE, MPIDI_NEM_PKT_LMT_RTS,
         MPIDI_NEM_IB_PKT_EAGER_SEND);

    int notify_rate;
    ibcom_errno =
        MPID_nem_ib_com_rdmabuf_occupancy_notify_rate_get(MPID_nem_ib_conns[vc->pg_rank].fd,
                                                          &notify_rate);
    dprintf("poll_eager,sendq=%d,ncom=%d,ncqe=%d,ldiff=%d(%d-%d),rdiff=%d(%d-%d),rate=%d\n",
            MPID_nem_ib_sendq_empty(vc_ib->sendq),
            vc_ib->ibcom->ncom < MPID_NEM_IB_COM_MAX_SQ_CAPACITY,
            MPID_nem_ib_ncqe < MPID_NEM_IB_COM_MAX_CQ_CAPACITY,
            MPID_nem_ib_diff32(vc_ib->ibcom->sseq_num, vc_ib->ibcom->lsr_seq_num_tail),
            vc_ib->ibcom->sseq_num, vc_ib->ibcom->lsr_seq_num_tail,
            MPID_nem_ib_diff32(vc_ib->ibcom->rsr_seq_num_tail,
                               vc_ib->ibcom->rsr_seq_num_tail_last_sent),
            vc_ib->ibcom->rsr_seq_num_tail, vc_ib->ibcom->rsr_seq_num_tail_last_sent, notify_rate);

    //dprintf("ib_poll,current pcc=%d\n", MPIDI_CH3I_progress_completion_count.v);

    /* Don't forget to put lmt-cookie types here!! */
    if (1) {
        /* lmt cookie messages or control message other than eager-short */

        /* eager-send with zero-length data is released here
         * because there is no way to trace the RDMA-write-to buffer addr
         * because rreq->dev.tmpbuf is set to zero in ch3_eager.c
         */
        dprintf("poll_eager,released,type=%d,MPIDI_NEM_IB_PKT_REPLY_SEQ_NUM=%d\n", pkt->type,
                MPIDI_NEM_IB_PKT_REPLY_SEQ_NUM);
        MPID_nem_ib_recv_buf_released(vc,
                                      (void *) ((uint8_t *) buf +
                                                sizeof(MPID_nem_ib_sz_hdrmagic_t) +
                                                sizeof(MPIDI_CH3_Pkt_t)));
    }
    else {
        if (sz_hdrmagic->sz ==
            sizeof(MPID_nem_ib_sz_hdrmagic_t) + sizeof(MPIDI_CH3_Pkt_t) +
            sizeof(MPID_nem_ib_tailmagic_t)) {
            if (pkt->type == MPIDI_CH3_PKT_EAGERSHORT_SEND
                //||                  pkt->type == MPIDI_CH3_PKT_GET
) {
            }
            else {
                printf("ib_poll,unknown pkt->type=%d\n", pkt->type);
                assert(0);
                MPIU_ERR_INTERNALANDJUMP(mpi_errno, "MPI header only but not released");
            }
        }
    }
#endif

    vc_ib->ibcom->rsr_seq_num_poll += 1;
    dprintf("ib_poll,inc,rsr_seq_num_poll=%d\n", vc_ib->ibcom->rsr_seq_num_poll);

  fn_exit:
    MPIDI_FUNC_EXIT(MPID_STATE_MPID_NEM_IB_POLL_EAGER);
    return mpi_errno;
  fn_fail:
    goto fn_exit;
}

#undef FUNCNAME
#define FUNCNAME MPID_nem_ib_poll
#undef FCNAME
#define FCNAME MPIDI_QUOTE(FUNCNAME)
int MPID_nem_ib_poll(int in_blocking_poll)
{

    int mpi_errno = MPI_SUCCESS;
    int ibcom_errno;
    uint32_t i;

    MPIDI_STATE_DECL(MPID_STATE_MPID_NEM_IB_POLL);
    MPIDI_FUNC_ENTER(MPID_STATE_MPID_NEM_IB_POLL);

#if 1
    unsigned int progress_completion_count_old = MPIDI_CH3I_progress_completion_count.v;
#endif

    /* poll lmt */
    /* when receiver side sends CTS to sender side
     * sender receives CTS and give up sending RTS
     * sender initiates RDMA-write,
     * sender sends RTS of the next epoch,
     * to detect the end of RDMA-write first and DP the entry for CTS,
     * you should perform lmt-poll first, next eager-poll
     */
    MPID_Request *rreq, *prev_rreq;
    rreq = MPID_nem_ib_lmtq_head(MPID_nem_ib_lmtq);
    if (rreq) {
#if defined (MPID_NEM_IB_TIMER_WAIT_IB_POLL)
        if (in_blocking_poll) {
            tsc[0] = MPI_rdtsc();
        }
#endif
        // dprintf("ib_poll,poll lmtq\n");
        prev_rreq = NULL;
        do {
            /* Obtain cookie. pkt_RTS_handler memcpy it (in mpid_nem_lmt.c) */
            /* MPID_IOV_BUF is macro, converted into iov_base (in src/include/mpiiov.h) */
            /* do not use s_cookie_buf because do_cts frees it */
            //MPID_nem_ib_lmt_cookie_t* s_cookie_buf = (MPID_nem_ib_lmt_cookie_t*)rreq->ch.lmt_tmp_cookie.iov_base;

            /* Wait for completion of DMA */
            /* do not use s_cookie_buf->sz because do_cts frees it */
            volatile void *write_to_buf;
            int is_contig;
            MPID_Datatype_is_contig(rreq->dev.datatype, &is_contig);
            if (is_contig) {
                write_to_buf =
                    (void *) ((char *) rreq->dev.user_buf /*+ REQ_FIELD(req, lmt_dt_true_lb) */);
            }
            else {
                write_to_buf = REQ_FIELD(rreq, lmt_pack_buf);
            }

            //assert(REQ_FIELD(rreq, lmt_dt_true_lb) == 0);
            volatile uint8_t *tailmagic =
                (uint8_t *) ((uint8_t *) write_to_buf /*+ REQ_FIELD(rreq, lmt_dt_true_lb) */  +
                             rreq->ch.lmt_data_sz - sizeof(uint8_t));

            uint8_t lmt_tail = REQ_FIELD(rreq, lmt_tail);
            if (*tailmagic != REQ_FIELD(rreq, lmt_tail)) {
                goto next;
            }
            dprintf("ib_poll,sz=%ld,old tail=%02x,new tail=%02x\n", rreq->ch.lmt_data_sz,
                    REQ_FIELD(rreq, lmt_tail), *tailmagic);

            dprintf
                ("ib_poll,lmt found,%d<-%d,req=%p,ref_count=%d,is_contig=%d,write_to_buf=%p,lmt_pack_buf=%p,user_buf=%p,tail=%p\n",
                 MPID_nem_ib_myrank, rreq->ch.vc->pg_rank, rreq, rreq->ref_count, is_contig,
                 write_to_buf, REQ_FIELD(rreq, lmt_pack_buf), rreq->dev.user_buf, tailmagic);

            /* unpack non-contiguous dt */
            if (!is_contig) {
                dprintf("ib_poll,copying noncontiguous data to user buffer\n");

                /* see MPIDI_CH3U_Request_unpack_uebuf (in /src/mpid/ch3/src/ch3u_request.c) */
                /* or MPIDI_CH3U_Receive_data_found (in src/mpid/ch3/src/ch3u_handle_recv_pkt.c) */
                MPIDI_msg_sz_t unpack_sz = rreq->ch.lmt_data_sz;
                MPID_Segment seg;
                MPI_Aint last;

                MPID_Segment_init(rreq->dev.user_buf, rreq->dev.user_count, rreq->dev.datatype,
                                  &seg, 0);
                last = unpack_sz;
                MPID_Segment_unpack(&seg, 0, &last, REQ_FIELD(rreq, lmt_pack_buf));
                if (last != unpack_sz) {
                    /* --BEGIN ERROR HANDLING-- */
                    /* received data was not entirely consumed by unpack()
                     * because too few bytes remained to fill the next basic
                     * datatype */
                    MPIR_STATUS_SET_COUNT(rreq->status, last);
                    rreq->status.MPI_ERROR =
                        MPIR_Err_create_code(MPI_SUCCESS, MPIR_ERR_RECOVERABLE, FCNAME, __LINE__,
                                             MPI_ERR_TYPE, "**MPID_nem_ib_poll", 0);
                    /* --END ERROR HANDLING-- */
                }
#if 1   /* debug, enable again later, polling waits forever when freeing it here. */
                //if (rreq->ref_count == 1) {
                dprintf("ib_poll,lmt,ref_count=%d,lmt_pack_buf=%p\n", rreq->ref_count,
                        REQ_FIELD(rreq, lmt_pack_buf));
                //MPIU_Free(REQ_FIELD(rreq, lmt_pack_buf));
                MPID_nem_ib_stfree(REQ_FIELD(rreq, lmt_pack_buf), (size_t) rreq->ch.lmt_data_sz);
                //} else {
                // dprintf("ib_poll,lmt,ref_count=%d,lmt_pack_buf=%p\n", rreq->ref_count, REQ_FIELD(rreq, lmt_pack_buf));
                //}
#endif
            }

            /* send done to sender. vc is stashed in MPID_nem_ib_lmt_start_recv (in ib_lmt.c) */
            MPID_nem_ib_vc_area *vc_ib = VC_IB(rreq->ch.vc);
            dprintf("ib_poll,GET,lmt_send_GET_DONE,rsr_seq_num_tail=%d\n",
                    vc_ib->ibcom->rsr_seq_num_tail);
            MPID_nem_ib_lmt_send_GET_DONE(rreq->ch.vc, rreq);
            dprintf("ib_poll,prev_rreq=%p,rreq->lmt_next=%p\n", prev_rreq,
                    MPID_nem_ib_lmtq_next(rreq));

            /* unlink rreq */
            if (prev_rreq != NULL) {
                MPID_nem_ib_lmtq_next(prev_rreq) = MPID_nem_ib_lmtq_next(rreq);
            }
            else {
                MPID_nem_ib_lmtq_head(MPID_nem_ib_lmtq) = MPID_nem_ib_lmtq_next(rreq);
            }
            if (MPID_nem_ib_lmtq_next(rreq) == NULL) {
                MPID_nem_ib_lmtq.tail = prev_rreq;
            }

            /* save rreq->dev.next (and rreq) because decrementing reference-counter might free rreq */
            MPID_Request *tmp_rreq = rreq;
            rreq = MPID_nem_ib_lmtq_next(rreq);

            /* decrement completion-counter */
            dprintf("ib_poll,%d<-%d,", MPID_nem_ib_myrank, tmp_rreq->ch.vc->pg_rank);
            int incomplete;
            MPIDI_CH3U_Request_decrement_cc(tmp_rreq, &incomplete);
            dprintf("lmt,complete,tmp_rreq=%p,rreq->ref_count=%d,comm=%p\n", tmp_rreq,
                    tmp_rreq->ref_count, tmp_rreq->comm);

            if (!incomplete) {
                MPIDI_CH3_Progress_signal_completion();
            }

            /* lmt_start_recv increments ref_count
             * drain_scq and ib_poll is not ordered, so both can decrement ref_count */
            /* ref_count is decremented
             * get-lmt: ib_poll, drain_scq, wait
             * put-lmt: ib_poll, wait */
            MPID_Request_release(tmp_rreq);
            dprintf("ib_poll,lmt,after release,tmp_rreq=%p,rreq->ref_count=%d,comm=%p\n",
                    tmp_rreq, tmp_rreq->ref_count, tmp_rreq->comm);


            goto next_unlinked;
          next:
            prev_rreq = rreq;
            rreq = MPID_nem_ib_lmtq_next(rreq);
          next_unlinked:;
        } while (rreq);
#if defined (MPID_NEM_IB_TIMER_WAIT_IB_POLL)
        if (in_blocking_poll) {
            stsc[0] += MPI_rdtsc() - tsc[0];
        }
#endif
    }

#if defined (MPID_NEM_IB_TIMER_WAIT_IB_POLL)
    if (in_blocking_poll) {
        tsc[1] = MPI_rdtsc();
    }
#endif
    int ncom_almost_full = 0;
    for (i = 0; i < MPID_nem_ib_npollingset; i++) {
        //tscs = MPID_nem_ib_rdtsc();
        MPIDI_VC_t *vc = MPID_nem_ib_pollingset[i];
        mpi_errno = MPID_nem_ib_poll_eager(vc);
        if (mpi_errno) {
            MPIU_ERR_POP(mpi_errno);
        }

        MPID_nem_ib_vc_area *vc_ib = VC_IB(vc);

        /* without this, command in sendq doesn't have a chance
         * to perform send_progress
         * when send and progress_send call drain_scq but asking it
         * for not performing send_progress and make the CQ empty */
        MPID_nem_ib_send_progress(vc_ib);

        ncom_almost_full |= (vc_ib->ibcom->ncom >= MPID_NEM_IB_COM_MAX_SQ_HEIGHT_DRAIN);

#if 0
        /* aggressively perform drain_scq */
        ncom_almost_full |= !(MPID_nem_ib_sendq_empty(vc_ib->sendq));
#endif
    }
#if defined (MPID_NEM_IB_TIMER_WAIT_IB_POLL)
    if (in_blocking_poll) {
        stsc[1] += MPI_rdtsc() - tsc[1];
    }
#endif

    // lazy feching of completion queue entry because it causes cache-miss
#if defined (MPID_NEM_IB_LMT_GET_CQE)
    if (MPID_nem_ib_ncqe_to_drain > 0 || MPID_nem_ib_ncqe_nces > 0 ||
        MPID_nem_ib_ncqe >= MPID_NEM_IB_COM_MAX_CQ_HEIGHT_DRAIN || ncom_almost_full)
#endif
#if !defined (MPID_NEM_IB_LMT_GET_CQE)
        if (/*(in_blocking_poll && result == 0) || */ MPID_nem_ib_ncqe_nces > 0 ||
            MPID_nem_ib_ncqe >= MPID_NEM_IB_COM_MAX_CQ_HEIGHT_DRAIN || ncom_almost_full)
#endif
        {
#if defined (MPID_NEM_IB_TIMER_WAIT_IB_POLL)
            if (in_blocking_poll) {
                tsc[0] = MPI_rdtsc();
            }
#endif
            //dprintf("ib_poll,calling drain_scq\n");
            ibcom_errno = MPID_nem_ib_drain_scq(0);
            MPIU_ERR_CHKANDJUMP(ibcom_errno, mpi_errno, MPI_ERR_OTHER, "**MPID_nem_ib_drain_scq");
#if defined (MPID_NEM_IB_TIMER_WAIT_IB_POLL)
            if (in_blocking_poll) {
                stsc[0] += MPI_rdtsc() - tsc[0];
            }
#endif
        }
#if 1
    /* aggressively perform drain_scq */
    ibcom_errno = MPID_nem_ib_drain_scq(0);
    MPIU_ERR_CHKANDJUMP(ibcom_errno, mpi_errno, MPI_ERR_OTHER, "**MPID_nem_ib_drain_scq");
#endif
    /* detect completion of lmt-put when MPI_Wait kicks ib_poll */
    if (MPID_nem_ib_ncqe_lmt_put > 0) {
        ibcom_errno = MPID_nem_ib_drain_scq_lmt_put();
        MPIU_ERR_CHKANDJUMP(ibcom_errno, mpi_errno, MPI_ERR_OTHER,
                            "**MPID_nem_ib_drain_scq_lmt_put");
    }

#ifdef MPID_NEM_IB_ONDEMAND
    /* process incoming connection request */
    MPID_nem_ib_cm_accept();

    /* process outgoing conncetion request */
    if (MPID_nem_ib_ncqe_connect >= MPID_NEM_IB_COM_MAX_CQ_HEIGHT_DRAIN) {
        ibcom_errno = MPID_nem_ib_cm_drain_scq(0);
        MPIU_ERR_CHKANDJUMP(ibcom_errno, mpi_errno, MPI_ERR_OTHER, "**MPID_nem_ib_cm_drain_scq");
    }
#endif

#if 1
    /* if polling on eager-send and lmt would repeat frequently, perform "pause" to yield instruction issue bandwitdh to other logical-core */
    if (in_blocking_poll && progress_completion_count_old == MPIDI_CH3I_progress_completion_count.v) {
        __asm__ __volatile__("pause;":::"memory");
    }
#endif
    //if (in_blocking_poll) { goto prev; }

  fn_exit:
    MPIDI_FUNC_EXIT(MPID_STATE_MPID_NEM_IB_POLL);
    return mpi_errno;
  fn_fail:
    goto fn_exit;
}

   /* new rreq is obtained in MPID_Irecv in mpid_irecv.c,
    * so we associate rreq with a receive request and ibv_post_recv it
    * so that we can obtain rreq by ibv_poll_cq
    */
#undef FUNCNAME
#define FUNCNAME MPID_nem_ib_recv_posted
#undef FCNAME
#define FCNAME MPIDI_QUOTE(FUNCNAME)
int MPID_nem_ib_recv_posted(struct MPIDI_VC *vc, struct MPID_Request *req)
{

    int mpi_errno = MPI_SUCCESS;
    MPID_nem_ib_vc_area *vc_ib = VC_IB(vc);

    MPIDI_STATE_DECL(MPID_STATE_MPID_NEM_IB_RECV_POSTED);
    MPIDI_FUNC_ENTER(MPID_STATE_MPID_NEM_IB_RECV_POSTED);
    dprintf("recv_posted,enter,%d->%d,req=%p\n", MPID_nem_ib_myrank, vc->pg_rank, req);

#if 0
    int ibcom_errno;
    ibcom_errno = MPID_nem_ib_com_irecv(vc_ib->sc->fd, (uint64_t) vc->pg_rank);
    MPIU_ERR_CHKANDJUMP(ibcom_errno, mpi_errno, MPI_ERR_OTHER, "**MPID_nem_ib_com_irecv");
#endif

#if 1   /*takagi */
    MPIDI_msg_sz_t data_sz;
    int dt_contig;
    MPI_Aint dt_true_lb;
    MPID_Datatype *dt_ptr;
    MPIDI_Datatype_get_info(req->dev.user_count, req->dev.datatype, dt_contig, data_sz, dt_ptr,
                            dt_true_lb);

    /* poll when rreq is for lmt */
    /* anticipating received message finds maching request in the posted-queue */
    if (data_sz + sizeof(MPIDI_CH3_Pkt_eager_send_t) > vc->eager_max_msg_sz) {
        //if (MPID_nem_ib_tsc_poll - MPID_nem_ib_rdtsc() > MPID_NEM_IB_POLL_PERIOD_RECV_POSTED) {
#if 1
        mpi_errno = MPID_nem_ib_poll_eager(vc);
#else
        mpi_errno = MPID_nem_ib_poll(0);
#endif
        if (mpi_errno) {
            MPIU_ERR_POP(mpi_errno);
        }
        //}
    }
    else {
#if 1
        /* anticipating received message finds maching request in the posted-queue */
        //if (MPID_nem_ib_tsc_poll - MPID_nem_ib_rdtsc() > MPID_NEM_IB_POLL_PERIOD_RECV_POSTED) {
#if 1
        mpi_errno = MPID_nem_ib_poll_eager(vc);
#else
        mpi_errno = MPID_nem_ib_poll(0);
#endif
        if (mpi_errno) {
            MPIU_ERR_POP(mpi_errno);
        }
        //}
#endif
    }
#endif

  fn_exit:
    MPIDI_FUNC_EXIT(MPID_STATE_MPID_NEM_IB_RECV_POSTED);
    return mpi_errno;
  fn_fail:
    goto fn_exit;
}

/* (1) packet-handler memcpy RDMA-write-to buf data to MPI user-buffer when matching request is found in posted-queue
   (2) MPI_Irecv memcpy RDMA-write-to buf data to MPI user-buffer when matching request is found in unexpected-queue
   the latter case can't be dealt with when call this after poll-found and packet-handler
   (packet-handler memcpy RDMA-write-to buf to another buffer when
   matching request is not found in posted-queue, so calling this after poll-found and packet-handler
   suffices in original MPICH implementation)
*/
#undef FUNCNAME
#define FUNCNAME MPID_nem_ib_recv_buf_released
#undef FCNAME
#define FCNAME MPIDI_QUOTE(FUNCNAME)
int MPID_nem_ib_recv_buf_released(struct MPIDI_VC *vc, void *user_data)
{
    int mpi_errno = MPI_SUCCESS;
    int ibcom_errno;
    MPID_nem_ib_vc_area *vc_ib = VC_IB(vc);

    MPIDI_STATE_DECL(MPID_STATE_MPID_NEM_IB_RECV_BUF_RELEASED);
    MPIDI_FUNC_ENTER(MPID_STATE_MPID_NEM_IB_RECV_BUF_RELEASED);
    dprintf("recv_buf_released,%d<-%d,user_data=%p\n", MPID_nem_ib_myrank, vc->pg_rank, user_data);
#if 1   /* moving from ib_poll */
    /* unmark magic */
    /* magic is located at MPID_NEM_IB_COM_INLINE_DATA boundary and variable length entails multiple prospective locations for the future use */

    /* see MPIDI_CH3_PktHandler_EagerShortSend (in src/mpid/ch3/src/ch3u_eager.c */
    /* eager-send with zero-length data is released in poll
     * because there is no way to trace the RDMA-write-to buffer addr
     * because rreq->dev.tmpbuf is set to zero in ch3_eager.c
     */
    if (user_data == NULL) {
        goto fn_exit;
    }

    MPIU_Assert((uint8_t *) vc_ib->ibcom->icom_mem[MPID_NEM_IB_COM_RDMAWR_TO] <=
                (uint8_t *) user_data &&
                (uint8_t *) user_data <
                (uint8_t *) vc_ib->ibcom->icom_mem[MPID_NEM_IB_COM_RDMAWR_TO] +
                MPID_NEM_IB_COM_RDMABUF_SZ);
    unsigned long mod =
        (unsigned long) ((uint8_t *) user_data -
                         (uint8_t *) vc_ib->ibcom->
                         icom_mem[MPID_NEM_IB_COM_RDMAWR_TO]) & (MPID_NEM_IB_COM_RDMABUF_SZSEG - 1);

    void *buf = (void *) ((uint8_t *) user_data - mod);
    //dprintf("recv_buf_released,clearing,buf=%p\n", buf);
    MPID_nem_ib_sz_hdrmagic_t *sz_hdrmagic = (MPID_nem_ib_sz_hdrmagic_t *) buf;

    int sz_data_pow2;
    MPID_NEM_IB_SZ_DATA_POW2(sz_hdrmagic->sz);
    //dprintf("recv_buf_released,sz=%d,pow2=%d\n", sz_hdrmagic->sz, sz_data_pow2);
#if 1
    uint32_t offset;
    for (offset = 0;;
         offset =
         offset ? ((((offset + 1) << 1) - 1) >
                   MPID_NEM_IB_MAX_DATA_POW2 ? MPID_NEM_IB_MAX_DATA_POW2 : (((offset + 1) << 1) -
                                                                            1)) : 15) {
        volatile MPID_nem_ib_tailmagic_t *ptr =
            (MPID_nem_ib_tailmagic_t *) ((uint8_t *) buf + offset);
        MPIU_Assert((uint8_t *) vc_ib->ibcom->icom_mem[MPID_NEM_IB_COM_RDMAWR_TO] <=
                    (uint8_t *) ptr &&
                    (uint8_t *) ptr <
                    (uint8_t *) vc_ib->ibcom->icom_mem[MPID_NEM_IB_COM_RDMAWR_TO] +
                    MPID_NEM_IB_COM_RDMABUF_SZ);
        ptr->magic = 0 /*0xde */ ;
        if (offset == sz_data_pow2) {
            break;
        }
    }
#endif
#endif

#if 1   /* moving from ib_poll */
    /* mark that one eager-send RDMA-write-to buffer has been released */
    int index_slot =
        (unsigned long) ((uint8_t *) user_data -
                         (uint8_t *) vc_ib->ibcom->icom_mem[MPID_NEM_IB_COM_RDMAWR_TO]) /
        MPID_NEM_IB_COM_RDMABUF_SZSEG;
    MPIU_Assert(0 <= index_slot && index_slot < MPID_NEM_IB_COM_RDMABUF_NSEG);
    //dprintf("user_data=%p,mem=%p,sub=%08lx,index_slot=%d\n", user_data, vc_ib->ibcom->icom_mem[MPID_NEM_IB_COM_RDMAWR_TO], (unsigned long)user_data - (unsigned long)vc_ib->ibcom->icom_mem[MPID_NEM_IB_COM_RDMAWR_TO], index_slot);
    //dprintf("index_slot=%d,released=%016lx\n", index_slot, vc_ib->ibcom->rsr_seq_num_released[index_slot / 64]);
    vc_ib->ibcom->rsr_seq_num_released[index_slot / 64] |= (1ULL << (index_slot & 63));
    //dprintf("released[index_slot/64]=%016lx\n", vc_ib->ibcom->rsr_seq_num_released[index_slot / 64]);
    //    int index_tail = (vc_ib->ibcom->rsr_seq_num_tail + 1) & (MPID_NEM_IB_COM_RDMABUF_NSEG-1);
    int index_tail = (vc_ib->ibcom->rsr_seq_num_tail + 1) % MPID_NEM_IB_COM_RDMABUF_NSEG;
    //dprintf("tail+1=%d,index_tail=%d\n", vc_ib->ibcom->rsr_seq_num_tail + 1, index_tail);
    //dprintf("released=%016lx\n", vc_ib->ibcom->rsr_seq_num_released[index_tail / 64]);
    if (1 || (index_tail & 7) || MPID_nem_ib_diff32(index_slot, index_tail) >= MPID_NEM_IB_COM_RDMABUF_NSEG - 8) {      /* avoid wrap-around */
        while (1) {
            if (((vc_ib->ibcom->rsr_seq_num_released[index_tail / 64] >> (index_tail & 63)) & 1) ==
                1) {
                vc_ib->ibcom->rsr_seq_num_tail += 1;
                vc_ib->ibcom->rsr_seq_num_released[index_tail / 64] &= ~(1ULL << (index_tail & 63));
                dprintf("rsr_seq_num_tail,incremented to %d\n", vc_ib->ibcom->rsr_seq_num_tail);
            }
            else {
                break;
            }
        }
    }
    else {
        if (((vc_ib->ibcom->rsr_seq_num_released[index_tail / 64] >> (index_tail & 63)) & 0xff) ==
            0xff) {
            vc_ib->ibcom->rsr_seq_num_tail += 8;
            vc_ib->ibcom->rsr_seq_num_released[index_tail / 64] &= ~(0xffULL << (index_tail & 63));
            //dprintf("released[index_tail/64]=%016lx\n", vc_ib->ibcom->rsr_seq_num_released[index_tail / 64]);
        }
    }

    //dprintf("recv_buf_released,%d->%d,rsr_seq_num_tail=%d,rsr_seq_num_tail_last_sent=%d\n", MPID_nem_ib_myrank, vc->pg_rank, vc_ib->ibcom->rsr_seq_num_tail, vc_ib->ibcom->rsr_seq_num_tail_last_sent);

    int notify_rate;
    ibcom_errno =
        MPID_nem_ib_com_rdmabuf_occupancy_notify_rate_get(MPID_nem_ib_conns[vc->pg_rank].fd,
                                                          &notify_rate);
    MPIU_ERR_CHKANDJUMP(ibcom_errno, mpi_errno, MPI_ERR_OTHER,
                        "**MPID_nem_ib_com_rdmabuf_occupancy_notify_rate_get");

    /* if you missed the chance to make eager-send message piggy-back it */
    if (MPID_nem_ib_diff32
        (vc_ib->ibcom->rsr_seq_num_tail,
         vc_ib->ibcom->rsr_seq_num_tail_last_sent) >
        MPID_NEM_IB_COM_RDMABUF_OCCUPANCY_NOTIFY_RATE_DELAY_MULTIPLIER(notify_rate)
        //|| MPID_nem_ib_diff32(lsr_seq_num_head, vc_ib->ibcom->lsr_seq_num_tail_last_sent) == MPID_NEM_IB_COM_RDMABUF_NSEG
) {
        MPID_Request *sreq;
        sreq = MPID_nem_ib_sendq_head(vc_ib->sendq);
        if (sreq) {
            int msg_type = MPIDI_Request_get_msg_type(sreq);
            if (msg_type == MPIDI_REQUEST_EAGER_MSG &&  /* guard for the following pointer dereference */
                ((MPIDI_CH3_Pkt_t *) sreq->dev.iov[0].MPID_IOV_BUF)->type == MPIDI_NEM_PKT_NETMOD &&
                ((MPID_nem_pkt_netmod_t *) sreq->dev.iov[0].MPID_IOV_BUF)->subtype ==
                MPIDI_NEM_IB_PKT_REPLY_SEQ_NUM) {
                goto skip;
            }
        }
        //printf("recv_buf_released,sending reply_seq_num,diff=%d,rate=%d,id=%d\n", MPID_nem_ib_diff32(vc_ib->ibcom->rsr_seq_num_tail, vc_ib->ibcom->rsr_seq_num_tail_last_sent), notify_rate + (notify_rate>>1), vc_ib->ibcom->sseq_num);
        MPID_nem_ib_send_reply_seq_num(vc);
      skip:;
    }
#endif

  fn_exit:
    MPIDI_FUNC_EXIT(MPID_STATE_MPID_NEM_IB_RECV_BUF_RELEASED);
    return mpi_errno;
  fn_fail:
    goto fn_exit;
}

#if 0
/* packet handler for wrapper packet of MPIDI_NEM_PKT_LMT_DONE */
/* see pkt_DONE_handler (in src/mpid/ch3/channels/nemesis/src/mpid_nem_lmt.c) */
#undef FUNCNAME
#define FUNCNAME MPID_nem_ib_PktHandler_lmt_done
#undef FCNAME
#define FCNAME MPIDI_QUOTE(FUNCNAME)
int MPID_nem_ib_PktHandler_lmt_done(MPIDI_VC_t * vc, MPIDI_CH3_Pkt_t * pkt,
                                    MPIDI_msg_sz_t * buflen, MPID_Request ** rreqp)
{
    int mpi_errno = MPI_SUCCESS;
    int ibcom_errno;
    MPID_nem_ib_pkt_lmt_done_t *const done_pkt = (MPID_nem_ib_pkt_lmt_done_t *) pkt;
    MPID_Request *req;
    MPIDI_STATE_DECL(MPID_STATE_MPID_NEM_IB_PKTHANDLER_LMT_DONE);
    MPIDI_FUNC_ENTER(MPID_STATE_MPID_NEM_IB_PKTHANDLER_LMT_DONE);

    /* Check the assumption on sizeof(MPIDI_CH3_Pkt_t).
     * It is utilized in pkt_DONE_handler (in src/mpid/ch3/channels/nemesis/src/mpid_nem_lmt.c)
     * that must be larger than sizeof(MPID_nem_ib_pkt_lmt_done_t) */
    if (sizeof(MPID_nem_ib_pkt_lmt_done_t) > sizeof(MPIDI_CH3_Pkt_t)) {
        MPIU_ERR_SETFATALANDJUMP(mpi_errno, MPI_ERR_INTERN, "**sizeof(MPIDI_CH3_Pkt_t)");
    }

    /* fall back to the original handler */
    /* we don't need to worry about the difference caused by embedding seq_num
     * because the handler does not use it (e.g. applying sizeof operator to it) */
    MPID_nem_pkt_lmt_done_t *pkt_parent_class = (MPID_nem_pkt_lmt_done_t *) pkt;
    pkt_parent_class->type = MPIDI_NEM_PKT_LMT_DONE;
#if 0
    mpi_errno = MPID_nem_handle_pkt(vc, (char *) pkt_parent_class, *buflen);
#else
    MPIU_ERR_CHKANDJUMP(1, mpi_errno, MPI_ERR_OTHER, "**notimplemented");
    /* you need to modify mpid_nem_lmt.c to make pkt_DONE_handler visible to me */
    //mpi_errno = pkt_DONE_handler(vc, pkt, buflen, rreqp);
#endif
    if (mpi_errno) {
        MPIU_ERR_POP(mpi_errno);
    }

  fn_exit:
    MPIDI_FUNC_EXIT(MPID_STATE_MPID_NEM_IB_PKTHANDLER_LMT_DONE);
    return mpi_errno;
  fn_fail:
    goto fn_exit;
}
#endif

/* packet handler for wrapper packet of MPIDI_CH3_PKT_EAGER_SEND */
/* see MPIDI_CH3_PktHandler_EagerSend (in src/mpid/ch3/src/ch3u_eager.c) */
#undef FUNCNAME
#define FUNCNAME MPID_nem_ib_PktHandler_EagerSend
#undef FCNAME
#define FCNAME MPIDI_QUOTE(FUNCNAME)
int MPID_nem_ib_PktHandler_EagerSend(MPIDI_VC_t * vc, MPIDI_CH3_Pkt_t * pkt,
                                     MPIDI_msg_sz_t * buflen /* out */ ,
                                     MPID_Request ** rreqp /* out */)
{
    MPID_nem_ib_pkt_prefix_t *netmod_pkt = (MPID_nem_ib_pkt_prefix_t *) pkt;
    MPIDI_CH3_Pkt_eager_send_t *ch3_pkt =
        (MPIDI_CH3_Pkt_eager_send_t *) ((uint8_t *) pkt + sizeof(MPID_nem_ib_pkt_prefix_t));
    MPID_Request *rreq;
    int found;
    int complete;
    char *data_buf;
    MPIDI_msg_sz_t data_len;
    int mpi_errno = MPI_SUCCESS;
    int ibcom_errno;

    MPIDI_STATE_DECL(MPID_STATE_MPID_NEM_IB_PKTHANDLER_EAGERSEND);
    MPIDI_FUNC_ENTER(MPID_STATE_MPID_NEM_IB_PKTHANDLER_EAGERSEND);

    dprintf("ib_pkthandler_eagersend,tag=%d\n", ch3_pkt->match.parts.tag);

    /* Check the assumption on sizeof(MPIDI_CH3_Pkt_t).
     * It is utilized to point the payload location in MPIDI_CH3_PktHandler_EagerSend
     * (src/mpid/ch3/src/ch3u_eager.c) that must be larger than sizeof(MPID_nem_ib_pkt_eager_send_t) */
    //if (sizeof(MPID_nem_ib_pkt_eager_send_t) > sizeof(MPIDI_CH3_Pkt_t)) {
    //MPIU_ERR_SETFATALANDJUMP(mpi_errno, MPI_ERR_INTERN, "**sizeof(MPIDI_CH3_Pkt_t)");
    //}

    /* Update occupation status of local SR (send request) queue */
    int *lsr_seq_num_tail;
    MPID_nem_ib_vc_area *vc_ib = VC_IB(vc);
    ibcom_errno = MPID_nem_ib_com_lsr_seq_num_tail_get(vc_ib->sc->fd, &lsr_seq_num_tail);
    MPIU_ERR_CHKANDJUMP(ibcom_errno, mpi_errno, MPI_ERR_OTHER,
                        "**MPID_nem_ib_com_lsr_seq_num_tail_get");
    dprintf("MPID_nem_ib_PktHandler_EagerSend,lsr_seq_num_tail=%d,netmod_pkt->seq_num_tail=%d\n",
            *lsr_seq_num_tail, netmod_pkt->seq_num_tail);
    *lsr_seq_num_tail = MPID_NEM_IB_MAX(*lsr_seq_num_tail, netmod_pkt->seq_num_tail);
    dprintf("MPID_nem_ib_PktHandler_EagerSend,lsr_seq_num_tail updated to %d\n", *lsr_seq_num_tail);

#ifndef MPID_NEM_IB_DISABLE_VAR_OCC_NOTIFY_RATE
    /* change remote notification policy of RDMA-write-to buf */
    dprintf("pkthandler,eagersend,old rstate=%d\n", vc_ib->ibcom->rdmabuf_occupancy_notify_rstate);
    MPID_nem_ib_change_rdmabuf_occupancy_notify_policy_lw(vc_ib, lsr_seq_num_tail);
    dprintf("pkthandler,eagersend,new rstate=%d\n", vc_ib->ibcom->rdmabuf_occupancy_notify_rstate);
#endif

    dprintf("pkthandler,eagersend,sendq_empty=%d,ncom=%d,rdmabuf_occ=%d\n",
            MPID_nem_ib_sendq_empty(vc_ib->sendq), vc_ib->ibcom->ncom,
            MPID_nem_ib_diff32(vc_ib->ibcom->sseq_num, vc_ib->ibcom->lsr_seq_num_tail));
    /* try to send from sendq because at least one RDMA-write-to buffer has been released */
    /* calling drain_scq from progress_send derpives of chance
     * for ib_poll to drain sendq using ncqe
     * however transfers events to
     * (not to reply_seq_num because it's regulated by the rate)
     * fire on ib_poll using nces (e.g. MPI_Put) so we need to perform
     * progress_send for all of VCs using nces in ib_poll. */
    dprintf("pkthandler,eagersend,send_progress\n");
    fflush(stdout);
    MPID_NEM_IB_CHECK_AND_SEND_PROGRESS
        /* fall back to the original handler */
        /* we don't need to worry about the difference caused by embedding seq_num
         * because size of MPI-header of MPIDI_CH3_PKT_EAGER_SEND equals to sizeof(MPIDI_CH3_Pkt_t)
         * see MPID_nem_ib_iSendContig
         */
        //ch3_pkt->type = MPIDI_CH3_PKT_EAGER_SEND;
#if 0
        mpi_errno = MPID_nem_handle_pkt(vc, (char *) pkt_parent_class, *buflen);
#else
        dprintf("ib_poll.c,before PktHandler_EagerSend,buflen=%ld\n", *buflen);
    MPIDI_msg_sz_t ch3_buflen = *buflen - sizeof(MPID_nem_ib_pkt_prefix_t);
    mpi_errno = MPIDI_CH3_PktHandler_EagerSend(vc, (MPIDI_CH3_Pkt_t *) ch3_pkt, &ch3_buflen, rreqp);
    dprintf("ib_poll.c,after PktHandler_EagerSend,buflen=%ld\n", ch3_buflen);
    *buflen = ch3_buflen + sizeof(MPID_nem_ib_pkt_prefix_t);
    dprintf("ib_poll.c,after addition,buflen=%ld\n", *buflen);
#endif
    if (mpi_errno) {
        MPIU_ERR_POP(mpi_errno);
    }

  fn_exit:
    MPIDI_FUNC_EXIT(MPID_STATE_MPID_NEM_IB_PKTHANDLER_EAGERSEND);
    return mpi_errno;
  fn_fail:
    goto fn_exit;
}

#if 1
/* packet handler for wrapper packet of MPIDI_CH3_PKT_PUT */
/* see MPIDI_CH3_PktHandler_EagerSend (in src/mpid/ch3/src/ch3u_rma_sync.c) */
#undef FUNCNAME
#define FUNCNAME MPID_nem_ib_PktHandler_Put
#undef FCNAME
#define FCNAME MPIDI_QUOTE(FUNCNAME)
int MPID_nem_ib_PktHandler_Put(MPIDI_VC_t * vc, MPIDI_CH3_Pkt_t * pkt,
                               MPIDI_msg_sz_t * buflen /* out */ ,
                               MPID_Request ** rreqp /* out */)
{
    MPID_nem_ib_pkt_prefix_t *netmod_pkt = (MPID_nem_ib_pkt_prefix_t *) pkt;
    MPIDI_CH3_Pkt_put_t *ch3_pkt =
        (MPIDI_CH3_Pkt_put_t *) ((uint8_t *) pkt + sizeof(MPID_nem_ib_pkt_prefix_t));
    MPID_Request *rreq;
    int found;
    int complete;
    char *data_buf;
    MPIDI_msg_sz_t data_len;
    int mpi_errno = MPI_SUCCESS;
    int ibcom_errno;

    MPIDI_STATE_DECL(MPID_STATE_MPID_NEM_IB_PKTHANDLER_PUT);
    MPIDI_FUNC_ENTER(MPID_STATE_MPID_NEM_IB_PKTHANDLER_PUT);

    /* Update occupation status of local SR (send request) queue */
    MPID_nem_ib_vc_area *vc_ib = VC_IB(vc);
    dprintf("MPID_nem_ib_Pkthandler_Put,lsr_seq_num_tail=%d,put_pkt->seq_num_tail=%d\n",
            vc_ib->ibcom->lsr_seq_num_tail, netmod_pkt->seq_num_tail);
    vc_ib->ibcom->lsr_seq_num_tail =
        MPID_NEM_IB_MAX(vc_ib->ibcom->lsr_seq_num_tail, netmod_pkt->seq_num_tail);
    dprintf("MPID_nem_ib_Pkthandler_Put,lsr_seq_num_tail updated to %d\n",
            vc_ib->ibcom->lsr_seq_num_tail);

#ifndef MPID_NEM_IB_DISABLE_VAR_OCC_NOTIFY_RATE
    /* change remote notification policy of RDMA-write-to buf */
    dprintf("pkthandler,put,old rstate=%d\n", vc_ib->ibcom->rdmabuf_occupancy_notify_rstate);
    MPID_nem_ib_change_rdmabuf_occupancy_notify_policy_lw(vc_ib, &vc_ib->ibcom->lsr_seq_num_tail);
    dprintf("pkthandler,put,new rstate=%d\n", vc_ib->ibcom->rdmabuf_occupancy_notify_rstate);
#endif
    dprintf("pkthandler,put,sendq_empty=%d,ncom=%d,rdmabuf_occ=%d\n",
            MPID_nem_ib_sendq_empty(vc_ib->sendq), vc_ib->ibcom->ncom,
            MPID_nem_ib_diff32(vc_ib->ibcom->sseq_num, vc_ib->ibcom->lsr_seq_num_tail));
    /* try to send from sendq because at least one RDMA-write-to buffer has been released */
    dprintf("pkthandler,put,send_progress\n");
    fflush(stdout);
    MPID_NEM_IB_CHECK_AND_SEND_PROGRESS;

    /* fall back to the original handler */
    /* we don't need to worry about the difference caused by embedding seq_num
     * because size of MPI-header of MPIDI_CH3_PKT_PUT equals to sizeof(MPIDI_CH3_Pkt_t)
     * see MPID_nem_ib_iSendContig
     */
    MPIDI_msg_sz_t ch3_buflen = *buflen - sizeof(MPID_nem_ib_pkt_prefix_t);
    mpi_errno = MPIDI_CH3_PktHandler_Put(vc, (MPIDI_CH3_Pkt_t *) ch3_pkt, &ch3_buflen, rreqp);
    *buflen = ch3_buflen + sizeof(MPID_nem_ib_pkt_prefix_t);
    if (mpi_errno) {
        MPIU_ERR_POP(mpi_errno);
    }

  fn_exit:
    MPIDI_FUNC_EXIT(MPID_STATE_MPID_NEM_IB_PKTHANDLER_PUT);
    return mpi_errno;
  fn_fail:
    goto fn_exit;
}
#endif

/* packet handler for wrapper packet of MPIDI_CH3_PKT_ACCUMULATE */
/* see MPIDI_CH3_PktHandler_Accumulate (in src/mpid/ch3/src/ch3u_rma_sync.c) */
#undef FUNCNAME
#define FUNCNAME MPID_nem_ib_PktHandler_Accumulate
#undef FCNAME
#define FCNAME MPIDI_QUOTE(FUNCNAME)
int MPID_nem_ib_PktHandler_Accumulate(MPIDI_VC_t * vc, MPIDI_CH3_Pkt_t * pkt,
                                      MPIDI_msg_sz_t * buflen /* out */ ,
                                      MPID_Request ** rreqp /* out */)
{
    MPID_nem_ib_pkt_prefix_t *netmod_pkt = (MPID_nem_ib_pkt_prefix_t *) pkt;
    MPIDI_CH3_Pkt_accum_t *ch3_pkt =
        (MPIDI_CH3_Pkt_accum_t *) ((uint8_t *) pkt + sizeof(MPID_nem_ib_pkt_prefix_t));
    MPID_Request *rreq;
    int found;
    int complete;
    char *data_buf;
    MPIDI_msg_sz_t data_len;
    int mpi_errno = MPI_SUCCESS;
    int ibcom_errno;

    MPIDI_STATE_DECL(MPID_STATE_MPID_NEM_IB_PKTHANDLER_ACCUMULATE);
    MPIDI_FUNC_ENTER(MPID_STATE_MPID_NEM_IB_PKTHANDLER_ACCUMULATE);

    /* Update occupation status of local SR (send request) queue */
    MPID_nem_ib_vc_area *vc_ib = VC_IB(vc);
    dprintf("MPID_nem_ib_Pkthandler_Accumulate,lsr_seq_num_tail=%d,accum_pkt->seq_num_tail=%d\n",
            vc_ib->ibcom->lsr_seq_num_tail, netmod_pkt->seq_num_tail);
    vc_ib->ibcom->lsr_seq_num_tail =
        MPID_NEM_IB_MAX(vc_ib->ibcom->lsr_seq_num_tail, netmod_pkt->seq_num_tail);
    dprintf("MPID_nem_ib_Pkthandler_Accumulate,lsr_seq_num_tail updated to %d\n",
            vc_ib->ibcom->lsr_seq_num_tail);

#ifndef MPID_NEM_IB_DISABLE_VAR_OCC_NOTIFY_RATE
    /* change remote notification policy of RDMA-write-to buf */
    dprintf("pkthandler,put,old rstate=%d\n", vc_ib->ibcom->rdmabuf_occupancy_notify_rstate);
    MPID_nem_ib_change_rdmabuf_occupancy_notify_policy_lw(vc_ib, &vc_ib->ibcom->lsr_seq_num_tail);
    dprintf("pkthandler,put,new rstate=%d\n", vc_ib->ibcom->rdmabuf_occupancy_notify_rstate);
#endif
    dprintf("pkthandler,put,sendq_empty=%d,ncom=%d,rdmabuf_occ=%d\n",
            MPID_nem_ib_sendq_empty(vc_ib->sendq), vc_ib->ibcom->ncom,
            MPID_nem_ib_diff32(vc_ib->ibcom->sseq_num, vc_ib->ibcom->lsr_seq_num_tail));
    /* try to send from sendq because at least one RDMA-write-to buffer has been released */
    dprintf("pkthandler,put,send_progress\n");
    fflush(stdout);
    MPID_NEM_IB_CHECK_AND_SEND_PROGRESS
        /* fall back to the original handler */
        /* we don't need to worry about the difference caused by embedding seq_num
         * because size of MPI-header of MPIDI_CH3_PKT_PUT equals to sizeof(MPIDI_CH3_Pkt_t)
         * see MPID_nem_ib_iSendContig
         */
        MPIDI_msg_sz_t ch3_buflen = *buflen - sizeof(MPID_nem_ib_pkt_prefix_t);
    mpi_errno =
        MPIDI_CH3_PktHandler_Accumulate(vc, (MPIDI_CH3_Pkt_t *) ch3_pkt, &ch3_buflen, rreqp);
    *buflen = ch3_buflen + sizeof(MPID_nem_ib_pkt_prefix_t);
    if (mpi_errno) {
        MPIU_ERR_POP(mpi_errno);
    }

  fn_exit:
    MPIDI_FUNC_EXIT(MPID_STATE_MPID_NEM_IB_PKTHANDLER_ACCUMULATE);
    return mpi_errno;
  fn_fail:
    goto fn_exit;
}

/* packet handler for wrapper packet of MPIDI_CH3_PKT_GET */
/* see MPIDI_CH3_PktHandler_Get (in src/mpid/ch3/src/ch3u_rma_sync.c) */
#undef FUNCNAME
#define FUNCNAME MPID_nem_ib_PktHandler_Get
#undef FCNAME
#define FCNAME MPIDI_QUOTE(FUNCNAME)
int MPID_nem_ib_PktHandler_Get(MPIDI_VC_t * vc, MPIDI_CH3_Pkt_t * pkt,
                               MPIDI_msg_sz_t * buflen /* out */ ,
                               MPID_Request ** rreqp /* out */)
{
    MPID_nem_ib_pkt_prefix_t *netmod_pkt = (MPID_nem_ib_pkt_prefix_t *) pkt;
    MPIDI_CH3_Pkt_get_t *ch3_pkt =
        (MPIDI_CH3_Pkt_get_t *) ((uint8_t *) pkt + sizeof(MPID_nem_ib_pkt_prefix_t));
    MPID_Request *rreq;
    int found;
    int complete;
    char *data_buf;
    MPIDI_msg_sz_t data_len;
    int mpi_errno = MPI_SUCCESS;
    int ibcom_errno;

    MPIDI_STATE_DECL(MPID_STATE_MPID_NEM_IB_PKTHANDLER_GET);
    MPIDI_FUNC_ENTER(MPID_STATE_MPID_NEM_IB_PKTHANDLER_GET);

    /* Update occupation status of local SR (send request) queue */
    MPID_nem_ib_vc_area *vc_ib = VC_IB(vc);
    dprintf("MPID_nem_ib_Pkthandler_Get,lsr_seq_num_tail=%d,get_pkt->seq_num_tail=%d\n",
            vc_ib->ibcom->lsr_seq_num_tail, netmod_pkt->seq_num_tail);
    vc_ib->ibcom->lsr_seq_num_tail =
        MPID_NEM_IB_MAX(vc_ib->ibcom->lsr_seq_num_tail, netmod_pkt->seq_num_tail);
    dprintf("MPID_nem_ib_Pkthandler_Get,lsr_seq_num_tail updated to %d\n",
            vc_ib->ibcom->lsr_seq_num_tail);

#ifndef MPID_NEM_IB_DISABLE_VAR_OCC_NOTIFY_RATE
    /* change remote notification policy of RDMA-write-to buf */
    dprintf("pkthandler,put,old rstate=%d\n", vc_ib->ibcom->rdmabuf_occupancy_notify_rstate);
    MPID_nem_ib_change_rdmabuf_occupancy_notify_policy_lw(vc_ib, &vc_ib->ibcom->lsr_seq_num_tail);
    dprintf("pkthandler,put,new rstate=%d\n", vc_ib->ibcom->rdmabuf_occupancy_notify_rstate);
#endif
    dprintf("pkthandler,put,sendq_empty=%d,ncom=%d,rdmabuf_occ=%d\n",
            MPID_nem_ib_sendq_empty(vc_ib->sendq), vc_ib->ibcom->ncom,
            MPID_nem_ib_diff32(vc_ib->ibcom->sseq_num, vc_ib->ibcom->lsr_seq_num_tail));
    /* try to send from sendq because at least one RDMA-write-to buffer has been released */
    dprintf("pkthandler,get,send_progress\n");
    fflush(stdout);
    MPID_NEM_IB_SEND_PROGRESS_POLLINGSET
        /* fall back to the original handler */
        /* we don't need to worry about the difference caused by embedding seq_num
         * because size of MPI-header of MPIDI_CH3_PKT_PUT equals to sizeof(MPIDI_CH3_Pkt_t)
         * see MPID_nem_ib_iSendContig
         */
        MPIDI_msg_sz_t ch3_buflen = *buflen - sizeof(MPID_nem_ib_pkt_prefix_t);
    mpi_errno = MPIDI_CH3_PktHandler_Get(vc, (MPIDI_CH3_Pkt_t *) ch3_pkt, &ch3_buflen, rreqp);
    *buflen = ch3_buflen + sizeof(MPID_nem_ib_pkt_prefix_t);
    if (mpi_errno) {
        MPIU_ERR_POP(mpi_errno);
    }

  fn_exit:
    MPIDI_FUNC_EXIT(MPID_STATE_MPID_NEM_IB_PKTHANDLER_GET);
    return mpi_errno;
  fn_fail:
    goto fn_exit;
}

/* packet handler for wrapper packet of MPIDI_CH3_PKT_GET_RESP */
/* see MPIDI_CH3_PktHandler_GetResp (in src/mpid/ch3/src/ch3u_rma_sync.c) */
#undef FUNCNAME
#define FUNCNAME MPID_nem_ib_PktHandler_GetResp
#undef FCNAME
#define FCNAME MPIDI_QUOTE(FUNCNAME)
int MPID_nem_ib_PktHandler_GetResp(MPIDI_VC_t * vc, MPIDI_CH3_Pkt_t * pkt,
                                   MPIDI_msg_sz_t * buflen /* out */ ,
                                   MPID_Request ** rreqp /* out */)
{
    MPID_nem_ib_pkt_prefix_t *netmod_pkt = (MPID_nem_ib_pkt_prefix_t *) pkt;
    MPIDI_CH3_Pkt_get_t *ch3_pkt =
        (MPIDI_CH3_Pkt_get_t *) ((uint8_t *) pkt + sizeof(MPID_nem_ib_pkt_prefix_t));
    MPID_Request *rreq;
    int found;
    int complete;
    char *data_buf;
    MPIDI_msg_sz_t data_len;
    int mpi_errno = MPI_SUCCESS;
    int ibcom_errno;

    MPIDI_STATE_DECL(MPID_STATE_MPID_NEM_IB_PKTHANDLER_GETRESP);
    MPIDI_FUNC_ENTER(MPID_STATE_MPID_NEM_IB_PKTHANDLER_GETRESP);

    /* Update occupation status of local SR (send request) queue */
    MPID_nem_ib_vc_area *vc_ib = VC_IB(vc);
    dprintf("MPID_nem_ib_Pkthandler_GetResp,lsr_seq_num_tail=%d,get_pkt->seq_num_tail=%d\n",
            vc_ib->ibcom->lsr_seq_num_tail, netmod_pkt->seq_num_tail);
    vc_ib->ibcom->lsr_seq_num_tail =
        MPID_NEM_IB_MAX(vc_ib->ibcom->lsr_seq_num_tail, netmod_pkt->seq_num_tail);
    dprintf("MPID_nem_ib_Pkthandler_GetResp,lsr_seq_num_tail updated to %d\n",
            vc_ib->ibcom->lsr_seq_num_tail);

#ifndef MPID_NEM_IB_DISABLE_VAR_OCC_NOTIFY_RATE
    /* change remote notification policy of RDMA-write-to buf */
    dprintf("pkthandler,put,old rstate=%d\n", vc_ib->ibcom->rdmabuf_occupancy_notify_rstate);
    MPID_nem_ib_change_rdmabuf_occupancy_notify_policy_lw(vc_ib, &vc_ib->ibcom->lsr_seq_num_tail);
    dprintf("pkthandler,put,new rstate=%d\n", vc_ib->ibcom->rdmabuf_occupancy_notify_rstate);
#endif
    dprintf("pkthandler,put,sendq_empty=%d,ncom=%d,rdmabuf_occ=%d\n",
            MPID_nem_ib_sendq_empty(vc_ib->sendq), vc_ib->ibcom->ncom,
            MPID_nem_ib_diff32(vc_ib->ibcom->sseq_num, vc_ib->ibcom->lsr_seq_num_tail));
    /* try to send from sendq because at least one RDMA-write-to buffer has been released */
    dprintf("pkthandler,get,send_progress\n");
    fflush(stdout);
    MPID_NEM_IB_SEND_PROGRESS_POLLINGSET
        /* fall back to the original handler */
        /* we don't need to worry about the difference caused by embedding seq_num
         * because size of MPI-header of MPIDI_CH3_PKT_PUT equals to sizeof(MPIDI_CH3_Pkt_t)
         * see MPID_nem_ib_iSendContig
         */
        MPIDI_msg_sz_t ch3_buflen = *buflen - sizeof(MPID_nem_ib_pkt_prefix_t);
    mpi_errno = MPIDI_CH3_PktHandler_GetResp(vc, (MPIDI_CH3_Pkt_t *) ch3_pkt, &ch3_buflen, rreqp);
    *buflen = ch3_buflen + sizeof(MPID_nem_ib_pkt_prefix_t);
    if (mpi_errno) {
        MPIU_ERR_POP(mpi_errno);
    }

  fn_exit:
    MPIDI_FUNC_EXIT(MPID_STATE_MPID_NEM_IB_PKTHANDLER_GETRESP);
    return mpi_errno;
  fn_fail:
    goto fn_exit;
}

/* MPI_Isend set req-type to MPIDI_REQUEST_TYPE_RECV */
#undef FUNCNAME
#define FUNCNAME MPID_nem_ib_pkt_GET_DONE_handler
#undef FCNAME
#define FCNAME MPIDI_QUOTE(FUNCNAME)
int MPID_nem_ib_pkt_GET_DONE_handler(MPIDI_VC_t * vc, MPIDI_CH3_Pkt_t * pkt,
                                     MPIDI_msg_sz_t * buflen, MPID_Request ** rreqp)
{
    int mpi_errno = MPI_SUCCESS;
    int ibcom_errno;
    MPID_nem_ib_pkt_lmt_get_done_t *const done_pkt = (MPID_nem_ib_pkt_lmt_get_done_t *) pkt;
    MPID_Request *req;
    MPID_nem_ib_vc_area *vc_ib = VC_IB(vc);
    MPIDI_STATE_DECL(MPID_STATE_MPID_NEM_IB_PKT_GET_DONE_HANDLER);
    MPIDI_FUNC_ENTER(MPID_STATE_MPID_NEM_IB_PKT_GET_DONE_HANDLER);

    dprintf("get_done_handler,enter\n");

    *buflen = sizeof(MPIDI_CH3_Pkt_t);
    MPID_Request_get_ptr(done_pkt->req_id, req);

    MPIU_THREAD_CS_ENTER(LMT,);

    switch (MPIDI_Request_get_type(req)) {
        /* MPIDI_Request_set_type is not performed when
         * MPID_Isend --> FDU_or_AEP --> recv_posted --> ib_poll --> PUTCTS packet-handler */
    case MPIDI_REQUEST_TYPE_RECV:
        MPIU_ERR_INTERNALANDJUMP(mpi_errno, "unexpected request type");
        break;
    case MPIDI_REQUEST_TYPE_SEND:
    case MPIDI_REQUEST_TYPE_RSEND:
    case MPIDI_REQUEST_TYPE_SSEND:
    case MPIDI_REQUEST_TYPE_BSEND:
        /* extract embeded RDMA-write-to buffer occupancy information */
        dprintf("get_done_handler,old lsr_seq_num_tail=%d,done_pkt->seq_num_tail=%d\n",
                vc_ib->ibcom->lsr_seq_num_tail, done_pkt->seq_num_tail);
        vc_ib->ibcom->lsr_seq_num_tail =
            MPID_NEM_IB_MAX(vc_ib->ibcom->lsr_seq_num_tail, done_pkt->seq_num_tail);
        //dprintf("lmt_start_recv,new lsr_seq_num=%d\n", vc_ib->ibcom->lsr_seq_num_tail);

#ifndef MPID_NEM_IB_DISABLE_VAR_OCC_NOTIFY_RATE
        /* change remote notification policy of RDMA-write-to buf */
        //dprintf("lmt_start_recv,reply_seq_num,old rstate=%d\n", vc_ib->ibcom->rdmabuf_occupancy_notify_rstate);
        MPID_nem_ib_change_rdmabuf_occupancy_notify_policy_lw(vc_ib,
                                                              &vc_ib->ibcom->lsr_seq_num_tail);
        //dprintf("lmt_start_recv,reply_seq_num,new rstate=%d\n", vc_ib->ibcom->rdmabuf_occupancy_notify_rstate);
#endif
        //dprintf("lmt_start_recv,reply_seq_num,sendq_empty=%d,ncom=%d,ncqe=%d,rdmabuf_occ=%d\n", MPID_nem_ib_sendq_empty(vc_ib->sendq), vc_ib->ibcom->ncom, MPID_nem_ib_ncqe, MPID_nem_ib_diff32(vc_ib->ibcom->sseq_num, vc_ib->ibcom->lsr_seq_num_tail));
        /* try to send from sendq because at least one RDMA-write-to buffer has been released */
        //dprintf("lmt_start_recv,reply_seq_num,send_progress\n");
        if (!MPID_nem_ib_sendq_empty(vc_ib->sendq)) {
            dprintf("get_done_handler,ncom=%d,ncqe=%d,diff=%d(%d-%d)\n",
                    vc_ib->ibcom->ncom < MPID_NEM_IB_COM_MAX_SQ_CAPACITY,
                    MPID_nem_ib_ncqe < MPID_NEM_IB_COM_MAX_CQ_CAPACITY,
                    MPID_nem_ib_diff32(vc_ib->ibcom->sseq_num,
                                       vc_ib->ibcom->lsr_seq_num_tail) <
                    MPID_NEM_IB_COM_RDMABUF_NSEG, vc_ib->ibcom->sseq_num,
                    vc_ib->ibcom->lsr_seq_num_tail);
        }
        dprintf("get_done_handler,send_progress\n");
        fflush(stdout);
        MPID_NEM_IB_CHECK_AND_SEND_PROGRESS mpi_errno = vc->ch.lmt_done_send(vc, req);
        if (mpi_errno)
            MPIU_ERR_POP(mpi_errno);
        break;
    default:
        MPIU_ERR_INTERNALANDJUMP(mpi_errno, "unexpected request type");
        break;
    }

    *rreqp = NULL;

  fn_exit:
    MPIU_THREAD_CS_EXIT(LMT,);
    MPIDI_FUNC_EXIT(MPID_STATE_MPID_NEM_IB_PKT_GET_DONE_HANDLER);
    return mpi_errno;
  fn_fail:
    goto fn_exit;
}

#undef FUNCNAME
#define FUNCNAME MPID_nem_ib_PktHandler_req_seq_num
#undef FCNAME
#define FCNAME MPIDI_QUOTE(FUNCNAME)
int MPID_nem_ib_PktHandler_req_seq_num(MPIDI_VC_t * vc, MPIDI_CH3_Pkt_t * pkt,
                                       MPIDI_msg_sz_t * buflen, MPID_Request ** rreqp)
{
    int mpi_errno = MPI_SUCCESS;
    int ibcom_errno;
    MPID_nem_ib_pkt_req_seq_num_t *const req_pkt = (MPID_nem_ib_pkt_req_seq_num_t *) pkt;
    MPID_Request *req;
    MPIDI_STATE_DECL(MPID_STATE_MPID_NEM_IB_PKTHANDLER_REQ_SEQ_NUM);
    MPIDI_FUNC_ENTER(MPID_STATE_MPID_NEM_IB_PKTHANDLER_REQ_SEQ_NUM);

    /* mark as all of the message is read */
    *buflen = sizeof(MPIDI_CH3_Pkt_t);

    /* mark as I don't need continuation read request */
    *rreqp = NULL;

    /* update occupancy info of SR */
    /* request piggy-backs seq_num although it's requesting responder's seq_num */
    MPID_nem_ib_vc_area *vc_ib = VC_IB(vc);
    vc_ib->ibcom->lsr_seq_num_tail =
        MPID_NEM_IB_MAX(vc_ib->ibcom->lsr_seq_num_tail, req_pkt->seq_num_tail);

    dprintf("PktHandler_req_seq_num,sendq=%d,ncom=%d,ncqe=%d,diff=%d(%d-%d)\n",
            MPID_nem_ib_sendq_empty(vc_ib->sendq),
            vc_ib->ibcom->ncom < MPID_NEM_IB_COM_MAX_SQ_CAPACITY,
            MPID_nem_ib_ncqe < MPID_NEM_IB_COM_MAX_CQ_CAPACITY,
            MPID_nem_ib_diff32(vc_ib->ibcom->sseq_num,
                               vc_ib->ibcom->lsr_seq_num_tail) < MPID_NEM_IB_COM_RDMABUF_NSEG,
            vc_ib->ibcom->sseq_num, vc_ib->ibcom->lsr_seq_num_tail);

    /* send reply */
    dprintf("PktHandler_req_seq_num,sending reply_seq_num,id=%d\n", vc_ib->ibcom->sseq_num);
    MPID_nem_ib_send_reply_seq_num(vc);

  fn_exit:
    MPIDI_FUNC_EXIT(MPID_STATE_MPID_NEM_IB_PKTHANDLER_REQ_SEQ_NUM);
    return mpi_errno;
  fn_fail:
    goto fn_exit;
}

#undef FUNCNAME
#define FUNCNAME MPID_nem_ib_PktHandler_reply_seq_num
#undef FCNAME
#define FCNAME MPIDI_QUOTE(FUNCNAME)
int MPID_nem_ib_PktHandler_reply_seq_num(MPIDI_VC_t * vc, MPIDI_CH3_Pkt_t * pkt,
                                         MPIDI_msg_sz_t * buflen, MPID_Request ** rreqp)
{
    int mpi_errno = MPI_SUCCESS;
    int ibcom_errno;
    MPID_nem_ib_pkt_reply_seq_num_t *const reply_pkt = (MPID_nem_ib_pkt_reply_seq_num_t *) pkt;
    MPID_Request *req;
    MPIDI_STATE_DECL(MPID_STATE_MPID_NEM_IB_PKTHANDLER_REPLY_SEQ_NUM);
    MPIDI_FUNC_ENTER(MPID_STATE_MPID_NEM_IB_PKTHANDLER_REPLY_SEQ_NUM);


    /* mark as all of the message is consumed */
    *buflen = sizeof(MPIDI_CH3_Pkt_t);

    /* mark as I don't need continuation read request */
    *rreqp = NULL;

    /* update occupancy info of RDMA-write-buf */
    int *lsr_seq_num_tail;
    MPID_nem_ib_vc_area *vc_ib = VC_IB(vc);
    dprintf("pkthandler,reply_seq_num,old lsr_seq_num=%d,reply_pkt->seq_num_tail=%d\n",
            vc_ib->ibcom->lsr_seq_num_tail, reply_pkt->seq_num_tail);
    ibcom_errno = MPID_nem_ib_com_lsr_seq_num_tail_get(vc_ib->sc->fd, &lsr_seq_num_tail);
    MPIU_ERR_CHKANDJUMP(ibcom_errno, mpi_errno, MPI_ERR_OTHER,
                        "**MPID_nem_ib_com_lsr_seq_num_tail_get");
    *lsr_seq_num_tail = MPID_NEM_IB_MAX(*lsr_seq_num_tail, reply_pkt->seq_num_tail);
    //dprintf("pkthandler,reply_seq_num,new lsr_seq_num=%d\n", vc_ib->ibcom->lsr_seq_num_tail);

#ifndef MPID_NEM_IB_DISABLE_VAR_OCC_NOTIFY_RATE
    /* change remote notification policy of RDMA-write-to buf */
    //dprintf("pkthandler,reply_seq_num,old rstate=%d\n", vc_ib->ibcom->rdmabuf_occupancy_notify_rstate);
    MPID_nem_ib_change_rdmabuf_occupancy_notify_policy_lw(vc_ib, lsr_seq_num_tail);
    //dprintf("pkthandler,reply_seq_num,new rstate=%d\n", vc_ib->ibcom->rdmabuf_occupancy_notify_rstate);
#endif

    //dprintf("pkthandler,reply_seq_num,sendq_empty=%d,ncom=%d,ncqe=%d,rdmabuf_occ=%d\n", MPID_nem_ib_sendq_empty(vc_ib->sendq), vc_ib->ibcom->ncom, MPID_nem_ib_ncqe, MPID_nem_ib_diff32(vc_ib->ibcom->sseq_num, vc_ib->ibcom->lsr_seq_num_tail));
    /* try to send from sendq because at least one RDMA-write-to buffer has been released */
    //dprintf("pkthandler,reply_seq_num,send_progress\n");
    dprintf("pkthandler,reply_seq_num,send_progress\n");
    MPID_NEM_IB_CHECK_AND_SEND_PROGRESS fn_exit:
        MPIDI_FUNC_EXIT(MPID_STATE_MPID_NEM_IB_PKTHANDLER_REPLY_SEQ_NUM);
    return mpi_errno;
  fn_fail:
    goto fn_exit;
}

#undef FUNCNAME
#define FUNCNAME MPID_nem_ib_PktHandler_change_rdmabuf_occupancy_notify_state
#undef FCNAME
#define FCNAME MPIDI_QUOTE(FUNCNAME)
int MPID_nem_ib_PktHandler_change_rdmabuf_occupancy_notify_state(MPIDI_VC_t * vc,
                                                                 MPIDI_CH3_Pkt_t * pkt,
                                                                 MPIDI_msg_sz_t * buflen,
                                                                 MPID_Request ** rreqp)
{
    int mpi_errno = MPI_SUCCESS;
    int ibcom_errno;
    MPID_nem_ib_pkt_change_rdmabuf_occupancy_notify_state_t *const reply_pkt =
        (MPID_nem_ib_pkt_change_rdmabuf_occupancy_notify_state_t *) pkt;
    MPID_Request *req;
    MPIDI_STATE_DECL(MPID_STATE_MPID_NEM_IB_PKTHANDLER_CHANGE_RDMABUF_OCCUPANCY_NOTIFY_STATE);
    MPIDI_FUNC_ENTER(MPID_STATE_MPID_NEM_IB_PKTHANDLER_CHANGE_RDMABUF_OCCUPANCY_NOTIFY_STATE);

    /* mark as all of the message is read */
    *buflen = sizeof(MPIDI_CH3_Pkt_t);

    /* mark as I don't need continuation read request */
    *rreqp = NULL;


    /* update occupancy info of SR */
    MPID_nem_ib_vc_area *vc_ib = VC_IB(vc);
    dprintf("pkthandler,change notify state,old lstate=%d,pkt->state=%d\n",
            vc_ib->ibcom->rdmabuf_occupancy_notify_lstate, reply_pkt->state);
    int *rdmabuf_occupancy_notify_lstate;
    ibcom_errno =
        MPID_nem_ib_com_rdmabuf_occupancy_notify_lstate_get(vc_ib->sc->fd,
                                                            &rdmabuf_occupancy_notify_lstate);
    MPIU_ERR_CHKANDJUMP(ibcom_errno, mpi_errno, MPI_ERR_OTHER,
                        "**MPID_nem_ib_com_rdmabuf_occupancy_notify_lstate_get");
    *rdmabuf_occupancy_notify_lstate = reply_pkt->state;
    dprintf("pkthandler,change notify state,new lstate=%d\n",
            vc_ib->ibcom->rdmabuf_occupancy_notify_lstate);

  fn_exit:
    MPIDI_FUNC_EXIT(MPID_STATE_MPID_NEM_IB_PKTHANDLER_CHANGE_RDMABUF_OCCUPANCY_NOTIFY_STATE);
    return mpi_errno;
  fn_fail:
    goto fn_exit;
}

#ifdef MPID_NEM_IB_ONDEMAND
#undef FUNCNAME
#define FUNCNAME MPID_nem_ib_cm_drain_scq
#undef FCNAME
#define FCNAME MPIDI_QUOTE(FUNCNAME)
int MPID_nem_ib_cm_drain_scq()
{

    int mpi_errno = MPI_SUCCESS;
    int result;
    int i;
    struct ibv_wc cqe[MPID_NEM_IB_COM_MAX_CQ_HEIGHT_DRAIN];

    MPIDI_STATE_DECL(MPID_STATE_MPID_NEM_IB_CM_DRAIN_SCQ);
    MPIDI_FUNC_ENTER(MPID_STATE_MPID_NEM_IB_CM_DRAIN_SCQ);

    result =
        ibv_poll_cq(MPID_nem_ib_rc_shared_scq_lmt_put, MPID_NEM_IB_COM_MAX_CQ_HEIGHT_DRAIN,
                    &cqe[0]);
    MPIU_ERR_CHKANDJUMP(result < 0, mpi_errno, MPI_ERR_OTHER, "**netmod,ib,ibv_poll_cq");

    if (result > 0) {
        dprintf("cm_drain_scq,found,result=%d\n", result);
    }
    for (i = 0; i < result; i++) {

#ifdef HAVE_LIBDCFA
        if (cqe[i].status != IBV_WC_SUCCESS) {
            dprintf("cm_drain_scq,status=%08x\n", cqe[i].status);
        }
#else
        if (cqe[i].status != IBV_WC_SUCCESS) {
            dprintf("cm_drain_scq,status=%08x,%s\n", cqe[i].status,
                    ibv_wc_status_str(cqe[i].status));
        }
#endif
        MPIU_ERR_CHKANDJUMP(cqe[i].status != IBV_WC_SUCCESS, mpi_errno, MPI_ERR_OTHER,
                            "**MPID_nem_ib_cm_drain_scq");
        /* TODO retry a connection request when it timed out */

        if (cqe.wr_id == MPID_NEM_IB_SYN || cqe.wr_id == MPID_NEM_IB_SYNACK) {

            MPID_nem_ib_conn_ud_ibcom->ncom_lmt_put -= 1;
            MPID_nem_ib_ncqe_connect -= 1;

            /* Try to send from sendq_connect */
            if (!MPID_nem_ib_sendq_empty(sendq_connect) &&
                MPID_nem_ib_ncom_lmt_put < MPID_NEM_IB_COM_MAX_SQ_CAPACITY &&
                MPID_nem_ib_ncqe_lmt_put < MPID_NEM_IB_COM_MAX_CQ_CAPACITY) {
                MPID_nem_ib_send_progress_connect();
            }
        }
        else {
            printf("unknown command=%d\n", cqe.wr_id);
            MPIU_ERR_CHKANDJUMP(1, mpi_errno, MPI_ERR_OTHER, "**MPID_nem_ib_cm_drain_scq");
        }
    }

  fn_exit:
    MPIDI_FUNC_EXIT(MPID_STATE_MPID_NEM_IB_CM_DRAIN_SCQ);
    return mpi_errno;
  fn_fail:
    goto fn_exit;
}

#undef FUNCNAME
#define FUNCNAME MPID_nem_ib_cm_poll
#undef FCNAME
#define FCNAME MPIDI_QUOTE(FUNCNAME)
int MPID_nem_ib_cm_poll()
{
    int mpi_errno = MPI_SUCCESS;

    MPIDI_STATE_DECL(MPID_STATE_MPID_NEM_IB_CM_POLL);
    MPIDI_FUNC_ENTER(MPID_STATE_MPID_NEM_IB_CM_POLL);

    dprintf("cm_poll,enter\n");


    volatile uint32_t *owner =
        (uint32_t *) (MPID_nem_ib_com_scratch_pad->icom_mem[MPID_NEM_IB_COM_SCRATCH_PAD_TO]);
    if (*owner == (uint32_t) - 1) {
        goto fn_exit;
    }   /* not acquired */

    MPID_nem_ib_com *ibcom_scratch_pad;
    ibcom_errno =
        MPID_nem_ib_com_obtain_pointer(MPID_nem_ib_scratch_pad_fds[*owner], &ibcom_scratch_pad);
    MPIU_ERR_CHKANDJUMP(ibcom_errno, mpi_errno, MPI_ERR_OTHER, "**MPID_nem_ib_com_obtain_pointer");

    MPID_nem_ib_cm_cmd_t *received =
        (MPID_nem_ib_cm_cmd_t *) (ibcom_scratch_pad->icom_mem[MPID_NEM_IB_COM_SCRATCH_PAD_TO] +
                                  sizeof(uint32_t));
    MPID_nem_ib_cm_cmd_t cmd;
    MPID_nem_ib_vc_area *vc_ib;
    switch (received->type) {
    case MPID_NEM_IB_CM_SYN:
        ibcom_errno =
            MPID_nem_ib_com_open(ib_port, MPID_NEM_IB_COM_OPEN_RC, &MPID_nem_ib_conns[*owner].fd);
        MPIU_ERR_CHKANDJUMP(ibcom_errno, mpi_errno, MPI_ERR_OTHER, "**MPID_nem_ib_com_open");
        cmd.type = MPID_NEM_IB_CM_SYNACK;
        goto common_tail;
        break;
    case MPID_NEM_IB_CM_BUSINESSCARD:
        ibcom_errno =
            MPID_nem_ib_com_rts(MPID_nem_ib_conns[*owner].fd, received->qpnum, received->lid,
                                &(received->gid));
        MPIU_ERR_CHKANDJUMP(ibcom_errno, mpi_errno, MPI_ERR_OTHER, "**MPID_nem_ib_com_rts");
        ibcom_errno =
            MPID_nem_ib_com_reg_mr_connect(MPID_nem_ib_conns[*owner].fd, received->rmem,
                                           received->rkey);
        MPIU_ERR_CHKANDJUMP(ibcom_errno, mpi_errno, MPI_ERR_OTHER,
                            "**MPID_nem_ib_com_reg_mr_connect");
        VC_FIELD(MPID_nem_ib_conns[owner].vc, is_connected) = 1;

        cmd.type = MPID_NEM_IB_CM_ACK;
      common_tail:
        ibcom_errno =
            MPID_nem_ib_com_get_info_conn(MPID_nem_ib_conns[*owner].fd,
                                          MPID_NEM_IB_COM_INFOKEY_PORT_LID, &(cmd.lid),
                                          sizeof(uint16_t));
        MPIU_ERR_CHKANDJUMP(ibcom_errno, mpi_errno, MPI_ERR_OTHER,
                            "**MPID_nem_ib_com_get_info_conn");

        ibcom_errno =
            MPID_nem_ib_com_get_info_conn(MPID_nem_ib_conns[*owner].fd,
                                          MPID_NEM_IB_COM_INFOKEY_PORT_GID, &(cmd.gid),
                                          sizeof(union ibv_gid));
        MPIU_ERR_CHKANDJUMP(ibcom_errno, mpi_errno, MPI_ERR_OTHER,
                            "**MPID_nem_ib_com_get_info_conn");

        ibcom_errno =
            MPID_nem_ib_com_get_info_conn(MPID_nem_ib_conns[*owner].fd,
                                          MPID_NEM_IB_COM_INFOKEY_QP_QPN, &(cmd.qpnum),
                                          sizeof(uint32_t));
        MPIU_ERR_CHKANDJUMP(ibcom_errno, mpi_errno, MPI_ERR_OTHER,
                            "**MPID_nem_ib_com_get_info_conn");

        ibcom_errno =
            MPID_nem_ib_com_get_info_mr(MPID_nem_ib_conns[*owner].fd,
                                        MPID_NEM_IB_COM_SCRATCH_PAD_TO,
                                        MPID_NEM_IB_COM_INFOKEY_MR_ADDR, &(cmd.rmem),
                                        sizeof(void *));
        MPIU_ERR_CHKANDJUMP(ibcom_errno, mpi_errno, MPI_ERR_OTHER, "**MPID_nem_ib_com_get_info_mr");

        ibcom_errno =
            MPID_nem_ib_com_get_info_mr(MPID_nem_ib_conns[*owner].fd,
                                        MPID_NEM_IB_COM_SCRATCH_PAD_TO,
                                        MPID_NEM_IB_COM_INFOKEY_MR_RKEY, &(cmd.rkey), sizeof(int));
        MPIU_ERR_CHKANDJUMP(ibcom_errno, mpi_errno, MPI_ERR_OTHER, "**MPID_nem_ib_com_get_info_mr");

        *owner = (uint32_t) - 1;        /* release */

        mpi_errno = MPID_nem_ib_cm_send_core(rank, &cmd);
        MPIU_ERR_CHKANDJUMP(mp_errno, mpi_errno, MPI_ERR_OTHER, "**MPID_nem_ib_cm_send_core");
        break;
    default:
        printf("unknown connection command\n");
        MPIU_ERR_CHKANDJUMP(1, mpi_errno, MPI_ERR_OTHER, "**MPID_nem_ib_cm_poll");
    }

  fn_exit:
    MPIDI_FUNC_EXIT(MPID_STATE_MPID_NEM_IB_CM_POLL);
    return mpi_errno;
  fn_fail:
    goto fn_exit;
}

#undef FUNCNAME
#define FUNCNAME MPID_nem_ib_cm_accept
#undef FCNAME
#define FCNAME MPIDI_QUOTE(FUNCNAME)
int MPID_nem_ib_cm_accept()
{
    int mpi_errno = MPI_SUCCESS;
    int ibcom_errno;
    int result;
    int i;
    struct ibv_wc cqe[MPID_NEM_IB_COM_MAX_CQ_HEIGHT_DRAIN];

    MPIDI_STATE_DECL(MPID_STATE_MPID_NEM_IB_CM_ACCEPT);
    MPIDI_FUNC_ENTER(MPID_STATE_MPID_NEM_IB_CM_ACCEPT);

    result = ibv_poll_cq(MPID_nem_ib_ud_shared_rcq, MPID_NEM_IB_COM_MAX_CQ_HEIGHT_DRAIN, &cqe);
    MPIU_ERR_CHKANDJUMP(result < 0, mpi_errno, MPI_ERR_OTHER, "**netmod,ib,ibv_poll_cq");

    if (result > 0) {
        dprintf("accept,result=%d\n", result);
    }
    for (i = 0; i < result; i++) {
        dprintf("accept,i=%d\n", i);

        MPIU_ERR_CHKANDJUMP(cqe.status != IBV_WC_SUCCESS, mpi_errno, MPI_ERR_OTHER,
                            "**MPID_nem_ib_cm_accept");

        void *rbuf;
        ibcom_errno = MPID_nem_ib_com_mem_udwr_to(MPID_nem_ib_conn_ud_fd, &rbuf);
        MPIU_ERR_CHKANDJUMP(ibcom_errno, mpi_errno, MPI_ERR_OTHER, "**MPID_nem_ib_com_mem_udwr_to");
        MPID_nem_ib_conn_pkt_t *rpkt = (MPID_nem_ib_conn_pkt_t *) (rbuf + 40);
        if (rpkt->type == MPID_NEM_IB_SYN) {

            dprintf("accept,%d<-%d,type=%08x\n", MPID_nem_ib_myrank, rpkt->remote_rank, rpkt->type);

            void *sbuf;
            ibcom_errno = MPID_nem_ib_com_mem_udwr_from(MPID_nem_ib_conn_ud_fd, &sbuf);
            MPIU_ERR_CHKANDJUMP(ibcom_errno, mpi_errno, MPI_ERR_OTHER,
                                "**MPID_nem_ib_com_mem_udwr_from");
            MPID_nem_ib_conn_pkt_t *spkt = (MPID_nem_ib_conn_pkt_t *) (sbuf + 40);
            spkt->remote_rank = MPID_nem_ib_myrank;
            spkt->type = MPID_NEM_IB_SYNACK;

            ibcom_errno =
                MPID_nem_ib_com_get_info_conn(MPID_nem_ib_conns[rpkt->remote_rank].fd,
                                              MPID_NEM_IB_COM_INFOKEY_QP_QPN, &spkt->qpn,
                                              sizeof(uint32_t));
            MPIU_ERR_CHKANDJUMP(ibcom_errno, mpi_errno, MPI_ERR_OTHER,
                                "**MPID_nem_ib_com_get_info_conn");

            ibcom_errno =
                MPID_nem_ib_com_get_info_mr(MPID_nem_ib_conns[remote_rank].fd,
                                            MPID_NEM_IB_COM_RDMAWR_TO,
                                            MPID_NEM_IB_COM_INFOKEY_MR_ADDR, &spkt->rmem,
                                            sizeof(void *));
            MPIU_ERR_CHKANDJUMP(ibcom_errno, mpi_errno, MPI_ERR_OTHER,
                                "**MPID_nem_ib_com_get_info_mr");

            ibcom_errno =
                MPID_nem_ib_com_get_info_mr(MPID_nem_ib_conns[remote_rank].fd,
                                            MPID_NEM_IB_COM_RDMAWR_TO,
                                            MPID_NEM_IB_COM_INFOKEY_MR_RKEY, &spkt->rkey,
                                            sizeof(int));
            MPIU_ERR_CHKANDJUMP(ibcom_errno, mpi_errno, MPI_ERR_OTHER,
                                "**MPID_nem_ib_com_get_info_mr");

            /* kokomade. add udsend_core(synack) */
            if (MPID_nem_ib_conn_ibcom->ncom < &&MPID_nem_ib_ncqe_connect <) {
                MPID_nem_ib_conn_send_core(rpkt->remote_rank);
            }
            else {
                MPID_nem_ib_sendq_conn_entry_t *entry =
                    MPIU_Malloc(sizeof(MPID_nem_ib_sendq_conn_entry_t));
                MPIU_ERR_CHKANDJUMP(!entry, mpi_errno, MPI_ERR_OTHER, "**outofmemory");
                entry->pending_pkt = *spkt;
                MPID_nem_ib_conn_sendq_enqueue(MPID_nem_ib_conn_sendq, entry);
            }


        }
        else {
            dprintf("accept,unknown type=%08x\n", *((uint32_t *) (rbuf + 44)));
        }
    }
  fn_exit:
    MPIDI_FUNC_EXIT(MPID_STATE_MPID_NEM_IB_CM_ACCEPT);
    return mpi_errno;
  fn_fail:
    goto fn_exit;
}
#endif
