/*
 * Decompiled with CFR 0.152.
 */
package viewer.legends;

import base.drawable.Category;
import java.util.Comparator;
import viewer.common.Parameters;

public class LegendComparators {
    public static final Comparator INDEX_ORDER = new IndexOrder();
    private static final Comparator PREVIEW_ORDER = new PreviewOrder();
    private static final Comparator TOPOLOGY_ORDER = new TopologyOrder();
    public static final Comparator CASE_SENSITIVE_ORDER = new CaseSensitiveOrder();
    public static final Comparator CASE_INSENSITIVE_ORDER = new CaseInsensitiveOrder();

    public static class CaseInsensitiveOrder
    implements Comparator {
        public int compare(Object object, Object object2) {
            Category category = (Category)object;
            Category category2 = (Category)object2;
            int n = 0;
            if (Parameters.LEGEND_TOPOLOGY_ORDER && (n = TOPOLOGY_ORDER.compare(category, category2)) != 0) {
                return n;
            }
            if (Parameters.LEGEND_PREVIEW_ORDER && (n = PREVIEW_ORDER.compare(category, category2)) != 0) {
                return n;
            }
            return category.getName().compareToIgnoreCase(category2.getName());
        }
    }

    public static class CaseSensitiveOrder
    implements Comparator {
        public int compare(Object object, Object object2) {
            Category category = (Category)object;
            Category category2 = (Category)object2;
            int n = 0;
            if (Parameters.LEGEND_TOPOLOGY_ORDER && (n = TOPOLOGY_ORDER.compare(category, category2)) != 0) {
                return n;
            }
            if (Parameters.LEGEND_PREVIEW_ORDER && (n = PREVIEW_ORDER.compare(category, category2)) != 0) {
                return n;
            }
            return category.getName().compareTo(category2.getName());
        }
    }

    public static class TopologyOrder
    implements Comparator {
        public int compare(Object object, Object object2) {
            Category category = (Category)object;
            Category category2 = (Category)object2;
            return category2.getTopology().hashCode() - category.getTopology().hashCode();
        }
    }

    public static class PreviewOrder
    implements Comparator {
        public int compare(Object object, Object object2) {
            Category category = (Category)object;
            Category category2 = (Category)object2;
            int n = category.getIndex() < 0 ? 0 : 1;
            int n2 = category2.getIndex() < 0 ? 0 : 1;
            return n - n2;
        }
    }

    public static class IndexOrder
    implements Comparator {
        public int compare(Object object, Object object2) {
            Category category = (Category)object;
            Category category2 = (Category)object2;
            return category.getIndex() - category2.getIndex();
        }
    }
}

