/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.text;

import com.sun.java.swing.event.DocumentEvent;
import com.sun.java.swing.event.DocumentListener;
import com.sun.java.swing.event.EventListenerList;
import com.sun.java.swing.event.UndoableEditEvent;
import com.sun.java.swing.event.UndoableEditListener;
import com.sun.java.swing.text.AttributeSet;
import com.sun.java.swing.text.BadLocationException;
import com.sun.java.swing.text.Document;
import com.sun.java.swing.text.Element;
import com.sun.java.swing.text.MutableAttributeSet;
import com.sun.java.swing.text.Position;
import com.sun.java.swing.text.Segment;
import com.sun.java.swing.text.SimpleAttributeSet;
import com.sun.java.swing.text.StateInvariantError;
import com.sun.java.swing.text.StyleConstants;
import com.sun.java.swing.text.StyleContext;
import com.sun.java.swing.undo.AbstractUndoableEdit;
import com.sun.java.swing.undo.CannotRedoException;
import com.sun.java.swing.undo.CannotUndoException;
import com.sun.java.swing.undo.CompoundEdit;
import com.sun.java.swing.undo.UndoableEdit;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class AbstractDocument
implements Document,
Serializable {
    private transient int numReaders;
    private transient Thread currWriter;
    private Dictionary documentProperties;
    protected EventListenerList listenerList = new EventListenerList();
    private Content data;
    private AttributeContext context;
    private static final String BAD_LOCK_STATE = "document lock failure";
    protected static final String BAD_LOCATION = "document location failure";
    public static final String ParagraphElementName = "paragraph";
    public static final String ContentElementName = "content";
    public static final String SectionElementName = "section";
    public static final String ElementNameAttribute = "$ename";
    static /* synthetic */ Class class$com$sun$java$swing$event$DocumentListener;
    static /* synthetic */ Class class$com$sun$java$swing$event$UndoableEditListener;

    protected AbstractDocument(Content content) {
        this(content, StyleContext.getDefaultStyleContext());
    }

    protected AbstractDocument(Content content, AttributeContext attributeContext) {
        this.data = content;
        this.context = attributeContext;
    }

    public Dictionary getDocumentProperties() {
        if (this.documentProperties == null) {
            this.documentProperties = new Hashtable(2);
        }
        return this.documentProperties;
    }

    public void setDocumentProperties(Dictionary dictionary) {
        this.documentProperties = dictionary;
    }

    protected void fireInsertUpdate(DocumentEvent documentEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$com$sun$java$swing$event$DocumentListener != null ? class$com$sun$java$swing$event$DocumentListener : AbstractDocument.class$("com.sun.java.swing.event.DocumentListener"))) {
                ((DocumentListener)objectArray[n + 1]).insertUpdate(documentEvent);
            }
            n -= 2;
        }
    }

    protected void fireChangedUpdate(DocumentEvent documentEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$com$sun$java$swing$event$DocumentListener != null ? class$com$sun$java$swing$event$DocumentListener : AbstractDocument.class$("com.sun.java.swing.event.DocumentListener"))) {
                ((DocumentListener)objectArray[n + 1]).changedUpdate(documentEvent);
            }
            n -= 2;
        }
    }

    protected void fireRemoveUpdate(DocumentEvent documentEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$com$sun$java$swing$event$DocumentListener != null ? class$com$sun$java$swing$event$DocumentListener : AbstractDocument.class$("com.sun.java.swing.event.DocumentListener"))) {
                ((DocumentListener)objectArray[n + 1]).removeUpdate(documentEvent);
            }
            n -= 2;
        }
    }

    protected void fireUndoableEditUpdate(UndoableEditEvent undoableEditEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$com$sun$java$swing$event$UndoableEditListener != null ? class$com$sun$java$swing$event$UndoableEditListener : AbstractDocument.class$("com.sun.java.swing.event.UndoableEditListener"))) {
                ((UndoableEditListener)objectArray[n + 1]).undoableEditHappened(undoableEditEvent);
            }
            n -= 2;
        }
    }

    public void render(Runnable runnable) {
        try {
            this.readLock();
            runnable.run();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.readUnlock();
            throw throwable;
        }
        Object var3_2 = null;
        this.readUnlock();
    }

    public int getLength() {
        return this.data.length() - 1;
    }

    public void addDocumentListener(DocumentListener documentListener) {
        this.listenerList.add(class$com$sun$java$swing$event$DocumentListener != null ? class$com$sun$java$swing$event$DocumentListener : (class$com$sun$java$swing$event$DocumentListener = AbstractDocument.class$("com.sun.java.swing.event.DocumentListener")), documentListener);
    }

    public void removeDocumentListener(DocumentListener documentListener) {
        this.listenerList.remove(class$com$sun$java$swing$event$DocumentListener != null ? class$com$sun$java$swing$event$DocumentListener : (class$com$sun$java$swing$event$DocumentListener = AbstractDocument.class$("com.sun.java.swing.event.DocumentListener")), documentListener);
    }

    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listenerList.add(class$com$sun$java$swing$event$UndoableEditListener != null ? class$com$sun$java$swing$event$UndoableEditListener : (class$com$sun$java$swing$event$UndoableEditListener = AbstractDocument.class$("com.sun.java.swing.event.UndoableEditListener")), undoableEditListener);
    }

    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listenerList.remove(class$com$sun$java$swing$event$UndoableEditListener != null ? class$com$sun$java$swing$event$UndoableEditListener : (class$com$sun$java$swing$event$UndoableEditListener = AbstractDocument.class$("com.sun.java.swing.event.UndoableEditListener")), undoableEditListener);
    }

    public final Object getProperty(Object object) {
        return this.getDocumentProperties().get(object);
    }

    public final void putProperty(Object object, Object object2) {
        if (object2 != null) {
            this.getDocumentProperties().put(object, object2);
            return;
        }
        this.getDocumentProperties().remove(object);
    }

    public void remove(int n, int n2) throws BadLocationException {
        if (n2 > 0) {
            block4: {
                try {
                    this.writeLock();
                    DefaultDocumentEvent defaultDocumentEvent = new DefaultDocumentEvent(n, n2, DocumentEvent.EventType.REMOVE);
                    this.removeUpdate(defaultDocumentEvent);
                    UndoableEdit undoableEdit = this.data.remove(n, n2);
                    if (undoableEdit != null) {
                        defaultDocumentEvent.addEdit(undoableEdit);
                    }
                    defaultDocumentEvent.end();
                    this.fireRemoveUpdate(defaultDocumentEvent);
                    if (undoableEdit == null) break block4;
                    this.fireUndoableEditUpdate(new UndoableEditEvent(this, defaultDocumentEvent));
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    this.writeUnlock();
                    throw throwable;
                }
            }
            Object var4_5 = null;
            this.writeUnlock();
            return;
        }
    }

    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        block4: {
            if (string == null || string.length() == 0) {
                return;
            }
            try {
                this.writeLock();
                UndoableEdit undoableEdit = this.data.insertString(n, string);
                DefaultDocumentEvent defaultDocumentEvent = new DefaultDocumentEvent(n, string.length(), DocumentEvent.EventType.INSERT);
                if (undoableEdit != null) {
                    defaultDocumentEvent.addEdit(undoableEdit);
                }
                this.insertUpdate(defaultDocumentEvent, attributeSet);
                defaultDocumentEvent.end();
                this.fireInsertUpdate(defaultDocumentEvent);
                if (undoableEdit == null) break block4;
                this.fireUndoableEditUpdate(new UndoableEditEvent(this, defaultDocumentEvent));
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                this.writeUnlock();
                throw throwable;
            }
        }
        Object var5_6 = null;
        this.writeUnlock();
    }

    public String getText(int n, int n2) throws BadLocationException {
        String string = this.data.getString(n, n2);
        return string;
    }

    public void getText(int n, int n2, Segment segment) throws BadLocationException {
        this.data.getChars(n, n2, segment);
    }

    public synchronized Position createPosition(int n) throws BadLocationException {
        return this.data.createPosition(n);
    }

    public final Position getStartPosition() {
        Position position;
        try {
            position = this.createPosition(0);
        }
        catch (BadLocationException badLocationException) {
            position = null;
        }
        return position;
    }

    public final Position getEndPosition() {
        Position position;
        try {
            position = this.createPosition(this.data.length());
        }
        catch (BadLocationException badLocationException) {
            position = null;
        }
        return position;
    }

    public Element[] getRootElements() {
        Element[] elementArray = new Element[]{this.getDefaultRootElement()};
        return elementArray;
    }

    public abstract Element getDefaultRootElement();

    protected final AttributeContext getAttributeContext() {
        return this.context;
    }

    protected void insertUpdate(DefaultDocumentEvent defaultDocumentEvent, AttributeSet attributeSet) {
    }

    protected void removeUpdate(DefaultDocumentEvent defaultDocumentEvent) {
    }

    public void dump(PrintStream printStream) {
        Element element = this.getDefaultRootElement();
        if (element instanceof AbstractElement) {
            ((AbstractElement)element).dump(printStream, 0);
        }
    }

    protected final Content getContent() {
        return this.data;
    }

    protected Element createLeafElement(Element element, AttributeSet attributeSet, int n, int n2) {
        return new LeafElement(element, attributeSet, n, n2);
    }

    protected Element createBranchElement(Element element, AttributeSet attributeSet) {
        return new BranchElement(element, attributeSet);
    }

    protected final synchronized Thread getCurrentWriter() {
        return this.currWriter;
    }

    protected final synchronized void writeLock() {
        try {
            while (this.numReaders > 0 || this.currWriter != null) {
                this.wait();
            }
            this.currWriter = Thread.currentThread();
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    protected final synchronized void writeUnlock() {
        if (this.numReaders > 0 || this.currWriter == null) {
            throw new StateInvariantError(BAD_LOCK_STATE);
        }
        this.currWriter = null;
        this.notify();
    }

    protected final synchronized void readLock() {
        try {
            while (this.currWriter != null) {
                this.wait();
            }
            ++this.numReaders;
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    protected final synchronized void readUnlock() {
        if (this.numReaders <= 0) {
            throw new StateInvariantError(BAD_LOCK_STATE);
        }
        --this.numReaders;
        this.notify();
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.listenerList = new EventListenerList();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public interface Content {
        public Position createPosition(int var1) throws BadLocationException;

        public int length();

        public UndoableEdit insertString(int var1, String var2) throws BadLocationException;

        public UndoableEdit remove(int var1, int var2) throws BadLocationException;

        public String getString(int var1, int var2) throws BadLocationException;

        public void getChars(int var1, int var2, Segment var3) throws BadLocationException;
    }

    public interface AttributeContext {
        public AttributeSet addAttribute(AttributeSet var1, Object var2, Object var3);

        public AttributeSet addAttributes(AttributeSet var1, AttributeSet var2);

        public AttributeSet removeAttribute(AttributeSet var1, Object var2);

        public AttributeSet removeAttributes(AttributeSet var1, Enumeration var2);

        public AttributeSet removeAttributes(AttributeSet var1, AttributeSet var2);

        public AttributeSet getEmptySet();

        public void reclaim(AttributeSet var1);
    }

    public abstract class AbstractElement
    implements Element,
    MutableAttributeSet,
    Serializable {
        private Element parent;
        private transient AttributeSet attributes;

        public AbstractElement(Element element, AttributeSet attributeSet) {
            AbstractDocument.this = AbstractDocument.this;
            this.attributes = attributeSet != null ? attributeSet.copyAttributes() : AbstractDocument.this.getAttributeContext().getEmptySet();
            this.parent = element;
        }

        private final void indent(PrintStream printStream, int n) {
            int n2 = 0;
            while (n2 < n) {
                printStream.print("  ");
                ++n2;
            }
        }

        public void dump(PrintStream printStream, int n) {
            Object object;
            Object object2;
            this.indent(printStream, n);
            if (this.getName() == null) {
                printStream.print("<??");
            } else {
                printStream.print("<" + this.getName());
            }
            if (this.getAttributeCount() > 0) {
                printStream.println("");
                object2 = this.attributes.getAttributeNames();
                while (object2.hasMoreElements()) {
                    object = object2.nextElement();
                    this.indent(printStream, n + 1);
                    printStream.println(String.valueOf(object) + "=" + this.getAttribute(object));
                }
                this.indent(printStream, n);
            }
            printStream.println(">");
            if (this.isLeaf()) {
                this.indent(printStream, n + 1);
                printStream.print("[" + this.getStartOffset() + "," + this.getEndOffset() + "]");
                object2 = AbstractDocument.this.getContent();
                try {
                    object = object2.getString(this.getStartOffset(), this.getEndOffset() - this.getStartOffset()).trim();
                    if (((String)object).length() > 40) {
                        object = String.valueOf(((String)object).substring(0, 40)) + "...";
                    }
                    printStream.println((String)object);
                    return;
                }
                catch (BadLocationException badLocationException) {
                    return;
                }
            }
            int n2 = this.getElementCount();
            int n3 = 0;
            while (n3 < n2) {
                AbstractElement abstractElement = (AbstractElement)this.getElement(n3);
                abstractElement.dump(printStream, n + 1);
                ++n3;
            }
        }

        protected void finalize() throws Throwable {
            AttributeContext attributeContext = AbstractDocument.this.getAttributeContext();
            attributeContext.reclaim(this.attributes);
        }

        public int getAttributeCount() {
            return this.attributes.getAttributeCount();
        }

        public boolean isDefined(Object object) {
            return this.attributes.isDefined(object);
        }

        public boolean isEqual(AttributeSet attributeSet) {
            return this.attributes.isEqual(attributeSet);
        }

        public AttributeSet copyAttributes() {
            return this.attributes;
        }

        public Object getAttribute(Object object) {
            Object object2 = this.attributes.getAttribute(object);
            if (object2 == null) {
                AttributeSet attributeSet;
                AttributeSet attributeSet2 = attributeSet = this.parent != null ? this.parent.getAttributes() : null;
                if (attributeSet != null) {
                    object2 = attributeSet.getAttribute(object);
                }
            }
            return object2;
        }

        public Enumeration getAttributeNames() {
            return this.attributes.getAttributeNames();
        }

        public boolean containsAttribute(Object object, Object object2) {
            return this.attributes.containsAttribute(object, object2);
        }

        public boolean containsAttributes(AttributeSet attributeSet) {
            return this.attributes.containsAttributes(attributeSet);
        }

        public AttributeSet getResolveParent() {
            AttributeSet attributeSet = this.attributes.getResolveParent();
            if (attributeSet == null && this.parent != null) {
                attributeSet = this.parent.getAttributes();
            }
            return attributeSet;
        }

        public void addAttribute(Object object, Object object2) {
            this.checkForIllegalCast();
            AttributeContext attributeContext = AbstractDocument.this.getAttributeContext();
            this.attributes = attributeContext.addAttribute(this.attributes, object, object2);
        }

        public void addAttributes(AttributeSet attributeSet) {
            this.checkForIllegalCast();
            AttributeContext attributeContext = AbstractDocument.this.getAttributeContext();
            this.attributes = attributeContext.addAttributes(this.attributes, attributeSet);
        }

        public void removeAttribute(Object object) {
            this.checkForIllegalCast();
            AttributeContext attributeContext = AbstractDocument.this.getAttributeContext();
            this.attributes = attributeContext.removeAttribute(this.attributes, object);
        }

        public void removeAttributes(Enumeration enumeration) {
            this.checkForIllegalCast();
            AttributeContext attributeContext = AbstractDocument.this.getAttributeContext();
            this.attributes = attributeContext.removeAttributes(this.attributes, enumeration);
        }

        public void removeAttributes(AttributeSet attributeSet) {
            this.checkForIllegalCast();
            AttributeContext attributeContext = AbstractDocument.this.getAttributeContext();
            if (attributeSet == this) {
                this.attributes = attributeContext.getEmptySet();
                return;
            }
            this.attributes = attributeContext.removeAttributes(this.attributes, attributeSet);
        }

        public void setResolveParent(AttributeSet attributeSet) {
            this.checkForIllegalCast();
            AttributeContext attributeContext = AbstractDocument.this.getAttributeContext();
            if (attributeSet != null) {
                this.attributes = attributeContext.addAttribute(this.attributes, StyleConstants.ResolveAttribute, attributeSet);
                return;
            }
            this.attributes = attributeContext.removeAttribute(this.attributes, StyleConstants.ResolveAttribute);
        }

        private final void checkForIllegalCast() {
            Thread thread = AbstractDocument.this.getCurrentWriter();
            if (thread == null || thread != Thread.currentThread()) {
                throw new StateInvariantError("Illegal cast to MutableAttributeSet");
            }
        }

        public Document getDocument() {
            return AbstractDocument.this;
        }

        public Element getParentElement() {
            return this.parent;
        }

        public AttributeSet getAttributes() {
            return this;
        }

        public String getName() {
            if (this.attributes.isDefined(AbstractDocument.ElementNameAttribute)) {
                return (String)this.attributes.getAttribute(AbstractDocument.ElementNameAttribute);
            }
            return null;
        }

        public abstract int getStartOffset();

        public abstract int getEndOffset();

        public abstract Element getElement(int var1);

        public abstract int getElementCount();

        public abstract int getElementIndex(int var1);

        public abstract boolean isLeaf();

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
            StyleContext.writeAttributeSet(objectOutputStream, this.attributes);
        }

        private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
            objectInputStream.defaultReadObject();
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            StyleContext.readAttributeSet(objectInputStream, simpleAttributeSet);
            AttributeContext attributeContext = AbstractDocument.this.getAttributeContext();
            this.attributes = attributeContext.addAttributes(SimpleAttributeSet.EMPTY, simpleAttributeSet);
        }
    }

    public class BranchElement
    extends AbstractElement {
        private AbstractElement[] children = new AbstractElement[1];
        private int nchildren = 0;
        private int lastIndex = -1;

        public BranchElement(Element element, AttributeSet attributeSet) {
            super(element, attributeSet);
            AbstractDocument.this = AbstractDocument.this;
        }

        public Element positionToElement(int n) {
            int n2 = this.getElementIndex(n);
            AbstractElement abstractElement = this.children[n2];
            int n3 = abstractElement.getStartOffset();
            int n4 = abstractElement.getEndOffset();
            if (n >= n3 && n < n4) {
                return abstractElement;
            }
            return null;
        }

        public void replace(int n, int n2, Element[] elementArray) {
            int n3 = elementArray.length - n2;
            int n4 = n + n2;
            int n5 = this.nchildren - n4;
            int n6 = n4 + n3;
            if (this.nchildren + n3 >= this.children.length) {
                int n7 = Math.max(2 * this.children.length, this.nchildren + n3);
                AbstractElement[] abstractElementArray = new AbstractElement[n7];
                System.arraycopy(this.children, 0, abstractElementArray, 0, n);
                System.arraycopy(elementArray, 0, abstractElementArray, n, elementArray.length);
                System.arraycopy(this.children, n4, abstractElementArray, n6, n5);
                this.children = abstractElementArray;
            } else {
                System.arraycopy(this.children, n4, this.children, n6, n5);
                System.arraycopy(elementArray, 0, this.children, n, elementArray.length);
            }
            this.nchildren += n3;
        }

        public String toString() {
            return "BranchElement(" + this.getName() + ") " + this.getStartOffset() + "," + this.getEndOffset() + "\n";
        }

        public String getName() {
            String string = super.getName();
            if (string == null) {
                string = AbstractDocument.ParagraphElementName;
            }
            return string;
        }

        public int getStartOffset() {
            return this.children[0].getStartOffset();
        }

        public int getEndOffset() {
            AbstractElement abstractElement = this.children[this.nchildren - 1];
            return abstractElement.getEndOffset();
        }

        public Element getElement(int n) {
            if (n < this.nchildren) {
                return this.children[n];
            }
            return null;
        }

        public int getElementCount() {
            return this.nchildren;
        }

        public int getElementIndex(int n) {
            int n2;
            AbstractElement abstractElement;
            int n3 = 0;
            int n4 = this.nchildren - 1;
            int n5 = 0;
            int n6 = this.getStartOffset();
            if (this.nchildren == 0) {
                return 0;
            }
            if (n >= this.getEndOffset()) {
                return this.nchildren - 1;
            }
            if (this.lastIndex >= n3 && this.lastIndex <= n4) {
                abstractElement = this.children[this.lastIndex];
                n6 = abstractElement.getStartOffset();
                n2 = abstractElement.getEndOffset();
                if (n >= n6 && n < n2) {
                    return this.lastIndex;
                }
                if (n < n6) {
                    n4 = this.lastIndex;
                } else {
                    n3 = this.lastIndex;
                }
            }
            while (n3 <= n4) {
                n5 = n3 + (n4 - n3) / 2;
                abstractElement = this.children[n5];
                n6 = abstractElement.getStartOffset();
                n2 = abstractElement.getEndOffset();
                if (n >= n6 && n < n2) {
                    int n7;
                    this.lastIndex = n7 = n5;
                    return n7;
                }
                if (n < n6) {
                    n4 = n5 - 1;
                    continue;
                }
                n3 = n5 + 1;
            }
            int n8 = n < n6 ? n5 : n5 + 1;
            this.lastIndex = n8;
            return n8;
        }

        public boolean isLeaf() {
            return false;
        }
    }

    public class LeafElement
    extends AbstractElement {
        private transient Position p0;
        private transient Position p1;

        public LeafElement(Element element, AttributeSet attributeSet, int n, int n2) {
            super(element, attributeSet);
            AbstractDocument.this = AbstractDocument.this;
            try {
                this.p0 = AbstractDocument.this.createPosition(n);
                this.p1 = AbstractDocument.this.createPosition(n2);
                return;
            }
            catch (BadLocationException badLocationException) {
                this.p0 = null;
                this.p1 = null;
                throw new StateInvariantError("Can't create Position references");
            }
        }

        public String toString() {
            return "LeafElement(" + this.getName() + ") " + this.p0 + "," + this.p1 + "\n";
        }

        public int getStartOffset() {
            return this.p0.getOffset();
        }

        public int getEndOffset() {
            return this.p1.getOffset();
        }

        public String getName() {
            String string = super.getName();
            if (string == null) {
                string = AbstractDocument.ContentElementName;
            }
            return string;
        }

        public int getElementIndex(int n) {
            return -1;
        }

        public Element getElement(int n) {
            return null;
        }

        public int getElementCount() {
            return 0;
        }

        public boolean isLeaf() {
            return true;
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
            objectOutputStream.writeInt(this.p0.getOffset());
            objectOutputStream.writeInt(this.p1.getOffset());
        }

        private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
            objectInputStream.defaultReadObject();
            int n = objectInputStream.readInt();
            int n2 = objectInputStream.readInt();
            try {
                this.p0 = AbstractDocument.this.createPosition(n);
                this.p1 = AbstractDocument.this.createPosition(n2);
                return;
            }
            catch (BadLocationException badLocationException) {
                this.p0 = null;
                this.p1 = null;
                throw new IOException("Can't restore Position references");
            }
        }
    }

    public class DefaultDocumentEvent
    extends CompoundEdit
    implements DocumentEvent {
        private int offset;
        private int length;
        private Hashtable changeLookup;
        private DocumentEvent.EventType type;

        public DefaultDocumentEvent(int n, int n2, DocumentEvent.EventType eventType) {
            AbstractDocument.this = AbstractDocument.this;
            this.offset = n;
            this.length = n2;
            this.type = eventType;
        }

        public String toString() {
            return this.edits.toString();
        }

        public boolean addEdit(UndoableEdit undoableEdit) {
            if (this.changeLookup == null && this.edits.size() > 10) {
                this.changeLookup = new Hashtable();
                int n = this.edits.size();
                int n2 = 0;
                while (n2 < n) {
                    Object e = this.edits.elementAt(n2);
                    if (e instanceof DocumentEvent.ElementChange) {
                        DocumentEvent.ElementChange elementChange = (DocumentEvent.ElementChange)e;
                        this.changeLookup.put(elementChange.getElement(), elementChange);
                    }
                    ++n2;
                }
            }
            if (this.changeLookup != null && undoableEdit instanceof DocumentEvent.ElementChange) {
                DocumentEvent.ElementChange elementChange = (DocumentEvent.ElementChange)((Object)undoableEdit);
                this.changeLookup.put(elementChange.getElement(), elementChange);
            }
            return super.addEdit(undoableEdit);
        }

        public void redo() throws CannotRedoException {
            block4: {
                AbstractDocument.this.writeLock();
                try {
                    super.redo();
                    if (this.type == DocumentEvent.EventType.INSERT) {
                        AbstractDocument.this.fireInsertUpdate(this);
                        break block4;
                    }
                    if (this.type == DocumentEvent.EventType.REMOVE) {
                        AbstractDocument.this.fireRemoveUpdate(this);
                        break block4;
                    }
                    AbstractDocument.this.fireChangedUpdate(this);
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    AbstractDocument.this.writeUnlock();
                    throw throwable;
                }
            }
            Object var2_1 = null;
            AbstractDocument.this.writeUnlock();
        }

        public void undo() throws CannotUndoException {
            block4: {
                AbstractDocument.this.writeLock();
                try {
                    super.undo();
                    if (this.type == DocumentEvent.EventType.REMOVE) {
                        AbstractDocument.this.fireInsertUpdate(this);
                        break block4;
                    }
                    if (this.type == DocumentEvent.EventType.INSERT) {
                        AbstractDocument.this.fireRemoveUpdate(this);
                        break block4;
                    }
                    AbstractDocument.this.fireChangedUpdate(this);
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    AbstractDocument.this.writeUnlock();
                    throw throwable;
                }
            }
            Object var2_1 = null;
            AbstractDocument.this.writeUnlock();
        }

        public boolean isSignificant() {
            return true;
        }

        public String getPresentationName() {
            DocumentEvent.EventType eventType = this.getType();
            if (eventType == DocumentEvent.EventType.INSERT) {
                return "addition";
            }
            if (eventType == DocumentEvent.EventType.REMOVE) {
                return "deletion";
            }
            return "style change";
        }

        public String getUndoPresentationName() {
            return "Undo " + this.getPresentationName();
        }

        public String getRedoPresentationName() {
            return "Redo " + this.getPresentationName();
        }

        public DocumentEvent.EventType getType() {
            return this.type;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLength() {
            return this.length;
        }

        public Document getDocument() {
            return AbstractDocument.this;
        }

        public DocumentEvent.ElementChange getChange(Element element) {
            if (this.changeLookup != null) {
                return (DocumentEvent.ElementChange)this.changeLookup.get(element);
            }
            int n = this.edits.size();
            int n2 = 0;
            while (n2 < n) {
                DocumentEvent.ElementChange elementChange;
                Object e = this.edits.elementAt(n2);
                if (e instanceof DocumentEvent.ElementChange && (elementChange = (DocumentEvent.ElementChange)e).getElement() == element) {
                    return elementChange;
                }
                ++n2;
            }
            return null;
        }
    }

    public static class ElementEdit
    extends AbstractUndoableEdit
    implements DocumentEvent.ElementChange {
        private Element e;
        private int index;
        private Element[] removed;
        private Element[] added;

        public ElementEdit(Element element, int n, Element[] elementArray, Element[] elementArray2) {
            this.e = element;
            this.index = n;
            this.removed = elementArray;
            this.added = elementArray2;
        }

        public Element getElement() {
            return this.e;
        }

        public int getIndex() {
            return this.index;
        }

        public Element[] getChildrenRemoved() {
            return this.removed;
        }

        public Element[] getChildrenAdded() {
            return this.added;
        }

        public void redo() throws CannotRedoException {
            super.redo();
            Element[] elementArray = this.removed;
            this.removed = this.added;
            this.added = elementArray;
            ((BranchElement)this.e).replace(this.index, this.removed.length, this.added);
        }

        public void undo() throws CannotUndoException {
            super.undo();
            ((BranchElement)this.e).replace(this.index, this.added.length, this.removed);
            Element[] elementArray = this.removed;
            this.removed = this.added;
            this.added = elementArray;
        }
    }
}

