/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.table;

import com.sun.java.swing.JTable;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.table.DefaultTableCellRenderer;
import com.sun.java.swing.table.JTableHeader;
import com.sun.java.swing.table.TableCellEditor;
import com.sun.java.swing.table.TableCellRenderer;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;

public class TableColumn
implements Serializable {
    public static final String COLUMN_WIDTH_PROPERTY = "columWidth";
    public static final String HEADER_VALUE_PROPERTY = "headerValue";
    public static final String HEADER_RENDERER_PROPERTY = "headerRenderer";
    public static final String CELL_RENDERER_PROPERTY = "cellRenderer";
    protected int modelIndex;
    protected Object identifier;
    protected int width;
    protected int minWidth;
    protected int maxWidth;
    protected TableCellRenderer headerRenderer;
    protected Object headerValue;
    protected TableCellRenderer cellRenderer;
    protected TableCellEditor cellEditor;
    protected boolean isResizable;
    protected transient int resizedPostingDisableCount;
    private PropertyChangeSupport changeSupport;

    public TableColumn() {
        this(0);
    }

    public TableColumn(int n) {
        this(n, 75, null, null);
    }

    public TableColumn(int n, int n2) {
        this(n, n2, null, null);
    }

    public TableColumn(int n, int n2, TableCellRenderer tableCellRenderer, TableCellEditor tableCellEditor) {
        this.modelIndex = n;
        this.width = n2;
        this.cellRenderer = tableCellRenderer;
        this.cellEditor = tableCellEditor;
        this.minWidth = 15;
        this.maxWidth = Integer.MAX_VALUE;
        this.isResizable = true;
        this.resizedPostingDisableCount = 0;
        this.setHeaderRenderer(this.createDefaultHeaderRenderer());
        this.headerValue = null;
    }

    public void setModelIndex(int n) {
        this.modelIndex = n;
    }

    public int getModelIndex() {
        return this.modelIndex;
    }

    public void setIdentifier(Object object) {
        this.identifier = object;
    }

    public Object getIdentifier() {
        if (this.identifier != null) {
            return this.identifier;
        }
        return this.getHeaderValue();
    }

    public void setHeaderRenderer(TableCellRenderer tableCellRenderer) {
        TableCellRenderer tableCellRenderer2 = this.headerRenderer;
        if (tableCellRenderer == null) {
            throw new IllegalArgumentException("Object is null");
        }
        this.headerRenderer = tableCellRenderer;
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(HEADER_RENDERER_PROPERTY, tableCellRenderer2, this.headerRenderer);
        }
    }

    public TableCellRenderer getHeaderRenderer() {
        return this.headerRenderer;
    }

    public void setHeaderValue(Object object) {
        Object object2 = this.headerValue;
        this.headerValue = object;
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(HEADER_VALUE_PROPERTY, object2, this.headerValue);
        }
    }

    public Object getHeaderValue() {
        return this.headerValue;
    }

    public void setCellRenderer(TableCellRenderer tableCellRenderer) {
        TableCellRenderer tableCellRenderer2 = this.cellRenderer;
        this.cellRenderer = tableCellRenderer;
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(CELL_RENDERER_PROPERTY, tableCellRenderer2, this.cellRenderer);
        }
    }

    public TableCellRenderer getCellRenderer() {
        return this.cellRenderer;
    }

    public void setCellEditor(TableCellEditor tableCellEditor) {
        this.cellEditor = tableCellEditor;
    }

    public TableCellEditor getCellEditor() {
        return this.cellEditor;
    }

    public void setWidth(int n) {
        int n2 = this.width;
        if (this.width == n) {
            return;
        }
        this.width = n;
        if (this.width < this.minWidth) {
            this.width = this.minWidth;
        } else if (this.width > this.maxWidth) {
            this.width = this.maxWidth;
        }
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(COLUMN_WIDTH_PROPERTY, new Integer(n2), new Integer(this.width));
        }
    }

    public int getWidth() {
        return this.width;
    }

    public void setMinWidth(int n) {
        this.minWidth = n;
        if (this.minWidth < 0) {
            this.minWidth = 0;
        }
        if (this.width < this.minWidth) {
            this.setWidth(this.minWidth);
        }
    }

    public int getMinWidth() {
        return this.minWidth;
    }

    public void setMaxWidth(int n) {
        this.maxWidth = n;
        if (this.maxWidth < 0) {
            this.maxWidth = 0;
        } else if (this.maxWidth < this.minWidth) {
            this.maxWidth = this.minWidth;
        }
        if (this.width > this.maxWidth) {
            this.setWidth(this.maxWidth);
        }
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void setResizable(boolean bl) {
        this.isResizable = bl;
    }

    public boolean getResizable() {
        return this.isResizable;
    }

    public void sizeWidthToFit() {
        Component component = this.getHeaderRenderer().getTableCellRendererComponent(null, this.getHeaderValue(), false, false, 0, 0);
        int n = component.getPreferredSize().width;
        if (n > this.getMaxWidth()) {
            this.setMaxWidth(n);
        }
        if (n < this.getMinWidth()) {
            this.setMinWidth(n);
        }
        this.setWidth(n);
    }

    public void disableResizedPosting() {
        ++this.resizedPostingDisableCount;
    }

    public void enableResizedPosting() {
        --this.resizedPostingDisableCount;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    protected TableCellRenderer createDefaultHeaderRenderer() {
        1 var1_1 = new 1();
        var1_1.setHorizontalAlignment(0);
        return var1_1;
    }

    private final class 1
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JTableHeader jTableHeader;
            if (jTable != null && (jTableHeader = jTable.getTableHeader()) != null) {
                this.setForeground(jTableHeader.getForeground());
                this.setBackground(jTableHeader.getBackground());
                this.setFont(jTableHeader.getFont());
            }
            this.setText(object == null ? "" : object.toString());
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            return this;
        }

        /* synthetic */ 1() {
        }
    }
}

