/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.event;

import com.sun.java.swing.tree.TreePath;
import java.util.EventObject;

public class TreeSelectionEvent
extends EventObject {
    protected TreePath[] paths;
    protected boolean[] areNew;
    protected TreePath oldLeadSelectionPath;
    protected TreePath newLeadSelectionPath;

    public TreeSelectionEvent(Object object, TreePath[] treePathArray, boolean[] blArray, TreePath treePath, TreePath treePath2) {
        super(object);
        this.paths = treePathArray;
        this.areNew = blArray;
        this.oldLeadSelectionPath = treePath;
        this.newLeadSelectionPath = treePath2;
    }

    public TreeSelectionEvent(Object object, TreePath treePath, boolean bl, TreePath treePath2, TreePath treePath3) {
        super(object);
        this.paths = new TreePath[1];
        this.paths[0] = treePath;
        this.areNew = new boolean[1];
        this.areNew[0] = bl;
        this.oldLeadSelectionPath = treePath2;
        this.newLeadSelectionPath = treePath3;
    }

    public TreePath[] getPaths() {
        int n = this.paths.length;
        TreePath[] treePathArray = new TreePath[n];
        System.arraycopy(this.paths, 0, treePathArray, 0, n);
        return treePathArray;
    }

    public TreePath getPath() {
        return this.paths[0];
    }

    public boolean isAddedPath() {
        return this.areNew[0];
    }

    public boolean isAddedPath(TreePath treePath) {
        int n = this.paths.length - 1;
        while (n >= 0) {
            if (this.paths[n].equals(treePath)) {
                return this.areNew[n];
            }
            --n;
        }
        throw new IllegalArgumentException("path is not a path identified by the TreeSelectionEvent");
    }

    public TreePath getOldLeadSelectionPath() {
        return this.oldLeadSelectionPath;
    }

    public TreePath getNewLeadSelectionPath() {
        return this.newLeadSelectionPath;
    }

    public Object cloneWithSource(Object object) {
        return new TreeSelectionEvent(object, this.paths, this.areNew, this.oldLeadSelectionPath, this.newLeadSelectionPath);
    }
}

