/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.event;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.EventListener;

public class EventListenerList
implements Serializable {
    private static final Object[] NULL_ARRAY = new Object[0];
    protected transient Object[] listenerList = NULL_ARRAY;

    public Object[] getListenerList() {
        return this.listenerList;
    }

    public int getListenerCount() {
        return this.listenerList.length / 2;
    }

    public int getListenerCount(Class clazz) {
        int n = 0;
        Object[] objectArray = this.listenerList;
        int n2 = 0;
        while (n2 < objectArray.length) {
            if (clazz == (Class)objectArray[n2]) {
                ++n;
            }
            n2 += 2;
        }
        return n;
    }

    public synchronized void add(Class clazz, EventListener eventListener) {
        if (!clazz.isInstance(eventListener)) {
            throw new IllegalArgumentException("Listener " + eventListener + " is not of type " + clazz);
        }
        if (eventListener == null) {
            throw new IllegalArgumentException("Listener " + eventListener + " is null");
        }
        if (this.listenerList == NULL_ARRAY) {
            this.listenerList = new Object[]{clazz, eventListener};
            return;
        }
        int n = this.listenerList.length;
        Object[] objectArray = new Object[n + 2];
        System.arraycopy(this.listenerList, 0, objectArray, 0, n);
        objectArray[n] = clazz;
        objectArray[n + 1] = eventListener;
        this.listenerList = objectArray;
    }

    public synchronized void remove(Class clazz, EventListener eventListener) {
        if (!clazz.isInstance(eventListener)) {
            throw new IllegalArgumentException("Listener " + eventListener + " is not of type " + clazz);
        }
        if (eventListener == null) {
            throw new IllegalArgumentException("Listener " + eventListener + " is null");
        }
        int n = -1;
        int n2 = this.listenerList.length - 2;
        while (n2 >= 0) {
            if (this.listenerList[n2] == clazz && this.listenerList[n2 + 1] == eventListener) {
                n = n2;
                break;
            }
            n2 -= 2;
        }
        if (n != -1) {
            Object[] objectArray = new Object[this.listenerList.length - 2];
            System.arraycopy(this.listenerList, 0, objectArray, 0, n);
            if (n < objectArray.length) {
                System.arraycopy(this.listenerList, n + 2, objectArray, n, objectArray.length - n);
            }
            this.listenerList = objectArray.length == 0 ? NULL_ARRAY : objectArray;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Object[] objectArray = this.listenerList;
        objectOutputStream.defaultWriteObject();
        int n = 0;
        while (n < objectArray.length) {
            Class clazz = (Class)objectArray[n];
            EventListener eventListener = (EventListener)objectArray[n + 1];
            if (eventListener != null && eventListener instanceof Serializable) {
                objectOutputStream.writeObject(clazz.getName());
                objectOutputStream.writeObject(eventListener);
            }
            n += 2;
        }
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object;
        this.listenerList = NULL_ARRAY;
        objectInputStream.defaultReadObject();
        while ((object = objectInputStream.readObject()) != null) {
            EventListener eventListener = (EventListener)objectInputStream.readObject();
            this.add(Class.forName((String)object), eventListener);
        }
    }

    public String toString() {
        Object[] objectArray = this.listenerList;
        String string = "EventListenerList: ";
        string = String.valueOf(string) + objectArray.length / 2 + " listeners: ";
        int n = 0;
        while (n <= objectArray.length - 2) {
            string = String.valueOf(string) + " type " + ((Class)objectArray[n]).getName();
            string = String.valueOf(string) + " listener " + objectArray[n + 1];
            n += 2;
        }
        return string;
    }
}

