/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing;

import com.sun.java.accessibility.Accessible;
import com.sun.java.accessibility.AccessibleContext;
import com.sun.java.accessibility.AccessibleRole;
import com.sun.java.accessibility.AccessibleState;
import com.sun.java.accessibility.AccessibleStateSet;
import com.sun.java.accessibility.AccessibleValue;
import com.sun.java.swing.BoundedRangeModel;
import com.sun.java.swing.DefaultBoundedRangeModel;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.SwingConstants;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.event.ChangeEvent;
import com.sun.java.swing.event.ChangeListener;
import com.sun.java.swing.plaf.SliderUI;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;

public class JSlider
extends JComponent
implements SwingConstants,
Accessible {
    protected BoundedRangeModel sliderModel;
    protected int majorTickSpacing;
    protected int minorTickSpacing;
    protected boolean snapToTicks = true;
    private boolean paintTicks = false;
    private boolean paintLabels = false;
    private boolean isInverted = false;
    protected int orientation;
    private Dictionary labelTable;
    protected ChangeListener changeListener = this.createChangeListener();
    protected transient ChangeEvent changeEvent;
    static /* synthetic */ Class class$com$sun$java$swing$event$ChangeListener;

    private void checkOrientation(int n) {
        switch (n) {
            default: {
                throw new IllegalArgumentException("orientation must be one of: VERTICAL, HORIZONTAL");
            }
            case 0: 
            case 1: 
        }
    }

    public JSlider(int n, int n2, int n3, int n4) {
        this.checkOrientation(n);
        this.orientation = n;
        this.sliderModel = new DefaultBoundedRangeModel(n4, 0, n2, n3);
        this.sliderModel.addChangeListener(this.changeListener);
        this.updateUI();
    }

    public JSlider() {
        this(0, 0, 100, 50);
    }

    public SliderUI getUI() {
        return (SliderUI)this.ui;
    }

    public void setUI(SliderUI sliderUI) {
        super.setUI(sliderUI);
    }

    public void updateUI() {
        this.updateLabelUIs();
        this.setUI((SliderUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return "SliderUI";
    }

    protected ChangeListener createChangeListener() {
        return new ModelListener();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(class$com$sun$java$swing$event$ChangeListener != null ? class$com$sun$java$swing$event$ChangeListener : (class$com$sun$java$swing$event$ChangeListener = JComponent.class$("com.sun.java.swing.event.ChangeListener")), changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(class$com$sun$java$swing$event$ChangeListener != null ? class$com$sun$java$swing$event$ChangeListener : (class$com$sun$java$swing$event$ChangeListener = JComponent.class$("com.sun.java.swing.event.ChangeListener")), changeListener);
    }

    protected void fireStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$com$sun$java$swing$event$ChangeListener != null ? class$com$sun$java$swing$event$ChangeListener : JComponent.class$("com.sun.java.swing.event.ChangeListener"))) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((ChangeListener)objectArray[n + 1]).stateChanged(this.changeEvent);
            }
            n -= 2;
        }
    }

    public BoundedRangeModel getModel() {
        return this.sliderModel;
    }

    public void setModel(BoundedRangeModel boundedRangeModel) {
        BoundedRangeModel boundedRangeModel2 = this.getModel();
        if (boundedRangeModel2 != null) {
            boundedRangeModel2.removeChangeListener(this.changeListener);
        }
        this.sliderModel = boundedRangeModel;
        if (boundedRangeModel != null) {
            boundedRangeModel.addChangeListener(this.changeListener);
            if (this.accessibleContext != null) {
                this.accessibleContext.firePropertyChange("AccessibleValue", boundedRangeModel2 == null ? null : new Integer(boundedRangeModel2.getValue()), boundedRangeModel == null ? null : new Integer(boundedRangeModel.getValue()));
            }
        }
        this.firePropertyChange("model", boundedRangeModel2, this.sliderModel);
    }

    public int getValue() {
        return this.getModel().getValue();
    }

    public void setValue(int n) {
        BoundedRangeModel boundedRangeModel = this.getModel();
        int n2 = boundedRangeModel.getValue();
        boundedRangeModel.setValue(n);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleValue", new Integer(n2), new Integer(boundedRangeModel.getValue()));
        }
    }

    public int getMinimum() {
        return this.getModel().getMinimum();
    }

    public void setMinimum(int n) {
        this.getModel().setMinimum(n);
    }

    public int getMaximum() {
        return this.getModel().getMaximum();
    }

    public void setMaximum(int n) {
        this.getModel().setMaximum(n);
    }

    public boolean getValueIsAdjusting() {
        return this.getModel().getValueIsAdjusting();
    }

    public void setValueIsAdjusting(boolean bl) {
        BoundedRangeModel boundedRangeModel = this.getModel();
        boolean bl2 = boundedRangeModel.getValueIsAdjusting();
        boundedRangeModel.setValueIsAdjusting(bl);
        if (bl2 != bl && this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleState", bl2 ? AccessibleState.BUSY : null, bl ? AccessibleState.BUSY : null);
        }
    }

    public int getExtent() {
        return this.getModel().getExtent();
    }

    public void setExtent(int n) {
        this.getModel().setExtent(n);
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int n) {
        this.checkOrientation(n);
        int n2 = n;
        this.orientation = n;
        this.firePropertyChange("orientation", n2, n);
        if (n2 != n && this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleState", n2 == 1 ? AccessibleState.VERTICAL : AccessibleState.HORIZONTAL, n == 1 ? AccessibleState.VERTICAL : AccessibleState.HORIZONTAL);
        }
    }

    public Dictionary getLabelTable() {
        return this.labelTable;
    }

    public void setLabelTable(Dictionary dictionary) {
        Dictionary dictionary2 = this.labelTable;
        this.labelTable = dictionary;
        this.updateLabelUIs();
        this.firePropertyChange("labelTable", dictionary2, this.labelTable);
    }

    protected void updateLabelUIs() {
        if (this.getLabelTable() == null) {
            return;
        }
        Enumeration enumeration = this.getLabelTable().keys();
        while (enumeration.hasMoreElements()) {
            Object v = this.getLabelTable().get(enumeration.nextElement());
            if (!(v instanceof JComponent)) continue;
            JComponent jComponent = (JComponent)v;
            jComponent.updateUI();
            jComponent.setSize(jComponent.getPreferredSize());
        }
    }

    public Hashtable createStandardLabels(int n) {
        return this.createStandardLabels(n, this.getMinimum());
    }

    public Hashtable createStandardLabels(int n, int n2) {
        if (n2 > this.getMaximum() || n2 < this.getMinimum()) {
            throw new IllegalArgumentException("Slider label start point out of range.");
        }
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        int n3 = n2;
        while (n3 <= this.getMaximum()) {
            hashtable.put(new Integer(n3), new JLabel(String.valueOf(n3), 0));
            n3 += n;
        }
        return hashtable;
    }

    public boolean getInverted() {
        return this.isInverted;
    }

    public void setInverted(boolean bl) {
        boolean bl2 = this.isInverted;
        this.isInverted = bl;
        this.firePropertyChange("inverted", bl2, this.isInverted);
    }

    public int getMajorTickSpacing() {
        return this.majorTickSpacing;
    }

    public void setMajorTickSpacing(int n) {
        int n2 = this.majorTickSpacing;
        this.majorTickSpacing = n;
        if (this.labelTable == null && this.getMajorTickSpacing() > 0 && this.getPaintLabels()) {
            this.setLabelTable(this.createStandardLabels(this.getMajorTickSpacing()));
        }
        this.firePropertyChange("majorTickSpacing", n2, this.majorTickSpacing);
    }

    public int getMinorTickSpacing() {
        return this.minorTickSpacing;
    }

    public void setMinorTickSpacing(int n) {
        int n2 = this.minorTickSpacing;
        this.minorTickSpacing = n;
        this.firePropertyChange("minorTickSpacing", n2, this.minorTickSpacing);
    }

    public boolean getSnapToTicks() {
        return this.snapToTicks;
    }

    public void setSnapToTicks(boolean bl) {
        boolean bl2 = this.snapToTicks;
        this.snapToTicks = bl;
        this.firePropertyChange("snapToTicks", bl2, this.snapToTicks);
    }

    public boolean getPaintTicks() {
        return this.paintTicks;
    }

    public void setPaintTicks(boolean bl) {
        boolean bl2 = this.paintTicks;
        this.paintTicks = bl;
        this.firePropertyChange("paintTicks", bl2, this.paintTicks);
    }

    public boolean getPaintLabels() {
        return this.paintLabels;
    }

    public void setPaintLabels(boolean bl) {
        boolean bl2 = this.paintLabels;
        this.paintLabels = bl;
        if (this.labelTable == null && this.getMajorTickSpacing() > 0) {
            this.setLabelTable(this.createStandardLabels(this.getMajorTickSpacing()));
        }
        this.firePropertyChange("paintLabels", bl2, this.paintLabels);
    }

    public String toString() {
        String string = "";
        if (!this.isEnabled() && !this.isVisible()) {
            string = "(not Enabled, not Visible)";
        } else if (!this.isEnabled()) {
            string = "(not Enabled)";
        } else if (!this.isVisible()) {
            string = "(not Visible)";
        }
        String string2 = String.valueOf(string) + (this.getOrientation() == 1 ? "vertical" : "horizontal") + ", " + "value=" + this.getValue() + ", " + "adj=" + this.getValueIsAdjusting() + ", " + "min=" + this.getMinimum() + ", " + "max=" + this.getMaximum() + ", " + "majorTickSpacing=" + this.getMajorTickSpacing() + ", " + "minorTickSpacing=" + this.getMinorTickSpacing() + ", " + "snapToTicks=" + this.getSnapToTicks() + ", " + "isInverted=" + this.getInverted() + ", " + "paintLabels=" + this.getPaintLabels() + ", " + "paintTicks=" + this.getPaintTicks();
        return String.valueOf(this.getClass().getName()) + "[" + string2 + "]";
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJSlider();
        }
        return this.accessibleContext;
    }

    private class ModelListener
    implements ChangeListener,
    Serializable {
        public void stateChanged(ChangeEvent changeEvent) {
            JSlider.this.fireStateChanged();
        }

        ModelListener() {
            JSlider.this = JSlider.this;
        }
    }

    protected class AccessibleJSlider
    extends JComponent.AccessibleJComponent
    implements AccessibleValue {
        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (JSlider.this.getValueIsAdjusting()) {
                accessibleStateSet.add(AccessibleState.BUSY);
            }
            if (JSlider.this.getOrientation() == 1) {
                accessibleStateSet.add(AccessibleState.VERTICAL);
            } else {
                accessibleStateSet.add(AccessibleState.HORIZONTAL);
            }
            return accessibleStateSet;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SLIDER;
        }

        public AccessibleValue getAccessibleValue() {
            return this;
        }

        public Number getCurrentAccessibleValue() {
            return new Integer(JSlider.this.getValue());
        }

        public boolean setCurrentAccessibleValue(Number number) {
            if (number instanceof Integer) {
                JSlider.this.setValue(number.intValue());
                return true;
            }
            return false;
        }

        public Number getMinimumAccessibleValue() {
            return new Integer(JSlider.this.getMinimum());
        }

        public Number getMaximumAccessibleValue() {
            return new Integer(JSlider.this.getMaximum());
        }

        AccessibleJSlider() {
            JSlider.this = JSlider.this;
        }
    }
}

