/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Color;
import java.awt.Font;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;

public abstract class LookAndFeel {
    private static ModifierKeyword[] modifierKeywords = new ModifierKeyword[]{new ModifierKeyword("shift", 1), new ModifierKeyword("control", 2), new ModifierKeyword("meta", 4), new ModifierKeyword("alt", 8), new ModifierKeyword("button1", 16), new ModifierKeyword("button2", 8), new ModifierKeyword("button3", 4)};
    static /* synthetic */ Class class$java$awt$event$KeyEvent;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public UIDefaults getDefaults() {
        return null;
    }

    public abstract String getDescription();

    public abstract String getID();

    public abstract String getName();

    public void initialize() {
    }

    public static void installBorder(JComponent jComponent, String string) {
        Border border = jComponent.getBorder();
        if (border == null || border instanceof UIResource) {
            jComponent.setBorder(UIManager.getBorder(string));
        }
    }

    public static void installColors(JComponent jComponent, String string, String string2) {
        Color color;
        Color color2 = jComponent.getBackground();
        if (color2 == null || color2 instanceof UIResource) {
            jComponent.setBackground(UIManager.getColor(string));
        }
        if ((color = jComponent.getForeground()) == null || color instanceof UIResource) {
            jComponent.setForeground(UIManager.getColor(string2));
        }
    }

    public static void installColorsAndFont(JComponent jComponent, String string, String string2, String string3) {
        Font font = jComponent.getFont();
        if (font == null || font instanceof UIResource) {
            jComponent.setFont(UIManager.getFont(string3));
        }
        LookAndFeel.installColors(jComponent, string, string2);
    }

    public abstract boolean isNativeLookAndFeel();

    public abstract boolean isSupportedLookAndFeel();

    public static Object makeIcon(final Class clazz, final String string) {
        return new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults uIDefaults) {
                byte[][] byArray = new byte[1][];
                SwingUtilities.doPrivileged(new Runnable(clazz, byArray, string){
                    private final /* synthetic */ byte[][] val$buffer;
                    private final /* synthetic */ String val$gifFile;
                    private final /* synthetic */ Class val$baseClass;
                    {
                        this.val$baseClass = clazz;
                        this.val$buffer = byArray;
                        this.val$gifFile = string;
                    }

                    public void run() {
                        try {
                            int n;
                            InputStream inputStream = this.val$baseClass.getResourceAsStream(this.val$gifFile);
                            if (inputStream == null) {
                                return;
                            }
                            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
                            this.val$buffer[0] = new byte[1024];
                            while ((n = bufferedInputStream.read(this.val$buffer[0])) > 0) {
                                byteArrayOutputStream.write(this.val$buffer[0], 0, n);
                            }
                            ((FilterInputStream)bufferedInputStream).close();
                            byteArrayOutputStream.flush();
                            this.val$buffer[0] = byteArrayOutputStream.toByteArray();
                        }
                        catch (IOException iOException) {
                            System.err.println(iOException.toString());
                            return;
                        }
                    }
                });
                if (byArray[0] == null) {
                    System.err.println(String.valueOf(clazz.getName()) + "/" + string + " not found.");
                    return null;
                }
                if (byArray[0].length == 0) {
                    System.err.println("warning: " + string + " is zero-length");
                    return null;
                }
                return new IconUIResource(new ImageIcon(byArray[0]));
            }
        };
    }

    public static JTextComponent.KeyBinding[] makeKeyBindings(Object[] objectArray) {
        JTextComponent.KeyBinding[] keyBindingArray = new JTextComponent.KeyBinding[objectArray.length / 2];
        int n = 0;
        while (n < objectArray.length) {
            KeyStroke keyStroke = objectArray[n] instanceof KeyStroke ? (KeyStroke)objectArray[n] : LookAndFeel.parseKeyStroke((String)objectArray[n]);
            String string = (String)objectArray[n + 1];
            keyBindingArray[n / 2] = new JTextComponent.KeyBinding(keyStroke, string);
            n += 2;
        }
        return keyBindingArray;
    }

    private static KeyStroke parseKeyStroke(String string) {
        String string2;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = 0;
        while ((string2 = stringTokenizer.nextToken()) != null) {
            int n2;
            int n3 = 0;
            int n4 = 0;
            while (n3 == 0 && n4 < modifierKeywords.length) {
                n3 = modifierKeywords[n4].getModifierMask(string2);
                ++n4;
            }
            if (n3 != 0) {
                n |= n3;
                continue;
            }
            String string3 = "VK_" + string2;
            try {
                n2 = (class$java$awt$event$KeyEvent != null ? class$java$awt$event$KeyEvent : (class$java$awt$event$KeyEvent = LookAndFeel.class$("java.awt.event.KeyEvent"))).getField(string3).getInt(class$java$awt$event$KeyEvent != null ? class$java$awt$event$KeyEvent : (class$java$awt$event$KeyEvent = LookAndFeel.class$("java.awt.event.KeyEvent")));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new Error("Unrecognized keycode name: " + string3);
            }
            return KeyStroke.getKeyStroke(n2, n);
        }
        throw new Error("Can't parse KeyStroke: \"" + string + "\"");
    }

    public String toString() {
        return "[" + this.getDescription() + " - " + this.getClass().getName() + "]";
    }

    public void uninitialize() {
    }

    public static void uninstallBorder(JComponent jComponent) {
        if (jComponent.getBorder() instanceof UIResource) {
            jComponent.setBorder(null);
        }
    }

    private static class ModifierKeyword {
        final String keyword;
        final int mask;

        ModifierKeyword(String string, int n) {
            this.keyword = string;
            this.mask = n;
        }

        int getModifierMask(String string) {
            return string.equals(this.keyword) ? this.mask : 0;
        }
    }
}

