/***************************************************************************
                          newvolume.cpp  -  description
                             -------------------
    begin                : Wed Feb 14 2001
    copyright            : (C) 2001 by Stefano Brustia
    email                : hio@lombardiacom.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "newvolume.h"
#include "resources.h"

#include <qlabel.h>
#include <kmessagebox.h>
#include <kfiledialog.h>
#include <klocale.h>
#include <kconfig.h>
#include <kapp.h>

#include <kurlcompletion.h>
#include <kcompletionbox.h>
#include <iostream.h>

NewVolume::NewVolume (MyDb* db, QWidget* parent, const char* name)
     :QDialog (parent, name, TRUE)
{
    this->db = db;
     initDialog();
     setOptions();
     connect (butdirdial, SIGNAL (clicked()), this, SLOT (slotbutdirdial()));
     connect (butok, SIGNAL(clicked()), SLOT (slotbutok()));
     connect (butcancel, SIGNAL(clicked()), SLOT (slotbutcancel()));
}

void NewVolume::initDialog()
{
     setCaption(i18n("New Volume"));

     QGridLayout* grid = new QGridLayout (this,4,3,8,14);



     recursive= new QCheckBox(this, "check_recursive");
     grid->addWidget (recursive, 0,0);
     recursive->setText ( i18n("Recursive"));


     QLabel *lvolname= new QLabel(i18n("Volume Name"), this);
     lvolname->resize( lvolname->sizeHint() );
     grid->addWidget(lvolname,0,2);

     volname = new QLineEdit(this);
     volname->setMaxLength(MAX_VOLUME_L);
     grid->addWidget(volname,0,1);

    lvolname->setBuddy (volname);

     grid->addRowSpacing (0, 40);

     QGroupBox* group = new QGroupBox (this);
     group->setTitle(i18n("Base Directory"));
     group->setLineWidth(1);
     group->setMidLineWidth( 0 );
     grid->addMultiCellWidget(group, 1, 2, 0, 2);

     QGridLayout* grid1 = new QGridLayout (group, 1, 2, 15, 4);


		 dir = new KComboBox(true, group);
     grid1->addWidget(dir,0,0);

		 // To go into kcompletionbox when press tab (default it go to next object in widget)
		 dir->completionBox()->setTabHandling( true );
		dir->setFixedWidth (320);
		KURLCompletion *comp = new KURLCompletion(KURLCompletion::FileCompletion);
		dir->setCompletionObject( comp );

	//That is to complete the path into kcombox when press TAB key
		 connect( dir->completionBox(), SIGNAL( highlighted( const QString & )),
             dir, SLOT( setEditText ( const QString & )));

     butdirdial = new QPushButton (group, "Dir..." );
     butdirdial->setText ("...");
     butdirdial->setFixedWidth (30);
     grid1->addWidget (butdirdial, 0,1);



     butok = new QPushButton (this, "Push_Ok");
     butok->resize (butok->sizeHint() );
     butok->setText( i18n("Ok") );
     grid->addWidget (butok, 3,0);


     butcancel = new QPushButton( this, "Push_Cancel" );
     grid->addWidget(butcancel,3,2);
     butcancel->resize (butcancel->sizeHint() );
     butcancel->setText( i18n("Cancel") );


     volname->setFocus();

     resize (340, 220);
}

void NewVolume::setOptions()
{
     KConfig* config;

     config = kapp->config();

     config->setGroup("OPTIONS");
          recursive->setChecked(config->readBoolEntry("RecursiveVol", false));
					lastDirs = config->readListEntry ("LastDirs");
	if (!(lastDirs.isEmpty()))
	{
		for (uint i=0; i < lastDirs.count(); i++)
			dir->insertItem(lastDirs[i]);
		dir->setCurrentItem(-1);
	}
}


QString NewVolume::getDirBase()
{
     return (dir->currentText());
}

QString NewVolume::getVolName()
{
     return (volname->text());
}

bool NewVolume::getRecursive()
{
     return (recursive->isChecked());
}

// Slot implementation

void NewVolume::slotbutok()
{
     //MYSQL_RES* res;
     MYSQL_ROW row;
     QString vol;

   if ((volname->text()=="") || (dir->currentText()=="") )
     {
       KMessageBox::sorry( this, i18n("Volume Name and \n"
                                      "Directory Base \n\n"
                                      "Must be NOT NULL !!"  ));
       return;
     }
QDir info (dir->currentText());
	if (!(info.exists()))
	{
       KMessageBox::sorry( this, i18n("This Directory \n"
                                      "doesn't exist or \n"
																			"it is not a directory !"));
       return;
     }
   db->getVolname();
   cerr << "query fatta" << endl;
   while ((row=db->getRow()))
   {
     vol = row[0];
     if (vol == volname->text())
     {
          KMessageBox::sorry( this, i18n("Another Volume exists \n"
                                              "with the same name !"  ));
          return;
     }
   }
   db->freeRes();

	 // next code to save or not the current directory in history
	 bool found = false;
	 for (uint i=0; i<lastDirs.count(); i++)
	 	if (lastDirs[i] == dir->currentText())
		{
			lastDirs.remove(lastDirs.at(i));
			lastDirs.prepend(dir->currentText());
			found = true;
			break;
		}
	if ( !found /*&& !(lastDirs.isEmpty())*/)
	{
		cerr << " NOT dupl" << endl;
		if ( lastDirs.count() > 9 )
			lastDirs.remove(lastDirs.last());
		lastDirs.prepend (dir->currentText());
	}

	//write history in config file
	KConfig* config;

	config = kapp->config();
		config->setGroup("OPTIONS");
		config->writeEntry("LastDirs", lastDirs);

   done(0);
}

void NewVolume::slotbutcancel()
{
    done(1);
}

void NewVolume::slotbutdirdial()
{
	QString dirbase;
	if (dir->currentText().isEmpty())
		dirbase = KFileDialog::getExistingDirectory(QDir::homeDirPath(), this, i18n("Add Volume..."));
	else
		dirbase = KFileDialog::getExistingDirectory(dir->currentText(), this, i18n("Add Volume..."));
	dir->setEditText(dirbase);
}

#include "newvolume.moc"
