/***************************************************************************
                          item.h  -  description
                             -------------------
    begin                : Fri Mar 16 2001
    copyright            : (C) 2001 by Stefano Brustia
    email                : hio@lombardiacom.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef ITEM_H
#define ITEM_H

#include <qlistview.h>

class Mp3ListItem : public QListViewItem
{
public:
     Mp3ListItem (QListView* parent, int mp3id, int length);
		Mp3ListItem (QListViewItem* parent, int mp3id, int length);
     ~Mp3ListItem();

     Mp3ListItem* itemBelow();
     Mp3ListItem* itemAbove();
     int getMp3id() const;
     int getLength() const;

private:
     int mp3id;
     int length;

};

class PLListItem : public QListViewItem
{
public:
     PLListItem (QListView* parent, int mp3id, const char* file, int length);
     PLListItem (QListView* parent, PLListItem* after, int mp3id, const char* file, int length);
     ~PLListItem();

     PLListItem* itemBelow();
     PLListItem* itemAbove();
     int getMp3id() const;
     const char* getFileN() const;
     int getLength() const;

private:
     int mp3id;
     QString file;
     int length;


};

#endif
