/***************************************************************************
                          plview.h  -  description
                             -------------------
    begin                : Thu Mar 15 2001
    copyright            : (C) 2001 by Stefano Brustia
    email                : hio@lombardiacom.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PLVIEW_H
#define PLVIEW_H

//#include <qlistview.h>
#include <qwidget.h>
#include <qlayout.h>
#include <qcombobox.h>
#include <qpushbutton.h>
#include <qpopupmenu.h>
#include <qlabel.h>
/*#include <kaction.h>*/

#include "item.h"
#include "mp3kultview.h"
#include "mydb.h"
#include "mp3list.h"

class PLView : public QWidget
{
     Q_OBJECT;
//class MyDb;
public:
     PLView(MyDb* db, QWidget* parent=0, const char* name = 0);
     ~PLView();
     void addSong(Mp3ListItem* mp3item);
     void setFont(QFont font);
     Mp3List* getListView() const;
     bool getSaved();
     void setMp3KultView(Mp3KultView* view);
     void viewPL();

     QPushButton* playPL;

protected slots:
     void slotMoveUp();
     void slotMoveDown();
     void slotChangePl(const QString& name);
     void slotRemoveSongs();
     //void slotRemoveSelected();
     void slotRefreshStatus();

public slots:
     void slotSave();
     void slotNew();
     void slotDelete();
     void slotLocalPL();
     void slotExport();
     void slotImport();
		void slotRename();

signals:
     void totalLengthCh(const QString &);

private:
     void initView();
     void initplName();
     void removeSong(PLListItem* item);
     const char* elabLength(int len);
     const QString elabLengthTotal(int len);

     MyDb* db;
     QGridLayout* mainGrid;
     Mp3List* listview;
     PLListItem* item;
     QComboBox* plName;
     QPushButton* moveUp;
     QPushButton* moveDown;
     QPopupMenu* popup;
     QLabel* plLength;
     Mp3KultView* mkview;
     bool saved;
     int totalLength;
};

#endif
