/***************************************************************************
                          edittag.cpp  -  description
                             -------------------
    begin                : Fri Apr 27 2001
    copyright            : (C) 2001 by Stefano Brustia
    email                : hio@lombardiacom.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlayout.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qvalidator.h>
#include <kmessagebox.h>
#include <klocale.h>
#include <kconfig.h>
#include <kapp.h>

#include <iostream.h>

#include "edittag.h"


EditTag::EditTag(QWidget* parent, const char* file, const char* name)
    :QDialog (parent, name, true)
{
    KConfig* config;
    config = kapp->config();

    mp3info = new Mp3Info (file);
    bool succ = mp3info->getResult();

    config->setGroup("OPTIONS");

    mod = config->readNumEntry("WriteTag", 2);

    if (succ)
    {
        initDialog();
        setGenreList();
        setInfo();

        connect (butok, SIGNAL(clicked()), this, SLOT(slotbutok()));
        connect (butcancel, SIGNAL(clicked()), this, SLOT(slotbutcancel()));
        connect (butDeleteV1, SIGNAL(clicked()), this, SLOT(slotRemoveId3v1()));
        connect (butDeleteV2, SIGNAL(clicked()), this, SLOT(slotRemoveId3v2()));
    }
    else
    {
        KMessageBox::error (this, i18n("Error reading: \n ") +
                                        file,
                                        i18n("Error"));
          return;
    }
}

EditTag::~EditTag()
{
}

void EditTag::initDialog()
{
    setCaption (i18n("Edit Tag"));

    QGridLayout* mainGrid = new QGridLayout (this, 2, 4, 12, 14);

    QGroupBox* group = new QGroupBox (this);
    group->setTitle(i18n("ID3 Tag"));
    mainGrid->addMultiCellWidget(group, 0, 0, 0, 3);

    QGridLayout* groupL = new QGridLayout(group, 6, 4, 16, 4);
    //groupL->setColStretch(0, 10);
    groupL->setColStretch(2,10);

    QLabel* ltitle = new QLabel(group);
    ltitle->setText(i18n("Title:"));
    groupL->addWidget(ltitle, 0,0, AlignRight);
    title = new QLineEdit(group);
    groupL->addMultiCellWidget(title, 0, 0, 1, 3);

    QLabel* lartist = new QLabel(group);
    lartist->setText(i18n("Artist:"));
    groupL->addWidget(lartist, 1,0, AlignRight);
    artist = new QLineEdit(group);
    groupL->addMultiCellWidget(artist, 1, 1, 1, 3);

    QLabel* lalbum = new QLabel(group);
    lalbum->setText(i18n("Album:"));
    groupL->addWidget(lalbum, 2,0, AlignRight);
    album = new QLineEdit(group);
    groupL->addMultiCellWidget(album, 2, 2, 1, 3);

    QLabel* lcomment = new QLabel(group);
    lcomment->setText(i18n("Comment:"));
    groupL->addWidget(lcomment, 3,0, AlignRight);
    comment = new QLineEdit(group);
    groupL->addMultiCellWidget(comment, 3, 3, 1, 3);

    QLabel* lyear = new QLabel(group);
    lyear->setText(i18n("Year:"));
    lyear->setAlignment(AlignRight | AlignVCenter);
    groupL->addWidget(lyear, 4,0/*, AlignRight*/);
    year = new QLineEdit(group);
    year->setValidator(new QIntValidator(0,9999, this));
    year->setFixedWidth(50);
    year->setMaxLength(4);
    //year->setMaximumSize(year->sizeHint());
    groupL->addWidget(year, 4, 1);

    QLabel* ltrack = new QLabel(group);
    ltrack->setText(i18n("Track:"));
    ltrack->setMinimumWidth(80);
    ltrack->setAlignment(AlignRight | AlignVCenter);
    ltrack->setSizeIncrement(0,40);
    groupL->addWidget(ltrack, 4, 2 /*AlignRight*/);
    track = new QLineEdit(group);
    track->setValidator(new QIntValidator(0,255, this));
    track->setFixedWidth(50);
    track->setMaxLength(2);
    groupL->addWidget(track, 4, 3);

    if (mod==0) {
      title->setMaxLength(30);
      comment->setMaxLength(30);
      album->setMaxLength(30);
      artist->setMaxLength(30);
    }

    QLabel* lgenre = new QLabel(group);
    lgenre->setText(i18n("Genre:"));
    groupL->addWidget(lgenre, 5,0, AlignRight);
    genre = new QComboBox (group);
    //genre->setMinimumWidth(160);
    groupL->addMultiCellWidget(genre,5, 5, 1, 3);

    butDeleteV1 =  new QPushButton(this);
    butDeleteV1->setText(i18n("Remove V1"));
    mainGrid->addWidget(butDeleteV1, 1, 1);

    butDeleteV2 =  new QPushButton(this);
    butDeleteV2->setText(i18n("Remove V2"));
    mainGrid->addWidget(butDeleteV2, 1, 2);

    butok = new QPushButton(this);
    butok->setText(i18n("OK"));
    mainGrid->addWidget(butok, 1, 0);

    butcancel = new QPushButton(this);
    butcancel->setText(i18n("Cancel"));
    mainGrid->addWidget(butcancel, 1, 3);
}

void EditTag::setInfo()
{
    /*if (mod == 0){

    }   */
    title->setText(mp3info->getTitle());
    artist->setText(mp3info->getArtist());
    album->setText(mp3info->getAlbum());
    comment->setText(mp3info->getComment());
    year->setText(mp3info->getYear());
    track->setText(mp3info->getTrack());
    // genreList->setCurrentItem(mp3info->getGenre());
    if ((mp3info->getGenreC()))
    {
			//cerr << "Genre: " << mp3info->getGenreC() << endl;
        genre->setCurrentItem(genreList->index(genreList->findItem(mp3info->getGenreC())));
    }
    else
    {
        genre->setCurrentItem(0);
    }

}

void EditTag::setGenreList()
{
    genreList = new QListBox(this);
    int i=0;
    genreList->insertItem("");
		//cerr << "init genre" << endl;
    while (!QString(Mp3Info::getGenre(i)).isEmpty())
    {
        genreList->insertItem(Mp3Info::getGenre(i));
        i++;
    }
		//cerr << "Init finished" << endl;
    genreList->sort(); //Ascending, default = true
		//cerr << "Sorted" << endl;
    genre->setListBox(genreList);
}

void EditTag::slotbutok()
{
    int num;

    if (!((genre->currentText()).isEmpty()))
    {
        int i=0;
        while((strcmp(genre->currentText(), Mp3Info::getGenre(i))) && i<255)
        {
            i++;
        }
        num = i;
        // cerr() << "Write Genre: " << num << endl;
    }
    else
    {
        // cerr() << "Write Genre: 255" << endl;
        num=255;
    }

    mp3info->writeTagInfo (title->text(), artist->text(), album->text(),
                            comment->text(), year->text(), num, track->text(), mod);
    done(0);
}

void EditTag::slotbutcancel()
{
    done(1);
}

void EditTag::slotRemoveId3v1()
{
  int response=KMessageBox::questionYesNo(this, i18n("Are you sure to \n"
                                          "remove the tag ?"),
                                        i18n("Removal Tag confirmation"));
  if (response == 3)
  {
    mp3info->deleteTag(1);
    done (0);
  }
}

void EditTag::slotRemoveId3v2()
{
  int response=KMessageBox::questionYesNo(this, i18n("Are you sure to \n"
                                          "remove the tag ?"),
                                        i18n("Removal Tag confirmation"));
  if (response == 3)
  {
    mp3info->deleteTag(2);
    done(0);
  }
}

#include "edittag.moc"
