/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.testing;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Ticker;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

@Beta
@GwtCompatible
public class FakeTicker
extends Ticker {
    private final AtomicLong nanos = new AtomicLong();

    public FakeTicker advance(long time, TimeUnit timeUnit) {
        return this.advance(timeUnit.toNanos(time));
    }

    public FakeTicker advance(long nanoseconds) {
        this.nanos.addAndGet(nanoseconds);
        return this;
    }

    public long read() {
        return this.nanos.get();
    }
}

