/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.Multimap;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.google.AbstractMultimapTester;
import java.util.Collection;
import java.util.Map;

@GwtCompatible
public class MultimapSizeTester<K, V>
extends AbstractMultimapTester<K, V> {
    public void testSize() {
        int expectedSize = this.getNumElements();
        Multimap multimap = this.multimap();
        MultimapSizeTester.assertEquals((int)expectedSize, (int)multimap.size());
        int size = 0;
        for (Map.Entry entry : multimap.entries()) {
            MultimapSizeTester.assertTrue((boolean)multimap.containsEntry(entry.getKey(), entry.getValue()));
            ++size;
        }
        MultimapSizeTester.assertEquals((int)expectedSize, (int)size);
        int size2 = 0;
        for (Map.Entry entry2 : multimap.asMap().entrySet()) {
            size2 += ((Collection)entry2.getValue()).size();
        }
        MultimapSizeTester.assertEquals((int)expectedSize, (int)size2);
    }

    @CollectionSize.Require(value={CollectionSize.ZERO})
    public void testIsEmptyYes() {
        MultimapSizeTester.assertTrue((boolean)this.multimap().isEmpty());
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testIsEmptyNo() {
        MultimapSizeTester.assertFalse((boolean)this.multimap().isEmpty());
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_KEYS})
    public void testSizeNullEntry() {
        this.initMultimapWithNullKey();
        MultimapSizeTester.assertEquals((int)this.getNumElements(), (int)this.multimap().size());
        MultimapSizeTester.assertFalse((boolean)this.multimap().isEmpty());
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testSizeMultipleValues() {
        this.resetContainer(Helpers.mapEntry(this.sampleKeys().e0, this.sampleValues().e0), Helpers.mapEntry(this.sampleKeys().e0, this.sampleValues().e1), Helpers.mapEntry(this.sampleKeys().e0, this.sampleValues().e2));
        MultimapSizeTester.assertEquals((int)3, (int)this.multimap().size());
        MultimapSizeTester.assertEquals((int)3, (int)this.multimap().entries().size());
        MultimapSizeTester.assertEquals((int)3, (int)this.multimap().keys().size());
        MultimapSizeTester.assertEquals((int)1, (int)this.multimap().keySet().size());
        MultimapSizeTester.assertEquals((int)1, (int)this.multimap().asMap().size());
    }
}

