/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.Maps;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.google.AbstractMultimapTester;
import java.util.Collection;
import java.util.Map;

@GwtCompatible
public class MultimapRemoveEntryTester<K, V>
extends AbstractMultimapTester<K, V> {
    private static final Object[] EMPTY = new Object[0];

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testRemoveAbsent() {
        MultimapRemoveEntryTester.assertFalse((boolean)this.multimap().remove(this.sampleKeys().e0, this.sampleValues().e1));
        this.expectUnchanged();
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testRemovePropagatesToGet() {
        Collection result = this.multimap().get(this.sampleKeys().e0);
        MultimapRemoveEntryTester.assertTrue((boolean)this.multimap().remove(this.sampleKeys().e0, this.sampleValues().e0));
        MultimapRemoveEntryTester.assertTrue((boolean)result.isEmpty());
        MultimapRemoveEntryTester.assertFalse((boolean)this.multimap().containsKey(this.sampleKeys().e0));
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testRemovePresent() {
        MultimapRemoveEntryTester.assertTrue((boolean)this.multimap().remove(this.sampleKeys().e0, this.sampleValues().e0));
        this.expectMissing((Map.Entry)this.samples.e0);
        this.assertGet(this.sampleKeys().e0, EMPTY);
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE, MapFeature.ALLOWS_NULL_KEYS})
    public void testRemoveNullKeyPresent() {
        this.initMultimapWithNullKey();
        MultimapRemoveEntryTester.assertTrue((boolean)this.multimap().remove(null, this.getValueForNullKey()));
        this.expectMissing(Maps.immutableEntry((Object)null, this.getValueForNullKey()));
        this.assertGet(this.getKeyForNullValue(), EMPTY);
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE, MapFeature.ALLOWS_NULL_VALUES})
    public void testRemoveNullValuePresent() {
        this.initMultimapWithNullValue();
        MultimapRemoveEntryTester.assertTrue((boolean)this.multimap().remove(this.getKeyForNullValue(), null));
        this.expectMissing(Maps.immutableEntry(this.getKeyForNullValue(), (Object)null));
        this.assertGet(this.getKeyForNullValue(), EMPTY);
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE, MapFeature.ALLOWS_NULL_QUERIES})
    public void testRemoveNullKeyAbsent() {
        MultimapRemoveEntryTester.assertFalse((boolean)this.multimap().remove(null, this.sampleValues().e0));
        this.expectUnchanged();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE, MapFeature.ALLOWS_NULL_QUERIES})
    public void testRemoveNullValueAbsent() {
        MultimapRemoveEntryTester.assertFalse((boolean)this.multimap().remove(this.sampleKeys().e0, null));
        this.expectUnchanged();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE}, absent={MapFeature.ALLOWS_NULL_QUERIES})
    public void testRemoveNullValueForbidden() {
        try {
            this.multimap().remove(this.sampleKeys().e0, null);
            MultimapRemoveEntryTester.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE}, absent={MapFeature.ALLOWS_NULL_QUERIES})
    public void testRemoveNullKeyForbidden() {
        try {
            this.multimap().remove(null, this.sampleValues().e0);
            MultimapRemoveEntryTester.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.expectUnchanged();
    }
}

