/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.BiMap;
import com.google.common.collect.testing.DerivedGenerator;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.OneSizeTestContainerGenerator;
import com.google.common.collect.testing.SampleElements;
import com.google.common.collect.testing.TestMapGenerator;
import com.google.common.collect.testing.TestSetGenerator;
import com.google.common.collect.testing.TestSubjectGenerator;
import com.google.common.collect.testing.google.TestBiMapGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

@GwtCompatible
public final class DerivedGoogleCollectionGenerators {
    private DerivedGoogleCollectionGenerators() {
    }

    public static class BiMapValueSetGenerator<K, V>
    implements TestSetGenerator<V>,
    DerivedGenerator {
        private final OneSizeTestContainerGenerator<BiMap<K, V>, Map.Entry<K, V>> mapGenerator;
        private final SampleElements<V> samples;

        public BiMapValueSetGenerator(OneSizeTestContainerGenerator<BiMap<K, V>, Map.Entry<K, V>> mapGenerator) {
            this.mapGenerator = mapGenerator;
            SampleElements mapSamples = this.mapGenerator.samples();
            this.samples = new SampleElements(((Map.Entry)mapSamples.e0).getValue(), ((Map.Entry)mapSamples.e1).getValue(), ((Map.Entry)mapSamples.e2).getValue(), ((Map.Entry)mapSamples.e3).getValue(), ((Map.Entry)mapSamples.e4).getValue());
        }

        @Override
        public SampleElements<V> samples() {
            return this.samples;
        }

        @Override
        public Set<V> create(Object ... elements) {
            Object[] valuesArray = elements;
            Collection<Map.Entry<K, V>> originalEntries = this.mapGenerator.getSampleElements(elements.length);
            ArrayList<Map.Entry<K, Object>> entries = new ArrayList<Map.Entry<K, Object>>(elements.length);
            int i = 0;
            for (Map.Entry<K, V> entry : originalEntries) {
                entries.add(Helpers.mapEntry(entry.getKey(), valuesArray[i++]));
            }
            return ((BiMap)this.mapGenerator.create(entries.toArray())).values();
        }

        @Override
        public V[] createArray(int length) {
            V[] vs = ((TestBiMapGenerator)this.mapGenerator.getInnerGenerator()).createValueArray(length);
            return vs;
        }

        @Override
        public Iterable<V> order(List<V> insertionOrder) {
            return insertionOrder;
        }

        @Override
        public TestSubjectGenerator<?> getInnerGenerator() {
            return this.mapGenerator;
        }
    }

    public static class InverseBiMapGenerator<K, V>
    implements TestBiMapGenerator<V, K>,
    DerivedGenerator {
        private final OneSizeTestContainerGenerator<BiMap<K, V>, Map.Entry<K, V>> generator;

        public InverseBiMapGenerator(OneSizeTestContainerGenerator<BiMap<K, V>, Map.Entry<K, V>> oneSizeTestContainerGenerator) {
            this.generator = oneSizeTestContainerGenerator;
        }

        @Override
        public SampleElements<Map.Entry<V, K>> samples() {
            SampleElements samples = this.generator.samples();
            return new SampleElements<Map.Entry<V, K>>(this.reverse((Map.Entry)samples.e0), this.reverse((Map.Entry)samples.e1), this.reverse((Map.Entry)samples.e2), this.reverse((Map.Entry)samples.e3), this.reverse((Map.Entry)samples.e4));
        }

        private Map.Entry<V, K> reverse(Map.Entry<K, V> entry) {
            return Helpers.mapEntry(entry.getValue(), entry.getKey());
        }

        @Override
        public BiMap<V, K> create(Object ... elements) {
            Map.Entry[] entries = new Map.Entry[elements.length];
            for (int i = 0; i < elements.length; ++i) {
                entries[i] = this.reverse((Map.Entry)elements[i]);
            }
            return ((BiMap)this.generator.create(entries)).inverse();
        }

        public Map.Entry<V, K>[] createArray(int length) {
            return new Map.Entry[length];
        }

        @Override
        public Iterable<Map.Entry<V, K>> order(List<Map.Entry<V, K>> insertionOrder) {
            return insertionOrder;
        }

        @Override
        public V[] createKeyArray(int length) {
            return new Object[length];
        }

        @Override
        public K[] createValueArray(int length) {
            return new Object[length];
        }

        @Override
        public TestSubjectGenerator<?> getInnerGenerator() {
            return this.generator;
        }
    }

    public static class MapGenerator<K, V>
    implements TestMapGenerator<K, V>,
    DerivedGenerator {
        private final OneSizeTestContainerGenerator<BiMap<K, V>, Map.Entry<K, V>> generator;

        public MapGenerator(OneSizeTestContainerGenerator<BiMap<K, V>, Map.Entry<K, V>> oneSizeTestContainerGenerator) {
            this.generator = oneSizeTestContainerGenerator;
        }

        @Override
        public SampleElements<Map.Entry<K, V>> samples() {
            return this.generator.samples();
        }

        @Override
        public Map<K, V> create(Object ... elements) {
            return (Map)this.generator.create(elements);
        }

        public Map.Entry<K, V>[] createArray(int length) {
            return (Map.Entry[])this.generator.createArray(length);
        }

        @Override
        public Iterable<Map.Entry<K, V>> order(List<Map.Entry<K, V>> insertionOrder) {
            return this.generator.order(insertionOrder);
        }

        @Override
        public K[] createKeyArray(int length) {
            return new Object[length];
        }

        @Override
        public V[] createValueArray(int length) {
            return new Object[length];
        }

        @Override
        public TestSubjectGenerator<?> getInnerGenerator() {
            return this.generator;
        }
    }
}

