/***************************************************************************
 *   Copyright (C) 2005 by Dmitry Nezhevenko                               *
 *   dionua@users.sf.net                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef FORM1_H
#define FORM1_H

#include <form1_base.h>

#define PHONE_NONE 0
#define PHONE_AT 1
#define PHONE_P2K 2

#define MODE_FILEMANAGER 1
#define MODE_SEEMEDITOR 2
#define MODE_JAVA 3

class PhoneMan;
class QString;
class QLabel;
class QProgressBar;
class appConfig;
class QUrlOperator;

class frmFileManager;
class frmSeemEditor;
class frmJava;

/**
@author Dmitry Nezhevenko
*/
class Form1 : public Form1_base
{
Q_OBJECT
public:
    Form1(QWidget *parent = 0, const char *name = 0);
    ~Form1();
private:
	PhoneMan * phone;
	QLabel * lblStatus;
	QLabel * lblPhoneModel;	
	QLabel * lblMode;
	QLabel * lblDriveName;
	QLabel * lblFileCount;
	QLabel * lblFreeSpace;
	QProgressBar * progressBar;
	appConfig * myCfg;
	QUrlOperator * tmpURL;
	

	frmFileManager * fileManager;
	frmSeemEditor * seemEditor;
	frmJava * java;
	
	int wasMode;
	
	char connect_tmp;
	char enableAutoConnect;
	

	void updateStatus();
	void updateSpace();
	void setWorkMode(int mode);
	
	void loadConfig();
private slots:
	void onPostMsg(int style, const QString &s);
	void onStatusChanged(int status);
	void onModeChanged(int status);
	
	void onNfoPhoneModel(const QString &s);
	void onNfoDriveName(const QString &s);
	void onNfoFileCount(int cnt);
	void onNfoFreeSpace(long space);
	void onNfoProgress(int pb);
	
	void doactConnect(bool t);
	void doactReboot();
	void doactSuspend();
	void doactAbout();
	void doactAboutQT();
	void doactPreferences();
	
	void setModeSeemEditor(bool);
	void setModeFileManager(bool);
	void setModeJava(bool);
};

#endif
