/*	motion.h
 *
 *	Include file for video.c
 *      Copyright 2000 by Jeroen Vreeken (pe1rxq@amsat.org)
 *      This software is distributed under the GNU public license version 2
 *      See also the file 'COPYING'.
 *
 */

#ifndef _INCLUDE_VIDEO_H
#define _INCLUDE_VIDEO_H

/* video4linux stuff */
#define NORM_DEFAULT    0
#define NORM_PAL        0
#define NORM_NTSC       1
#define NORM_SECAM      2
#define NORM_PAL_NC	3
#define IN_DEFAULT      8
#define IN_TV           0
#define IN_COMPOSITE    1
#define IN_COMPOSITE2   2
#define IN_SVIDEO       3

#define VIDEO_DEVICE "/dev/video"

/* video functions, video.c */
char *vid_start (int dev, int width, int height, int input, int norm);
char *vid_next (int dev, char *map, int width, int height);
int vid_startpipe (char *devname, int width, int height);
int vid_putpipe (int dev, char *image, int height, int width);
void vid_autobright (int dev, char *image, int height, int width);
char *vid_keepalive(struct images *imgs, int dev, int pipe, int mpipe);

#endif
