#!/bin/sh -
case "$1" in "" | start)
	echo Preparing for Tuning:
	[ -f /proc/mosix/admin/mfscosts ] && {
		dir=`mount | fgrep " type mfs (" | awk '{print $3}'`
		case "$dir" in "")
			[ ! -e /mfs ] && mkdir -p /mfs
			if [ -d /mfs ]
			then
				echo Mounting MFS on /mfs...
				mount -t mfs mfstest /mfs
			else
				echo Sorry, MFS cannot be tuned because "/mfs" is used for something else.
			fi ;;
			/mfs) : ;;
			/?*) if [ -d /mfs ]
			     then
				/bin/echo -n "MFS is mounted on $dir instead of /mfs - Fix? [y/N]? "
				read yn
				case "$yn" in [yY]*)
					umount $dir
					mount -t mfs mfstest /mfs ;;
					*) echo OK, but MFS cannot be tuned. ;;
				esac
			     elif [ ! -e /mfs ]
			     then
				ln -s "$dir" /mfs
			     elif [ ! -d /mfs/magic ]
			     then
				echo Sorry, MFS cannot be tuned because "/mfs" is used for something else.
			     fi ;;
		esac
	}
	echo "[9;30]"
	case `awk '{if($2 == "/") print $3}' < /proc/mounts` in nfs) : ;;
		*)
		echo Starting Network...
		if [ -x /etc/rc.d/init.d/network ]
		then
			sh /etc/rc.d/init.d/network start
		else
			sh /etc/rc.d/rc.network
		fi
	esac
	eval `ps ax | awk '{if($5 == "minilogd")print "kill " $1;next}'`
	if [ -x /etc/rc.d/init.d/mosix ]
	then
		sh /etc/rc.d/init.d/mosix start
	else
		sh /etc/rc.d/rc.mosix start
	fi
	echo 1 > /proc/mosix/admin/quiet ;;

	stop) echo 0 > /proc/mosix/admin/quiet
	      echo "[9;10]" ;;
	*) echo "???" ;;
esac
