# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.

from twisted.internet import defer
from elisa.plugins.pigment.graph.image import Image
from elisa.plugins.pigment.graph import IMAGE_TOP_LEFT, IMAGE_TOP_RIGHT

from elisa.core.utils.misc import is_hildon_desktop_running
from elisa.core import common

def moblin_decorator(controller):
    if is_hildon_desktop_running():
        menu_widget = controller.menu
        frontend = controller.frontend
        theme = frontend.get_theme()

        def home_clicked_callback(drawable, x, y, z, button, time, pressure):
            frontend.reduce_window()

        def close_clicked_callback(drawable, x, y, z, button, time, pressure):
            common.application.stop()

        icon_size = (0.2, 0.2)
        icon_opacity = 80

        icon = theme.get_resource('elisa.plugins.poblesec.moblin_home')
        home_image = Image()
        home_image.bg_color = (0, 0, 0, 0)
        home_image.set_from_file(icon)
        home_image.alignment = IMAGE_TOP_LEFT
        home_image.position = (0., 0., 0.0)
        home_image.size = icon_size
        home_image.visible = True
        home_image.opacity = icon_opacity
        home_image.connect('clicked', home_clicked_callback)

        icon = theme.get_resource('elisa.plugins.poblesec.moblin_close')
        close_image = Image()
        close_image.bg_color = (0, 0, 0, 0)
        close_image.set_from_file(icon)
        close_image.alignment = IMAGE_TOP_RIGHT
        close_image.position = (1.0 - icon_size[0], 0., 0.0)
        close_image.size = icon_size
        close_image.visible = True
        close_image.opacity = icon_opacity
        close_image.connect('clicked', close_clicked_callback)

        menu_widget.add(home_image)
        menu_widget.add(close_image)

    return defer.succeed(None)
