set htmlHelpContents {
<html><body>
<ul>
  <li><a href="#about">1. About this document</a>
  <li><a href="#introduction">2. Introduction</a>
  <li><a href="#required">3. Required software</a>
  <li><a href="#architecture">4. Architecture</a>
  <li><a href="#core">5. Core</a><ul>
    <li><a href="#userinterface">5.1. User interface</a><ul>
      <li><a href="#menus">5.1.1. Menus</a><ul>
        <li><a href="#menus.file">5.1.1.1. File</a><ul>
          <li><a href="#menus.file.save">5.1.1.1.1. Save</a>
          <li><a href="#menus.file.saveas">5.1.1.1.2. Save As</a>
          <li><a href="#menus.file.modules">5.1.1.1.3. Modules</a><ul>
            <li><a href="#menus.file.modules.loaded">5.1.1.1.3.1. Loaded</a>
            <li><a href="#menus.file.modules.load">5.1.1.1.3.2. Load</a>
            <li><a href="#menus.file.modules.unload">5.1.1.1.3.3. Unload</a>
          </ul>
          <li><a href="#menus.file.print">5.1.1.1.4. Print</a>
          <li><a href="#menus.file.exit">5.1.1.1.5. Exit</a>
        </ul>
        <li><a href="#menus.edit">5.1.1.2. Edit</a><ul>
          <li><a href="#menus.edit.thresholds">5.1.1.2.1. Thresholds</a><ul>
            <li><a href="#menus.edit.thresholds.types">5.1.1.2.1.1. Types</a>
            <li><a href="#menus.edit.thresholds.color">5.1.1.2.1.2. Color</a>
            <li><a href="#menus.edit.thresholds.script">5.1.1.2.1.3. Script</a>
          </ul>
          <li><a href="#menus.edit.configuration">5.1.1.2.2. Configuration</a>
          <li><a href="#menus.edit.new">5.1.1.2.3. New</a>
          <li><a href="#menus.edit.preferences">5.1.1.2.4. Preferences</a><ul>
            <li><a href="#menus.edit.preferences.printing">5.1.1.2.4.1. Printing</a>
          </ul>
        </ul>
        <li><a href="#menus.view">5.1.1.3. View</a><ul>
          <li><a href="#menus.view.refresh">5.1.1.3.1. Refresh</a>
          <li><a href="#menus.view.polltime">5.1.1.3.2. Poll Time</a>
        </ul>
        <li><a href="#menus.help">5.1.1.4. Help</a><ul>
          <li><a href="#menus.help.global">5.1.1.4.1. Global</a>
          <li><a href="#menus.help.modules">5.1.1.4.2. Modules</a>
          <li><a href="#menus.help.copyright">5.1.1.4.3. Copyright</a>
          <li><a href="#menus.help.sourceversions">5.1.1.4.4. Source Versions</a>
          <li><a href="#menus.help.about">5.1.1.4.5. About</a>
        </ul>
      </ul>
      <li><a href="#draganddrop">5.1.2. Drag and drop</a><ul>
        <li><a href="#dropsites">5.1.2.1. Drop sites</a>
        <li><a href="#dragsites">5.1.2.2. Drag sites</a>
      </ul>
    </ul>
    <li><a href="#commandline">5.2. Command line</a><ul>
      <li><a href="#mainarguments">5.2.1. Main arguments</a>
      <li><a href="#modulearguments">5.2.2. Module arguments</a>
    </ul>
    <li><a href="#core.configuration">5.3. Configuration</a><ul>
      <li><a href="#configuration.canvas">5.3.1. Canvas</a><ul>
        <li><a href="#configuration.canvas.size">5.3.1.1. Size</a>
        <li><a href="#configuration.canvas.colors">5.3.1.2. Colors</a>
      </ul>
      <li><a href="#configuration.viewers">5.3.2. Viewers</a><ul>
        <li><a href="#configuration.viewers.colors">5.3.2.1. Colors</a>
        <li><a href="#configuration.viewers.graphs">5.3.2.2. Graphs</a>
        <li><a href="#configuration.viewers.pies">5.3.2.3. Pies</a>
      </ul>
    </ul>
    <li><a href="#core.preferences">5.4. Preferences</a><ul>
      <li><a href="#preferences.canvas">5.4.1. Canvas</a><ul>
        <li><a href="#preferences.canvas.printing">5.4.1.1. Printing</a>
      </ul>
      <li><a href="#preferences.thresholds">5.5.1. Thresholds</a><ul>
        <li><a href="#preferences.thresholds.email">5.5.1.1. Email</a>
      </ul>
    </ul>
  </ul>
</ul>
<ul>
  <li><a href="#future">8. Future developments</a>
  <li><a href="#misc">9. Miscellaneous information</a>
</ul>
</body></html>}
set htmlHelpData {
<body><html>

<h3><a name="about"></a>1. About this document</h3>

This document contains general information, reference information and examples designed to help the user understand the moodss application and the programmer write modules for it.

<h3><a name="introduction"></a>2. Introduction</h3>

Quite often, one needs to monitor changing data, whether it might come from a system, such as the different processes running on a Unix server, or from a network, such as the volume and distribution of traffic that runs through it.

<p>Most often, such data can be organized in a table with rows of information, each column representing a different kind of data. For example, in the case of processes running on a computer system, rows might be sorted according to their unique process identifier, with columns containing values such as CPU usage, memory usage, owner's name, time of creation, ...

<p>The software used to view this type of information comes in different forms and shapes. Unix users might be familiar with the <i>top</i> application which presents rows of process data as lines of text, whereas RMON (Remote MONitoring) SNMP software usually uses multiple windows with graphical displays, curves, pie charts, multiple configuration dialog boxes, even 3D visualization modules to visualize network traffic, connection matrices, ...

<p>In most cases, data comes from one or more tables. A common interface, graphical with menus, drag'n'drop capability, table widgets, textual and graphical data viewers such as multiple line graphs, bar and pie charts, could be used. The user could then sort table rows, select one or more cells, rows, columns, create views such as other tables, charts, ... best suited to the way data should be presented. Once optimized, the data viewers layout and configuration could be saved for later reuse as a dashboard. In effect, what is needed is a spreadsheet tailored to dynamic data processing.

<p>Moodss (Modular Object Oriented Dynamic SpreadSheet) is an attempt at answering these needs. It is composed of a main part (the core) and an unlimited number of modules, loaded as the application is launched or while it is running, each module interfacing to a specific type of data. The core is written in the great Tcl language (at <a href="http://www.scriptics.com/">http://www.scriptics.com/</a>) using object oriented techniques thanks to the stooop package (at <a href="http://jfontain.free.fr/">http://jfontain.free.fr/</a>). The module function is to describe the data that it is also in charge of retrieving and formatting. Modules can be written in plain Tcl or use dynamically linked libraries written in the C language (modules are packages in the Tcl sense, so any language that can interface with Tcl is supported).

<p>Modules are loaded when moodss is started or dynamically at a later time. Several modules can be handled concurrently (starting with moodss version 3.0). This way, you may monitor data coming from any number of heterogeneous sources. Modules are specified in the command line or dynamically loaded, and can be unloaded at any time.

<p>Versions 4.0 and up add a dashboard functionality: the current configuration (modules, viewers, poll time, windows sizes and placement, ...) can be saved in a file at any time, for later reuse (see the -f (--file) command line switch documentation).

<p>Versions 4.3 and up support asynchronous modules (for which no polling is needed as module data may change on its own). Note that any number of asynchronous and regular (synchronous) modules can be simultaneously loaded.

<p>Versions 5.0 and up add a free text viewer, which can be used for comments, and which can also embed live data cells in text form.

<p>Versions 5.3 and up support viewer type mutation through viewer icon drag'n'drop, and viewer quick destruction by a drop into the eraser icon. A new menu for empty viewer creation was also added.

<p>Versions 6.0 and up support command line arguments per module, data table column anchoring in module configuration and automatic module discovery.

<p>Versions 6.1 and up support HTML formatted help data for modules.

<p>Versions 6.6 and up support automatic cross hairs with coordinates in message area for graph data viewers.

<p>Versions 6.7 and up support contextual help (through the main window message area) on all menu items.

<p>Versions 7.0 and up support per user (on UNIX systems) application wide preferences setting.

<p>Versions 7.99 and up support concurrent instances of the same module.

<p>Versions 8.1 and up support configuration settings per dashboard, with a user interface similar to the preferences interface.

<p>Versions 8.6 and up (in the 8 series) add a stacked graph viewer.

<p>Versions 9.0 and up are only compatible with Tcl/Tk versions 8.2 and above.

<p>Versions 9.4 and up add a stacked graph viewer.

<p>Versions 10.0 and up allow printing in postscript to printer or a file.

<p>Versions 10.1 and up allow printing previewing.

<p>Versions 11.0 and up are multilingual with incomplete French language support added.

<p>Versions 11.1 and up allow dynamically loading modules.

<p>Versions 11.3 and up allow dynamically unloading modules.

<p>Versions 11.7 and up allow swapping columns and rows in module data views.

<p>Versions 11.12 and up include a core trace module that allows displaying message from other loaded modules.

<p>Versions 12.0 and up include the ability to set thresholds on data cells.

<p>Versions 12.1 and up include the ability to send email alerts on thresholds.

<p>Versions 12.3 and up include the ability to change source data cells color on thresholds.

<p>Versions 13.0 and up allow modules to be written in the Perl language.

<p>Versions 14.0 and up allow modules to be written in the Python language.

<p>Since module data access is entirely customizable (through C code, Tcl, HTTP, ...) and since several modules can be loaded at once, applications for moodss become limitless. For example, comparing a remote database server CPU activity and traffic load from a network probe on the same graph becomes possible.

<p>As features are added to moodss, different ways of viewing data will be made available while the module structure will stay the same. The goal of moodss is to become a nice feature packed generic way of viewing data. Moodss can be used to monitor any type of data, since the simplest cases can fit in one table with a single row, with the most complicated requiring loading several multiple table modules.

<p>As moodss is written in Tcl and uses well supported extensions (Tktable and BLT), it will run on Tcl/Tk supported platforms: UNIX and Windows (I do not know if Tktable and BLT are available for the MacIntosh). Obviously, some modules may be specific to a platform, but the core is guaranteed to run on them all.

<p>After reading and understanding this document, you should be able to write your own modules in order to monitor the data that you are interested in.

<p>Moodss is free software. You can redistribute it and/or modify it under the terms described in the COPYRIGHT file or use the main window Help Copyright menu for more information.

<h3><a name="required"></a>3. Required software</h3>

If you are using a Linux Redhat system (6.0 or above), then use the moodss rpm file (available at <a href="http://jfontain.free.fr/">http://jfontain.free.fr/</a>) for installation. It requires the tcl, tk, blt and tktable rpms also available at the same location (see INSTALL file for more information). You are then all set for using the included Linux modules or develop your own modules.

<p><b><i>Unless you want to work on the moodss source code (not the modules), you can skip the rest of this section.</i></b>

<p>For the current version (14.0), the following packages must be installed before attempting to install moodss (make sure to check the INSTALL file for the latest information):

<ul>
<li>Tcl/Tk version 8.3.1 or above (at <a href="http://sunscript.sun.com/">http://sunscript.sun.com/</a>)
<li>tkTable version 2.6 or above (at <a href="http://www.hobbs.wservice.com/tcl/main.html">http://www.hobbs.wservice.com/tcl/main.html</a>)<b>*</b>
<li>the latest BLT library version 2.4u or above (at <a href="http://www.tcltk.com/blt/">http://www.tcltk.com/blt/</a>)<b>*</b>
</ul>

<div align=right><b>*</b><i> many thanks to the authors for these great packages</i></div>

The pie widgets, stooop and scwoop libraries are included in the self contained <i>moodss</i> application file. Therefore, it is not required to install the stooop, scwoop and tkpiechart packages, unless you want to work on the moodss source code itself. However, should you want to get more information on those extensions, you will find the latest versions:
<ul>
<li>stooop version 4.1 or above
<li>switched version 2.2 or above (included in the stooop distribution)
<li>scwoop version 4.0 or above
<li>tkpiechart version 6.1 or above
</ul>

at <a href="http://jfontain.free.fr/">http://jfontain.free.fr/</a>.

<h3><a name="architecture"></a>4. Architecture</h3>

The moodss application is composed of the core software and one or several modules. Modules are implemented as Tcl packages and thus usually comprise a Tcl source file and a pkgIndex.tcl file as required by the Tcl package implementation.

<p>The core loads one or more modules, whose names are passed as command line parameters, come from a save file or are dynamically loaded, and starts displaying module data in one or more tables. The tables are then updated at the frequency defined by the poll time, which the user may change, or asynchronously for the relevant modules. For example, to launch moodss with the random module, just type (on a UNIX machine):

<pre>$ moodss random</pre>

All the module code and data are kept in a separate namespace. The module data is stored is a single array including some configuration data used when the module is loaded by the core, and variable data (displayed in the application table and eventual graphical viewers). If a module is synchronous, it must start updating its data when requested by the core. If a module is asynchronous, its data may be updated at any time. The synchronous or asynchronous nature is specified in the configuration data for the module.

<p>The initial data tables represent the first data views, from which any number of cells can be selected. Data viewers can be created by dragging and dropping cells into a graph, bar chart, pie chart, summary table, free text or thresholds iconic site. In turn, these viewers can display more table cells, which when dropped into the viewer, result in the creation of corresponding data graph lines, chart bars, pie slices, table rows or text cells. Cells or rows can be removed from existing viewers, by simply selecting them and dropping them in the eraser iconic site (a pencil eraser).

<p>Any viewer can be mutated (its type changed) by dragging from a viewer icon and dropping into it. For example, create a stacked data bar viewer from several cells, then drag the 3D pie icon into it. Any viewer can also be destroyed in one shot by dropping the eraser icon into it.

<p>Any draggable data can be dropped in any valid drop site at any time. It is thus possible to drag several data cells from any table or any viewer into other ones, the thresholds interface, the eraser, ... even if the data comes from different modules.

<p>All data viewers can be moved and resized at will with the help of a simple internal window manager.

<p>The current configuration (loaded modules, tables and viewers coordinates, sizes, poll time, main window size, ...) can be saved in a file at any time, so that an identical dashboard can be relaunched at will.

<h3><a name="core"></a>5. Core</h3>

<h4><a name="userinterface"></a>5.1. User interface</h4>

Immediately after launch, module(s) is(are) loaded and initialized, with corresponding messages displayed in the message area, as follows:

<center><pre><img src="moodss5.gif" alt"moodss window view in load mode"></pre></center>

Soon after, tabular data is displayed in one or more tkTable widgets with the module identifier as title, automatic scroll bars, between the menu bar, the drop sites with graphical viewers, summary table, free text, thresholds and eraser icons and a message area, as one can see below:

<center><pre><img src="moodss1.gif" alt"moodss initial main window view"></pre></center>

The message area is used to display status information, such as when the data is being updated, and help information, as the user moves the mouse pointer over sensitive areas, such as table column headers. Contextual help on all menu items is also activated as traversal occurs, either using the mouse or the keyboard, resulting in a short explicative string appearing in the message area and related to the active (highlighted) menu item. Further help is provided through widget tips (also known as balloons) when appropriate (on data table column headers, for example), and of course the Help menu.

<p>The window title shows the name of the loaded module(s) along with the poll time.

<p>When several modules of the same type are loaded (for example, CPU statistics on a group of servers), the initial data tables feature the module name followed by an instance number (<i>module&lt;N></i>), or the module identifier generated from the module code (<i>cpustats(host.domain.org)</i> for example). A lone module keeps his unmodified name as table titles.
<br>Any data displayed in a table can be sorted (provided that the related module allows it) at any time by simply clicking on a column title. Clicking on the same column title again sorts the data in opposite order, thus toggling between increasing and decreasing orders.
<br>When sorting, the selected column is used as a reference, meaning that all rows will be rearranged so that the selected column appears sorted, with values either increasing or decreasing.
<br>A little triangular indicator is placed to the right of the reference column title label, pointing up or down depending on whether the sorting order is decreasing or increasing.
<br>Table columns can be interactively resized by holding the first mouse button down on a column border. The mouse cursor is changed to an horizontal double arrow on column borders to show this capability.

<p>Aside from the main tables, graphical and textual viewers can be created for monitoring table cell data over time. Viewers can also be deleted, data views (such as pie slices, curves, ...) can be added or removed from existing viewers, ... These functions are all implemented using the <a href="#draganddrop">drag and drop</a> functionality.

<p>For all viewers, if a module identifier string is required (provided by the module, several instances of the same module, ...) for proper cell identification, that string will be placed first in the label. For example, data cells originating from the third instance of the random module would be labeled: "<i>random&lt;3>: data cell label</i>".

<p>Graphical viewers available at this time are BLT graph viewers (see images below), side-by-side bars charts, overlapped bars charts, stacked bars charts, 2D pie charts and 3D pie charts*. Graph viewers feature an automatic cross hair which follows the mouse pointer movements inside the plotting area. Corresponding coordinates are updated in real time in the main window message area.

<p>*<i>Note: if you know of any other nice viewers (like 3D graphs) that work with Tcl, please let me know so I can integrate them. Many thanks in advance...</i>

<center><table cols=2 width="100%">
<tr align=center valign=center>
<td><pre><img src="hgraph.gif" alt="graph viewer sample"></pre></td>
<td><pre><img src="hstackgr.gif" alt="stacked graph viewer sample"></pre></td>
</tr>
<tr align=center valign=center>
<td><pre><img src="hoverbar.gif" alt="overlap bar chart viewer sample"></pre></td>
<td><pre><img src="hsidebar.gif" alt="side bar chart viewer sample"></pre></td>
</tr>
<tr align=center valign=center>
<td><pre><img src="hstackbr.gif" alt="stacked bar chart viewer sample"></pre></td>
<td><pre><img src="h2dpie.gif" alt="2D pie chart viewer sample"></pre></td>
</tr>
<tr align=center valign=center>
<td><pre><img src="h3dpie.gif" alt="3D pie chart viewer sample"></pre></td>
</tr>
</table></center>

There are 2 textual viewers.

<p>The summary table displays for each row the cell label, the current, average, minimum and maximum values since the row was created. Data cells can be inserted one or several at a time through a simple drop. Rows can be deleted by selecting any cell in the row then dropping any number of them into the eraser drop site. Data cells with missing data (could be no longer available if coming from a vanished process, for example) display the ? character.

<p>The free text viewer is an editable Tk text widget with any number (including zero) of embedded data cell windows. Data cells can be inserted one or several at a time through a simple drop, as with the other viewers. New data cell windows are inserted at the current insertion cursor position. Data cells can be deleted by selecting then dropping any number of them into the eraser drop site. They can also be deleted using the keyboard Delete and Backspace keys, which also work on the regular text, as well as the expected other key bindings. When dropping data cells, each data cell window is preceded by a relevant label text for the cell, which can later be edited at any time.

<center><table width="100%">
<tr align=center valign=center>
<td width="58%"><pre><img src="hsumtbl.gif" alt="summary table viewer sample"></pre></td>
<td width="42%"><pre><img src="hfreetxt.gif" alt="free text viewer sample"></pre></td>
</tr>
</table></center>

Here is a screen shot of loaded <i>ps</i> and <i>cpustats</i> modules with several graphical viewers:

<center><pre><img src="moodss3.gif" alt="moodss window with graph data viewers"></pre></center>

All data viewers can be moved and resized thanks to handling areas in the data viewer borders. When moving the mouse pointer over these areas, the mouse cursor changes to indicate the possible action. Corner handles allow resizing in both X and Y axis. Handles in the middle of the sides allow resizing in either the X or Y axis direction. All other areas can be used for moving the data viewer as shown by the quadruple arrow cursor. Clicking on any part of the border changes the stacking order: the viewer being clicked on either goes below (eventually becomes hidden) the other viewers, or becomes fully visible (on top, eventually hiding other viewers). When moving or resizing, the message area displays the current coordinates or size in real time as the mouse is being moved. Further description of this small window manager functionality is useless, as it behaves like a basic window manager (let me know if it does not).

<p>Here is another shot featuring a free text viewer with loaded <i>cpustats</i> and <i>memstats</i> modules:

<center><pre><img src="moodss4.gif" alt"moodss window with free text data viewer"></pre></center>

Dropping cells into the thresholds drop site in the main window, or selecting the edit menu thresholds entry results in the following dialog box being displayed. While displayed, user interaction with other parts of the user interface remains possible.

<center><pre><img src="moodss8.gif" alt"thresholds user interface"></pre></center>

More information on <a href="#menus.edit.thresholds">thresholds</a>.

<h5><a name="menus"></a>5.1.1. Menus</h5>

<h6><a name="menus.file"></a>5.1.1.1. File</h6>

<h6><a name="menus.file.save"></a>5.1.1.1.1. Save</h6>

The current application configuration (including existing data viewers) can be saved in a file, which achieves a dashboard functionality.

<p>Once moodss has been launched with one or several modules and tables have been moved, resized, viewers created, moved and resized, the current configuration can be saved in a .moo file, and later reused by passing the corresponding file name with the <i>-f (--file)</i> command line switch.

<p>For moodss version 4.0 and above, the following information is saved in the file (which is human readable):

<ul>
<li>moodss version
<li>date and time
<li>application window size
<li>poll time
<li>modules
<li>tables positions and sizes
<li>viewers types, positions, sizes and specific data
</ul>

For moodss version 5.1 and above, the following information is also saved:

<ul>
<li>table viewers column widths
</ul>

For moodss version 5.2 and above, the following information is also saved:

<ul>
<li>viewers stacking order (for internal window manager)
</ul>

For moodss version 8.1 and above, the following information is also saved:

<ul>
<li>global configuration (such as canvas color, sizes, ...) (see <i>Edit</i> menu)
</ul>

When using this menu for the first time, and if a file name was not specified in the command line, the file selector dialog box appears so that the user may choose a file name (with a <i>.moo</i> extension).

<p>Once a file name has been specified (either through the command line or the file selector dialog box), that file name is reused whenever the <i>File Save</i> menu is used.

<h6><a name="menus.file.saveas"></a>5.1.1.1.2. Save As</h6>

This menu behaves as expected, with the user always having to choose a file name using the file selector dialog box (see <i>Save</i> menu above).
<br>This menu may be used at any time to change the current save file name.

<h6><a name="menus.file.modules"></a>5.1.1.1.3. Modules</h6>

<h6><a name="menus.file.modules.loaded"></a>5.1.1.1.3.1. Loaded</h6>

A module can be picked from a list of the currently loaded modules. Eventually, the module current options appear underneath.

<h6><a name="menus.file.modules.load"></a>5.1.1.1.3.2. Load</h6>

You can dynamically load a module by simply selecting its name from the available list discovered when the selection window opens. When the module is selected, its options appear underneath and any number of them can be filled.

<p>Once the new module, or new instance of an already loaded module, is loaded, the application behaves as if the module had been loaded from the start.

<h6><a name="menus.file.modules.unload"></a>5.1.1.1.3.3. Unload</h6>

The module to unload is picked from a list of the currently loaded modules. Once unloaded, the module data tables disappear, but the viewers containing cells pointing to the module data remain, simply showing that the data is now invalid.

<p><i>Note</i>: if a module is unloaded then loaded again, viewers that monitored the unloaded module data will not resume monitoring the newly loaded module data since internally Tcl traces on variables were removed.

<h6><a name="menus.file.print"></a>5.1.1.1.4. Print</h6>

You can print the canvas area in postscript to a printer or a file, which you may choose using the classical file browser. Please note that only the strictly visible area, without the scrollbars, will be printed.
<p>You can choose the printout orientation (portrait or landscape), palette (color, gray scale or monochrome) and the paper size.

<p>Due to widget and architecture limitations, the printout is pixel based. As a benefit, it is extremely WYSIWYG :-).
<br>Also, because of design limitations, printing is disabled on Windows platforms.

<p>The printout is sized according to the following rules:
<ul>
<li>empty space, around tables or data viewers, is not included (the area is cropped)
<li>a margin of 0.5 inch (12.7 millimeters) is used both horizontally and vertically on all sides
<li>size reduction occurs equally horizontally and vertically (aspect ratio is preserved) only when necessary so that all tables and data viewers are visible on the printout
</ul>

<p>When the print menu entry is selected, a dialog box appears, as can be seen in the screen shot below (which also shows the preview window):

<center><pre><img src="moodss7.gif" alt"print dialog box with preview window"></pre></center>

<br>You can choose to send the postscript data to a printer or to the screen for previewing.

<p>Depending on the print configuration (see <a href="#core.preferences">Preferences</a>), either a print command line entry or a printer selection list appears below the informational message. Hitting the OK button sends the data to the selected printer or through the specified command line.

<p>The preview functionality uses <em>gs</em> (also known as ghostscript), which must be installed (<i>note</i>: version 5.50 is required, as 5.10 is buggy). If gs cannot be found or executed, the preview button is grayed. If the gs version is below 5.20, the button is also grayed and a window tip explaining the cause is displayed when the mouse pointer is located above the button.

<p>When the gs utility is available and of the correct version, the preview button can be depressed, in which case the print dialog temporarily disappears (so that the application main window is not obscured), and reappears along with the preview window, once the printout view has been calculated.

<br>The preview window also features a zoom menu for resizing. If the user so desires, one or more printing parameters, such as page size, orientation, ... can be changed while the preview window remains visible. Hitting the preview button then results in both the print dialog box and the preview window to temporarily disappear while the new page look is calculated. After a short while, they both reappear with the preview updated accordingly, and having kept the same zoom ratio.

<p>Also note that due to the implementation of the graphical layer on UNIX systems, any window or object obscuring the canvas area will also be printed, but this is unlikely, as the moodss application window will be in front when the print menu item is selected.

<h6><a name="menus.file.exit"></a>5.1.1.1.5. Exit</h6>

Use this menu to gracefully quit the moodss application. You may also use the window manager to close the application.

<p>If there are unsaved changes (configuration, viewers created, tables or viewers moved, stacked, ...), the user is given the opportunity to save them to file (see <a href="#menus.file.save">File Save</a> menu). The file selector dialog box is used if no save file name is currently known by the application.

<h6><a name="menus.edit"></a>5.1.1.2. Edit</h6>

<h6><a name="menus.edit.thresholds"></a>5.1.1.2.1. Thresholds</h6>

Opens the thresholds dialog box.

<p>A list of threshold entries is displayed in a table with the following columns:

<ul>
<li><b>active</b>: clicking on the check button toggles the state of the entry between active and not. When active, the shell script is invoked when and if the threshold condition occurs. For example, if the threshold type is <i>up</i> and the data cell value goes above the threshold value.
<li><b>type</b>: clicking on the entry icon toggles the threshold type between <i>differ</i>, <i>down</i>, <i>equal</i>, <i>unknown</i> and <i>up</i>.  (see threshold types below).
<li><b>color</b>: selects the color to be displayed in source cell(s) when the threshold condition occurs. Clicking on the menu button drops a menu window with predefined color buttons, the last of which, with 3 dots as a label, if selected, opens a custom color selection dialog box. The menu button color reflects the currently selected threshold color. The <b>?</b> entry stands for the transparent color, that is there will be no color change in the monitored cell displays when the threshold condition occurs.
<li><b>source</b>: initially, when the threshold entry is created, the data cell label, as it would be displayed in a data viewer. This column is editable so that the user may input a more meaningful description.
<li><b>value</b>: the threshold value, used as reference when comparing with the data cell current value. When changed, the threshold condition is checked as the user confirms when closing the dialog window.
<li><b>emails</b>: a comma separated list of email addresses. When a threshold event occurs, an alert message will be sent to each recipient (also see <a href="#preferences.thresholds.email">preferences</a>).
<br><i><b>Note</b>: this column title is grayed if the SMTP package, which is required to send emails, was not found (see the INSTALL file for more information).</i>
<li><b>script</b>: a UNIX shell script invoked when the threshold is crossed. See script section below for passing arguments to the script. Any errors are displayed on the standard error channel and eventually visible in the trace module data table if displayed <i>(incompatible with the Windows platform)</i>.
</ul>

<p>Help is provided through widget tips on the table title cells, and a help button, which directly opens the main help window at the relevant section.

<p>Creating threshold entries is done through the drag'n'drop mechanism by dropping data cells into the thresholds drop icon. Any number of thresholds can be set on the same data cell.

<p>Selecting a row is done by clicking on any cell of the row. The row is then highlighted.

Below the thresholds table, the following buttons, that act on the selected row, can be found:
<ul>
<li><b>Test</b>: simulates a threshold condition. The shell script is then invoked as if the real threshold was crossed, the cell value being artificially generated. Displayed source cell(s) in the main application window remain unaffected colorwise.
<li><b>Delete</b>: removes the selected threshold entry (row). All related displayed source cells are reset to their original (transparent) color.
</ul>

<p><i>Note: there are still a lot of features to implement: please see the TODO file.</i>

<h6><a name="menus.edit.thresholds.types"></a>5.1.1.2.1.1. Types</h6>

The following threshold types are supported:
<ul>
<li><img src=differ.gif alt=differ>&nbsp;: threshold and cell value must differ.
<li><img src=down.gif alt=down>&nbsp;: cell value must be less than threshold.
<li><img src=equal.gif alt=equal>&nbsp;: threshold and cell value must be equal.
<li><img src=unknown.gif alt=unknown>&nbsp;: cell value must be unknown (invalid).
<li><img src=up.gif alt=up>&nbsp;: cell value must be more than threshold.
</ul>

<p>Depending on the source data cell type, specific internal comparison techniques are used.

<p>For the ASCII type, the current cell value can be lexicographically less than, equal to, or greater than the threshold value. Empty threshold values are allowed. The strings are compared in a case-insensitive manner.

<p>The dictionary type is handled as the ASCII type, with case ignored except as a tie-breaker and if there are embedded numbers, the numbers compare as  integers, not characters.

<p>For the clock type, the cell and threshold values are first converted to seconds, then compared.

<p>When the threshold type is <img src=unknown.gif alt=unknown>, the condition occurs when the data cell value cannot be determined, and only in such a case. It is the only type of threshold that can be triggered by the void nature of a data cell, as for the other threshold types, no action is ever taken in such an event.

<h6><a name="menus.edit.thresholds.color"></a>5.1.1.2.1.2. Color</h6>

If a non-transparent color has been selected (see previous section), whenever the threshold condition occurs, all displays of the monitored data cell change color (in data tables or in viewers), and return to their normal color when the threshold condition no longer exists.

<p>When several thresholds are placed on the same data cell with different colors, and they all trigger, the behavior is undefined at this time (but the most recent threshold is likely to prevail).

<h6><a name="menus.edit.thresholds.script"></a>5.1.1.2.1.3. Script</h6>

Whenever a threshold is triggered (the manner of which depends on the type), the corresponding script is passed to the UNIX shell interpreter (the <i>sh</i> UNIX command), after variable substitution.

<p>Substitution occurs prior to script invocation if the script contains any % characters. Each % and the character following it is replaced with information from the threshold occurrence. The replacement depends on the character following the %, as defined in the following list:
<ul>
<li><b>%%</b>: replaced by a single %.
<li><b>%c</b>: replaced by the original data cell string (as would be displayed in any data viewer).
<li><b>%s</b>: replaced by the contents of the source column from the thresholds table.
<li><b>%t</b>: the threshold value
<li><b>%T</b>: the threshold type (either <i>up</i> or <i>down</i>)
<li><b>%v</b>: the data cell value responsible for triggering the threshold
</ul>

<h6><a name="menus.edit.configuration"></a>5.1.1.2.2. Configuration</h6>

When selected, this menu launches the configuration dialog box, as described in <a href="#core.configuration">Configuration</a>.

<h6><a name="menus.edit.new"></a>5.1.1.2.3. New</h6>

Allows the creation of empty viewers of any type (graph chart, stacked graph chart, overlap bar chart, side bar chart, stacked bar chart, 2D pie chart, 3D pie chart, summary table or free text).
<br>This menu is only visible when not running in read-only mode (see <a href="#commandline">Command line</a>).

<h6><a name="menus.edit.preferences"></a>5.1.1.2.4. Preferences</h6>

The Preferences dialog box is very similar to the <a href="#core.configuration">configuration</a> dialog box, except that it also includes canvas printing default settings.
<br>It allows the user to change application wide settings, saved in a global file (known as an <i>rc</i> file to UNIX people), used for initialization when the application is started. Since this file is stored in the user home directory (on a UNIX system), it provides a way for a user to customize the look, behavior, ... of the moodss application in a permanent manner.

<p>Preferences choices, when applied (either by choosing Apply or OK) also affect <a href="#core.configuration">configuration</a> settings.

<p>Further and up-to-date help is always provided in the different Preferences dialog box screens.

<h6><a name="menus.edit.preferences.printing"></a>5.1.1.2.4.1. Printing</h6>

Choose the default behavior when printing: either to a printer or a file, and set various parameters.

The print command typically reads the Postscript data from its standard input and redirects it to the specified printer (for example, on UNIX, 'lpr -Pacme' will print the canvas area on the "acme" printer.
<br>By default, the command is set to 'lpr -P%P', which by including the <em>%P</em> generic printer name tag allows the user to pick the printer from a list (drawn from the /etc/printcap database) at printing time.

<p>When printing to a file, you may choose its default location and name with the file browser. Note that it can be overridden in the print dialog box launched when actually printing.

<h6><a name="menus.view"></a>5.1.1.3. View</h6>

<h6><a name="menus.view.refresh"></a>5.1.1.3.1. Refresh</h6>

Immediately refreshes display of all loaded asynchronous modules.

<h6><a name="menus.view.polltime"></a>5.1.1.3.2. Poll Time</h6>

The <i>View</i> menu (may not exist, see below) contains the <i>Poll Time</i> entry which when selected launches the corresponding dialog box, as shown below:

<center><pre><img src="moodss2.gif" alt"poll time dialog box"></pre></center>

The user can select a new poll time among the module choices from a spin entry widget, or directly type in a new value, as long as it is not smaller than the module minimum poll time, in which case a warning message is displayed.

<p>When several modules are used, the minimum poll time is the greater of the minimum poll times of all modules. The default poll time (used when moodss is started) is the greater of the default poll times of all modules. The available choices in the poll time dialog box is the combination of all modules poll times.

<p>The <i>Poll time</i> menu entry is available only when needed, which is not the case if all the loaded modules are asynchronous. If this case, the <i>Options</i> menu itself is not displayed.
<br>This menu is only visible when not running in read-only mode (see <a href="#commandline">Command line</a>).

<h6><a name="menus.help"></a>5.1.1.4. Help</h6>

<h6><a name="menus.help.global"></a>5.1.1.4.1. Global</h6>

This menu launches an embedded HTML viewer with this very document minus the sections related to module development.

<h6><a name="menus.help.modules"></a>5.1.1.4.2. Modules</h6>

This menu features one sub menu per module, which when selected displays the module's help data.

<h6><a name="menus.help.copyright"></a>5.1.1.4.3. Copyright</h6>

Displays the GPL (Gnu General Public License) document, a truly great idea from the Free Software Foundation.

<h6><a name="menus.help.sourceversions"></a>5.1.1.4.4. Source Versions</h6>

Displays all the source code file names with their versions, in a table with sortable columns (as in table viewers).

<h6><a name="menus.help.about"></a>5.1.1.4.5. About</h6>

Displays version, author, extension authors, license and basic information about moodss.

<h5><a name="draganddrop"></a>5.1.2 Drag and drop</h5>

Drag and drop in moodss tries to behave as the now familiar Windows functionality (no, it doesn't mean I am a Bill Gates fan, as they probably stole the idea from somebody else anyway :^). For example, to create a graphical plot, one must first select one or more data cells in a data table, hold down the first mouse button (the left one for a right handed user) while dragging over to the left-most icon below the menu bar (when dragging an object, as the mouse pointer passes over possible drop sites, they are highlighted with a thin black border for user feedback). Releasing the mouse button at this time results in the creation of a BLT graph viewer.

<p>Only valid drop sites for the data being dragged are highlighted when the mouse cursor passes over them, thus guaranteeing error free operations (if there are no bugs, that is :).

<p>In summary, data cells can be dragged from any table or any viewer into any viewer drop site icon, any viewer or the eraser.

<h6><a name="dropsites"></a>5.1.2.1. Drop sites</h6>

All icons right below the menu bar are valid drop sites for data cells (several may be dropped at the same time). From left to right:

<ul>
<li>graph viewer with one or more data curves created at once
<li>stacked graph viewer with one or more data filled curves created at once
<li>side by side bar chart with one or more data bars created at once
<li>stacked bar chart with one or more data bars created at once
<li>2D pie chart with one or more data slices created at once
<li>3D pie chart with one or more data slices created at once
<li>summary table with one or more data rows created at once
<li>free text with one or more labeled data cell windows created at once
<li>thresholds with one or more entries created at once
<li>object eraser with one or more data viewer elements deleted at once
</ul>

<p>For example, a graph viewer with 1 curve is created by dropping 1 data cell into the graph viewer icon.

<p>Once a viewer exists, it also acts as a drop site for data cells, which may be dragged from any table or other viewers. Dropping one or more cells directly in the viewer results in corresponding lines, bars, slices or rows being created and automatically updated. Each new graphical element is assigned a new and different color.

<p>You may delete one or more viewer elements (graph lines, bar chart bars, pie charts slices, summary table rows or free text cell window) from a viewer by selecting them (using the first mouse button) through their labels. Several elements can be selected by depressing the control key as the first mouse button is pressed. The selection can also be extended by depressing the shift key along with the first mouse button. The pie slices can also be directly selected by clicking on the slices themselves.
<br>Then dragging from the viewer to the eraser drop site (the pencil eraser) on the upper right side of the main window and releasing the first mouse button result in the corresponding viewer elements to be destroyed. When there are no remaining elements, the viewer itself (graph, bar chart, pie or summary table) can be destroyed by dropping it into the eraser site. The free text viewer can only be deleted this way when completely emptied of any text and data cell window.

<p>Any viewer can be deleted in one shot by dropping from the eraser icon into it.

<p>Any viewer also acts as a drop site for viewer type data, which allows viewer mutation by just dropping from the new viewer type icon into the existing viewer. It is much quicker than destroying the existing viewer and create a new one of the new type, while remembering which data cells were monitored by the viewer of the old type.
<br>When mutating, if some cells in the current viewer no longer exist (they may belong to a disappeared summary table), they are not made a part of the new viewer, and a warning message is flashed to the user in the message area.

<h6><a name="dragsites"></a>5.1.2.2. Drag sites</h6>

A table is obviously a drag site. One or more cells can be dragged at once after selection, using the traditional single/shift/control mouse click technique.

<p>Any viewer is also a drag site. It requires selecting one or more viewer elements before initiating the drag operation from any selected element in the viewer. If there are no selected elements, dragging is impossible: the mouse cursor is not changed into the drag circular cursor.

<p>If a viewer contains no elements, then the viewer itself can be dragged and dropped into the eraser.

<p>All viewer icons (below the menu bar) are drag sites for viewer type data, which allows quick viewer mutation (see mechanism description in <a href="#dropsites">Drop sites</a>).

<p>The eraser icon is also a drag site of the killing action type, which allows viewer destruction in one shot.

<h4><a name="commandline"></a>5.2. Command line</h4>

<h5><a name="mainarguments"></a>5.2.1. Main arguments</h5>

Launching moodss is very simple:

<pre>    $ moodss</pre>

or

<pre>    $ wish moodss</pre>

if the Tcl/Tk wish interpreter is not found in your PATH. You can then dynamically load modules from the File menu.

<p>You can also just pass one or more data module names as parameters, as in:

<pre>    $ wish moodss random</pre>

or, for 2 modules at once:

<pre>    $ wish moodss ps cpustats</pre>

You can specify the same module more than once and with different arguments in the command line:

<pre>    $ wish moodss ps -r host.domain ps -r otherhost.domain</pre>

When several modules of the same type are passed as argument, the initial data tables feature the module name followed by a number as title. For example <i>"ps&lt;2>"</i>. If the module provides an identifier string, that text will be used instead, as in <i>"ps(host.domain)"</i>. Data cell labels include the module identifier or numbered module name as well, for proper identification.

<p>You may eventually specify a poll time in seconds using:

<pre>    $ wish moodss -p 25 random</pre>

Note that when all the specified modules are asynchronous, the poll time option specifies the preferred interval for graph viewers.

<p>Once saved through the File Save menus (for example in save.moo), the configuration can be retrieved using:

<pre>    $ wish moodss -f save.moo</pre>

which would result in the same modules being loaded, the same viewers displayed at the same positions and sizes, the same poll time being used, as well at the same application window size. New modules data displays can be added at any latter time to existing dashboards by specifying modules on the command line after the -f (--file) switch / value pair.

<p>Command line options include:

<ul>
<li><b>--debug</b>: set verbose reporting when module errors occur
<li><b>-f</b> (or <b>--file</b>): specify a configuration file name
<li><b>-h</b> (or <b>--help</b>): display some help text and exit
<li><b>-geometry</b>: set the initial geometry of the main window (a la X window)
<li><b>-p</b> (or <b>--poll-time</b>): specify a poll time in seconds
<li><b>-r</b> (or <b>--read-only</b>): disable viewer creation, editing, ...
<li><b>-S</b> (or <b>--static</b>): disable internal window manager sizing and moving
<li><b>--show-modules</b>: discover valid moodss modules, show their directory location(s) and exit
<li><b>--version</b>: output version information and exit
</ul>

Moodss command line options must appear before any module name appears on the command line, so as not to interfere with the module options.

<p>In debug mode, when errors occur within the module namespace body or initialize procedure, the error message (either in text output when loading the module from the command line, or in a message window when dynamically loading the module) is followed by a Tcl stack trace of what was in progress when the error occurred (see the Tcl <i>error</i> manual page for further information).

<h5><a name="modulearguments"></a>5.2.2. Module arguments</h5>

Module themselves can take options (if programmed to do so, see <a href="#initialization">module initialization</a>), through command line arguments placed right after the module name and before the next module name, if any.

<p>For example, the following command:

<pre>    $ moodss -p 15 random --asynchronous arp --remote jdoe@foo.bar --numeric route --numeric</pre>

causes the <i>random</i> module to update asynchronously, the <i>arp</i> module to collect data from the <i>foo.bar</i> host under the <i>jdoe</i> login name and not attempt to lookup symbolic names for hosts, with the last module <i>route</i> doing the same.

<p>Note the setting the application poll time to 15 seconds does not interfere with the module options.

<p>The moodss core checks the validity of module options according to the information provided by the module programmer. Any invalid option / value combination for the module is detected, reported on the standard error channel before the application exits.

<p>Finally, it is always possible to determine the valid options for a module, using the following command:

<pre>    $ moodss module --help</pre>

<h4><a name="core.configuration"></a>5.3. Configuration</h4>

All configuration parameters can be set using the following interface:

<center><pre><img src="moodss6.gif" alt"configuration dialog box"></pre></center>

The Configuration dialog box allows the user to change global settings for the current view (also called a dashboard). This data is stored along when saving the configuration to a file (see <a href="#menus.file.save">Save</a> menu).

<p>Changing configuration choices do not affect the <a href="#core.preferences">Preferences</a> choices, which are used as initial values the first time the user modifies the configuration. Configuration settings have a higher priority than preferences settings, but are lost when not filed.

<p>Configuration entry is done through pages organized in a browsable hierarchical tree, always visible on the left side of the configuration dialog box (see picture above).

<p>After selection of the category from the tree on the left, a related dialog interface appears, which may or may not allow immediately applying new data values.
<br>Clicking on the OK button results in the current configuration data to be saved in memory. It will be stored in the save file when requested (see File <a href="#menus.file.save">Save</a> and <a href="#menus.file.saveas">Save As</a> menus).

<p>Specific help can always be accessed by clicking on the bottom <b>Help</b> button when in a configuration page.

<h5><a name="configuration.canvas"></a>5.3.1. Canvas</h5>

The canvas is the data viewers background area, and its configuration (size, color, ...) can be changed as described below.

<h5><a name="configuration.canvas.size"></a>5.3.1.1. Size</a></h5>

The canvas width and height can be changed so that all the different tables and viewers that the dashboard comprises can fit nicely within the viewing space.
<p>The default is the current screen size.
<p>The size is immediately updated when clicking on the <b>Apply</b> button.

<h5><a name="configuration.canvas.colors"></a>5.3.1.2. Colors</a></h5>

The canvas color can be changed for your viewing pleasure...
<p>The color is immediately updated when clicking on the <b>Apply</b> button.

<h5><a name="configuration.viewers"></a></a>5.3.2. Viewers</h5>

The viewers are used for viewing table data, and their configuration (colors, ...) can be changed as described below.

<h5><a name="configuration.viewers.colors"></a>5.3.2.1. Colors</a></h5>

These are the colors of viewer elements. For each viewer that needs different colors for displaying data cell elements (such as graphs, pie charts, ...), each new element uses the next color in the sequence (wraps around if necessary).

<p><i>Advice</i>: adjacent colors should be very different, colors should be visible on a black background.

<p><i>Note</i>: in a future version, creating, deleting and moving colors in the sequence will be possible.

<h5><a name="configuration.viewers.graphs"></a>5.3.2.2. Graphs</a></h5>

The number of samples (on the X axis) can be changed for data graph viewers. The specified value will not be used for existing graphs but for newly created ones.

<h5><a name="configuration.viewers.pies"></a>5.3.2.3. Pies</a></h5>

The labeler type for data pie viewers can be changed as follows:
<ul>
<li>current value labels can be displayed next to corresponding slices (<b>peripheral</b> style)
<li>or next to the corresponding text labels (<b>box</b> style)
</ul>

<p>The selected type will not be used for existing pies but for newly created ones.

<h4><a name="core.preferences"></a>5.4. Preferences</h4>

The preferences dialog box is used for application-wide settings.

<p>On UNIX systems, preferences data is saved in each user home directory under the <i>rc</i> file named <i>.moodssrc</i>.

<p>On Windows, data is saved in <i>C:\.moodssrc</i> (by default, but depends on the <i>HOME</i> variable).

<p>After selection of the category from the tree on the left, a related dialog interface appears.
<br>Help is provided for each interface, which may or may not allow immediately applying new data values.
<br>Clicking on the <b>OK</b> button results in the preferences data to be written to the <i>rc</i> file.

<h5><a name="preferences.canvas"></a>5.4.1. Canvas</h5>

<h5><a name="preferences.canvas.printing"></a>5.4.1.1. Printing</a></h5>

The canvas area can be printed in the Postscript data format.

<p>The default behavior when printing can be set to either a printer or a file, but can always be overridden in the print dialog box launched when actually printing.
<br>Various parameters, such as orientation, palette and paper size can be set.

<p>The print command typically reads the Postscript data from its standard input and redirects it to the specified printer (for example, on UNIX, <tt>lpr -Pacme</tt> will print the canvas area on the <i>acme</i> printer, and <tt>lpr -P%P</tt> will allow printer selection from a listbox at printing time.

<p>When printing to a file, you may choose its default with the file browser.

<h5><a name="preferences.thresholds"></a>5.5.1. Thresholds</h5>

<h5><a name="preferences.thresholds.email"></a>5.5.1.1. Email</h5>

When a threshold event occurs, an email alert message can be sent (see <a href="#menus.edit.thresholds">thresholds</a>).

<p>Proper identification is required so that the originator of the message (the <i>From</i> address field in an email message) is known. Use your own email address or another email address (such as <i>moodss@your.domain.com</i>) that you control.
<br>In any case, the <b>From address</b> field must contain a valid email address.
<br>Your user name is used by default.

<p>Sending email requires an <b>Outgoing mail SMTP server</b>. Input the one that you use for sending your emails (check your browser or email software current configuration), or any other valid SMTP address (consult your system administrator in case of doubt).
<br>The local host (<i>127.0.0.1</i> address) is used by default.


<h3><a name="future"></a>8. Future developments</h3>

The following features will eventually be added to the core (also look at the TODO file):

<ul>
<li>more Linux modules
<li>more data viewers
<li>table row and column selection in one click
</ul>

I welcome any suggestion for new features that you may need in your specific use of moodss.

<h3><a name="misc"></a>9. Miscellaneous information</h3>

For downloading Tcl software (such as stooop, scwoop, tkpiechart, ...), many Redhat rpm packages, visit my home page at <a href="http://jfontain.free.fr/">http://jfontain.free.fr/</a>.

<p>Send your comments, complaints, ... to <a href="mailto:jfontain@free.fr">jfontain@free.fr</a>.

</body>
</html>
}
