# copyright (C) 1997-2001 Jean-Luc Fontaine (mailto:jfontain@free.fr)
# this program is free software: please read the COPYRIGHT file enclosed in this package or use the Help Copyright menu

set rcsId {$Id: myvars.tcl,v 1.14 2001/02/15 20:31:39 jfontain Exp $}


package provide myvars [lindex {$Revision: 1.14 $} 1]
if {[lsearch -exact $auto_path /usr/lib]<0} {                         ;# in case Tcl/Tk is somewhere else than in the /usr hierarchy
    lappend auto_path /usr/lib
}
if {[catch {package require Mytcl} message]} {
    error "$message\nMytcl package does not seem to be installed:\nget it at http://jfontain.free.fr/"
}


namespace eval myvars {

    array set help {
        back_log \
{The number of outstanding connection requests MySQL can have.
This comes into play when the main MySQL thread gets VERY
many connection requests in a very short time. It then takes some
time (although very little) for the main thread to check the connection
and start a new thread. The back_log value indicates how many
requests can be stacked during this short time before MySQL momentarily
stops answering new requests. You need to increase this only if you
expect a large number of connections in a short period of time.}
        basedir \
{Normally you should need to tell mysqld only the base directory
under which MySQL is installed. You can do this with the --basedir
option. You can also use --help to check the effect of changing
path options.}
        connect_timeout \
{The number of seconds the mysqld server is waiting for a
connect packet before responding with Bad handshake.}
        datadir \
{DATADIR is the MySQL data directory (typically /usr/local/mysql/data
for a binary installation, or /usr/local/var for a source installation).
Note that this is the directory that was specified at configuration time,
not the one specified with --datadir when mysqld starts up! (--datadir
has no effect on where the server looks for option files, because it
looks for them before it processes any command-line arguments.)}
        delayed_insert_limit \
{After inserting delayed_insert_limit rows, the INSERT DELAYED
handler will check if there are any SELECT statements pending.
If so, it allows these to execute before continuing.}
        delayed_insert_timeout \
{How long a INSERT DELAYED thread should wait
for INSERT statements before terminating.}
        delayed_queue_size \
{How big a queue (in rows) should be allocated for handling INSERT
DELAYED. If the queue becomes full, any client that does INSERT
DELAYED will wait until there is room in the queue again.}
        flush_time \
{If this is set to a non-zero value, then every flush_time seconds all
tables will be closed (to free up resources and sync things to disk).}
        language \
{mysqld can issue error messages in the following languages:
Czech, Dutch, English (the default), Estonia, French,
German, Hungarian, Italian, Norwegian, Norwegian-ny,
Polish, Portuguese, Spanish and Swedish.
To start mysqld with a particular language, use either the
--language=lang or -L lang options.}
        log {whether standard log is turned ON or OFF}
        log_update {whether update log is turned ON or OFF}
        long_query_time \
{If a query takes longer than this (in seconds),
the Slow_queries counter will be incremented.}
        low_priority_updates \
{If ON, all INSERT, UPDATE, DELETE and
LOCK TABLE WRITE statements wait until there
is no pending SELECT or LOCK TABLE READ
on the affected table.}
        max_allowed_packet \
{The maximum size of one packet. The message buffer is initialized
to net_buffer_length bytes, but can grow up to max_allowed_packet
bytes when needed. This value by default is small to catch big
(possibly wrong) packets. You must increase this value if you are
using big BLOB columns. It should be as big as the biggest BLOB
you want to use.}
        max_connect_errors \
{If there is more than this number of interrupted connections
from a host this host will be blocked for further connections.
You can unblock a host with the command FLUSH HOSTS.}
        max_connections \
{The number of simultaneous clients allowed. Increasing this value
increases the number of file descriptors that mysqld requires.}
        max_join_size \
{Joins that are probably going to read more than max_join_size
records return an error. Set this value if your users tend to
perform joins without a WHERE clause that take a long time
and return millions of rows.}
        max_sort_length \
{The number of bytes to use when sorting BLOB or TEXT values
(only the first max_sort_length bytes of each value are used;
the rest are ignored).}
        max_write_lock_count \
{Forces MySQL to issue a SELECT after a
specific number of inserts on a table.}
        net_buffer_length \
{The communication buffer is reset to this size between queries.
This should not normally be changed, but if you have very little
memory, you can set it to the expected size of a query. (That is,
the expected length of SQL statements sent by clients. If
statements exceed this length, the buffer is automatically
enlarged, up to max_allowed_packet bytes.)}
        pid_file {file containing the mysqld process identifier}
        port {the TCP/IP port that the server is using (default: 3306)}
        protocol_version {the server/client protocol version}
        record_buffer \
{Each thread that does a sequential scan allocates a buffer of this
size for each table it scans. If you do many sequential scans, you
may want to increase this value.}
        skip_locking \
{Use the --skip-locking MySQL option to avoid external locking.
Note that this will not impact MySQL functionality as long that
only run one server. Just remember to take down the server (or
lock relevant parts) before you run myisamchk. On some system
this switch is mandatory since the external locking does not work
in any case.
The only case when you cannot use --skip-locking is if you run
multiple MySQL SERVERS (not clients) on the same data. Or run
myisamchk on the table without first flushing and locking the
mysqld server tables first.}
        skip_networking \
{Do not allow TCP/IP connections over the network.
All connections to mysqld must be made via Unix sockets.
This option is unsuitable for systems that use MIT-pthreads,
because the MIT-pthreads package does not support Unix
sockets.}
        socket \
{The socket file to use when connecting to localhost
(which is the default host).}
        sort_buffer \
{Each thread that needs to do a sort allocates a buffer of this
size. Increase this value for faster ORDER BY or GROUP BY
operations.}
        table_cache \
{The number of open tables for all threads. Increasing this value
increases the number of file descriptors that mysqld requires.
MySQL needs two file descriptors for each unique open table.}
        thread_stack \
{The stack size for each thread. Many of the limits detected by the
crash-me test are dependent on this value. The default is large
enough for normal operation.}
        tmp_table_size \
{If a temporary table exceeds this size, MySQL generates an error
of the form `The table tbl_name is full'. Increase the value of
tmp_table_size if you do many advanced GROUP BY queries.}
        tmpdir {directory where temporary tables/files are created}
        version {the MySQL server version number}
        wait_timeout \
{The number of seconds the server waits for activity on a
connection before closing it. See also interactive_timeout.}
    }

    # specifies whether a variable is not of numeric type, so other variables may be used in viewers that expect such a type
    array set notNumeric {
        basedir {} bdb_home {} bdb_logdir {} bdb_tmpdir {} datadir {} language {} large_files_support {} locked_in_memory {}
        log {} log_update {} low_priority_updates {} pid_file {} protocol_version {} skip_locking {} skip_networking {} socket {}
        tmpdir {} version {}
    }
    array set data {
        updates 0
        0,label {} 0,type ascii 0,message {} 0,0 {}
        pollTimes {10 5 20 30 60 120 300}
        switches {--host 1 --password 1 --port 1 --user 1}
    }
    set file [open myvars.htm]
    set data(helpText) [read $file]                                                           ;# initialize HTML help data from file
    close $file

    proc initialize {optionsName} {
        upvar $optionsName options
        variable host
        variable user
        variable connection
        variable help
        variable data
        variable notNumeric

        set arguments {}
        set host localhost                                                                                             ;# by default
        catch {set host $options(--host)}
        lappend arguments $host
        set user $::env(USER)                                                                                          ;# by default
        catch {set user $options(--user)}
        lappend arguments $user
        set password {}
        catch {set password $options(--password)}
        catch {lappend arguments $password}
        lappend arguments {}                                                                              ;# no preselected database
        set port 3306                                                                                                  ;# by default
        catch {set port $options(--port)}
        catch {lappend arguments $port}
        set data(identifier) myvars($host)
        set connection [eval sql connect $arguments]
        set query [sql query $connection {show variables like 'version'}]
        scan [lindex [sql fetchrow $connection $query] 1] %u.%u.%u major minor subMinor
        sql endquery $connection $query
        if {$major<3} {
            error {cannot monitor a server below version 3}
        }
        if {$minor<22} {
            error {cannot monitor a server below version 3.22}
        }
        if {$minor>23} {
            error {cannot monitor a server above version 3.23}
        }
        if {$minor==23} {
            if {$subMinor<33} {
                error {cannot monitor a server below version 3.23.33 in the 3.23 series}
            }
            array set help {
                ansi_mode {ON if mysqld was started with --ansi}
                binlog_cache_size \
{The size of the cache to hold the SQL statements for the binary
log during a transaction. If you often use big, multi-statement
transactions you can increase this to get more performance.}
                character_set {the default character set}
                character_sets {the supported character sets}
                concurrent_insert \
{If ON (the default), MySQL will allow you to use INSERT on
MyISAM tables at the same time as you run SELECT queries
on them. You can turn this option off by starting mysqld with
--safe or --skip-new.}
                delay_key_write \
{If enabled (is on by default), MySQL will honor the delay_key_write
option CREATE TABLE. This means that the key buffer for tables with
this option will not get flushed on every index update, but only when
a table is closed. This will speed up writes on keys a lot but you
should add automatic checking of all tables with
"myisamchk --fast --force" if you use this. Note that if you start
mysqld with the --delay-key-write-for-all-tables option this means
that all tables will be treated as if they were created with the
delay_key_write option. You can clear this flag by starting mysqld
with --skip-new or --safe-mode.}
                flush {ON if you have started MySQL with the --flush option.}
                have_bdb \
{YES if mysqld supports Berkeley DB tables.
DISABLED if --skip-bdb is used.}
                have_gemini \
{YES if mysqld supports Gemini tables.
DISABLED if --skip-gemini is used.}
                have_innobase \
{YES if mysqld supports Innobase tables.
DISABLED if --skip-innobase is used.}
                have_isam {YES if mysqld supports ISAM tables.}
                have_raid {YES if mysqld supports the RAID option.}
                have_ssl \
{YES if mysqld supports SSL (encryption)
on the client/server protocol.}
                init_file \
{The name of the file specified with the --init-file option
when you start the server. This is a file of SQL statements
you want the server to execute when it starts.}
                interactive_timeout \
{The number of seconds the server waits for activity on an
interactive connection before closing it. An interactive
client is defined as a client that uses the CLIENT_INTERACTIVE
option to mysql_real_connect(). See also wait_timeout.}
                join_buffer_size \
{The size of the buffer that is used for full joins (joins that do not
use indexes).  The buffer is allocated one time for each full join
between two tables. Increase this value to get a faster full join
when adding indexes is not possible. (Normally the best way to
get fast joins is to add indexes.)}
                key_buffer_size \
{Index blocks are buffered and are shared by all threads.
key_buffer_size is the size of the buffer used for index blocks.
Increase this to get better index handling (for all reads and multiple
writes) to as much as you can afford; 64M on a 256M machine that
mainly runs MySQL is quite common. If you however make this too
big (more than 50% of your total memory?) your system may start to
page and become REALLY slow. Remember that because MySQL
does not cache data read, that you will have to leave some room
for the OS filesystem cache. You can check the performance of the
key buffer by doing show status and examine the variables
Key_read_requests, Key_reads, Key_write_requests and Key_writes.
The Key_reads/Key_read_request ratio should normally be < 0.01.
The Key_write/Key_write_requests is usually near 1 if you are using
mostly updates/deletes but may be much smaller if you tend to do
updates that affect many at the same time or if you are using
delay_key_write.}
                large_files_support {whether mysqld was compiled with options for big file support.}
                locked_in_memory {if mysqld was locked in memory with --memlock}
                log_bin {if the binary log is enabled}
                log_slave_updates {if the updates from the slave should be logged}
                log_update {if the update log is enabled}
                lower_case_table_names {Change all table names to lower case on disk.}
                max_binlog_size \
{If a write to the binary (replication) log exceeds the
given value, rotate the logs. You cannot set it to less
than 1024 bytes, or more than 1 GB. Default is 1 GB.}
                max_binlog_cache_size \
{If a multi-statement transaction requires more than this amount
of memory, one will get the error "Multi-statement transaction
required more than 'max_binlog_cache_size' bytes of storage".}
                max_delayed_threads \
{Don't start more than this number of threads to handle
INSERT DELAYED statements. If you try to insert data
into a new table after all INSERT DELAYED threads
are in use, the row will be inserted as if the DELAYED
attribute wasn't specified.}
                max_heap_table_size {Do not allow creation of heap tables bigger than this.}
                max_tmp_tables \
{(This option does not yet do anything) Maximum number of
temporary tables a client can keep open at the same time.}
                myisam_recover_options \
{If this option is used, mysqld will on open check if the table is marked as
crashed or if if the table was not closed properly
(The last option only works if you are running with --skip-locking).
If this is the case mysqld will run check on the table. If the table was
corrupted, mysqld will attempt to repair it.
The following options affect how the repair works:
- DEFAULT: The same as not giving any option to --myisam-recover.
- BACKUP: If the data table was changed during recover, save a backup
of the `table_name.MYD' data file as `table_name-datetime.BAK'.
- FORCE: Run recover even if we will loose more than one row from the
.MYD file.
- QUICK: Do not check the rows in the table if there is not any delete
blocks.}
                myisam_sort_buffer_size \
{The buffer that is allocated when sorting
the index when doing a REPAIR table.}
                net_read_timeout \
{Number of seconds to wait for more data from a connection
before aborting the read. Note that when we do not expect data
from a connection, the timeout is defined by write_timeout.}
                net_retry_count \
{If a read on a communication port is interrupted, retry this
many times before giving up. This value should be quite high
on FreeBSD as internal interrupts is sent to all threads.}
                net_write_timeout \
{Number of seconds to wait for a block to be written
to a connection before aborting the write.}
                open_files_limit \
{If this is not 0, then mysqld will use this value to reserve file descriptors
to use with getrlimit(). If this value is 0 then mysqld will reserve
(max_connections * 5) or (max_connections + (table_cache * 2))
(whichever is larger) number of files. You should try increasing this if
mysqld gives you the error 'Too many open files'.}
                query_buffer_size \
{The initial allocation of the query buffer.
If most of your queries are long (like when
inserting blobs), you should increase this!}
                safe_show_database \
{Do not show databases for which the user does not have any database
or table privileges. This can improve security if you are concerned
about people being able to see what databases other users have.
See also skip_show_databases.}
                server_id \
{The unique replication numeric server id.
You should pick one to assign.
The range is from 1 to 2^32-1.
Set on both Master and Slave.}
                skip_show_database \
{This prevents people from doing SHOW DATABASES, if they do not
have the PROCESS_PRIV privilege. This can improve security if
you are concerned about people being able to see what databases
and tables other users have.}
                slow_launch_time \
{If the creating of the thread is longer than this (in seconds),
the Slow_launch_threads counter will be incremented.}
                table_type {the default table type}
                thread_cache_size \
{How many threads we should keep keep in a cache for reuse. When
a client disconnects the clients threads is put in the cache if there is
not more than thread_cache_size threads from before. All new threads
are first taken from the cache and only when the cache is empty a
new thread is created. This variable can be increased to improve
performance if you have a lot of new connections (Normally this does
not however give a notable performance improvement if you have a
good thread implementation).}
                timezone {the timezone for the server}
            }
            array set notNumeric {
                ansi_mode {} character_set {} character_sets {} concurrent_insert {} delay_key_write {} flush {} have_bdb {}
                have_bdb {} have_gemini {} have_innobase {} have_isam {} have_raid {} have_ssl {} init_file {} log_bin {}
                log_slave_updates {} log_update {} lower_case_table_names {} safe_show_database {} skip_show_database {}
                table_type {} timezone {}
            }
        } else {
            array set help {
                join_buffer \
{The size of the buffer that is used for full joins (joins that do not
use indexes).  The buffer is allocated one time for each full join
between two tables. Increase this value to get a faster full join
when adding indexes is not possible. (Normally the best way to
get fast joins is to add indexes.)}
                key_buffer \
{Index blocks are buffered and are shared by all threads.
key_buffer_size is the size of the buffer used for index blocks.
Increase this get better index handling (for all reads and multiple
writes) to as much as you can afford.  If you make this too big the
system will starte to page and go REAL slow. Remember that since
MySQL does not cache data read that you will have to leave some
room for the OS filesystem cache.
To get even more speed when writing many rows at the same time
use LOCK TABLES.}
                max_delayed_insert_threads \
{Do not start more than this number of threads to handle INSERT
DELAYED statements. If you try to insert data in a new table
after all INSERT DELAYED threads are in use, the row will be
inserted as if the DELAYED attribute was not specified.}
            }
        }

        set column 1
        foreach variable [lsort -dictionary [array names help]] {
            set data($column,label) $variable
            if {[info exists notNumeric($variable)]} {
                set data($column,type) ascii
            } else {
                set data($column,type) real                     ;# so that cell may be dropped in viewers that expect a numeric type
            }
            set data($column,message) $help($variable)
            set data($column,anchor) left
            lappend indices $column
            incr column
        }
        set data(views) [list [list indices $indices swap 1]]
    }

    proc update {} {
        variable connection
        variable data

        if {[catch {set query [sql query $connection {show variables}]} message]} {                       ;# problem reaching server
            flashMessage "myvars error: $message"
            foreach name [array names data *,label] {
                scan $name %u column
                if {$column==0} continue                                                                           ;# headers column
                set data(0,$column) ?
            }
        } else {
            while {[llength [set list [sql fetchrow $connection $query]]]>0} {
                lappend lists $list
            }
            sql endquery $connection $query
            set column 1
            foreach list [lsort -index 0 $lists] {                            ;# make sure variables alphabetical order is preserved
                foreach "variable data(0,$column)" $list {}
                incr column
            }
        }
        incr data(updates)
    }

    proc terminate {} {
        variable connection
        catch {sql disconnect $connection}
    }

}
