# copyright (C) 1997-2001 Jean-Luc Fontaine (mailto:jfontain@free.fr)
# this program is free software: please read the COPYRIGHT file enclosed in this package or use the Help Copyright menu

set rcsId {$Id: gui.tcl,v 2.31 2001/01/13 15:09:57 jfontain Exp $}


proc updateTitle {} {                                                          ;# show modules and poll time or mode in window title
    set names [modules::names]
    if {[llength $names]==0} {
        wm title . moodss
    } elseif {[llength $global::pollTimes]==0} {
        wm title . [format [mc {moodss: %s data (asynchronous)}] [commaSeparatedString $names]]
    } else {
        wm title . [format [mc {moodss: %s data (every %u seconds)}] [commaSeparatedString $names] $global::pollTime]
    }
}

proc underlineRemoved {string indexName} {     ;# underline is placed after character to underline, underlines are escaped with self
    upvar $indexName index                           ;# for example: passing A_bcd results in index set to 0 and Abcd to be returned

    set indices 0
    regexp -indices _ $string indices
    set index [expr {[lindex $indices 0]-1}]
    regsub _ $string {} string
    return $string
}

proc createMenuWidget {parentPath readOnly includePollTime} {
    set menu [menu $parentPath.menu -tearoff 0]
    set global::menu $menu
    frame $menu.bound                                  ;# create a frame for bindings that otherwise would propagate to all children
    set help(bar) [new menuContextHelp $menu]
    lappend objects $help(bar)
    set index(bar) -1

    menu $menu.file -tearoff 0
    set global::fileMenuContextHelper [new menuContextHelp $menu.file]
    lappend objects $global::fileMenuContextHelper
    set index(file) -1

    set string [underlineRemoved [mc F_ile] underline]
    $menu add cascade -label $string -menu $menu.file -underline $underline
    menuContextHelp::set $help(bar) [incr index(bar)] [mc {file related operations}]

    if {!$readOnly} {
        set string [underlineRemoved [mc S_ave] underline]
        $menu.file add command -label $string -command {save 0} -underline $underline -accelerator Ctrl+S
        bind $parentPath <Control-s> {save 0}
        set global::fileMenuContextHelperSaveIndex [incr index(file)]
        updateFileSaveMenuHelp $global::saveFile                          ;# save file may already have been defined in command line

        set string [underlineRemoved [mc {Save A_s}] underline]
        $menu.file add command -label $string... -command {save 1} -underline $underline -accelerator Ctrl+A
        bind $parentPath <Control-a> {save 1}
        menuContextHelp::set $global::fileMenuContextHelper [incr index(file)]\
            [mc {input file for saving configuration and viewers layout}]
    }

    set string [underlineRemoved [mc M_odules] underline]
    $menu.file add cascade -label $string -menu [menu $menu.file.modules -tearoff 0] -underline $underline
    menuContextHelp::set $global::fileMenuContextHelper [incr index(file)] [mc {operations on modules}]

    set moduleNames [modules::names]

    set help(modules) [new menuContextHelp $menu.file.modules]
    lappend objects $help(modules)
    set index(modules) -1
    set disable 1
    if {[llength $moduleNames]>0} {
        set disable 0
        set string [underlineRemoved [mc Load_ed] underline]
        $menu.file.modules add command -label $string... -command {new moduleOperations display} -underline $underline
        menuContextHelp::set $help(modules) [incr index(modules)] [mc {view loaded modules and their options}]
    }
    if {!$readOnly} {
        set disable 0
        set string [underlineRemoved [mc L_oad] underline]
        $menu.file.modules add command -label $string... -command {new moduleOperations load} -underline $underline
        menuContextHelp::set $help(modules) [incr index(modules)] [mc {load a new module instance}]
        if {[llength $moduleNames]>0} {
            set string [underlineRemoved [mc U_nload] underline]
            $menu.file.modules add command -label $string... -command {new moduleOperations unload} -underline $underline
            menuContextHelp::set $help(modules) [incr index(modules)] [mc {unload a module instance}]
        }
    }
    if {$disable} {
        $menu.file entryconfigure $index(file) -state disabled
    }

    set string [underlineRemoved [mc P_rint] underline]
    $menu.file add command -label $string... -command print::printOrSaveCanvas -underline $underline -accelerator Ctrl+P
    bind $parentPath <Control-p> print::printOrSaveCanvas
    menuContextHelp::set $global::fileMenuContextHelper [incr index(file)] [mc {print or save canvas area to file in postscript}]
    if {![string equal $::tcl_platform(platform) unix]} {
        $menu.file entryconfigure $index(file) -state disabled
    }
    $menu.file add separator
    incr index(file)
    set string [underlineRemoved [mc E_xit] underline]
    $menu.file add command -label $string -command exit -underline $underline -accelerator Ctrl+Q
    menuContextHelp::set $global::fileMenuContextHelper [incr index(file)] [mc {close main window and exit program}]
    bind $parentPath <Control-q> exit

    if {!$readOnly} {
        set string [underlineRemoved [mc E_dit] underline]
        $menu add cascade -label $string -menu [menu $menu.edit -tearoff 0] -underline $underline
        set help(edit) [new menuContextHelp $menu.edit]
        lappend objects $help(edit)
        menuContextHelp::set $help(bar) [incr index(bar)] [mc {content editing, configuration and preferences}]

        set string [underlineRemoved [mc T_hresholds] underline]
        $menu.edit add command -label $string... -command {thresholds::edit} -underline $underline
        menuContextHelp::set $help(edit) 0 [mc {edit data thresholds}]

        set string [underlineRemoved [mc C_onfiguration] underline]
        $menu.edit add command -label $string... -command {configuration::edit 0} -underline $underline
        menuContextHelp::set $help(edit) 1 [mc {edit current configuration}]

        set string [underlineRemoved [mc N_ew] underline]
        $menu.edit add cascade -label $string -menu [menu $menu.edit.new -tearoff 0] -underline $underline
        set help(new) [new menuContextHelp $menu.edit.new]
        lappend objects $help(new)
        menuContextHelp::set $help(edit) 2 [mc {create empty data viewers}]

        set string [underlineRemoved [mc {G_raph Chart}] underline]
        $menu.edit.new add command -label $string... -underline $underline\
            -command "createCellsViewer dataGraph {} 1 $global::static \$global::pollTime"
        menuContextHelp::set $help(new) 0 [mc {create an empty graph chart data viewer}]

        set string [underlineRemoved [mc {Stacked Graph C_hart}] underline]
        $menu.edit.new add command -label $string... -underline $underline\
            -command "createCellsViewer dataStackedGraph {} 1 $global::static \$global::pollTime"
        menuContextHelp::set $help(new) 1 [mc {create an empty stacked graph chart data viewer}]

        set string [underlineRemoved [mc {O_verlap Bar Chart}] underline]
        $menu.edit.new add command -label $string... -underline $underline\
            -command "createCellsViewer dataOverlapBarChart {} 1 $global::static"
        menuContextHelp::set $help(new) 2 [mc {create an empty overlap bar chart data viewer}]

        set string [underlineRemoved [mc {Side B_ar Chart}] underline]
        $menu.edit.new add command -label $string... -underline $underline\
            -command "createCellsViewer dataSideBarChart {} 1 $global::static"
        menuContextHelp::set $help(new) 3 [mc {create an empty side bar chart data viewer}]

        set string [underlineRemoved [mc {S_tacked Bar Chart}] underline]
        $menu.edit.new add command -label $string... -underline $underline\
            -command "createCellsViewer dataStackedBarChart {} 1 $global::static"
        menuContextHelp::set $help(new) 4 [mc {create an empty stacked bar chart data viewer}]

        set string [underlineRemoved [mc {2_D Pie Chart}] underline]
        $menu.edit.new add command -label $string... -underline $underline\
            -command "createCellsViewer data2DPieChart {} 1 $global::static"
        menuContextHelp::set $help(new) 5 [mc {create an empty 2D pie chart data viewer}]

        set string [underlineRemoved [mc {3_D Pie Chart}] underline]
        $menu.edit.new add command -label $string... -underline $underline\
            -command "createCellsViewer data3DPieChart {} 1 $global::static"
        menuContextHelp::set $help(new) 6 [mc {create an empty 3D pie chart data viewer}]

        set string [underlineRemoved [mc {Summary T_able}] underline]
        $menu.edit.new add command -label $string... -underline $underline\
            -command "createCellsViewer summaryTable {} 1 $global::static"
        menuContextHelp::set $help(new) 7 [mc {create an empty summary table data viewer}]

        set string [underlineRemoved [mc {F_ree Text}] underline]
        $menu.edit.new add command -label $string... -underline $underline\
            -command "createCellsViewer freeText {} 1 $global::static"
        menuContextHelp::set $help(new) 8 [mc {create an empty free text data viewer}]

        $menu.edit add separator
        set string [underlineRemoved [mc P_references] underline]
        $menu.edit add command -label $string... -command {configuration::edit 1} -underline $underline
        menuContextHelp::set $help(edit) 4 [mc {edit application-wide preferences}]
    }

    if {!$readOnly&&$includePollTime} {
        set string [underlineRemoved [mc V_iew] underline]
        $menu add cascade -label $string -menu [menu $menu.view -tearoff 0] -underline $underline
        set help(options) [new menuContextHelp $menu.view]
        lappend objects $help(options)
        menuContextHelp::set $help(bar) [incr index(bar)] [mc {data visualization settings}]

        set string [underlineRemoved [mc R_efresh] underline]
        $menu.view add command -label $string... -command {after idle ::refresh} -underline $underline -accelerator Ctrl+R
        bind $parentPath <Control-r> {after idle ::refresh}
        menuContextHelp::set $help(options) 0 [mc {refresh display of all synchronous modules}]
        set string [underlineRemoved [mc {P_oll Time}] underline]
        $menu.view add command -label $string... -command inquirePollTime -underline $underline
        menuContextHelp::set $help(options) 1 [mc {change poll time for all synchronous modules}]
    }

    set string [underlineRemoved [mc H_elp] underline]
    $menu add cascade -label $string -menu [menu $menu.help -tearoff 0] -underline $underline
    set help(help) [new menuContextHelp $menu.help]
    lappend objects $help(help)
    set index(help) -1
    menuContextHelp::set $help(bar) [incr index(bar)] [mc {help on moodss and modules}]

    set string [underlineRemoved [mc G_lobal] underline]
    $menu.help add command -label $string... -underline 0 -accelerator F1 -command generalHelpWindow
    bind $parentPath <F1> generalHelpWindow
    menuContextHelp::set $help(help) [incr index(help)] [mc {global help for user}]

    if {[llength $moduleNames]>0} {                                         ;# display modules help menu only if they are any loaded
        set string [underlineRemoved [mc M_odules] underline]
        $menu.help add cascade -label $string -menu [menu $menu.help.modules -tearoff 0] -underline $underline
        menuContextHelp::set $help(help) [incr index(help)] [mc {help on loaded modules}]
        set help(modulesHelp) [new menuContextHelp $menu.help.modules]
        lappend objects $help(modulesHelp)
        set index(modulesHelp) -1
        foreach module $moduleNames {
            $menu.help.modules add command -label $module... -command "moduleHelpWindow $module \[modules::helpHTMLData $module\]"
            menuContextHelp::set $help(modulesHelp) [incr index(modulesHelp)]\
                [format [mc {display %s module documentation}] $module]
        }
    }

    set string [underlineRemoved [mc C_opyright] underline]
    $menu.help add command -label $string... -underline $underline\
        -command {simpleTextDialogBox [mc {moodss: Copyright}] $help::copyright}
    menuContextHelp::set $help(help) [incr index(help)] [mc {display copyright information}]

    set string [underlineRemoved [mc {S_ource Versions}] underline]
    $menu.help add command -label $string... -underline $underline -command versionsDialogBox
    menuContextHelp::set $help(help) [incr index(help)] [mc {display all source files versions}]

    set string [underlineRemoved [mc A_bout] underline]
    $menu.help add command -label $string... -underline $underline -command aboutDialogBox
    menuContextHelp::set $help(help) [incr index(help)] [mc {display author and general information}]

    $parentPath configure -menu $menu

    bind $menu.bound <Destroy> "delete $objects"                                              ;# do a proper cleanup of used objects
}

proc updateFileSaveMenuHelp {file} {
    if {[string length $file]==0} {
        set string [mc {input file for saving configuration and viewers layout}]
    } else {
        set string [format [mc {into %s file, save configuration and viewers layout}] $file]
    }
    menuContextHelp::set $global::fileMenuContextHelper $global::fileMenuContextHelperSaveIndex $string
}

proc createMessageWidget {parentPath} {
    set global::messenger [new lifoLabel $parentPath -headerfont $font::(mediumBold) -font $font::(mediumNormal)]
    composite::configure $global::messenger body -width 200                       ;# make sure eventual initial messages are visible
    return $widget::($global::messenger,path)                                                             ;# return actual tk widget
}

proc dragEcho {data format} {
    return $data
}

proc createDragAndDropZone {parentPath} {
    set frame [frame $parentPath.drops]

    set label [label $frame.graph -image applicationIcon -relief sunken]
    pack $label -pady 1 -side left
    new dropSite -path $label -formats DATACELLS\
        -command "createCellsViewer dataGraph \$dragSite::data(DATACELLS) 1 $global::static \$global::pollTime"
    new widgetTip -path $label -text [mc "graph chart\ndrag'n'drop site"]
    set drag [new dragSite -path $label]
    dragSite::provide $drag VIEWER {dragEcho ::dataGraph}

    set label [label $frame.stackedGraph -image [image create photo -data [dataStackedGraph::iconData]] -relief sunken]
    pack $label -pady 1 -side left
    new dropSite -path $label -formats DATACELLS\
        -command "createCellsViewer dataStackedGraph \$dragSite::data(DATACELLS) 1 $global::static \$global::pollTime"
    new widgetTip -path $label -text [mc "stacked graph chart\ndrag'n'drop site"]
    set drag [new dragSite -path $label]
    dragSite::provide $drag VIEWER {dragEcho ::dataStackedGraph}

    set label [label $frame.overlapBarChart -image [image create photo -data [dataOverlapBarChart::iconData]] -relief sunken]
    pack $label -pady 1 -side left
    new dropSite -path $label -formats DATACELLS\
        -command "createCellsViewer dataOverlapBarChart \$dragSite::data(DATACELLS) 1 $global::static"
    new widgetTip -path $label -text [mc "overlap bar chart\ndrag'n'drop site"]
    set drag [new dragSite -path $label]
    dragSite::provide $drag VIEWER {dragEcho ::dataOverlapBarChart}

    set label [label $frame.sideBarChart -image [image create photo -data [dataSideBarChart::iconData]] -relief sunken]
    pack $label -pady 1 -side left
    new dropSite -path $label -formats DATACELLS\
        -command "createCellsViewer dataSideBarChart \$dragSite::data(DATACELLS) 1 $global::static"
    new widgetTip -path $label -text [mc "side bar chart\ndrag'n'drop site"]
    set drag [new dragSite -path $label]
    dragSite::provide $drag VIEWER {dragEcho ::dataSideBarChart}

    set label [label $frame.stackedBarChart -image [image create photo -data [dataStackedBarChart::iconData]] -relief sunken]
    pack $label -pady 1 -side left
    new dropSite -path $label -formats DATACELLS\
        -command "createCellsViewer dataStackedBarChart \$dragSite::data(DATACELLS) 1 $global::static"
    new widgetTip -path $label -text [mc "stacked bar chart\ndrag'n'drop site"]
    set drag [new dragSite -path $label]
    dragSite::provide $drag VIEWER {dragEcho ::dataStackedBarChart}

    set label [label $frame.2DPieChart -image [image create photo -data [data2DPieChart::iconData]] -relief sunken]
    pack $label -pady 1 -side left
    new dropSite -path $label -formats DATACELLS\
        -command "createCellsViewer data2DPieChart \$dragSite::data(DATACELLS) 1 $global::static"
    new widgetTip -path $label -text [mc "2D pie chart\ndrag'n'drop site"]
    set drag [new dragSite -path $label]
    dragSite::provide $drag VIEWER {dragEcho ::data2DPieChart}

    set label [label $frame.3DPieChart -image [image create photo -data [data3DPieChart::iconData]] -relief sunken]
    pack $label -pady 1 -side left
    new dropSite -path $label -formats DATACELLS\
        -command "createCellsViewer data3DPieChart \$dragSite::data(DATACELLS) 1 $global::static"
    new widgetTip -path $label -text [mc "3D pie chart\ndrag'n'drop site"]
    set drag [new dragSite -path $label]
    dragSite::provide $drag VIEWER {dragEcho ::data3DPieChart}

    set label [label $frame.summaryTable -image [image create photo -data [summaryTable::iconData]] -relief sunken]
    pack $label -pady 1 -side left
    new dropSite -path $label -formats DATACELLS\
        -command "createCellsViewer summaryTable \$dragSite::data(DATACELLS) 1 $global::static"
    new widgetTip -path $label -text [mc "summary table\ndrag'n'drop site"]
    set drag [new dragSite -path $label]
    dragSite::provide $drag VIEWER {dragEcho ::summaryTable}

    set label [label $frame.freeText -image [image create photo -data [freeText::iconData]] -relief sunken]
    pack $label -pady 1 -side left
    new dropSite -path $label -formats DATACELLS\
        -command "createCellsViewer freeText \$dragSite::data(DATACELLS) 1 $global::static"
    new widgetTip -path $label -text [mc "free text\ndrag'n'drop site"]
    set drag [new dragSite -path $label]
    dragSite::provide $drag VIEWER {dragEcho ::freeText}

    set label [label $frame.threshold -image [image create photo -data [thresholds::iconData]] -relief sunken]
    pack $label -pady 1 -side left
    new dropSite -path $label -formats DATACELLS -command\
        {thresholds::edit; viewer::view $thresholds::singleton $dragSite::data(DATACELLS)}
    new widgetTip -path $label -text [mc {threshold drop site}]

    set eraserData {
        R0lGODdhJAAkAKUAAPj4+Hh4eLi4uMiAKLhQAPDouPDksOjYoOjQmOjMkODAgOC8eNiwaPj8+Ojw6ODg4NjY2MDIwNioYNikWLCwsNCYSFCQqJigmJCQkNCQ
        QODo6NDg6Mjg4IiIiAAAAHB4cMiIMGhoaMDY2MjY4GBgYMh8IEhQSLDQ2EBAQKjI0LjQ2Dg4OCAoIKDAyJC4yIi4wICAgHiwuKDI0IiQiJjAyJCYkJiYmKCg
        oKioqICwwMDAwMjQyNDY0HiouOjo6AAAACwAAAAAJAAkAAAG/kCAcCgMEI/G4zBZVBKZSijy6VxWAVKqFRvoer9dwZULBlfF1cGAwJ5ux0p1wWA4HNrNN3xI
        KMzrBwgICQR5eV5oVX10doIJCQoKhWRfewAEX46QCgsLDAQNWnsBDg8PEBBdm50Mn25wpKaoERECAawMEhITk4cBiU+yELQCAhQUAbm7ExWFZVcW0dG1xhQX
        FxgBE8wVGb1YYxYaG+Qc0cfXGBgdHhXd3qJK4uQb5hoaFtjrHR8eGRkgQHxL8kWMhXIc7I3bYKEDvw8hQngAocaDh2dEDibkIOIgvREjLEAMQYKEhwElCFzU
        I8RCQhEwPZIDCdICSRImPKS8+MtQ/kuYIk6ckEmzpgWcJlB4UInIl4WgQlMcLApSRTRzKFCssMjVohkLUVNIpaqi7NWQK1aw4BlmC1ixKVpYoFlWhdCzVtWy
        7blFbIu/c0fUFTo0sF0Lawu6+evChYXBhAsLLju0q+XLjV88jhw1GuW7e8uAeaGZM9xohMVa2AujtevXrWOADZtChgzUcOXuncG7t+/es+HaphEtt+4vNZIr
        X75c+HDiFuL+Jb7Xxo3r2LNnty2DhnfHFqZ7X/3FBo7z6NOr906jMXj2jcl7sVGsvv37xdzHt9C+cQ75Xdigw4AEFmjggO79Z0GC/1W3w4MQRighhC7koGCF
        FspWHQ8cJ3bo4Yce5iCbBRnGoGF5pqSo4oosjmhiDD30AGAANvhg44045qhjEAA7
    }
    set label [label $frame.eraser -image [image create photo -data $eraserData] -relief sunken]
    pack $label -pady 1 -side right
    new dropSite -path $label -formats OBJECTS -command "eval delete \$dragSite::data(OBJECTS)"
    new widgetTip -path $label -text [mc "objects deletion\ndrag'n'drop site"]
    set drag [new dragSite -path $label]
    dragSite::provide $drag KILL list                                           ;# drag data is unimportant, only the kill action is

    return $frame
}

proc inquirePollTime {} {
    set dialog [new dialogBox .grabber\
        -buttons hoc -default o -title [mc {moodss: Poll Time}] -die 0 -x [winfo pointerx .] -y [winfo pointery .]\
        -helpcommand {generalHelpWindow #menus.view.polltime} -deletecommand {grab release .grabber}\
    ]
    grab .grabber                                                          ;# grab siblings such as help window so that it is usable
    lappend objects [linkedHelpWidgetTip $composite::($dialog,help,path)]
    set frame [frame $widget::($dialog,path).frame]
    set minimum [lindex $global::pollTimes 0]
    set message [message $frame.message\
        -width [winfo screenwidth .] -font $font::(mediumNormal) -justify center\
        -text [format [mc {Enter new poll time (greater than %u):}] $minimum]
    ]
    pack $message

    if {$::tcl_version<8.4} {
        set entry [new spinEntry $frame -width 4 -list $global::pollTimes -side right]
        spinEntry::set $entry $global::pollTime
        setupEntryValidation $composite::($entry,entry,path) {{checkUnsignedInteger %P}}              ;# filter on positive integers
        pack $widget::($entry,path) -anchor e -side left -expand 1 -padx 2   ;# evenly pack entry and label together near the center
        lappend objects $entry
    } else {                                                                                        ;# use native widget if possible
        set entry [spinbox $frame.spinbox -font $font::(mediumBold) -width 4 -values $global::pollTimes]
        $entry set $global::pollTime
        setupEntryValidation $entry {{checkUnsignedInteger %P}}                                       ;# filter on positive integers
        pack $entry -anchor e -side left -expand 1 -padx 2                   ;# evenly pack entry and label together near the center
    }

    pack [label $frame.label -text [mc seconds]] -anchor w -side right -expand 1 -padx 2
    dialogBox::display $dialog $frame
    widget::configure $dialog -command "
        if {$::tcl_version<8.4} {
            set time \[spinEntry::get $entry\]
        } else {
            set time \[$entry get\]
        }
        if {\$time<$minimum} {                                                                    ;# check against minimum poll time
            bell
            $message configure -text \[format \[mc {Enter new poll time\n(must be greater than %u):}\] $minimum\]
        } else {                                                                                                ;# new time is valid
            if {\$time!=\$global::pollTime} {                                     ;# but check that it actually differs from current
                set global::pollTime \$time
                viewer::updateInterval \$time
                updateTitle
                refresh                                      ;# update immediately in case poll time was set to a much greater value
            }
            delete $dialog                                                                                     ;# destroy dialog box
        }
    "
    bind $frame <Destroy> "delete $objects"                                          ;# delete objects not managed by the dialog box
}
