/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
*/
/* First off, code is include which follows the "include" declaration
** in the input file. */
#include <stdio.h>

#include "sqliteInt.h"
#include "parse.h"
#line 56 "parse.y"

/*
** An instance of this structure holds information about the
** LIMIT clause of a SELECT statement.
*/
struct LimitVal {
  Expr *pLimit;    /* The LIMIT expression.  NULL if there is no limit */
  Expr *pOffset;   /* The OFFSET expression.  NULL if there is none */
};

/*
** An instance of this structure is used to store the LIKE,
** GLOB, NOT LIKE, and NOT GLOB operators.
*/
struct LikeOp {
  Token eOperator;  /* "like" or "glob" or "regexp" */
  int not;         /* True if the NOT keyword is present */
};

/*
** An instance of the following structure describes the event of a
** TRIGGER.  "a" is the event type, one of TK_UPDATE, TK_INSERT,
** TK_DELETE, or TK_INSTEAD.  If the event is of the form
**
**      UPDATE ON (a,b,c)
**
** Then the "b" IdList records the list "a,b,c".
*/
struct TrigEvent { int a; IdList * b; };

/*
** An instance of this structure holds the ATTACH key and the key type.
*/
struct AttachKey { int type;  Token key; };

#line 48 "parse.c"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash 
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    sqlite3ParserTOKENTYPE     is the data type used for minor tokens given 
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is sqlite3ParserTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    sqlite3ParserARG_SDECL     A static variable declaration for the %extra_argument
**    sqlite3ParserARG_PDECL     A parameter declaration for the %extra_argument
**    sqlite3ParserARG_STORE     Code to store %extra_argument into yypParser
**    sqlite3ParserARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
#define YYCODETYPE unsigned char
#define YYNOCODE 248
#define YYACTIONTYPE unsigned short int
#define YYWILDCARD 59
#define sqlite3ParserTOKENTYPE Token
typedef union {
  sqlite3ParserTOKENTYPE yy0;
  int yy46;
  struct LikeOp yy72;
  Expr* yy172;
  ExprList* yy174;
  Select* yy219;
  struct LimitVal yy234;
  TriggerStep* yy243;
  struct TrigEvent yy370;
  SrcList* yy373;
  Expr * yy386;
  struct {int value; int mask;} yy405;
  Token yy410;
  IdList* yy432;
  int yy495;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define sqlite3ParserARG_SDECL Parse *pParse;
#define sqlite3ParserARG_PDECL ,Parse *pParse
#define sqlite3ParserARG_FETCH Parse *pParse = yypParser->pParse
#define sqlite3ParserARG_STORE yypParser->pParse = pParse
#define YYNSTATE 586
#define YYNRULE 311
#define YYERRORSYMBOL 138
#define YYERRSYMDT yy495
#define YYFALLBACK 1
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

/* Next are that tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   290,  898,  122,  585,  407,  170,    2,  437,   61,   61,
 /*    10 */    61,   61,  517,   63,   63,   63,   63,   64,   64,   65,
 /*    20 */    65,   65,   66,  231,  445,  209,  422,  428,   68,   63,
 /*    30 */    63,   63,   63,   64,   64,   65,   65,   65,   66,  231,
 /*    40 */   389,  386,  394,  449,   60,   59,  295,  432,  433,  429,
 /*    50 */   429,   62,   62,   61,   61,   61,   61,  261,   63,   63,
 /*    60 */    63,   63,   64,   64,   65,   65,   65,   66,  231,  290,
 /*    70 */   491,  492,  437,  487,  206,   81,   67,  417,   69,  152,
 /*    80 */    63,   63,   63,   63,   64,   64,   65,   65,   65,   66,
 /*    90 */   231,   67,  460,   69,  152,  422,  428,  571,  262,   58,
 /*   100 */    64,   64,   65,   65,   65,   66,  231,  395,  396,  419,
 /*   110 */   419,  419,  290,   60,   59,  295,  432,  433,  429,  429,
 /*   120 */    62,   62,   61,   61,   61,   61,  315,   63,   63,   63,
 /*   130 */    63,   64,   64,   65,   65,   65,   66,  231,  422,  428,
 /*   140 */    93,   65,   65,   65,   66,  231,  394,  231,  412,   34,
 /*   150 */    56,  296,  440,  441,  408,  486,   60,   59,  295,  432,
 /*   160 */   433,  429,  429,   62,   62,   61,   61,   61,   61,  488,
 /*   170 */    63,   63,   63,   63,   64,   64,   65,   65,   65,   66,
 /*   180 */   231,  290,  255,  522,  293,  569,  112,  406,  520,  449,
 /*   190 */   329,  315,  405,   20,  437,  338,  517,  394,  530,  529,
 /*   200 */   503,  445,  209,  568,  567,  206,  528,  422,  428,  147,
 /*   210 */   148,  395,  396,  412,   41,  208,  149,  531,  370,  487,
 /*   220 */   259,  566,  257,  417,  290,   60,   59,  295,  432,  433,
 /*   230 */   429,  429,   62,   62,   61,   61,   61,   61,  315,   63,
 /*   240 */    63,   63,   63,   64,   64,   65,   65,   65,   66,  231,
 /*   250 */   422,  428,  445,  331,  212,  419,  419,  419,  361,  437,
 /*   260 */   412,   41,  395,  396,  364,  565,  208,  290,   60,   59,
 /*   270 */   295,  432,  433,  429,  429,   62,   62,   61,   61,   61,
 /*   280 */    61,  394,   63,   63,   63,   63,   64,   64,   65,   65,
 /*   290 */    65,   66,  231,  422,  428,  489,  298,  522,  472,   66,
 /*   300 */   231,  211,  472,  224,  409,  284,  532,   20,  447,  521,
 /*   310 */   166,   60,   59,  295,  432,  433,  429,  429,   62,   62,
 /*   320 */    61,   61,   61,   61,  472,   63,   63,   63,   63,   64,
 /*   330 */    64,   65,   65,   65,   66,  231,  207,  478,  315,   76,
 /*   340 */   290,  235,  298,   55,  482,  225,  395,  396,  179,  545,
 /*   350 */   492,  343,  346,  347,   67,  150,   69,  152,  337,  522,
 /*   360 */   412,   35,  348,  237,  249,  368,  422,  428,  576,   20,
 /*   370 */   162,  116,  239,  341,  244,  342,  174,  320,  440,  441,
 /*   380 */   412,    3,   79,  250,   60,   59,  295,  432,  433,  429,
 /*   390 */   429,   62,   62,   61,   61,   61,   61,  172,   63,   63,
 /*   400 */    63,   63,   64,   64,   65,   65,   65,   66,  231,  290,
 /*   410 */   249,  548,  232,  485,  508,  351,  315,  116,  239,  341,
 /*   420 */   244,  342,  174,  179,  315,  523,  343,  346,  347,  250,
 /*   430 */   218,  413,  153,  462,  509,  422,  428,  348,  412,   34,
 /*   440 */   463,  208,  175,  173,  158,  233,  412,   34,  336,  547,
 /*   450 */   447,  321,  166,   60,   59,  295,  432,  433,  429,  429,
 /*   460 */    62,   62,   61,   61,   61,   61,  413,   63,   63,   63,
 /*   470 */    63,   64,   64,   65,   65,   65,   66,  231,  290,  540,
 /*   480 */   333,  515,  502,  539,  454,  569,  300,   19,  329,  142,
 /*   490 */   315,  388,  315,  328,    2,  360,  455,  292,  481,  371,
 /*   500 */   267,  266,  250,  568,  422,  428,  586,  389,  386,  456,
 /*   510 */   206,  493,  412,   49,  412,   49,  301,  583,  889,  157,
 /*   520 */   889,  494,   60,   59,  295,  432,  433,  429,  429,   62,
 /*   530 */    62,   61,   61,   61,   61,  199,   63,   63,   63,   63,
 /*   540 */    64,   64,   65,   65,   65,   66,  231,  290,  315,  179,
 /*   550 */   436,  253,  343,  346,  347,  368,  151,  580,  306,  248,
 /*   560 */   307,  450,   75,  348,   77,  380,  208,  423,  424,  413,
 /*   570 */   412,   27,  317,  422,  428,  438,    1,   22,  583,  888,
 /*   580 */   394,  888,  542,  476,  318,  261,  435,  435,  426,  427,
 /*   590 */   413,   60,   59,  295,  432,  433,  429,  429,   62,   62,
 /*   600 */    61,   61,   61,   61,  326,   63,   63,   63,   63,   64,
 /*   610 */    64,   65,   65,   65,   66,  231,  290,  425,  580,  372,
 /*   620 */   219,   92,  515,    9,  334,  394,  555,  394,  454,   67,
 /*   630 */   394,   69,  152,  397,  398,  399,  318,  234,  435,  435,
 /*   640 */   455,  316,  422,  428,  297,  395,  396,  318,  430,  435,
 /*   650 */   435,  579,  289,  456,  220,  325,    5,  217,  544,  290,
 /*   660 */    60,   59,  295,  432,  433,  429,  429,   62,   62,   61,
 /*   670 */    61,   61,   61,  393,   63,   63,   63,   63,   64,   64,
 /*   680 */    65,   65,   65,   66,  231,  422,  428,  480,  311,  390,
 /*   690 */   395,  396,  395,  396,  205,  395,  396,  821,  271,  515,
 /*   700 */   248,  198,  290,   60,   59,  295,  432,  433,  429,  429,
 /*   710 */    62,   62,   61,   61,   61,   61,  468,   63,   63,   63,
 /*   720 */    63,   64,   64,   65,   65,   65,   66,  231,  422,  428,
 /*   730 */   169,  158,  261,  261,  302,  413,  274,  117,  272,  261,
 /*   740 */   515,  515,  261,  515,  190,  290,   60,   70,  295,  432,
 /*   750 */   433,  429,  429,   62,   62,   61,   61,   61,   61,  377,
 /*   760 */    63,   63,   63,   63,   64,   64,   65,   65,   65,   66,
 /*   770 */   231,  422,  428,  382,  557,  303,  304,  248,  413,  318,
 /*   780 */   558,  435,  435,  559,  538,  358,  538,  385,  290,  194,
 /*   790 */    59,  295,  432,  433,  429,  429,   62,   62,   61,   61,
 /*   800 */    61,   61,  369,   63,   63,   63,   63,   64,   64,   65,
 /*   810 */    65,   65,   66,  231,  422,  428,  394,  273,  248,  248,
 /*   820 */   170,  246,  437,  413,  384,  365,  176,  177,  178,  467,
 /*   830 */   309,  121,  154,  126,  295,  432,  433,  429,  429,   62,
 /*   840 */    62,   61,   61,   61,   61,  315,   63,   63,   63,   63,
 /*   850 */    64,   64,   65,   65,   65,   66,  231,   72,  322,  175,
 /*   860 */     4,  315,  261,  315,  294,  261,  413,  412,   28,  315,
 /*   870 */   261,  315,  319,   72,  322,  315,    4,  418,  443,  443,
 /*   880 */   294,  395,  396,  412,   23,  412,   32,  437,  319,  324,
 /*   890 */   327,  412,   53,  412,   52,  315,  156,  412,   97,  449,
 /*   900 */   315,  192,  315,  275,  315,  324,  376,  469,  500,  315,
 /*   910 */   476,  277,  476,  163,  292,  449,  315,  412,   95,   74,
 /*   920 */    73,  467,  412,  100,  412,  101,  412,  111,   72,  313,
 /*   930 */   314,  412,  113,  417,  446,   74,   73,  479,  412,   16,
 /*   940 */   379,  315,  181,  465,   72,  313,  314,   72,  322,  417,
 /*   950 */     4,  206,  315,  184,  294,  315,  497,  498,  474,  206,
 /*   960 */   171,  339,  319,  412,   98,  419,  419,  419,  420,  421,
 /*   970 */    11,  359,  378,  305,  412,   33,  413,  412,   96,  324,
 /*   980 */   458,  419,  419,  419,  420,  421,   11,  413,  411,  449,
 /*   990 */   411,  160,  410,  315,  410,  466,  221,  222,  223,  103,
 /*  1000 */    83,  471,  315,  507,  506,  315,  620,  475,  315,   74,
 /*  1010 */    73,  245,  203,   21,  279,  412,   24,  437,   72,  313,
 /*  1020 */   314,  280,  315,  417,  412,   54,  505,  412,  114,  315,
 /*  1030 */   412,  115,  504,  201,  145,  547,  240,  510,  524,  200,
 /*  1040 */   315,  511,  202,  315,  412,   25,  315,  241,  315,   18,
 /*  1050 */   315,  412,   36,  315,  254,  419,  419,  419,  420,  421,
 /*  1060 */    11,  256,  412,   37,  258,  412,   26,  315,  412,   38,
 /*  1070 */   412,   39,  412,   40,  260,  412,   42,  315,  512,  315,
 /*  1080 */   126,  315,  437,  315,  187,  375,  276,  266,  265,  412,
 /*  1090 */    43,  291,  315,  252,  315,  126,  206,  581,    8,  412,
 /*  1100 */    44,  412,   29,  412,   30,  412,   45,  350,  363,  126,
 /*  1110 */   315,  543,  315,  126,  412,   46,  412,   47,  315,  355,
 /*  1120 */   381,  551,  315,  171,  552,  315,   90,  562,  578,   90,
 /*  1130 */   288,  366,  412,   48,  412,   31,  582,  367,  268,  269,
 /*  1140 */   412,   10,  270,  554,  412,   50,  564,  412,   51,  278,
 /*  1150 */   281,  282,  575,  144,  442,  403,  323,  226,  444,  461,
 /*  1160 */   464,  242,  503,  550,  561,  513,  161,  392,  400,  516,
 /*  1170 */   401,  345,  402,    7,  312,   83,  227,  332,  228,   82,
 /*  1180 */   330,   57,  408,  416,  168,   78,  459,  123,  210,  414,
 /*  1190 */    84,  335,  340,  299,  496,  500,  490,  229,  495,  243,
 /*  1200 */   104,  247,  499,  501,  230,  285,  415,  215,  514,  518,
 /*  1210 */   525,  526,  519,  236,  527,  473,  238,  352,  477,  286,
 /*  1220 */   182,  356,  533,  354,  119,  183,  185,   87,  546,  130,
 /*  1230 */   186,  535,  188,  140,  362,  191,  553,  216,  373,  374,
 /*  1240 */   131,  560,  308,  132,  133,  572,  577,  136,  263,  134,
 /*  1250 */   139,  536,  573,  391,   91,   94,  404,  574,   99,  214,
 /*  1260 */   102,  621,  622,  431,  164,  434,  165,   71,  141,   17,
 /*  1270 */   439,  448,  451,  155,    6,  452,  470,  110,  167,  453,
 /*  1280 */   457,  124,   13,  213,  120,   80,   12,  125,  159,  483,
 /*  1290 */   484,   85,  310,  105,  180,  251,  106,  118,   86,  107,
 /*  1300 */   241,  344,  349,  353,  143,  534,  127,  357,  171,  189,
 /*  1310 */   264,  108,  287,  128,  549,  129,  193,  537,  541,   14,
 /*  1320 */   195,   88,  196,  556,  197,  137,  138,  135,   15,  563,
 /*  1330 */   570,  109,  283,  146,  204,  383,  387,  899,  584,  899,
 /*  1340 */   899,  899,  899,  899,   89,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */    16,  139,  140,  141,  168,   21,  144,   23,   69,   70,
 /*    10 */    71,   72,  176,   74,   75,   76,   77,   78,   79,   80,
 /*    20 */    81,   82,   83,   84,   78,   79,   42,   43,   73,   74,
 /*    30 */    75,   76,   77,   78,   79,   80,   81,   82,   83,   84,
 /*    40 */     1,    2,   23,   58,   60,   61,   62,   63,   64,   65,
 /*    50 */    66,   67,   68,   69,   70,   71,   72,  147,   74,   75,
 /*    60 */    76,   77,   78,   79,   80,   81,   82,   83,   84,   16,
 /*    70 */   185,  186,   88,   88,  110,   22,  217,   92,  219,  220,
 /*    80 */    74,   75,   76,   77,   78,   79,   80,   81,   82,   83,
 /*    90 */    84,  217,  218,  219,  220,   42,   43,  238,  188,   46,
 /*   100 */    78,   79,   80,   81,   82,   83,   84,   88,   89,  124,
 /*   110 */   125,  126,   16,   60,   61,   62,   63,   64,   65,   66,
 /*   120 */    67,   68,   69,   70,   71,   72,  147,   74,   75,   76,
 /*   130 */    77,   78,   79,   80,   81,   82,   83,   84,   42,   43,
 /*   140 */    44,   80,   81,   82,   83,   84,   23,   84,  169,  170,
 /*   150 */    19,  164,  165,  166,   23,  169,   60,   61,   62,   63,
 /*   160 */    64,   65,   66,   67,   68,   69,   70,   71,   72,  169,
 /*   170 */    74,   75,   76,   77,   78,   79,   80,   81,   82,   83,
 /*   180 */    84,   16,   14,  147,  150,  147,   21,  167,  168,   58,
 /*   190 */   211,  147,  156,  157,   23,  216,  176,   23,  181,  176,
 /*   200 */   177,   78,   79,  165,  166,  110,  183,   42,   43,   78,
 /*   210 */    79,   88,   89,  169,  170,  228,  180,  181,  123,   88,
 /*   220 */    52,   98,   54,   92,   16,   60,   61,   62,   63,   64,
 /*   230 */    65,   66,   67,   68,   69,   70,   71,   72,  147,   74,
 /*   240 */    75,   76,   77,   78,   79,   80,   81,   82,   83,   84,
 /*   250 */    42,   43,   78,  209,  210,  124,  125,  126,  224,   88,
 /*   260 */   169,  170,   88,   89,  230,  227,  228,   16,   60,   61,
 /*   270 */    62,   63,   64,   65,   66,   67,   68,   69,   70,   71,
 /*   280 */    72,   23,   74,   75,   76,   77,   78,   79,   80,   81,
 /*   290 */    82,   83,   84,   42,   43,  160,   16,  147,  161,   83,
 /*   300 */    84,  210,  161,  153,  169,  158,  156,  157,  161,  162,
 /*   310 */   163,   60,   61,   62,   63,   64,   65,   66,   67,   68,
 /*   320 */    69,   70,   71,   72,  161,   74,   75,   76,   77,   78,
 /*   330 */    79,   80,   81,   82,   83,   84,  192,  200,  147,  131,
 /*   340 */    16,  200,   16,  199,   20,  190,   88,   89,   90,  185,
 /*   350 */   186,   93,   94,   95,  217,   22,  219,  220,  147,  147,
 /*   360 */   169,  170,  104,  200,   84,  147,   42,   43,  156,  157,
 /*   370 */    90,   91,   92,   93,   94,   95,   96,  164,  165,  166,
 /*   380 */   169,  170,  131,  103,   60,   61,   62,   63,   64,   65,
 /*   390 */    66,   67,   68,   69,   70,   71,   72,  155,   74,   75,
 /*   400 */    76,   77,   78,   79,   80,   81,   82,   83,   84,   16,
 /*   410 */    84,   11,  221,   20,   30,   16,  147,   91,   92,   93,
 /*   420 */    94,   95,   96,   90,  147,  181,   93,   94,   95,  103,
 /*   430 */   212,  189,  155,   27,   50,   42,   43,  104,  169,  170,
 /*   440 */    34,  228,   43,  201,  202,  147,  169,  170,  206,   49,
 /*   450 */   161,  162,  163,   60,   61,   62,   63,   64,   65,   66,
 /*   460 */    67,   68,   69,   70,   71,   72,  189,   74,   75,   76,
 /*   470 */    77,   78,   79,   80,   81,   82,   83,   84,   16,   25,
 /*   480 */   211,  147,   20,   29,   12,  147,  102,   19,  211,   21,
 /*   490 */   147,  141,  147,  216,  144,   41,   24,   98,   20,   99,
 /*   500 */   100,  101,  103,  165,   42,   43,    0,    1,    2,   37,
 /*   510 */   110,   39,  169,  170,  169,  170,  182,   19,   20,  147,
 /*   520 */    22,   49,   60,   61,   62,   63,   64,   65,   66,   67,
 /*   530 */    68,   69,   70,   71,   72,  155,   74,   75,   76,   77,
 /*   540 */    78,   79,   80,   81,   82,   83,   84,   16,  147,   90,
 /*   550 */    20,   20,   93,   94,   95,  147,  155,   59,  215,  225,
 /*   560 */   215,   20,  130,  104,  132,  227,  228,   42,   43,  189,
 /*   570 */   169,  170,   16,   42,   43,   20,   19,   22,   19,   20,
 /*   580 */    23,   22,   18,  147,  106,  147,  108,  109,   63,   64,
 /*   590 */   189,   60,   61,   62,   63,   64,   65,   66,   67,   68,
 /*   600 */    69,   70,   71,   72,  186,   74,   75,   76,   77,   78,
 /*   610 */    79,   80,   81,   82,   83,   84,   16,   92,   59,   55,
 /*   620 */   212,   21,  147,   19,  147,   23,  188,   23,   12,  217,
 /*   630 */    23,  219,  220,    7,    8,    9,  106,  147,  108,  109,
 /*   640 */    24,  147,   42,   43,  208,   88,   89,  106,   92,  108,
 /*   650 */   109,  244,  245,   37,  145,   39,  191,  182,   94,   16,
 /*   660 */    60,   61,   62,   63,   64,   65,   66,   67,   68,   69,
 /*   670 */    70,   71,   72,  147,   74,   75,   76,   77,   78,   79,
 /*   680 */    80,   81,   82,   83,   84,   42,   43,   80,  142,  143,
 /*   690 */    88,   89,   88,   89,  148,   88,   89,  133,   14,  147,
 /*   700 */   225,  155,   16,   60,   61,   62,   63,   64,   65,   66,
 /*   710 */    67,   68,   69,   70,   71,   72,  114,   74,   75,   76,
 /*   720 */    77,   78,   79,   80,   81,   82,   83,   84,   42,   43,
 /*   730 */   201,  202,  147,  147,  182,  189,   52,  147,   54,  147,
 /*   740 */   147,  147,  147,  147,  155,   16,   60,   61,   62,   63,
 /*   750 */    64,   65,   66,   67,   68,   69,   70,   71,   72,  213,
 /*   760 */    74,   75,   76,   77,   78,   79,   80,   81,   82,   83,
 /*   770 */    84,   42,   43,  188,  188,  182,  182,  225,  189,  106,
 /*   780 */   188,  108,  109,  188,   99,  100,  101,  241,   16,  155,
 /*   790 */    61,   62,   63,   64,   65,   66,   67,   68,   69,   70,
 /*   800 */    71,   72,  213,   74,   75,   76,   77,   78,   79,   80,
 /*   810 */    81,   82,   83,   84,   42,   43,   23,  133,  225,  225,
 /*   820 */    21,  225,   23,  189,  239,  236,   99,  100,  101,   22,
 /*   830 */   242,  243,  155,   22,   62,   63,   64,   65,   66,   67,
 /*   840 */    68,   69,   70,   71,   72,  147,   74,   75,   76,   77,
 /*   850 */    78,   79,   80,   81,   82,   83,   84,   16,   17,   43,
 /*   860 */    19,  147,  147,  147,   23,  147,  189,  169,  170,  147,
 /*   870 */   147,  147,   31,   16,   17,  147,   19,  147,  124,  125,
 /*   880 */    23,   88,   89,  169,  170,  169,  170,   88,   31,   48,
 /*   890 */   147,  169,  170,  169,  170,  147,   89,  169,  170,   58,
 /*   900 */   147,   22,  147,  188,  147,   48,  188,  114,   97,  147,
 /*   910 */   147,  188,  147,   19,   98,   58,  147,  169,  170,   78,
 /*   920 */    79,  114,  169,  170,  169,  170,  169,  170,   87,   88,
 /*   930 */    89,  169,  170,   92,  161,   78,   79,   80,  169,  170,
 /*   940 */    91,  147,  155,   22,   87,   88,   89,   16,   17,   92,
 /*   950 */    19,  110,  147,  155,   23,  147,    7,    8,   20,  110,
 /*   960 */    22,   80,   31,  169,  170,  124,  125,  126,  127,  128,
 /*   970 */   129,  208,  123,  208,  169,  170,  189,  169,  170,   48,
 /*   980 */   147,  124,  125,  126,  127,  128,  129,  189,  107,   58,
 /*   990 */   107,    5,  111,  147,  111,  203,   10,   11,   12,   13,
 /*  1000 */   121,  147,  147,   91,   92,  147,  112,  147,  147,   78,
 /*  1010 */    79,  147,   26,   19,   28,  169,  170,   23,   87,   88,
 /*  1020 */    89,   35,  147,   92,  169,  170,  178,  169,  170,  147,
 /*  1030 */   169,  170,  147,   47,  113,   49,   92,  178,  147,   53,
 /*  1040 */   147,  178,   56,  147,  169,  170,  147,  103,  147,   19,
 /*  1050 */   147,  169,  170,  147,  147,  124,  125,  126,  127,  128,
 /*  1060 */   129,  147,  169,  170,  147,  169,  170,  147,  169,  170,
 /*  1070 */   169,  170,  169,  170,  147,  169,  170,  147,   20,  147,
 /*  1080 */    22,  147,   88,  147,  232,   99,  100,  101,  147,  169,
 /*  1090 */   170,  105,  147,   20,  147,   22,  110,   20,   68,  169,
 /*  1100 */   170,  169,  170,  169,  170,  169,  170,   20,  147,   22,
 /*  1110 */   147,   20,  147,   22,  169,  170,  169,  170,  147,  233,
 /*  1120 */   134,   20,  147,   22,   20,  147,   22,   20,   20,   22,
 /*  1130 */    22,  147,  169,  170,  169,  170,   59,  147,  147,  147,
 /*  1140 */   169,  170,  147,  147,  169,  170,  147,  169,  170,  147,
 /*  1150 */   147,  147,  147,  191,  229,  149,  223,  193,  229,  172,
 /*  1160 */   172,  172,  177,  194,  194,  172,    6,  146,  146,  172,
 /*  1170 */   146,  173,  146,   22,  154,  121,  194,  118,  195,  119,
 /*  1180 */   116,  120,   23,  160,  112,  130,  152,  152,  222,  189,
 /*  1190 */    98,  115,   98,   40,  179,   97,  171,  196,  171,  171,
 /*  1200 */    19,   84,  173,  171,  197,  174,  198,  226,  160,  160,
 /*  1210 */   171,  171,  179,  204,  171,  205,  204,   15,  205,  174,
 /*  1220 */   151,   38,  152,  152,   60,  151,  151,  130,  184,   19,
 /*  1230 */   152,  152,  151,  214,  152,  184,  194,  226,  152,   15,
 /*  1240 */   187,  194,  152,  187,  187,   33,  137,  184,  234,  187,
 /*  1250 */   214,  235,  152,    1,  237,  237,   20,  152,  159,  175,
 /*  1260 */   175,  112,  112,   92,  112,  107,  112,   19,   19,  231,
 /*  1270 */    20,   20,   11,   19,  117,   20,  114,  240,   22,   20,
 /*  1280 */    20,   19,  117,   44,  243,   22,   22,   20,  112,   20,
 /*  1290 */    20,   19,  246,   19,   96,   20,   19,   32,   19,   19,
 /*  1300 */   103,   44,   44,   16,   21,   17,   98,   36,   22,   98,
 /*  1310 */   133,   19,    5,   45,    1,  102,  122,   51,   45,   19,
 /*  1320 */   113,   68,   14,   17,  115,  102,  122,  113,   19,  123,
 /*  1330 */    20,   14,  136,   19,  135,   57,    3,  247,    4,  247,
 /*  1340 */   247,  247,  247,  247,   68,
};
#define YY_SHIFT_USE_DFLT (-62)
#define YY_SHIFT_MAX 387
static const short yy_shift_ofst[] = {
 /*     0 */    39,  841,  986,  -16,  841,  931,  931,  258,  123,  -36,
 /*    10 */    96,  931,  931,  931,  931,  931,  -45,  400,  174,   19,
 /*    20 */   171,  -54,  -54,   53,  165,  208,  251,  324,  393,  462,
 /*    30 */   531,  600,  643,  686,  643,  643,  643,  643,  643,  643,
 /*    40 */   643,  643,  643,  643,  643,  643,  643,  643,  643,  643,
 /*    50 */   643,  643,  729,  772,  772,  857,  931,  931,  931,  931,
 /*    60 */   931,  931,  931,  931,  931,  931,  931,  931,  931,  931,
 /*    70 */   931,  931,  931,  931,  931,  931,  931,  931,  931,  931,
 /*    80 */   931,  931,  931,  931,  931,  931,  931,  931,  931,  931,
 /*    90 */   931,  931,  931,  931,  931,  -61,  -61,    6,    6,  280,
 /*   100 */    22,   61,  399,  564,   19,   19,   19,   19,   19,   19,
 /*   110 */    19,  216,  171,   63,  -62,  -62,  131,  326,  472,  472,
 /*   120 */   498,  559,  506,  799,   19,  799,   19,   19,   19,   19,
 /*   130 */    19,   19,   19,   19,   19,   19,   19,   19,   19,  849,
 /*   140 */    95,  -36,  -36,  -36,  -62,  -62,  -62,  -15,  -15,  333,
 /*   150 */   459,  478,  557,  530,  541,  616,  602,  793,  604,  607,
 /*   160 */   626,   19,   19,  881,   19,   19,  994,   19,   19,  807,
 /*   170 */    19,   19,  673,  807,   19,   19,  384,  384,  384,   19,
 /*   180 */    19,  673,   19,   19,  673,   19,  454,  685,   19,   19,
 /*   190 */   673,   19,   19,   19,  673,   19,   19,   19,  673,  673,
 /*   200 */    19,   19,   19,   19,   19,  468,  883,  921,  754,  754,
 /*   210 */   432,  406,  406,  406,  816,  406,  406,  811,  879,  879,
 /*   220 */  1160, 1160, 1160, 1160, 1151,  -36, 1054, 1059, 1060, 1064,
 /*   230 */  1061, 1159, 1055, 1072, 1072, 1092, 1076, 1092, 1076, 1094,
 /*   240 */  1094, 1153, 1094, 1098, 1094, 1181, 1117, 1159, 1117, 1159,
 /*   250 */  1153, 1094, 1094, 1094, 1181, 1202, 1072, 1202, 1072, 1202,
 /*   260 */  1072, 1072, 1183, 1097, 1202, 1072, 1164, 1164, 1210, 1054,
 /*   270 */  1072, 1224, 1224, 1224, 1224, 1054, 1164, 1210, 1072, 1212,
 /*   280 */  1212, 1072, 1072, 1109,  -62,  -62,  -62,  -62,  -62,  -62,
 /*   290 */   525,  684,  727,  168,  894,  556,  555,  938,  944,  949,
 /*   300 */   912, 1058, 1073, 1087, 1091, 1101, 1104, 1107, 1030, 1108,
 /*   310 */  1077, 1252, 1236, 1149, 1150, 1152, 1154, 1171, 1158, 1248,
 /*   320 */  1250, 1251, 1249, 1261, 1254, 1255, 1256, 1259, 1260, 1263,
 /*   330 */  1157, 1264, 1165, 1263, 1162, 1262, 1267, 1176, 1269, 1270,
 /*   340 */  1265, 1239, 1272, 1257, 1274, 1275, 1277, 1279, 1258, 1280,
 /*   350 */  1198, 1197, 1287, 1288, 1283, 1208, 1271, 1266, 1268, 1286,
 /*   360 */  1273, 1177, 1211, 1292, 1307, 1313, 1213, 1253, 1276, 1194,
 /*   370 */  1300, 1207, 1308, 1209, 1306, 1214, 1223, 1204, 1309, 1206,
 /*   380 */  1310, 1317, 1278, 1199, 1196, 1314, 1333, 1334,
};
#define YY_REDUCE_USE_DFLT (-165)
#define YY_REDUCE_MAX 289
static const short yy_reduce_ofst[] = {
 /*     0 */  -138,  277,  546,  137,  401,  -21,   44,   36,   38,  242,
 /*    10 */  -141,  191,   91,  269,  343,  345, -126,  589,  338,  150,
 /*    20 */   147,  -13,  213,  412,  412,  412,  412,  412,  412,  412,
 /*    30 */   412,  412,  412,  412,  412,  412,  412,  412,  412,  412,
 /*    40 */   412,  412,  412,  412,  412,  412,  412,  412,  412,  412,
 /*    50 */   412,  412,  412,  412,  412,  211,  698,  714,  716,  722,
 /*    60 */   724,  728,  748,  753,  755,  757,  762,  769,  794,  805,
 /*    70 */   808,  846,  855,  858,  861,  875,  882,  893,  896,  899,
 /*    80 */   901,  903,  906,  920,  930,  932,  934,  936,  945,  947,
 /*    90 */   963,  965,  971,  975,  978,  412,  412,  412,  412,   20,
 /*   100 */   412,  412,   23,   34,  334,  475,  552,  593,  594,  585,
 /*   110 */   212,  412,  289,  412,  412,  412,  135, -164, -115,  164,
 /*   120 */   407,  407,  350,  141,  436,  163,  596,  -90,  763,  218,
 /*   130 */   765,  438,  586,  592,  595,  715,  718,  408,  723,  380,
 /*   140 */   634,  677,  787,  798,  144,  529,  588,  -14,    0,   17,
 /*   150 */   244,  155,  298,  155,  155,  418,  372,  477,  490,  494,
 /*   160 */   509,  526,  590,  465,  494,  730,  773,  743,  833,  792,
 /*   170 */   854,  860,  155,  792,  864,  885,  848,  859,  863,  891,
 /*   180 */   907,  155,  914,  917,  155,  927,  852,  886,  941,  961,
 /*   190 */   155,  984,  990,  991,  155,  992,  995,  996,  155,  155,
 /*   200 */   999, 1002, 1003, 1004, 1005, 1006,  962,  964,  925,  929,
 /*   210 */   933,  987,  988,  989,  985,  993,  997,  998,  969,  970,
 /*   220 */  1021, 1022, 1024, 1026, 1020, 1000,  982,  983, 1001, 1007,
 /*   230 */  1008, 1023,  966, 1034, 1035, 1009, 1010, 1012, 1013, 1025,
 /*   240 */  1027, 1015, 1028, 1029, 1032, 1031,  981, 1048, 1011, 1049,
 /*   250 */  1033, 1039, 1040, 1043, 1045, 1069, 1070, 1074, 1071, 1075,
 /*   260 */  1078, 1079, 1014, 1016, 1081, 1082, 1044, 1051, 1019, 1042,
 /*   270 */  1086, 1053, 1056, 1057, 1062, 1047, 1063, 1036, 1090, 1017,
 /*   280 */  1018, 1100, 1105, 1037, 1099, 1084, 1085, 1038, 1041, 1046,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   592,  816,  897,  707,  897,  816,  897,  897,  843,  711,
 /*    10 */   872,  814,  897,  897,  897,  897,  789,  897,  843,  897,
 /*    20 */   623,  843,  843,  740,  897,  897,  897,  897,  897,  897,
 /*    30 */   897,  897,  741,  897,  818,  813,  809,  811,  810,  817,
 /*    40 */   742,  731,  738,  745,  723,  856,  747,  748,  754,  755,
 /*    50 */   873,  871,  777,  776,  795,  897,  897,  897,  897,  897,
 /*    60 */   897,  897,  897,  897,  897,  897,  897,  897,  897,  897,
 /*    70 */   897,  897,  897,  897,  897,  897,  897,  897,  897,  897,
 /*    80 */   897,  897,  897,  897,  897,  897,  897,  897,  897,  897,
 /*    90 */   897,  897,  897,  897,  897,  779,  800,  778,  788,  616,
 /*   100 */   780,  781,  676,  611,  897,  897,  897,  897,  897,  897,
 /*   110 */   897,  782,  897,  783,  796,  797,  897,  897,  897,  897,
 /*   120 */   897,  897,  592,  707,  897,  707,  897,  897,  897,  897,
 /*   130 */   897,  897,  897,  897,  897,  897,  897,  897,  897,  897,
 /*   140 */   897,  897,  897,  897,  701,  711,  890,  897,  897,  667,
 /*   150 */   897,  897,  897,  897,  897,  897,  897,  897,  897,  897,
 /*   160 */   599,  597,  897,  699,  897,  897,  625,  897,  897,  709,
 /*   170 */   897,  897,  714,  715,  897,  897,  897,  897,  897,  897,
 /*   180 */   897,  613,  897,  897,  688,  897,  849,  897,  897,  897,
 /*   190 */   863,  897,  897,  897,  861,  897,  897,  897,  690,  750,
 /*   200 */   830,  897,  876,  878,  897,  897,  699,  708,  897,  897,
 /*   210 */   812,  734,  734,  734,  646,  734,  734,  649,  744,  744,
 /*   220 */   596,  596,  596,  596,  666,  897,  744,  735,  737,  727,
 /*   230 */   739,  897,  897,  716,  716,  724,  726,  724,  726,  678,
 /*   240 */   678,  663,  678,  649,  678,  822,  827,  897,  827,  897,
 /*   250 */   663,  678,  678,  678,  822,  608,  716,  608,  716,  608,
 /*   260 */   716,  716,  853,  855,  608,  716,  680,  680,  756,  744,
 /*   270 */   716,  687,  687,  687,  687,  744,  680,  756,  716,  875,
 /*   280 */   875,  716,  716,  883,  633,  651,  651,  858,  890,  895,
 /*   290 */   897,  897,  897,  897,  763,  897,  897,  897,  897,  897,
 /*   300 */   897,  897,  897,  897,  897,  897,  897,  897,  836,  897,
 /*   310 */   897,  897,  897,  768,  764,  897,  765,  897,  693,  897,
 /*   320 */   897,  897,  897,  897,  897,  897,  897,  897,  897,  815,
 /*   330 */   897,  728,  897,  736,  897,  897,  897,  897,  897,  897,
 /*   340 */   897,  897,  897,  897,  897,  897,  897,  897,  897,  897,
 /*   350 */   897,  897,  897,  897,  897,  897,  897,  897,  851,  852,
 /*   360 */   897,  897,  897,  897,  897,  897,  897,  897,  897,  897,
 /*   370 */   897,  897,  897,  897,  897,  897,  897,  897,  897,  897,
 /*   380 */   897,  897,  882,  897,  897,  885,  593,  897,  587,  590,
 /*   390 */   589,  591,  595,  598,  620,  621,  622,  600,  601,  602,
 /*   400 */   603,  604,  605,  606,  612,  614,  632,  634,  618,  636,
 /*   410 */   697,  698,  760,  691,  692,  696,  771,  762,  766,  767,
 /*   420 */   769,  770,  784,  785,  787,  793,  799,  802,  786,  791,
 /*   430 */   792,  794,  798,  801,  694,  695,  805,  619,  626,  627,
 /*   440 */   630,  631,  839,  841,  840,  842,  629,  628,  772,  775,
 /*   450 */   807,  808,  864,  865,  866,  867,  868,  803,  717,  806,
 /*   460 */   790,  729,  732,  733,  730,  700,  710,  719,  720,  721,
 /*   470 */   722,  705,  706,  712,  725,  758,  759,  713,  702,  703,
 /*   480 */   704,  804,  761,  773,  774,  637,  638,  768,  639,  640,
 /*   490 */   641,  679,  682,  683,  684,  642,  661,  664,  665,  643,
 /*   500 */   650,  644,  645,  652,  653,  654,  657,  658,  659,  660,
 /*   510 */   655,  656,  823,  824,  828,  826,  825,  647,  648,  662,
 /*   520 */   635,  624,  617,  668,  671,  672,  673,  674,  675,  677,
 /*   530 */   669,  670,  615,  607,  609,  718,  845,  854,  850,  846,
 /*   540 */   847,  848,  610,  819,  820,  681,  752,  753,  844,  857,
 /*   550 */   859,  757,  860,  862,  887,  685,  686,  689,  829,  869,
 /*   560 */   743,  746,  749,  751,  831,  832,  833,  834,  837,  838,
 /*   570 */   835,  870,  874,  877,  879,  880,  881,  884,  886,  891,
 /*   580 */   892,  893,  896,  894,  594,  588,
};
#define YY_SZ_ACTTAB (int)(sizeof(yy_action)/sizeof(yy_action[0]))

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammer, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*       SEMI => nothing */
   23,  /*    EXPLAIN => ID */
   23,  /*      QUERY => ID */
   23,  /*       PLAN => ID */
   23,  /*      BEGIN => ID */
    0,  /* TRANSACTION => nothing */
   23,  /*   DEFERRED => ID */
   23,  /*  IMMEDIATE => ID */
   23,  /*  EXCLUSIVE => ID */
    0,  /*     COMMIT => nothing */
   23,  /*        END => ID */
    0,  /*   ROLLBACK => nothing */
    0,  /*     CREATE => nothing */
    0,  /*      TABLE => nothing */
   23,  /*         IF => ID */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
   23,  /*       TEMP => ID */
    0,  /*         LP => nothing */
    0,  /*         RP => nothing */
    0,  /*         AS => nothing */
    0,  /*      COMMA => nothing */
    0,  /*         ID => nothing */
   23,  /*      ABORT => ID */
   23,  /*      AFTER => ID */
   23,  /*    ANALYZE => ID */
   23,  /*        ASC => ID */
   23,  /*     ATTACH => ID */
   23,  /*     BEFORE => ID */
   23,  /*    CASCADE => ID */
   23,  /*       CAST => ID */
   23,  /*   CONFLICT => ID */
   23,  /*   DATABASE => ID */
   23,  /*       DESC => ID */
   23,  /*     DETACH => ID */
   23,  /*       EACH => ID */
   23,  /*       FAIL => ID */
   23,  /*        FOR => ID */
   23,  /*     IGNORE => ID */
   23,  /*  INITIALLY => ID */
   23,  /*    INSTEAD => ID */
   23,  /*    LIKE_KW => ID */
   23,  /*      MATCH => ID */
   23,  /*        KEY => ID */
   23,  /*         OF => ID */
   23,  /*     OFFSET => ID */
   23,  /*     PRAGMA => ID */
   23,  /*      RAISE => ID */
   23,  /*    REPLACE => ID */
   23,  /*   RESTRICT => ID */
   23,  /*        ROW => ID */
   23,  /*    TRIGGER => ID */
   23,  /*     VACUUM => ID */
   23,  /*       VIEW => ID */
   23,  /*    VIRTUAL => ID */
   23,  /*    REINDEX => ID */
   23,  /*     RENAME => ID */
   23,  /*   CTIME_KW => ID */
    0,  /*        ANY => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*         IS => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IN => nothing */
    0,  /*     ISNULL => nothing */
    0,  /*    NOTNULL => nothing */
    0,  /*         NE => nothing */
    0,  /*         EQ => nothing */
    0,  /*         GT => nothing */
    0,  /*         LE => nothing */
    0,  /*         LT => nothing */
    0,  /*         GE => nothing */
    0,  /*     ESCAPE => nothing */
    0,  /*     BITAND => nothing */
    0,  /*      BITOR => nothing */
    0,  /*     LSHIFT => nothing */
    0,  /*     RSHIFT => nothing */
    0,  /*       PLUS => nothing */
    0,  /*      MINUS => nothing */
    0,  /*       STAR => nothing */
    0,  /*      SLASH => nothing */
    0,  /*        REM => nothing */
    0,  /*     CONCAT => nothing */
    0,  /*    COLLATE => nothing */
    0,  /*     UMINUS => nothing */
    0,  /*      UPLUS => nothing */
    0,  /*     BITNOT => nothing */
    0,  /*     STRING => nothing */
    0,  /*    JOIN_KW => nothing */
    0,  /* CONSTRAINT => nothing */
    0,  /*    DEFAULT => nothing */
    0,  /*       NULL => nothing */
    0,  /*    PRIMARY => nothing */
    0,  /*     UNIQUE => nothing */
    0,  /*      CHECK => nothing */
    0,  /* REFERENCES => nothing */
    0,  /*   AUTOINCR => nothing */
    0,  /*         ON => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     UPDATE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*        SET => nothing */
    0,  /* DEFERRABLE => nothing */
    0,  /*    FOREIGN => nothing */
    0,  /*       DROP => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*        DOT => nothing */
    0,  /*       FROM => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      USING => nothing */
    0,  /*      ORDER => nothing */
    0,  /*         BY => nothing */
    0,  /*      GROUP => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*       INTO => nothing */
    0,  /*     VALUES => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*       BLOB => nothing */
    0,  /*   REGISTER => nothing */
    0,  /*   VARIABLE => nothing */
    0,  /*       CASE => nothing */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*      ALTER => nothing */
    0,  /*         TO => nothing */
    0,  /*        ADD => nothing */
    0,  /*   COLUMNKW => nothing */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  int stateno;       /* The state-number */
  int major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
  YYMINORTYPE minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
  int yyerrcnt;                 /* Shifts left before out of the error */
  sqlite3ParserARG_SDECL                /* A place to hold %extra_argument */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3ParserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  "$",             "SEMI",          "EXPLAIN",       "QUERY",       
  "PLAN",          "BEGIN",         "TRANSACTION",   "DEFERRED",    
  "IMMEDIATE",     "EXCLUSIVE",     "COMMIT",        "END",         
  "ROLLBACK",      "CREATE",        "TABLE",         "IF",          
  "NOT",           "EXISTS",        "TEMP",          "LP",          
  "RP",            "AS",            "COMMA",         "ID",          
  "ABORT",         "AFTER",         "ANALYZE",       "ASC",         
  "ATTACH",        "BEFORE",        "CASCADE",       "CAST",        
  "CONFLICT",      "DATABASE",      "DESC",          "DETACH",      
  "EACH",          "FAIL",          "FOR",           "IGNORE",      
  "INITIALLY",     "INSTEAD",       "LIKE_KW",       "MATCH",       
  "KEY",           "OF",            "OFFSET",        "PRAGMA",      
  "RAISE",         "REPLACE",       "RESTRICT",      "ROW",         
  "TRIGGER",       "VACUUM",        "VIEW",          "VIRTUAL",     
  "REINDEX",       "RENAME",        "CTIME_KW",      "ANY",         
  "OR",            "AND",           "IS",            "BETWEEN",     
  "IN",            "ISNULL",        "NOTNULL",       "NE",          
  "EQ",            "GT",            "LE",            "LT",          
  "GE",            "ESCAPE",        "BITAND",        "BITOR",       
  "LSHIFT",        "RSHIFT",        "PLUS",          "MINUS",       
  "STAR",          "SLASH",         "REM",           "CONCAT",      
  "COLLATE",       "UMINUS",        "UPLUS",         "BITNOT",      
  "STRING",        "JOIN_KW",       "CONSTRAINT",    "DEFAULT",     
  "NULL",          "PRIMARY",       "UNIQUE",        "CHECK",       
  "REFERENCES",    "AUTOINCR",      "ON",            "DELETE",      
  "UPDATE",        "INSERT",        "SET",           "DEFERRABLE",  
  "FOREIGN",       "DROP",          "UNION",         "ALL",         
  "EXCEPT",        "INTERSECT",     "SELECT",        "DISTINCT",    
  "DOT",           "FROM",          "JOIN",          "USING",       
  "ORDER",         "BY",            "GROUP",         "HAVING",      
  "LIMIT",         "WHERE",         "INTO",          "VALUES",      
  "INTEGER",       "FLOAT",         "BLOB",          "REGISTER",    
  "VARIABLE",      "CASE",          "WHEN",          "THEN",        
  "ELSE",          "INDEX",         "ALTER",         "TO",          
  "ADD",           "COLUMNKW",      "error",         "input",       
  "cmdlist",       "ecmd",          "cmdx",          "cmd",         
  "explain",       "transtype",     "trans_opt",     "nm",          
  "create_table",  "create_table_args",  "temp",          "ifnotexists", 
  "dbnm",          "columnlist",    "conslist_opt",  "select",      
  "column",        "columnid",      "type",          "carglist",    
  "id",            "ids",           "typetoken",     "typename",    
  "signed",        "plus_num",      "minus_num",     "carg",        
  "ccons",         "term",          "expr",          "onconf",      
  "sortorder",     "autoinc",       "idxlist_opt",   "refargs",     
  "defer_subclause",  "refarg",        "refact",        "init_deferred_pred_opt",
  "conslist",      "tcons",         "idxlist",       "defer_subclause_opt",
  "orconf",        "resolvetype",   "raisetype",     "ifexists",    
  "fullname",      "oneselect",     "multiselect_op",  "distinct",    
  "selcollist",    "from",          "where_opt",     "groupby_opt", 
  "having_opt",    "orderby_opt",   "limit_opt",     "sclp",        
  "as",            "seltablist",    "stl_prefix",    "joinop",      
  "on_opt",        "using_opt",     "seltablist_paren",  "joinop2",     
  "inscollist",    "sortlist",      "sortitem",      "nexprlist",   
  "setlist",       "insert_cmd",    "inscollist_opt",  "itemlist",    
  "exprlist",      "likeop",        "escape",        "between_op",  
  "in_op",         "case_operand",  "case_exprlist",  "case_else",   
  "uniqueflag",    "idxitem",       "collate",       "nmnum",       
  "plus_opt",      "number",        "trigger_decl",  "trigger_cmd_list",
  "trigger_time",  "trigger_event",  "foreach_clause",  "when_clause", 
  "trigger_cmd",   "database_kw_opt",  "key_opt",       "add_column_fullname",
  "kwcolumn_opt",  "create_vtab",   "vtabarglist",   "vtabarg",     
  "vtabargtoken",  "lp",            "anylist",     
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "input ::= cmdlist",
 /*   1 */ "cmdlist ::= cmdlist ecmd",
 /*   2 */ "cmdlist ::= ecmd",
 /*   3 */ "cmdx ::= cmd",
 /*   4 */ "ecmd ::= SEMI",
 /*   5 */ "ecmd ::= explain cmdx SEMI",
 /*   6 */ "explain ::=",
 /*   7 */ "explain ::= EXPLAIN",
 /*   8 */ "explain ::= EXPLAIN QUERY PLAN",
 /*   9 */ "cmd ::= BEGIN transtype trans_opt",
 /*  10 */ "trans_opt ::=",
 /*  11 */ "trans_opt ::= TRANSACTION",
 /*  12 */ "trans_opt ::= TRANSACTION nm",
 /*  13 */ "transtype ::=",
 /*  14 */ "transtype ::= DEFERRED",
 /*  15 */ "transtype ::= IMMEDIATE",
 /*  16 */ "transtype ::= EXCLUSIVE",
 /*  17 */ "cmd ::= COMMIT trans_opt",
 /*  18 */ "cmd ::= END trans_opt",
 /*  19 */ "cmd ::= ROLLBACK trans_opt",
 /*  20 */ "cmd ::= create_table create_table_args",
 /*  21 */ "create_table ::= CREATE temp TABLE ifnotexists nm dbnm",
 /*  22 */ "ifnotexists ::=",
 /*  23 */ "ifnotexists ::= IF NOT EXISTS",
 /*  24 */ "temp ::= TEMP",
 /*  25 */ "temp ::=",
 /*  26 */ "create_table_args ::= LP columnlist conslist_opt RP",
 /*  27 */ "create_table_args ::= AS select",
 /*  28 */ "columnlist ::= columnlist COMMA column",
 /*  29 */ "columnlist ::= column",
 /*  30 */ "column ::= columnid type carglist",
 /*  31 */ "columnid ::= nm",
 /*  32 */ "id ::= ID",
 /*  33 */ "ids ::= ID|STRING",
 /*  34 */ "nm ::= ID",
 /*  35 */ "nm ::= STRING",
 /*  36 */ "nm ::= JOIN_KW",
 /*  37 */ "type ::=",
 /*  38 */ "type ::= typetoken",
 /*  39 */ "typetoken ::= typename",
 /*  40 */ "typetoken ::= typename LP signed RP",
 /*  41 */ "typetoken ::= typename LP signed COMMA signed RP",
 /*  42 */ "typename ::= ids",
 /*  43 */ "typename ::= typename ids",
 /*  44 */ "signed ::= plus_num",
 /*  45 */ "signed ::= minus_num",
 /*  46 */ "carglist ::= carglist carg",
 /*  47 */ "carglist ::=",
 /*  48 */ "carg ::= CONSTRAINT nm ccons",
 /*  49 */ "carg ::= ccons",
 /*  50 */ "ccons ::= DEFAULT term",
 /*  51 */ "ccons ::= DEFAULT LP expr RP",
 /*  52 */ "ccons ::= DEFAULT PLUS term",
 /*  53 */ "ccons ::= DEFAULT MINUS term",
 /*  54 */ "ccons ::= DEFAULT id",
 /*  55 */ "ccons ::= NULL onconf",
 /*  56 */ "ccons ::= NOT NULL onconf",
 /*  57 */ "ccons ::= PRIMARY KEY sortorder onconf autoinc",
 /*  58 */ "ccons ::= UNIQUE onconf",
 /*  59 */ "ccons ::= CHECK LP expr RP",
 /*  60 */ "ccons ::= REFERENCES nm idxlist_opt refargs",
 /*  61 */ "ccons ::= defer_subclause",
 /*  62 */ "ccons ::= COLLATE id",
 /*  63 */ "autoinc ::=",
 /*  64 */ "autoinc ::= AUTOINCR",
 /*  65 */ "refargs ::=",
 /*  66 */ "refargs ::= refargs refarg",
 /*  67 */ "refarg ::= MATCH nm",
 /*  68 */ "refarg ::= ON DELETE refact",
 /*  69 */ "refarg ::= ON UPDATE refact",
 /*  70 */ "refarg ::= ON INSERT refact",
 /*  71 */ "refact ::= SET NULL",
 /*  72 */ "refact ::= SET DEFAULT",
 /*  73 */ "refact ::= CASCADE",
 /*  74 */ "refact ::= RESTRICT",
 /*  75 */ "defer_subclause ::= NOT DEFERRABLE init_deferred_pred_opt",
 /*  76 */ "defer_subclause ::= DEFERRABLE init_deferred_pred_opt",
 /*  77 */ "init_deferred_pred_opt ::=",
 /*  78 */ "init_deferred_pred_opt ::= INITIALLY DEFERRED",
 /*  79 */ "init_deferred_pred_opt ::= INITIALLY IMMEDIATE",
 /*  80 */ "conslist_opt ::=",
 /*  81 */ "conslist_opt ::= COMMA conslist",
 /*  82 */ "conslist ::= conslist COMMA tcons",
 /*  83 */ "conslist ::= conslist tcons",
 /*  84 */ "conslist ::= tcons",
 /*  85 */ "tcons ::= CONSTRAINT nm",
 /*  86 */ "tcons ::= PRIMARY KEY LP idxlist autoinc RP onconf",
 /*  87 */ "tcons ::= UNIQUE LP idxlist RP onconf",
 /*  88 */ "tcons ::= CHECK LP expr RP onconf",
 /*  89 */ "tcons ::= FOREIGN KEY LP idxlist RP REFERENCES nm idxlist_opt refargs defer_subclause_opt",
 /*  90 */ "defer_subclause_opt ::=",
 /*  91 */ "defer_subclause_opt ::= defer_subclause",
 /*  92 */ "onconf ::=",
 /*  93 */ "onconf ::= ON CONFLICT resolvetype",
 /*  94 */ "orconf ::=",
 /*  95 */ "orconf ::= OR resolvetype",
 /*  96 */ "resolvetype ::= raisetype",
 /*  97 */ "resolvetype ::= IGNORE",
 /*  98 */ "resolvetype ::= REPLACE",
 /*  99 */ "cmd ::= DROP TABLE ifexists fullname",
 /* 100 */ "ifexists ::= IF EXISTS",
 /* 101 */ "ifexists ::=",
 /* 102 */ "cmd ::= CREATE temp VIEW ifnotexists nm dbnm AS select",
 /* 103 */ "cmd ::= DROP VIEW ifexists fullname",
 /* 104 */ "cmd ::= select",
 /* 105 */ "select ::= oneselect",
 /* 106 */ "select ::= select multiselect_op oneselect",
 /* 107 */ "multiselect_op ::= UNION",
 /* 108 */ "multiselect_op ::= UNION ALL",
 /* 109 */ "multiselect_op ::= EXCEPT|INTERSECT",
 /* 110 */ "oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt",
 /* 111 */ "distinct ::= DISTINCT",
 /* 112 */ "distinct ::= ALL",
 /* 113 */ "distinct ::=",
 /* 114 */ "sclp ::= selcollist COMMA",
 /* 115 */ "sclp ::=",
 /* 116 */ "selcollist ::= sclp expr as",
 /* 117 */ "selcollist ::= sclp STAR",
 /* 118 */ "selcollist ::= sclp nm DOT STAR",
 /* 119 */ "as ::= AS nm",
 /* 120 */ "as ::= ids",
 /* 121 */ "as ::=",
 /* 122 */ "from ::=",
 /* 123 */ "from ::= FROM seltablist",
 /* 124 */ "stl_prefix ::= seltablist joinop",
 /* 125 */ "stl_prefix ::=",
 /* 126 */ "seltablist ::= stl_prefix nm dbnm as on_opt using_opt",
 /* 127 */ "seltablist ::= stl_prefix LP seltablist_paren RP as on_opt using_opt",
 /* 128 */ "seltablist_paren ::= select",
 /* 129 */ "seltablist_paren ::= seltablist",
 /* 130 */ "dbnm ::=",
 /* 131 */ "dbnm ::= DOT nm",
 /* 132 */ "fullname ::= nm dbnm",
 /* 133 */ "joinop ::= COMMA|JOIN",
 /* 134 */ "joinop ::= JOIN_KW JOIN",
 /* 135 */ "joinop ::= JOIN_KW nm JOIN",
 /* 136 */ "joinop ::= JOIN_KW nm nm JOIN",
 /* 137 */ "on_opt ::= ON expr",
 /* 138 */ "on_opt ::=",
 /* 139 */ "using_opt ::= USING LP inscollist RP",
 /* 140 */ "using_opt ::=",
 /* 141 */ "orderby_opt ::=",
 /* 142 */ "orderby_opt ::= ORDER BY sortlist",
 /* 143 */ "sortlist ::= sortlist COMMA sortitem sortorder",
 /* 144 */ "sortlist ::= sortitem sortorder",
 /* 145 */ "sortitem ::= expr",
 /* 146 */ "sortorder ::= ASC",
 /* 147 */ "sortorder ::= DESC",
 /* 148 */ "sortorder ::=",
 /* 149 */ "groupby_opt ::=",
 /* 150 */ "groupby_opt ::= GROUP BY nexprlist",
 /* 151 */ "having_opt ::=",
 /* 152 */ "having_opt ::= HAVING expr",
 /* 153 */ "limit_opt ::=",
 /* 154 */ "limit_opt ::= LIMIT expr",
 /* 155 */ "limit_opt ::= LIMIT expr OFFSET expr",
 /* 156 */ "limit_opt ::= LIMIT expr COMMA expr",
 /* 157 */ "cmd ::= DELETE FROM fullname where_opt",
 /* 158 */ "where_opt ::=",
 /* 159 */ "where_opt ::= WHERE expr",
 /* 160 */ "cmd ::= UPDATE orconf fullname SET setlist where_opt",
 /* 161 */ "setlist ::= setlist COMMA nm EQ expr",
 /* 162 */ "setlist ::= nm EQ expr",
 /* 163 */ "cmd ::= insert_cmd INTO fullname inscollist_opt VALUES LP itemlist RP",
 /* 164 */ "cmd ::= insert_cmd INTO fullname inscollist_opt select",
 /* 165 */ "cmd ::= insert_cmd INTO fullname inscollist_opt DEFAULT VALUES",
 /* 166 */ "insert_cmd ::= INSERT orconf",
 /* 167 */ "insert_cmd ::= REPLACE",
 /* 168 */ "itemlist ::= itemlist COMMA expr",
 /* 169 */ "itemlist ::= expr",
 /* 170 */ "inscollist_opt ::=",
 /* 171 */ "inscollist_opt ::= LP inscollist RP",
 /* 172 */ "inscollist ::= inscollist COMMA nm",
 /* 173 */ "inscollist ::= nm",
 /* 174 */ "expr ::= term",
 /* 175 */ "expr ::= LP expr RP",
 /* 176 */ "term ::= NULL",
 /* 177 */ "expr ::= ID",
 /* 178 */ "expr ::= JOIN_KW",
 /* 179 */ "expr ::= nm DOT nm",
 /* 180 */ "expr ::= nm DOT nm DOT nm",
 /* 181 */ "term ::= INTEGER|FLOAT|BLOB",
 /* 182 */ "term ::= STRING",
 /* 183 */ "expr ::= REGISTER",
 /* 184 */ "expr ::= VARIABLE",
 /* 185 */ "expr ::= expr COLLATE id",
 /* 186 */ "expr ::= CAST LP expr AS typetoken RP",
 /* 187 */ "expr ::= ID LP distinct exprlist RP",
 /* 188 */ "expr ::= ID LP STAR RP",
 /* 189 */ "term ::= CTIME_KW",
 /* 190 */ "expr ::= expr AND expr",
 /* 191 */ "expr ::= expr OR expr",
 /* 192 */ "expr ::= expr LT|GT|GE|LE expr",
 /* 193 */ "expr ::= expr EQ|NE expr",
 /* 194 */ "expr ::= expr BITAND|BITOR|LSHIFT|RSHIFT expr",
 /* 195 */ "expr ::= expr PLUS|MINUS expr",
 /* 196 */ "expr ::= expr STAR|SLASH|REM expr",
 /* 197 */ "expr ::= expr CONCAT expr",
 /* 198 */ "likeop ::= LIKE_KW",
 /* 199 */ "likeop ::= NOT LIKE_KW",
 /* 200 */ "likeop ::= MATCH",
 /* 201 */ "likeop ::= NOT MATCH",
 /* 202 */ "escape ::= ESCAPE expr",
 /* 203 */ "escape ::=",
 /* 204 */ "expr ::= expr likeop expr escape",
 /* 205 */ "expr ::= expr ISNULL|NOTNULL",
 /* 206 */ "expr ::= expr IS NULL",
 /* 207 */ "expr ::= expr NOT NULL",
 /* 208 */ "expr ::= expr IS NOT NULL",
 /* 209 */ "expr ::= NOT|BITNOT expr",
 /* 210 */ "expr ::= MINUS expr",
 /* 211 */ "expr ::= PLUS expr",
 /* 212 */ "between_op ::= BETWEEN",
 /* 213 */ "between_op ::= NOT BETWEEN",
 /* 214 */ "expr ::= expr between_op expr AND expr",
 /* 215 */ "in_op ::= IN",
 /* 216 */ "in_op ::= NOT IN",
 /* 217 */ "expr ::= expr in_op LP exprlist RP",
 /* 218 */ "expr ::= LP select RP",
 /* 219 */ "expr ::= expr in_op LP select RP",
 /* 220 */ "expr ::= expr in_op nm dbnm",
 /* 221 */ "expr ::= EXISTS LP select RP",
 /* 222 */ "expr ::= CASE case_operand case_exprlist case_else END",
 /* 223 */ "case_exprlist ::= case_exprlist WHEN expr THEN expr",
 /* 224 */ "case_exprlist ::= WHEN expr THEN expr",
 /* 225 */ "case_else ::= ELSE expr",
 /* 226 */ "case_else ::=",
 /* 227 */ "case_operand ::= expr",
 /* 228 */ "case_operand ::=",
 /* 229 */ "exprlist ::= nexprlist",
 /* 230 */ "exprlist ::=",
 /* 231 */ "nexprlist ::= nexprlist COMMA expr",
 /* 232 */ "nexprlist ::= expr",
 /* 233 */ "cmd ::= CREATE uniqueflag INDEX ifnotexists nm dbnm ON nm LP idxlist RP",
 /* 234 */ "uniqueflag ::= UNIQUE",
 /* 235 */ "uniqueflag ::=",
 /* 236 */ "idxlist_opt ::=",
 /* 237 */ "idxlist_opt ::= LP idxlist RP",
 /* 238 */ "idxlist ::= idxlist COMMA idxitem collate sortorder",
 /* 239 */ "idxlist ::= idxitem collate sortorder",
 /* 240 */ "idxitem ::= nm",
 /* 241 */ "collate ::=",
 /* 242 */ "collate ::= COLLATE id",
 /* 243 */ "cmd ::= DROP INDEX ifexists fullname",
 /* 244 */ "cmd ::= VACUUM",
 /* 245 */ "cmd ::= VACUUM nm",
 /* 246 */ "cmd ::= PRAGMA nm dbnm EQ nmnum",
 /* 247 */ "cmd ::= PRAGMA nm dbnm EQ ON",
 /* 248 */ "cmd ::= PRAGMA nm dbnm EQ minus_num",
 /* 249 */ "cmd ::= PRAGMA nm dbnm LP nmnum RP",
 /* 250 */ "cmd ::= PRAGMA nm dbnm",
 /* 251 */ "nmnum ::= plus_num",
 /* 252 */ "nmnum ::= nm",
 /* 253 */ "plus_num ::= plus_opt number",
 /* 254 */ "minus_num ::= MINUS number",
 /* 255 */ "number ::= INTEGER|FLOAT",
 /* 256 */ "plus_opt ::= PLUS",
 /* 257 */ "plus_opt ::=",
 /* 258 */ "cmd ::= CREATE trigger_decl BEGIN trigger_cmd_list END",
 /* 259 */ "trigger_decl ::= temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON fullname foreach_clause when_clause",
 /* 260 */ "trigger_time ::= BEFORE",
 /* 261 */ "trigger_time ::= AFTER",
 /* 262 */ "trigger_time ::= INSTEAD OF",
 /* 263 */ "trigger_time ::=",
 /* 264 */ "trigger_event ::= DELETE|INSERT",
 /* 265 */ "trigger_event ::= UPDATE",
 /* 266 */ "trigger_event ::= UPDATE OF inscollist",
 /* 267 */ "foreach_clause ::=",
 /* 268 */ "foreach_clause ::= FOR EACH ROW",
 /* 269 */ "when_clause ::=",
 /* 270 */ "when_clause ::= WHEN expr",
 /* 271 */ "trigger_cmd_list ::= trigger_cmd_list trigger_cmd SEMI",
 /* 272 */ "trigger_cmd_list ::=",
 /* 273 */ "trigger_cmd ::= UPDATE orconf nm SET setlist where_opt",
 /* 274 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt VALUES LP itemlist RP",
 /* 275 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt select",
 /* 276 */ "trigger_cmd ::= DELETE FROM nm where_opt",
 /* 277 */ "trigger_cmd ::= select",
 /* 278 */ "expr ::= RAISE LP IGNORE RP",
 /* 279 */ "expr ::= RAISE LP raisetype COMMA nm RP",
 /* 280 */ "raisetype ::= ROLLBACK",
 /* 281 */ "raisetype ::= ABORT",
 /* 282 */ "raisetype ::= FAIL",
 /* 283 */ "cmd ::= DROP TRIGGER ifexists fullname",
 /* 284 */ "cmd ::= ATTACH database_kw_opt expr AS expr key_opt",
 /* 285 */ "cmd ::= DETACH database_kw_opt expr",
 /* 286 */ "key_opt ::=",
 /* 287 */ "key_opt ::= KEY expr",
 /* 288 */ "database_kw_opt ::= DATABASE",
 /* 289 */ "database_kw_opt ::=",
 /* 290 */ "cmd ::= REINDEX",
 /* 291 */ "cmd ::= REINDEX nm dbnm",
 /* 292 */ "cmd ::= ANALYZE",
 /* 293 */ "cmd ::= ANALYZE nm dbnm",
 /* 294 */ "cmd ::= ALTER TABLE fullname RENAME TO nm",
 /* 295 */ "cmd ::= ALTER TABLE add_column_fullname ADD kwcolumn_opt column",
 /* 296 */ "add_column_fullname ::= fullname",
 /* 297 */ "kwcolumn_opt ::=",
 /* 298 */ "kwcolumn_opt ::= COLUMNKW",
 /* 299 */ "cmd ::= create_vtab",
 /* 300 */ "cmd ::= create_vtab LP vtabarglist RP",
 /* 301 */ "create_vtab ::= CREATE VIRTUAL TABLE nm dbnm USING nm",
 /* 302 */ "vtabarglist ::= vtabarg",
 /* 303 */ "vtabarglist ::= vtabarglist COMMA vtabarg",
 /* 304 */ "vtabarg ::=",
 /* 305 */ "vtabarg ::= vtabarg vtabargtoken",
 /* 306 */ "vtabargtoken ::= ANY",
 /* 307 */ "vtabargtoken ::= lp anylist RP",
 /* 308 */ "lp ::= LP",
 /* 309 */ "anylist ::=",
 /* 310 */ "anylist ::= anylist ANY",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.
*/
static void yyGrowStack(yyParser *p){
  int newSize;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  if( pNew ){
    p->yystack = pNew;
    p->yystksz = newSize;
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows to %d entries!\n",
              yyTracePrompt, p->yystksz);
    }
#endif
  }
}
#endif

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to sqlite3Parser and sqlite3ParserFree.
*/
void *sqlite3ParserAlloc(void *(*mallocProc)(size_t)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (size_t)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
#if YYSTACKDEPTH<=0
    yyGrowStack(pParser);
#endif
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(YYCODETYPE yymajor, YYMINORTYPE *yypminor){
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
    case 155:
    case 189:
    case 206:
#line 374 "parse.y"
{sqlite3SelectDelete((yypminor->yy219));}
#line 1274 "parse.c"
      break;
    case 169:
    case 170:
    case 194:
    case 196:
    case 204:
    case 210:
    case 218:
    case 221:
    case 223:
    case 235:
#line 627 "parse.y"
{sqlite3ExprDelete((yypminor->yy172));}
#line 1288 "parse.c"
      break;
    case 174:
    case 182:
    case 192:
    case 195:
    case 197:
    case 199:
    case 209:
    case 211:
    case 212:
    case 215:
    case 216:
    case 222:
#line 876 "parse.y"
{sqlite3ExprListDelete((yypminor->yy174));}
#line 1304 "parse.c"
      break;
    case 188:
    case 193:
    case 201:
    case 202:
#line 489 "parse.y"
{sqlite3SrcListDelete((yypminor->yy373));}
#line 1312 "parse.c"
      break;
    case 205:
    case 208:
    case 214:
#line 506 "parse.y"
{sqlite3IdListDelete((yypminor->yy432));}
#line 1319 "parse.c"
      break;
    case 231:
    case 236:
#line 979 "parse.y"
{sqlite3DeleteTriggerStep((yypminor->yy243));}
#line 1325 "parse.c"
      break;
    case 233:
#line 965 "parse.y"
{sqlite3IdListDelete((yypminor->yy370).b);}
#line 1330 "parse.c"
      break;
    case 238:
#line 1052 "parse.y"
{sqlite3ExprDelete((yypminor->yy386));}
#line 1335 "parse.c"
      break;
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;
  yyStackEntry *yytos = &pParser->yystack[pParser->yyidx];

  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yymajor = yytos->major;
  yy_destructor( yymajor, &yytos->minor);
  pParser->yyidx--;
  return yymajor;
}

/* 
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from sqlite3ParserAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void sqlite3ParserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  free(pParser->yystack);
#endif
  (*freeProc)((void*)pParser);
}

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  if( stateno>YY_SHIFT_MAX || (i = yy_shift_ofst[stateno])==YY_SHIFT_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    if( iLookAhead>0 ){
#ifdef YYFALLBACK
      int iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        return yy_find_shift_action(pParser, iFallback);
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( j>=0 && j<YY_SZ_ACTTAB && yy_lookahead[j]==YYWILDCARD ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
    }
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  int stateno,              /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
  /* int stateno = pParser->yystack[pParser->yyidx].stateno; */
 
  if( stateno>YY_REDUCE_MAX ||
      (i = yy_reduce_ofst[stateno])==YY_REDUCE_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser, YYMINORTYPE *yypMinor){
   sqlite3ParserARG_FETCH;
   yypParser->yyidx--;
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
#line 44 "parse.y"

  sqlite3ErrorMsg(pParse, "parser stack overflow");
  pParse->parseError = 1;
#line 1499 "parse.c"
   sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument var */
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer ot the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
#if YYSTACKDEPTH>0 
  if( yypParser->yyidx>=YYSTACKDEPTH ){
    yyStackOverflow(yypParser, yypMinor);
    return;
  }
#else
  if( yypParser->yyidx>=yypParser->yystksz ){
    yyGrowStack(yypParser);
    if( yypParser->yyidx>=yypParser->yystksz ){
      yyStackOverflow(yypParser, yypMinor);
      return;
    }
  }
#endif
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 139, 1 },
  { 140, 2 },
  { 140, 1 },
  { 142, 1 },
  { 141, 1 },
  { 141, 3 },
  { 144, 0 },
  { 144, 1 },
  { 144, 3 },
  { 143, 3 },
  { 146, 0 },
  { 146, 1 },
  { 146, 2 },
  { 145, 0 },
  { 145, 1 },
  { 145, 1 },
  { 145, 1 },
  { 143, 2 },
  { 143, 2 },
  { 143, 2 },
  { 143, 2 },
  { 148, 6 },
  { 151, 0 },
  { 151, 3 },
  { 150, 1 },
  { 150, 0 },
  { 149, 4 },
  { 149, 2 },
  { 153, 3 },
  { 153, 1 },
  { 156, 3 },
  { 157, 1 },
  { 160, 1 },
  { 161, 1 },
  { 147, 1 },
  { 147, 1 },
  { 147, 1 },
  { 158, 0 },
  { 158, 1 },
  { 162, 1 },
  { 162, 4 },
  { 162, 6 },
  { 163, 1 },
  { 163, 2 },
  { 164, 1 },
  { 164, 1 },
  { 159, 2 },
  { 159, 0 },
  { 167, 3 },
  { 167, 1 },
  { 168, 2 },
  { 168, 4 },
  { 168, 3 },
  { 168, 3 },
  { 168, 2 },
  { 168, 2 },
  { 168, 3 },
  { 168, 5 },
  { 168, 2 },
  { 168, 4 },
  { 168, 4 },
  { 168, 1 },
  { 168, 2 },
  { 173, 0 },
  { 173, 1 },
  { 175, 0 },
  { 175, 2 },
  { 177, 2 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 178, 2 },
  { 178, 2 },
  { 178, 1 },
  { 178, 1 },
  { 176, 3 },
  { 176, 2 },
  { 179, 0 },
  { 179, 2 },
  { 179, 2 },
  { 154, 0 },
  { 154, 2 },
  { 180, 3 },
  { 180, 2 },
  { 180, 1 },
  { 181, 2 },
  { 181, 7 },
  { 181, 5 },
  { 181, 5 },
  { 181, 10 },
  { 183, 0 },
  { 183, 1 },
  { 171, 0 },
  { 171, 3 },
  { 184, 0 },
  { 184, 2 },
  { 185, 1 },
  { 185, 1 },
  { 185, 1 },
  { 143, 4 },
  { 187, 2 },
  { 187, 0 },
  { 143, 8 },
  { 143, 4 },
  { 143, 1 },
  { 155, 1 },
  { 155, 3 },
  { 190, 1 },
  { 190, 2 },
  { 190, 1 },
  { 189, 9 },
  { 191, 1 },
  { 191, 1 },
  { 191, 0 },
  { 199, 2 },
  { 199, 0 },
  { 192, 3 },
  { 192, 2 },
  { 192, 4 },
  { 200, 2 },
  { 200, 1 },
  { 200, 0 },
  { 193, 0 },
  { 193, 2 },
  { 202, 2 },
  { 202, 0 },
  { 201, 6 },
  { 201, 7 },
  { 206, 1 },
  { 206, 1 },
  { 152, 0 },
  { 152, 2 },
  { 188, 2 },
  { 203, 1 },
  { 203, 2 },
  { 203, 3 },
  { 203, 4 },
  { 204, 2 },
  { 204, 0 },
  { 205, 4 },
  { 205, 0 },
  { 197, 0 },
  { 197, 3 },
  { 209, 4 },
  { 209, 2 },
  { 210, 1 },
  { 172, 1 },
  { 172, 1 },
  { 172, 0 },
  { 195, 0 },
  { 195, 3 },
  { 196, 0 },
  { 196, 2 },
  { 198, 0 },
  { 198, 2 },
  { 198, 4 },
  { 198, 4 },
  { 143, 4 },
  { 194, 0 },
  { 194, 2 },
  { 143, 6 },
  { 212, 5 },
  { 212, 3 },
  { 143, 8 },
  { 143, 5 },
  { 143, 6 },
  { 213, 2 },
  { 213, 1 },
  { 215, 3 },
  { 215, 1 },
  { 214, 0 },
  { 214, 3 },
  { 208, 3 },
  { 208, 1 },
  { 170, 1 },
  { 170, 3 },
  { 169, 1 },
  { 170, 1 },
  { 170, 1 },
  { 170, 3 },
  { 170, 5 },
  { 169, 1 },
  { 169, 1 },
  { 170, 1 },
  { 170, 1 },
  { 170, 3 },
  { 170, 6 },
  { 170, 5 },
  { 170, 4 },
  { 169, 1 },
  { 170, 3 },
  { 170, 3 },
  { 170, 3 },
  { 170, 3 },
  { 170, 3 },
  { 170, 3 },
  { 170, 3 },
  { 170, 3 },
  { 217, 1 },
  { 217, 2 },
  { 217, 1 },
  { 217, 2 },
  { 218, 2 },
  { 218, 0 },
  { 170, 4 },
  { 170, 2 },
  { 170, 3 },
  { 170, 3 },
  { 170, 4 },
  { 170, 2 },
  { 170, 2 },
  { 170, 2 },
  { 219, 1 },
  { 219, 2 },
  { 170, 5 },
  { 220, 1 },
  { 220, 2 },
  { 170, 5 },
  { 170, 3 },
  { 170, 5 },
  { 170, 4 },
  { 170, 4 },
  { 170, 5 },
  { 222, 5 },
  { 222, 4 },
  { 223, 2 },
  { 223, 0 },
  { 221, 1 },
  { 221, 0 },
  { 216, 1 },
  { 216, 0 },
  { 211, 3 },
  { 211, 1 },
  { 143, 11 },
  { 224, 1 },
  { 224, 0 },
  { 174, 0 },
  { 174, 3 },
  { 182, 5 },
  { 182, 3 },
  { 225, 1 },
  { 226, 0 },
  { 226, 2 },
  { 143, 4 },
  { 143, 1 },
  { 143, 2 },
  { 143, 5 },
  { 143, 5 },
  { 143, 5 },
  { 143, 6 },
  { 143, 3 },
  { 227, 1 },
  { 227, 1 },
  { 165, 2 },
  { 166, 2 },
  { 229, 1 },
  { 228, 1 },
  { 228, 0 },
  { 143, 5 },
  { 230, 11 },
  { 232, 1 },
  { 232, 1 },
  { 232, 2 },
  { 232, 0 },
  { 233, 1 },
  { 233, 1 },
  { 233, 3 },
  { 234, 0 },
  { 234, 3 },
  { 235, 0 },
  { 235, 2 },
  { 231, 3 },
  { 231, 0 },
  { 236, 6 },
  { 236, 8 },
  { 236, 5 },
  { 236, 4 },
  { 236, 1 },
  { 170, 4 },
  { 170, 6 },
  { 186, 1 },
  { 186, 1 },
  { 186, 1 },
  { 143, 4 },
  { 143, 6 },
  { 143, 3 },
  { 238, 0 },
  { 238, 2 },
  { 237, 1 },
  { 237, 0 },
  { 143, 1 },
  { 143, 3 },
  { 143, 1 },
  { 143, 3 },
  { 143, 6 },
  { 143, 6 },
  { 239, 1 },
  { 240, 0 },
  { 240, 1 },
  { 143, 1 },
  { 143, 4 },
  { 241, 7 },
  { 242, 1 },
  { 242, 3 },
  { 243, 0 },
  { 243, 2 },
  { 244, 1 },
  { 244, 3 },
  { 245, 1 },
  { 246, 0 },
  { 246, 2 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  sqlite3ParserARG_FETCH;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0 
        && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

  /* Silence complaints from purify about yygotominor being uninitialized
  ** in some cases when it is copied into the stack after the following
  ** switch.  yygotominor is uninitialized when a rule reduces that does
  ** not set the value of its left-hand side nonterminal.  Leaving the
  ** value of the nonterminal uninitialized is utterly harmless as long
  ** as the value is never used.  So really the only thing this code
  ** accomplishes is to quieten purify.  
  **
  ** 2007-01-16:  The wireshark project (www.wireshark.org) reports that
  ** without this code, their parser segfaults.  I'm not sure what there
  ** parser is doing to make this happen.  This is the second bug report
  ** from wireshark this week.  Clearly they are stressing Lemon in ways
  ** that it has not been previously stressed...  (SQLite ticket #2172)
  */
  memset(&yygotominor, 0, sizeof(yygotominor));


  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 0:
      case 1:
      case 2:
      case 4:
      case 5:
      case 10:
      case 11:
      case 12:
      case 20:
      case 28:
      case 29:
      case 37:
      case 44:
      case 45:
      case 46:
      case 47:
      case 48:
      case 49:
      case 55:
      case 82:
      case 83:
      case 84:
      case 85:
      case 256:
      case 257:
      case 267:
      case 268:
      case 288:
      case 289:
      case 297:
      case 298:
      case 302:
      case 303:
      case 305:
      case 309:
#line 97 "parse.y"
{
}
#line 1953 "parse.c"
        break;
      case 3:
#line 100 "parse.y"
{ sqlite3FinishCoding(pParse); }
#line 1958 "parse.c"
        break;
      case 6:
#line 103 "parse.y"
{ sqlite3BeginParse(pParse, 0); }
#line 1963 "parse.c"
        break;
      case 7:
#line 105 "parse.y"
{ sqlite3BeginParse(pParse, 1); }
#line 1968 "parse.c"
        break;
      case 8:
#line 106 "parse.y"
{ sqlite3BeginParse(pParse, 2); }
#line 1973 "parse.c"
        break;
      case 9:
#line 112 "parse.y"
{sqlite3BeginTransaction(pParse, yymsp[-1].minor.yy46);}
#line 1978 "parse.c"
        break;
      case 13:
#line 117 "parse.y"
{yygotominor.yy46 = TK_DEFERRED;}
#line 1983 "parse.c"
        break;
      case 14:
      case 15:
      case 16:
      case 107:
      case 109:
#line 118 "parse.y"
{yygotominor.yy46 = yymsp[0].major;}
#line 1992 "parse.c"
        break;
      case 17:
      case 18:
#line 121 "parse.y"
{sqlite3CommitTransaction(pParse);}
#line 1998 "parse.c"
        break;
      case 19:
#line 123 "parse.y"
{sqlite3RollbackTransaction(pParse);}
#line 2003 "parse.c"
        break;
      case 21:
#line 128 "parse.y"
{
   sqlite3StartTable(pParse,&yymsp[-1].minor.yy410,&yymsp[0].minor.yy410,yymsp[-4].minor.yy46,0,0,yymsp[-2].minor.yy46);
}
#line 2010 "parse.c"
        break;
      case 22:
      case 25:
      case 63:
      case 77:
      case 79:
      case 90:
      case 101:
      case 112:
      case 113:
      case 212:
      case 215:
#line 132 "parse.y"
{yygotominor.yy46 = 0;}
#line 2025 "parse.c"
        break;
      case 23:
      case 24:
      case 64:
      case 78:
      case 100:
      case 111:
      case 213:
      case 216:
#line 133 "parse.y"
{yygotominor.yy46 = 1;}
#line 2037 "parse.c"
        break;
      case 26:
#line 139 "parse.y"
{
  sqlite3EndTable(pParse,&yymsp[-1].minor.yy410,&yymsp[0].minor.yy0,0);
}
#line 2044 "parse.c"
        break;
      case 27:
#line 142 "parse.y"
{
  sqlite3EndTable(pParse,0,0,yymsp[0].minor.yy219);
  sqlite3SelectDelete(yymsp[0].minor.yy219);
}
#line 2052 "parse.c"
        break;
      case 30:
#line 154 "parse.y"
{
  yygotominor.yy410.z = yymsp[-2].minor.yy410.z;
  yygotominor.yy410.n = (pParse->sLastToken.z-yymsp[-2].minor.yy410.z) + pParse->sLastToken.n;
}
#line 2060 "parse.c"
        break;
      case 31:
#line 158 "parse.y"
{
  sqlite3AddColumn(pParse,&yymsp[0].minor.yy410);
  yygotominor.yy410 = yymsp[0].minor.yy410;
}
#line 2068 "parse.c"
        break;
      case 32:
      case 33:
      case 34:
      case 35:
      case 36:
      case 255:
#line 168 "parse.y"
{yygotominor.yy410 = yymsp[0].minor.yy0;}
#line 2078 "parse.c"
        break;
      case 38:
#line 229 "parse.y"
{sqlite3AddColumnType(pParse,&yymsp[0].minor.yy410);}
#line 2083 "parse.c"
        break;
      case 39:
      case 42:
      case 119:
      case 120:
      case 131:
      case 240:
      case 242:
      case 251:
      case 252:
      case 253:
      case 254:
#line 230 "parse.y"
{yygotominor.yy410 = yymsp[0].minor.yy410;}
#line 2098 "parse.c"
        break;
      case 40:
#line 231 "parse.y"
{
  yygotominor.yy410.z = yymsp[-3].minor.yy410.z;
  yygotominor.yy410.n = &yymsp[0].minor.yy0.z[yymsp[0].minor.yy0.n] - yymsp[-3].minor.yy410.z;
}
#line 2106 "parse.c"
        break;
      case 41:
#line 235 "parse.y"
{
  yygotominor.yy410.z = yymsp[-5].minor.yy410.z;
  yygotominor.yy410.n = &yymsp[0].minor.yy0.z[yymsp[0].minor.yy0.n] - yymsp[-5].minor.yy410.z;
}
#line 2114 "parse.c"
        break;
      case 43:
#line 241 "parse.y"
{yygotominor.yy410.z=yymsp[-1].minor.yy410.z; yygotominor.yy410.n=yymsp[0].minor.yy410.n+(yymsp[0].minor.yy410.z-yymsp[-1].minor.yy410.z);}
#line 2119 "parse.c"
        break;
      case 50:
      case 52:
#line 252 "parse.y"
{sqlite3AddDefaultValue(pParse,yymsp[0].minor.yy172);}
#line 2125 "parse.c"
        break;
      case 51:
#line 253 "parse.y"
{sqlite3AddDefaultValue(pParse,yymsp[-1].minor.yy172);}
#line 2130 "parse.c"
        break;
      case 53:
#line 255 "parse.y"
{
  Expr *p = sqlite3Expr(TK_UMINUS, yymsp[0].minor.yy172, 0, 0);
  sqlite3AddDefaultValue(pParse,p);
}
#line 2138 "parse.c"
        break;
      case 54:
#line 259 "parse.y"
{
  Expr *p = sqlite3Expr(TK_STRING, 0, 0, &yymsp[0].minor.yy410);
  sqlite3AddDefaultValue(pParse,p);
}
#line 2146 "parse.c"
        break;
      case 56:
#line 268 "parse.y"
{sqlite3AddNotNull(pParse, yymsp[0].minor.yy46);}
#line 2151 "parse.c"
        break;
      case 57:
#line 270 "parse.y"
{sqlite3AddPrimaryKey(pParse,0,yymsp[-1].minor.yy46,yymsp[0].minor.yy46,yymsp[-2].minor.yy46);}
#line 2156 "parse.c"
        break;
      case 58:
#line 271 "parse.y"
{sqlite3CreateIndex(pParse,0,0,0,0,yymsp[0].minor.yy46,0,0,0,0);}
#line 2161 "parse.c"
        break;
      case 59:
#line 272 "parse.y"
{sqlite3AddCheckConstraint(pParse,yymsp[-1].minor.yy172);}
#line 2166 "parse.c"
        break;
      case 60:
#line 274 "parse.y"
{sqlite3CreateForeignKey(pParse,0,&yymsp[-2].minor.yy410,yymsp[-1].minor.yy174,yymsp[0].minor.yy46);}
#line 2171 "parse.c"
        break;
      case 61:
#line 275 "parse.y"
{sqlite3DeferForeignKey(pParse,yymsp[0].minor.yy46);}
#line 2176 "parse.c"
        break;
      case 62:
#line 276 "parse.y"
{sqlite3AddCollateType(pParse, (char*)yymsp[0].minor.yy410.z, yymsp[0].minor.yy410.n);}
#line 2181 "parse.c"
        break;
      case 65:
#line 289 "parse.y"
{ yygotominor.yy46 = OE_Restrict * 0x010101; }
#line 2186 "parse.c"
        break;
      case 66:
#line 290 "parse.y"
{ yygotominor.yy46 = (yymsp[-1].minor.yy46 & yymsp[0].minor.yy405.mask) | yymsp[0].minor.yy405.value; }
#line 2191 "parse.c"
        break;
      case 67:
#line 292 "parse.y"
{ yygotominor.yy405.value = 0;     yygotominor.yy405.mask = 0x000000; }
#line 2196 "parse.c"
        break;
      case 68:
#line 293 "parse.y"
{ yygotominor.yy405.value = yymsp[0].minor.yy46;     yygotominor.yy405.mask = 0x0000ff; }
#line 2201 "parse.c"
        break;
      case 69:
#line 294 "parse.y"
{ yygotominor.yy405.value = yymsp[0].minor.yy46<<8;  yygotominor.yy405.mask = 0x00ff00; }
#line 2206 "parse.c"
        break;
      case 70:
#line 295 "parse.y"
{ yygotominor.yy405.value = yymsp[0].minor.yy46<<16; yygotominor.yy405.mask = 0xff0000; }
#line 2211 "parse.c"
        break;
      case 71:
#line 297 "parse.y"
{ yygotominor.yy46 = OE_SetNull; }
#line 2216 "parse.c"
        break;
      case 72:
#line 298 "parse.y"
{ yygotominor.yy46 = OE_SetDflt; }
#line 2221 "parse.c"
        break;
      case 73:
#line 299 "parse.y"
{ yygotominor.yy46 = OE_Cascade; }
#line 2226 "parse.c"
        break;
      case 74:
#line 300 "parse.y"
{ yygotominor.yy46 = OE_Restrict; }
#line 2231 "parse.c"
        break;
      case 75:
      case 76:
      case 91:
      case 93:
      case 95:
      case 96:
      case 166:
#line 302 "parse.y"
{yygotominor.yy46 = yymsp[0].minor.yy46;}
#line 2242 "parse.c"
        break;
      case 80:
#line 312 "parse.y"
{yygotominor.yy410.n = 0; yygotominor.yy410.z = 0;}
#line 2247 "parse.c"
        break;
      case 81:
#line 313 "parse.y"
{yygotominor.yy410 = yymsp[-1].minor.yy0;}
#line 2252 "parse.c"
        break;
      case 86:
#line 319 "parse.y"
{sqlite3AddPrimaryKey(pParse,yymsp[-3].minor.yy174,yymsp[0].minor.yy46,yymsp[-2].minor.yy46,0);}
#line 2257 "parse.c"
        break;
      case 87:
#line 321 "parse.y"
{sqlite3CreateIndex(pParse,0,0,0,yymsp[-2].minor.yy174,yymsp[0].minor.yy46,0,0,0,0);}
#line 2262 "parse.c"
        break;
      case 88:
#line 322 "parse.y"
{sqlite3AddCheckConstraint(pParse,yymsp[-2].minor.yy172);}
#line 2267 "parse.c"
        break;
      case 89:
#line 324 "parse.y"
{
    sqlite3CreateForeignKey(pParse, yymsp[-6].minor.yy174, &yymsp[-3].minor.yy410, yymsp[-2].minor.yy174, yymsp[-1].minor.yy46);
    sqlite3DeferForeignKey(pParse, yymsp[0].minor.yy46);
}
#line 2275 "parse.c"
        break;
      case 92:
      case 94:
#line 338 "parse.y"
{yygotominor.yy46 = OE_Default;}
#line 2281 "parse.c"
        break;
      case 97:
#line 343 "parse.y"
{yygotominor.yy46 = OE_Ignore;}
#line 2286 "parse.c"
        break;
      case 98:
      case 167:
#line 344 "parse.y"
{yygotominor.yy46 = OE_Replace;}
#line 2292 "parse.c"
        break;
      case 99:
#line 348 "parse.y"
{
  sqlite3DropTable(pParse, yymsp[0].minor.yy373, 0, yymsp[-1].minor.yy46);
}
#line 2299 "parse.c"
        break;
      case 102:
#line 358 "parse.y"
{
  sqlite3CreateView(pParse, &yymsp[-7].minor.yy0, &yymsp[-3].minor.yy410, &yymsp[-2].minor.yy410, yymsp[0].minor.yy219, yymsp[-6].minor.yy46, yymsp[-4].minor.yy46);
}
#line 2306 "parse.c"
        break;
      case 103:
#line 361 "parse.y"
{
  sqlite3DropTable(pParse, yymsp[0].minor.yy373, 1, yymsp[-1].minor.yy46);
}
#line 2313 "parse.c"
        break;
      case 104:
#line 368 "parse.y"
{
  sqlite3Select(pParse, yymsp[0].minor.yy219, SRT_Callback, 0, 0, 0, 0, 0);
  sqlite3SelectDelete(yymsp[0].minor.yy219);
}
#line 2321 "parse.c"
        break;
      case 105:
      case 128:
#line 378 "parse.y"
{yygotominor.yy219 = yymsp[0].minor.yy219;}
#line 2327 "parse.c"
        break;
      case 106:
#line 380 "parse.y"
{
  if( yymsp[0].minor.yy219 ){
    yymsp[0].minor.yy219->op = yymsp[-1].minor.yy46;
    yymsp[0].minor.yy219->pPrior = yymsp[-2].minor.yy219;
  }else{
    sqlite3SelectDelete(yymsp[-2].minor.yy219);
  }
  yygotominor.yy219 = yymsp[0].minor.yy219;
}
#line 2340 "parse.c"
        break;
      case 108:
#line 391 "parse.y"
{yygotominor.yy46 = TK_ALL;}
#line 2345 "parse.c"
        break;
      case 110:
#line 395 "parse.y"
{
  yygotominor.yy219 = sqlite3SelectNew(yymsp[-6].minor.yy174,yymsp[-5].minor.yy373,yymsp[-4].minor.yy172,yymsp[-3].minor.yy174,yymsp[-2].minor.yy172,yymsp[-1].minor.yy174,yymsp[-7].minor.yy46,yymsp[0].minor.yy234.pLimit,yymsp[0].minor.yy234.pOffset);
}
#line 2352 "parse.c"
        break;
      case 114:
      case 237:
#line 416 "parse.y"
{yygotominor.yy174 = yymsp[-1].minor.yy174;}
#line 2358 "parse.c"
        break;
      case 115:
      case 141:
      case 149:
      case 230:
      case 236:
#line 417 "parse.y"
{yygotominor.yy174 = 0;}
#line 2367 "parse.c"
        break;
      case 116:
#line 418 "parse.y"
{
   yygotominor.yy174 = sqlite3ExprListAppend(yymsp[-2].minor.yy174,yymsp[-1].minor.yy172,yymsp[0].minor.yy410.n?&yymsp[0].minor.yy410:0);
}
#line 2374 "parse.c"
        break;
      case 117:
#line 421 "parse.y"
{
  yygotominor.yy174 = sqlite3ExprListAppend(yymsp[-1].minor.yy174, sqlite3Expr(TK_ALL, 0, 0, 0), 0);
}
#line 2381 "parse.c"
        break;
      case 118:
#line 424 "parse.y"
{
  Expr *pRight = sqlite3Expr(TK_ALL, 0, 0, 0);
  Expr *pLeft = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy410);
  yygotominor.yy174 = sqlite3ExprListAppend(yymsp[-3].minor.yy174, sqlite3Expr(TK_DOT, pLeft, pRight, 0), 0);
}
#line 2390 "parse.c"
        break;
      case 121:
#line 436 "parse.y"
{yygotominor.yy410.n = 0;}
#line 2395 "parse.c"
        break;
      case 122:
#line 448 "parse.y"
{yygotominor.yy373 = sqliteMalloc(sizeof(*yygotominor.yy373));}
#line 2400 "parse.c"
        break;
      case 123:
#line 449 "parse.y"
{
  yygotominor.yy373 = yymsp[0].minor.yy373;
  sqlite3SrcListShiftJoinType(yygotominor.yy373);
}
#line 2408 "parse.c"
        break;
      case 124:
#line 457 "parse.y"
{
   yygotominor.yy373 = yymsp[-1].minor.yy373;
   if( yygotominor.yy373 && yygotominor.yy373->nSrc>0 ) yygotominor.yy373->a[yygotominor.yy373->nSrc-1].jointype = yymsp[0].minor.yy46;
}
#line 2416 "parse.c"
        break;
      case 125:
#line 461 "parse.y"
{yygotominor.yy373 = 0;}
#line 2421 "parse.c"
        break;
      case 126:
#line 462 "parse.y"
{
  yygotominor.yy373 = sqlite3SrcListAppendFromTerm(yymsp[-5].minor.yy373,&yymsp[-4].minor.yy410,&yymsp[-3].minor.yy410,&yymsp[-2].minor.yy410,0,yymsp[-1].minor.yy172,yymsp[0].minor.yy432);
}
#line 2428 "parse.c"
        break;
      case 127:
#line 467 "parse.y"
{
    yygotominor.yy373 = sqlite3SrcListAppendFromTerm(yymsp[-6].minor.yy373,0,0,&yymsp[-2].minor.yy410,yymsp[-4].minor.yy219,yymsp[-1].minor.yy172,yymsp[0].minor.yy432);
  }
#line 2435 "parse.c"
        break;
      case 129:
#line 478 "parse.y"
{
     sqlite3SrcListShiftJoinType(yymsp[0].minor.yy373);
     yygotominor.yy219 = sqlite3SelectNew(0,yymsp[0].minor.yy373,0,0,0,0,0,0,0);
  }
#line 2443 "parse.c"
        break;
      case 130:
#line 485 "parse.y"
{yygotominor.yy410.z=0; yygotominor.yy410.n=0;}
#line 2448 "parse.c"
        break;
      case 132:
#line 490 "parse.y"
{yygotominor.yy373 = sqlite3SrcListAppend(0,&yymsp[-1].minor.yy410,&yymsp[0].minor.yy410);}
#line 2453 "parse.c"
        break;
      case 133:
#line 494 "parse.y"
{ yygotominor.yy46 = JT_INNER; }
#line 2458 "parse.c"
        break;
      case 134:
#line 495 "parse.y"
{ yygotominor.yy46 = sqlite3JoinType(pParse,&yymsp[-1].minor.yy0,0,0); }
#line 2463 "parse.c"
        break;
      case 135:
#line 496 "parse.y"
{ yygotominor.yy46 = sqlite3JoinType(pParse,&yymsp[-2].minor.yy0,&yymsp[-1].minor.yy410,0); }
#line 2468 "parse.c"
        break;
      case 136:
#line 498 "parse.y"
{ yygotominor.yy46 = sqlite3JoinType(pParse,&yymsp[-3].minor.yy0,&yymsp[-2].minor.yy410,&yymsp[-1].minor.yy410); }
#line 2473 "parse.c"
        break;
      case 137:
      case 145:
      case 152:
      case 159:
      case 174:
      case 202:
      case 225:
      case 227:
#line 502 "parse.y"
{yygotominor.yy172 = yymsp[0].minor.yy172;}
#line 2485 "parse.c"
        break;
      case 138:
      case 151:
      case 158:
      case 203:
      case 226:
      case 228:
#line 503 "parse.y"
{yygotominor.yy172 = 0;}
#line 2495 "parse.c"
        break;
      case 139:
      case 171:
#line 507 "parse.y"
{yygotominor.yy432 = yymsp[-1].minor.yy432;}
#line 2501 "parse.c"
        break;
      case 140:
      case 170:
#line 508 "parse.y"
{yygotominor.yy432 = 0;}
#line 2507 "parse.c"
        break;
      case 142:
      case 150:
      case 229:
#line 519 "parse.y"
{yygotominor.yy174 = yymsp[0].minor.yy174;}
#line 2514 "parse.c"
        break;
      case 143:
#line 520 "parse.y"
{
  yygotominor.yy174 = sqlite3ExprListAppend(yymsp[-3].minor.yy174,yymsp[-1].minor.yy172,0);
  if( yygotominor.yy174 ) yygotominor.yy174->a[yygotominor.yy174->nExpr-1].sortOrder = yymsp[0].minor.yy46;
}
#line 2522 "parse.c"
        break;
      case 144:
#line 524 "parse.y"
{
  yygotominor.yy174 = sqlite3ExprListAppend(0,yymsp[-1].minor.yy172,0);
  if( yygotominor.yy174 && yygotominor.yy174->a ) yygotominor.yy174->a[0].sortOrder = yymsp[0].minor.yy46;
}
#line 2530 "parse.c"
        break;
      case 146:
      case 148:
#line 532 "parse.y"
{yygotominor.yy46 = SQLITE_SO_ASC;}
#line 2536 "parse.c"
        break;
      case 147:
#line 533 "parse.y"
{yygotominor.yy46 = SQLITE_SO_DESC;}
#line 2541 "parse.c"
        break;
      case 153:
#line 559 "parse.y"
{yygotominor.yy234.pLimit = 0; yygotominor.yy234.pOffset = 0;}
#line 2546 "parse.c"
        break;
      case 154:
#line 560 "parse.y"
{yygotominor.yy234.pLimit = yymsp[0].minor.yy172; yygotominor.yy234.pOffset = 0;}
#line 2551 "parse.c"
        break;
      case 155:
#line 562 "parse.y"
{yygotominor.yy234.pLimit = yymsp[-2].minor.yy172; yygotominor.yy234.pOffset = yymsp[0].minor.yy172;}
#line 2556 "parse.c"
        break;
      case 156:
#line 564 "parse.y"
{yygotominor.yy234.pOffset = yymsp[-2].minor.yy172; yygotominor.yy234.pLimit = yymsp[0].minor.yy172;}
#line 2561 "parse.c"
        break;
      case 157:
#line 568 "parse.y"
{sqlite3DeleteFrom(pParse,yymsp[-1].minor.yy373,yymsp[0].minor.yy172);}
#line 2566 "parse.c"
        break;
      case 160:
#line 578 "parse.y"
{
  sqlite3ExprListCheckLength(pParse,yymsp[-1].minor.yy174,SQLITE_MAX_COLUMN,"set list"); 
  sqlite3Update(pParse,yymsp[-3].minor.yy373,yymsp[-1].minor.yy174,yymsp[0].minor.yy172,yymsp[-4].minor.yy46);
}
#line 2574 "parse.c"
        break;
      case 161:
#line 587 "parse.y"
{yygotominor.yy174 = sqlite3ExprListAppend(yymsp[-4].minor.yy174,yymsp[0].minor.yy172,&yymsp[-2].minor.yy410);}
#line 2579 "parse.c"
        break;
      case 162:
#line 588 "parse.y"
{yygotominor.yy174 = sqlite3ExprListAppend(0,yymsp[0].minor.yy172,&yymsp[-2].minor.yy410);}
#line 2584 "parse.c"
        break;
      case 163:
#line 594 "parse.y"
{sqlite3Insert(pParse, yymsp[-5].minor.yy373, yymsp[-1].minor.yy174, 0, yymsp[-4].minor.yy432, yymsp[-7].minor.yy46);}
#line 2589 "parse.c"
        break;
      case 164:
#line 596 "parse.y"
{sqlite3Insert(pParse, yymsp[-2].minor.yy373, 0, yymsp[0].minor.yy219, yymsp[-1].minor.yy432, yymsp[-4].minor.yy46);}
#line 2594 "parse.c"
        break;
      case 165:
#line 598 "parse.y"
{sqlite3Insert(pParse, yymsp[-3].minor.yy373, 0, 0, yymsp[-2].minor.yy432, yymsp[-5].minor.yy46);}
#line 2599 "parse.c"
        break;
      case 168:
      case 231:
#line 608 "parse.y"
{yygotominor.yy174 = sqlite3ExprListAppend(yymsp[-2].minor.yy174,yymsp[0].minor.yy172,0);}
#line 2605 "parse.c"
        break;
      case 169:
      case 232:
#line 609 "parse.y"
{yygotominor.yy174 = sqlite3ExprListAppend(0,yymsp[0].minor.yy172,0);}
#line 2611 "parse.c"
        break;
      case 172:
#line 618 "parse.y"
{yygotominor.yy432 = sqlite3IdListAppend(yymsp[-2].minor.yy432,&yymsp[0].minor.yy410);}
#line 2616 "parse.c"
        break;
      case 173:
#line 619 "parse.y"
{yygotominor.yy432 = sqlite3IdListAppend(0,&yymsp[0].minor.yy410);}
#line 2621 "parse.c"
        break;
      case 175:
#line 630 "parse.y"
{yygotominor.yy172 = yymsp[-1].minor.yy172; sqlite3ExprSpan(yygotominor.yy172,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0); }
#line 2626 "parse.c"
        break;
      case 176:
      case 181:
      case 182:
#line 631 "parse.y"
{yygotominor.yy172 = sqlite3Expr(yymsp[0].major, 0, 0, &yymsp[0].minor.yy0);}
#line 2633 "parse.c"
        break;
      case 177:
      case 178:
#line 632 "parse.y"
{yygotominor.yy172 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy0);}
#line 2639 "parse.c"
        break;
      case 179:
#line 634 "parse.y"
{
  Expr *temp1 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy410);
  Expr *temp2 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy410);
  yygotominor.yy172 = sqlite3Expr(TK_DOT, temp1, temp2, 0);
}
#line 2648 "parse.c"
        break;
      case 180:
#line 639 "parse.y"
{
  Expr *temp1 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-4].minor.yy410);
  Expr *temp2 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy410);
  Expr *temp3 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy410);
  Expr *temp4 = sqlite3Expr(TK_DOT, temp2, temp3, 0);
  yygotominor.yy172 = sqlite3Expr(TK_DOT, temp1, temp4, 0);
}
#line 2659 "parse.c"
        break;
      case 183:
#line 648 "parse.y"
{yygotominor.yy172 = sqlite3RegisterExpr(pParse, &yymsp[0].minor.yy0);}
#line 2664 "parse.c"
        break;
      case 184:
#line 649 "parse.y"
{
  Token *pToken = &yymsp[0].minor.yy0;
  Expr *pExpr = yygotominor.yy172 = sqlite3Expr(TK_VARIABLE, 0, 0, pToken);
  sqlite3ExprAssignVarNumber(pParse, pExpr);
}
#line 2673 "parse.c"
        break;
      case 185:
#line 654 "parse.y"
{
  yygotominor.yy172 = sqlite3ExprSetColl(pParse, yymsp[-2].minor.yy172, &yymsp[0].minor.yy410);
}
#line 2680 "parse.c"
        break;
      case 186:
#line 658 "parse.y"
{
  yygotominor.yy172 = sqlite3Expr(TK_CAST, yymsp[-3].minor.yy172, 0, &yymsp[-1].minor.yy410);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-5].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2688 "parse.c"
        break;
      case 187:
#line 663 "parse.y"
{
  if( yymsp[-1].minor.yy174 && yymsp[-1].minor.yy174->nExpr>SQLITE_MAX_FUNCTION_ARG ){
    sqlite3ErrorMsg(pParse, "too many arguments on function %T", &yymsp[-4].minor.yy0);
  }
  yygotominor.yy172 = sqlite3ExprFunction(yymsp[-1].minor.yy174, &yymsp[-4].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-4].minor.yy0,&yymsp[0].minor.yy0);
  if( yymsp[-2].minor.yy46 && yygotominor.yy172 ){
    yygotominor.yy172->flags |= EP_Distinct;
  }
}
#line 2702 "parse.c"
        break;
      case 188:
#line 673 "parse.y"
{
  yygotominor.yy172 = sqlite3ExprFunction(0, &yymsp[-3].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2710 "parse.c"
        break;
      case 189:
#line 677 "parse.y"
{
  /* The CURRENT_TIME, CURRENT_DATE, and CURRENT_TIMESTAMP values are
  ** treated as functions that return constants */
  yygotominor.yy172 = sqlite3ExprFunction(0,&yymsp[0].minor.yy0);
  if( yygotominor.yy172 ){
    yygotominor.yy172->op = TK_CONST_FUNC;  
    yygotominor.yy172->span = yymsp[0].minor.yy0;
  }
}
#line 2723 "parse.c"
        break;
      case 190:
      case 191:
      case 192:
      case 193:
      case 194:
      case 195:
      case 196:
      case 197:
#line 686 "parse.y"
{yygotominor.yy172 = sqlite3Expr(yymsp[-1].major, yymsp[-2].minor.yy172, yymsp[0].minor.yy172, 0);}
#line 2735 "parse.c"
        break;
      case 198:
      case 200:
#line 696 "parse.y"
{yygotominor.yy72.eOperator = yymsp[0].minor.yy0; yygotominor.yy72.not = 0;}
#line 2741 "parse.c"
        break;
      case 199:
      case 201:
#line 697 "parse.y"
{yygotominor.yy72.eOperator = yymsp[0].minor.yy0; yygotominor.yy72.not = 1;}
#line 2747 "parse.c"
        break;
      case 204:
#line 704 "parse.y"
{
  ExprList *pList;
  pList = sqlite3ExprListAppend(0, yymsp[-1].minor.yy172, 0);
  pList = sqlite3ExprListAppend(pList, yymsp[-3].minor.yy172, 0);
  if( yymsp[0].minor.yy172 ){
    pList = sqlite3ExprListAppend(pList, yymsp[0].minor.yy172, 0);
  }
  yygotominor.yy172 = sqlite3ExprFunction(pList, &yymsp[-2].minor.yy72.eOperator);
  if( yymsp[-2].minor.yy72.not ) yygotominor.yy172 = sqlite3Expr(TK_NOT, yygotominor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172, &yymsp[-3].minor.yy172->span, &yymsp[-1].minor.yy172->span);
  if( yygotominor.yy172 ) yygotominor.yy172->flags |= EP_InfixFunc;
}
#line 2763 "parse.c"
        break;
      case 205:
#line 717 "parse.y"
{
  yygotominor.yy172 = sqlite3Expr(yymsp[0].major, yymsp[-1].minor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-1].minor.yy172->span,&yymsp[0].minor.yy0);
}
#line 2771 "parse.c"
        break;
      case 206:
#line 721 "parse.y"
{
  yygotominor.yy172 = sqlite3Expr(TK_ISNULL, yymsp[-2].minor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-2].minor.yy172->span,&yymsp[0].minor.yy0);
}
#line 2779 "parse.c"
        break;
      case 207:
#line 725 "parse.y"
{
  yygotominor.yy172 = sqlite3Expr(TK_NOTNULL, yymsp[-2].minor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-2].minor.yy172->span,&yymsp[0].minor.yy0);
}
#line 2787 "parse.c"
        break;
      case 208:
#line 729 "parse.y"
{
  yygotominor.yy172 = sqlite3Expr(TK_NOTNULL, yymsp[-3].minor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-3].minor.yy172->span,&yymsp[0].minor.yy0);
}
#line 2795 "parse.c"
        break;
      case 209:
#line 733 "parse.y"
{
  yygotominor.yy172 = sqlite3Expr(yymsp[-1].major, yymsp[0].minor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy172->span);
}
#line 2803 "parse.c"
        break;
      case 210:
#line 737 "parse.y"
{
  yygotominor.yy172 = sqlite3Expr(TK_UMINUS, yymsp[0].minor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy172->span);
}
#line 2811 "parse.c"
        break;
      case 211:
#line 741 "parse.y"
{
  yygotominor.yy172 = sqlite3Expr(TK_UPLUS, yymsp[0].minor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy172->span);
}
#line 2819 "parse.c"
        break;
      case 214:
#line 748 "parse.y"
{
  ExprList *pList = sqlite3ExprListAppend(0, yymsp[-2].minor.yy172, 0);
  pList = sqlite3ExprListAppend(pList, yymsp[0].minor.yy172, 0);
  yygotominor.yy172 = sqlite3Expr(TK_BETWEEN, yymsp[-4].minor.yy172, 0, 0);
  if( yygotominor.yy172 ){
    yygotominor.yy172->pList = pList;
  }else{
    sqlite3ExprListDelete(pList);
  } 
  if( yymsp[-3].minor.yy46 ) yygotominor.yy172 = sqlite3Expr(TK_NOT, yygotominor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-4].minor.yy172->span,&yymsp[0].minor.yy172->span);
}
#line 2835 "parse.c"
        break;
      case 217:
#line 764 "parse.y"
{
    yygotominor.yy172 = sqlite3Expr(TK_IN, yymsp[-4].minor.yy172, 0, 0);
    if( yygotominor.yy172 ){
      yygotominor.yy172->pList = yymsp[-1].minor.yy174;
      sqlite3ExprSetHeight(yygotominor.yy172);
    }else{
      sqlite3ExprListDelete(yymsp[-1].minor.yy174);
    }
    if( yymsp[-3].minor.yy46 ) yygotominor.yy172 = sqlite3Expr(TK_NOT, yygotominor.yy172, 0, 0);
    sqlite3ExprSpan(yygotominor.yy172,&yymsp[-4].minor.yy172->span,&yymsp[0].minor.yy0);
  }
#line 2850 "parse.c"
        break;
      case 218:
#line 775 "parse.y"
{
    yygotominor.yy172 = sqlite3Expr(TK_SELECT, 0, 0, 0);
    if( yygotominor.yy172 ){
      yygotominor.yy172->pSelect = yymsp[-1].minor.yy219;
      sqlite3ExprSetHeight(yygotominor.yy172);
    }else{
      sqlite3SelectDelete(yymsp[-1].minor.yy219);
    }
    sqlite3ExprSpan(yygotominor.yy172,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0);
  }
#line 2864 "parse.c"
        break;
      case 219:
#line 785 "parse.y"
{
    yygotominor.yy172 = sqlite3Expr(TK_IN, yymsp[-4].minor.yy172, 0, 0);
    if( yygotominor.yy172 ){
      yygotominor.yy172->pSelect = yymsp[-1].minor.yy219;
      sqlite3ExprSetHeight(yygotominor.yy172);
    }else{
      sqlite3SelectDelete(yymsp[-1].minor.yy219);
    }
    if( yymsp[-3].minor.yy46 ) yygotominor.yy172 = sqlite3Expr(TK_NOT, yygotominor.yy172, 0, 0);
    sqlite3ExprSpan(yygotominor.yy172,&yymsp[-4].minor.yy172->span,&yymsp[0].minor.yy0);
  }
#line 2879 "parse.c"
        break;
      case 220:
#line 796 "parse.y"
{
    SrcList *pSrc = sqlite3SrcListAppend(0,&yymsp[-1].minor.yy410,&yymsp[0].minor.yy410);
    yygotominor.yy172 = sqlite3Expr(TK_IN, yymsp[-3].minor.yy172, 0, 0);
    if( yygotominor.yy172 ){
      yygotominor.yy172->pSelect = sqlite3SelectNew(0,pSrc,0,0,0,0,0,0,0);
      sqlite3ExprSetHeight(yygotominor.yy172);
    }else{
      sqlite3SrcListDelete(pSrc);
    }
    if( yymsp[-2].minor.yy46 ) yygotominor.yy172 = sqlite3Expr(TK_NOT, yygotominor.yy172, 0, 0);
    sqlite3ExprSpan(yygotominor.yy172,&yymsp[-3].minor.yy172->span,yymsp[0].minor.yy410.z?&yymsp[0].minor.yy410:&yymsp[-1].minor.yy410);
  }
#line 2895 "parse.c"
        break;
      case 221:
#line 808 "parse.y"
{
    Expr *p = yygotominor.yy172 = sqlite3Expr(TK_EXISTS, 0, 0, 0);
    if( p ){
      p->pSelect = yymsp[-1].minor.yy219;
      sqlite3ExprSpan(p,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
      sqlite3ExprSetHeight(yygotominor.yy172);
    }else{
      sqlite3SelectDelete(yymsp[-1].minor.yy219);
    }
  }
#line 2909 "parse.c"
        break;
      case 222:
#line 821 "parse.y"
{
  yygotominor.yy172 = sqlite3Expr(TK_CASE, yymsp[-3].minor.yy172, yymsp[-1].minor.yy172, 0);
  if( yygotominor.yy172 ){
    yygotominor.yy172->pList = yymsp[-2].minor.yy174;
    sqlite3ExprSetHeight(yygotominor.yy172);
  }else{
    sqlite3ExprListDelete(yymsp[-2].minor.yy174);
  }
  sqlite3ExprSpan(yygotominor.yy172, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0);
}
#line 2923 "parse.c"
        break;
      case 223:
#line 833 "parse.y"
{
  yygotominor.yy174 = sqlite3ExprListAppend(yymsp[-4].minor.yy174, yymsp[-2].minor.yy172, 0);
  yygotominor.yy174 = sqlite3ExprListAppend(yygotominor.yy174, yymsp[0].minor.yy172, 0);
}
#line 2931 "parse.c"
        break;
      case 224:
#line 837 "parse.y"
{
  yygotominor.yy174 = sqlite3ExprListAppend(0, yymsp[-2].minor.yy172, 0);
  yygotominor.yy174 = sqlite3ExprListAppend(yygotominor.yy174, yymsp[0].minor.yy172, 0);
}
#line 2939 "parse.c"
        break;
      case 233:
#line 864 "parse.y"
{
  sqlite3CreateIndex(pParse, &yymsp[-6].minor.yy410, &yymsp[-5].minor.yy410, sqlite3SrcListAppend(0,&yymsp[-3].minor.yy410,0), yymsp[-1].minor.yy174, yymsp[-9].minor.yy46,
                      &yymsp[-10].minor.yy0, &yymsp[0].minor.yy0, SQLITE_SO_ASC, yymsp[-7].minor.yy46);
}
#line 2947 "parse.c"
        break;
      case 234:
      case 281:
#line 870 "parse.y"
{yygotominor.yy46 = OE_Abort;}
#line 2953 "parse.c"
        break;
      case 235:
#line 871 "parse.y"
{yygotominor.yy46 = OE_None;}
#line 2958 "parse.c"
        break;
      case 238:
#line 881 "parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy410.n>0 ){
    p = sqlite3Expr(TK_COLUMN, 0, 0, 0);
    if( p ) p->pColl = sqlite3LocateCollSeq(pParse, (char*)yymsp[-1].minor.yy410.z, yymsp[-1].minor.yy410.n);
  }
  yygotominor.yy174 = sqlite3ExprListAppend(yymsp[-4].minor.yy174, p, &yymsp[-2].minor.yy410);
  sqlite3ExprListCheckLength(pParse, yygotominor.yy174, SQLITE_MAX_COLUMN, "index");
  if( yygotominor.yy174 ) yygotominor.yy174->a[yygotominor.yy174->nExpr-1].sortOrder = yymsp[0].minor.yy46;
}
#line 2972 "parse.c"
        break;
      case 239:
#line 891 "parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy410.n>0 ){
    p = sqlite3Expr(TK_COLUMN, 0, 0, 0);
    if( p ) p->pColl = sqlite3LocateCollSeq(pParse, (char*)yymsp[-1].minor.yy410.z, yymsp[-1].minor.yy410.n);
  }
  yygotominor.yy174 = sqlite3ExprListAppend(0, p, &yymsp[-2].minor.yy410);
  sqlite3ExprListCheckLength(pParse, yygotominor.yy174, SQLITE_MAX_COLUMN, "index");
  if( yygotominor.yy174 ) yygotominor.yy174->a[yygotominor.yy174->nExpr-1].sortOrder = yymsp[0].minor.yy46;
}
#line 2986 "parse.c"
        break;
      case 241:
#line 904 "parse.y"
{yygotominor.yy410.z = 0; yygotominor.yy410.n = 0;}
#line 2991 "parse.c"
        break;
      case 243:
#line 910 "parse.y"
{sqlite3DropIndex(pParse, yymsp[0].minor.yy373, yymsp[-1].minor.yy46);}
#line 2996 "parse.c"
        break;
      case 244:
      case 245:
#line 916 "parse.y"
{sqlite3Vacuum(pParse);}
#line 3002 "parse.c"
        break;
      case 246:
#line 924 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-3].minor.yy410,&yymsp[-2].minor.yy410,&yymsp[0].minor.yy410,0);}
#line 3007 "parse.c"
        break;
      case 247:
#line 925 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-3].minor.yy410,&yymsp[-2].minor.yy410,&yymsp[0].minor.yy0,0);}
#line 3012 "parse.c"
        break;
      case 248:
#line 926 "parse.y"
{
  sqlite3Pragma(pParse,&yymsp[-3].minor.yy410,&yymsp[-2].minor.yy410,&yymsp[0].minor.yy410,1);
}
#line 3019 "parse.c"
        break;
      case 249:
#line 929 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-4].minor.yy410,&yymsp[-3].minor.yy410,&yymsp[-1].minor.yy410,0);}
#line 3024 "parse.c"
        break;
      case 250:
#line 930 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-1].minor.yy410,&yymsp[0].minor.yy410,0,0);}
#line 3029 "parse.c"
        break;
      case 258:
#line 944 "parse.y"
{
  Token all;
  all.z = yymsp[-3].minor.yy410.z;
  all.n = (yymsp[0].minor.yy0.z - yymsp[-3].minor.yy410.z) + yymsp[0].minor.yy0.n;
  sqlite3FinishTrigger(pParse, yymsp[-1].minor.yy243, &all);
}
#line 3039 "parse.c"
        break;
      case 259:
#line 953 "parse.y"
{
  sqlite3BeginTrigger(pParse, &yymsp[-7].minor.yy410, &yymsp[-6].minor.yy410, yymsp[-5].minor.yy46, yymsp[-4].minor.yy370.a, yymsp[-4].minor.yy370.b, yymsp[-2].minor.yy373, yymsp[0].minor.yy172, yymsp[-10].minor.yy46, yymsp[-8].minor.yy46);
  yygotominor.yy410 = (yymsp[-6].minor.yy410.n==0?yymsp[-7].minor.yy410:yymsp[-6].minor.yy410);
}
#line 3047 "parse.c"
        break;
      case 260:
      case 263:
#line 959 "parse.y"
{ yygotominor.yy46 = TK_BEFORE; }
#line 3053 "parse.c"
        break;
      case 261:
#line 960 "parse.y"
{ yygotominor.yy46 = TK_AFTER;  }
#line 3058 "parse.c"
        break;
      case 262:
#line 961 "parse.y"
{ yygotominor.yy46 = TK_INSTEAD;}
#line 3063 "parse.c"
        break;
      case 264:
      case 265:
#line 966 "parse.y"
{yygotominor.yy370.a = yymsp[0].major; yygotominor.yy370.b = 0;}
#line 3069 "parse.c"
        break;
      case 266:
#line 968 "parse.y"
{yygotominor.yy370.a = TK_UPDATE; yygotominor.yy370.b = yymsp[0].minor.yy432;}
#line 3074 "parse.c"
        break;
      case 269:
#line 975 "parse.y"
{ yygotominor.yy172 = 0; }
#line 3079 "parse.c"
        break;
      case 270:
#line 976 "parse.y"
{ yygotominor.yy172 = yymsp[0].minor.yy172; }
#line 3084 "parse.c"
        break;
      case 271:
#line 980 "parse.y"
{
  if( yymsp[-2].minor.yy243 ){
    yymsp[-2].minor.yy243->pLast->pNext = yymsp[-1].minor.yy243;
  }else{
    yymsp[-2].minor.yy243 = yymsp[-1].minor.yy243;
  }
  yymsp[-2].minor.yy243->pLast = yymsp[-1].minor.yy243;
  yygotominor.yy243 = yymsp[-2].minor.yy243;
}
#line 3097 "parse.c"
        break;
      case 272:
#line 989 "parse.y"
{ yygotominor.yy243 = 0; }
#line 3102 "parse.c"
        break;
      case 273:
#line 995 "parse.y"
{ yygotominor.yy243 = sqlite3TriggerUpdateStep(&yymsp[-3].minor.yy410, yymsp[-1].minor.yy174, yymsp[0].minor.yy172, yymsp[-4].minor.yy46); }
#line 3107 "parse.c"
        break;
      case 274:
#line 1000 "parse.y"
{yygotominor.yy243 = sqlite3TriggerInsertStep(&yymsp[-5].minor.yy410, yymsp[-4].minor.yy432, yymsp[-1].minor.yy174, 0, yymsp[-7].minor.yy46);}
#line 3112 "parse.c"
        break;
      case 275:
#line 1003 "parse.y"
{yygotominor.yy243 = sqlite3TriggerInsertStep(&yymsp[-2].minor.yy410, yymsp[-1].minor.yy432, 0, yymsp[0].minor.yy219, yymsp[-4].minor.yy46);}
#line 3117 "parse.c"
        break;
      case 276:
#line 1007 "parse.y"
{yygotominor.yy243 = sqlite3TriggerDeleteStep(&yymsp[-1].minor.yy410, yymsp[0].minor.yy172);}
#line 3122 "parse.c"
        break;
      case 277:
#line 1010 "parse.y"
{yygotominor.yy243 = sqlite3TriggerSelectStep(yymsp[0].minor.yy219); }
#line 3127 "parse.c"
        break;
      case 278:
#line 1013 "parse.y"
{
  yygotominor.yy172 = sqlite3Expr(TK_RAISE, 0, 0, 0); 
  if( yygotominor.yy172 ){
    yygotominor.yy172->iColumn = OE_Ignore;
    sqlite3ExprSpan(yygotominor.yy172, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0);
  }
}
#line 3138 "parse.c"
        break;
      case 279:
#line 1020 "parse.y"
{
  yygotominor.yy172 = sqlite3Expr(TK_RAISE, 0, 0, &yymsp[-1].minor.yy410); 
  if( yygotominor.yy172 ) {
    yygotominor.yy172->iColumn = yymsp[-3].minor.yy46;
    sqlite3ExprSpan(yygotominor.yy172, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0);
  }
}
#line 3149 "parse.c"
        break;
      case 280:
#line 1030 "parse.y"
{yygotominor.yy46 = OE_Rollback;}
#line 3154 "parse.c"
        break;
      case 282:
#line 1032 "parse.y"
{yygotominor.yy46 = OE_Fail;}
#line 3159 "parse.c"
        break;
      case 283:
#line 1037 "parse.y"
{
  sqlite3DropTrigger(pParse,yymsp[0].minor.yy373,yymsp[-1].minor.yy46);
}
#line 3166 "parse.c"
        break;
      case 284:
#line 1044 "parse.y"
{
  sqlite3Attach(pParse, yymsp[-3].minor.yy172, yymsp[-1].minor.yy172, yymsp[0].minor.yy386);
}
#line 3173 "parse.c"
        break;
      case 285:
#line 1047 "parse.y"
{
  sqlite3Detach(pParse, yymsp[0].minor.yy172);
}
#line 3180 "parse.c"
        break;
      case 286:
#line 1053 "parse.y"
{ yygotominor.yy386 = 0; }
#line 3185 "parse.c"
        break;
      case 287:
#line 1054 "parse.y"
{ yygotominor.yy386 = yymsp[0].minor.yy172; }
#line 3190 "parse.c"
        break;
      case 290:
#line 1062 "parse.y"
{sqlite3Reindex(pParse, 0, 0);}
#line 3195 "parse.c"
        break;
      case 291:
#line 1063 "parse.y"
{sqlite3Reindex(pParse, &yymsp[-1].minor.yy410, &yymsp[0].minor.yy410);}
#line 3200 "parse.c"
        break;
      case 292:
#line 1068 "parse.y"
{sqlite3Analyze(pParse, 0, 0);}
#line 3205 "parse.c"
        break;
      case 293:
#line 1069 "parse.y"
{sqlite3Analyze(pParse, &yymsp[-1].minor.yy410, &yymsp[0].minor.yy410);}
#line 3210 "parse.c"
        break;
      case 294:
#line 1074 "parse.y"
{
  sqlite3AlterRenameTable(pParse,yymsp[-3].minor.yy373,&yymsp[0].minor.yy410);
}
#line 3217 "parse.c"
        break;
      case 295:
#line 1077 "parse.y"
{
  sqlite3AlterFinishAddColumn(pParse, &yymsp[0].minor.yy410);
}
#line 3224 "parse.c"
        break;
      case 296:
#line 1080 "parse.y"
{
  sqlite3AlterBeginAddColumn(pParse, yymsp[0].minor.yy373);
}
#line 3231 "parse.c"
        break;
      case 299:
#line 1089 "parse.y"
{sqlite3VtabFinishParse(pParse,0);}
#line 3236 "parse.c"
        break;
      case 300:
#line 1090 "parse.y"
{sqlite3VtabFinishParse(pParse,&yymsp[0].minor.yy0);}
#line 3241 "parse.c"
        break;
      case 301:
#line 1091 "parse.y"
{
    sqlite3VtabBeginParse(pParse, &yymsp[-3].minor.yy410, &yymsp[-2].minor.yy410, &yymsp[0].minor.yy410);
}
#line 3248 "parse.c"
        break;
      case 304:
#line 1096 "parse.y"
{sqlite3VtabArgInit(pParse);}
#line 3253 "parse.c"
        break;
      case 306:
      case 307:
      case 308:
      case 310:
#line 1098 "parse.y"
{sqlite3VtabArgExtend(pParse,&yymsp[0].minor.yy0);}
#line 3261 "parse.c"
        break;
  };
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yymsp[-yysize].stateno,yygoto);
  if( yyact < YYNSTATE ){
#ifdef NDEBUG
    /* If we are not debugging and the reduce action popped at least
    ** one element off the stack, then we can push the new element back
    ** onto the stack here, and skip the stack overflow test in yy_shift().
    ** That gives a significant speed improvement. */
    if( yysize ){
      yypParser->yyidx++;
      yymsp -= yysize-1;
      yymsp->stateno = yyact;
      yymsp->major = yygoto;
      yymsp->minor = yygotominor;
    }else
#endif
    {
      yy_shift(yypParser,yyact,yygoto,&yygotominor);
    }
  }else if( yyact == YYNSTATE + YYNRULE + 1 ){
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  sqlite3ParserARG_FETCH;
#define TOKEN (yyminor.yy0)
#line 34 "parse.y"

  if( !pParse->parseError ){
    if( TOKEN.z[0] ){
      sqlite3ErrorMsg(pParse, "near \"%T\": syntax error", &TOKEN);
    }else{
      sqlite3ErrorMsg(pParse, "incomplete SQL statement");
    }
    pParse->parseError = 1;
  }
#line 3329 "parse.c"
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "sqlite3ParserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3Parser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  sqlite3ParserTOKENTYPE yyminor       /* The value for the token */
  sqlite3ParserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
#if YYSTACKDEPTH<=0
    if( yypParser->yystksz <=0 ){
      memset(&yyminorunion, 0, sizeof(yyminorunion));
      yyStackOverflow(yypParser, &yyminorunion);
      return;
    }
#endif
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);
  sqlite3ParserARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,yymajor);
    if( yyact<YYNSTATE ){
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      if( yyendofinput && yypParser->yyidx>=0 ){
        yymajor = 0;
      }else{
        yymajor = YYNOCODE;
      }
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else if( yyact == YY_ERROR_ACTION ){
      int yymx;
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_reduce_action(
                        yypParser->yystack[yypParser->yyidx].stateno,
                        YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }else{
      yy_accept(yypParser);
      yymajor = YYNOCODE;
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}
