exception Error of string
  (** exception used to report error conditions,
      to be displayed to the user in a dialog box *)

val error  : string -> 'a
val errorf : ('a, unit, string, 'b) format4 -> 'a

module StringMap : Map.S with type key = string

type query_domain = string list
type date = string
type query_limit =
  | QUERY_NO_LIMIT
  | QUERY_BETWEEN of date * date
type query = {
    dom : query_domain ;
    lim : query_limit ;
    all_propagates : bool
  }

type select_info = { query : query; preselect : string option; }


module NodeMap : Map.S with type key = string
module EdgeMap : Map.S with type key = string * string
module IdSet   : Set.S with type elt = string

type sig_verif =
  | SIG_OK
  | SIG_BAD
  | SIG_UNKNOWN

type cert = {
    c_id        : string ;
    c_name      : string ;
    c_value     : string ;
    c_signer_id : string ;
    c_signature : sig_verif ;
  }

type node_kind =
  | REGULAR
  | NEIGHBOUR_IN
  | NEIGHBOUR_OUT
  | MERGE
  | DISAPPROVE
  | TAGGED of string

type relation = PARENT | CHILD

type a_node = {
            id       : string ;
    mutable kind     : node_kind ;
    mutable family   : (string * relation) list ;
  }

val neighbour_kind : node_kind -> bool

type node_data = {
    revision_id  : string ;
    manifest_id  : string ;
    revision_set : (string * Revision.change list) list ;
    certs        : cert list ;
  }

type edge_kind =
  | SAME_BRANCH
  | DISAPPROVED
  | BRANCHING
  | BRANCHING_NEIGH
  | SPANNING


type agraph = {
  nodes           : a_node NodeMap.t ;
  ancestry        : edge_kind EdgeMap.t ;
}

type c_node = {
  n_x : float;
  n_y : float;
  n_w : float;
  n_h : float;
  c_kind : node_kind ;
}

type edge = {
  startp    : float array;
  endp      : float array;
  controlp  : float array;
  edge_kind : edge_kind ;
}

type cgraph = {
  bb      : float * float * float * float;
  c_nodes : c_node NodeMap.t;
  c_edges : edge EdgeMap.t;
}
  (** Type with the geometrical information for the layout of the
      ancestry graph *)

val empty_agraph : agraph
  (** dummy value for initialization. *)

val empty_cgraph : cgraph
  (** dummy value for initialization. *)

type direction = [
    `PARENT
  | `CHILD
  | `NEXT
  | `PREV ]

type autocolor =
  | NONE
  | BY_AUTHOR_HASH
  | BY_BRANCH_HASH
