type graph = {
    strict : bool ;
    kind   : [`GRAPH | `DIGRAPH] ;
    id     : string option ;
    stmt   : statement list ;
  }
and statement = [
  | `NODE of string * port option * attr list
  | `SUBGRAPH of string option * statement list
  | `ATTR_GRAPH of attr list
  | `ATTR_NODE of attr list
  | `ATTR_EDGE of attr list
  | `ID_EQUAL of string * string
  | `EDGE of (subgraph_or_node * edegeop * attr list)
  ]
and subgraph_or_node = [ 
    `SUBGRAPH of string option * statement list
  | `NODEID of (string * port option) ]
and port = ([`NO_LOCATION | `LOCATION of [`ONE_ID of string
                                         | `TWO_ID of string * string ]] *
            [`NO_ANGLE | `ANGLE of string])
and attr = string * string
and edegeop = ([`DIRECTED | `UNDIRECTED] * subgraph_or_node) list
