
{
  open Revision_parser

  let kwd = Hashtbl.create 37

  let _ = 
    List.iter (fun (k, tok) -> Hashtbl.add kwd k tok)
      [ "format_version", FORMAT_VERSION;
	"new_manifest", NEW_MANIFEST;
        "old_revision", OLD_REVISION;
        "old_manifest", OLD_MANIFEST;
	"content", CONTENT;
	"patch", PATCH;
	"from", FROM;
	"to", TO;
        "add_file", ADD_FILE;
        "add_dir", ADD_DIR;
        "delete", DELETE_FILE;
        "delete_file", DELETE_FILE;
        "delete_dir", DELETE_DIR;
        "rename", RENAME_FILE;
        "rename_file", RENAME_FILE;
        "rename_dir", RENAME_DIR; 
	"clear", CLEAR;
	"set", SET;
	"attr", ATTR;
	"value", VALUE;
      ]
}

let id = ['a'-'z' '0'-'9']*
let ident = ['a'-'z' '_']+

rule lex = parse
  | [ ' ' '\n' '\t']+   { lex lexbuf }
  | '[' (id as id) ']'  { ID id }
  | ident               { try Hashtbl.find kwd (Lexing.lexeme lexbuf) 
                          with Not_found -> raise Parsing.Parse_error }
  | '"'                 { STRING (string (Buffer.create 128) lexbuf) }
  | eof                 { EOF }

and string b = parse
  | '"'     { Buffer.contents b }
  | "\\\""  { Buffer.add_char b '"' ; string b lexbuf }
  | _       { Buffer.add_char b (Lexing.lexeme_char lexbuf 0) ; 
              string b lexbuf }
