<elements>
  <summary>
    <attribution license="cc4" from="Microsoft" modified="false" />
    <para>The System.IO namespace contains types that allow reading and writing to files and data streams, and types that provide basic file and directory support.</para>
  </summary>
  <remarks>To be added.</remarks>
  <class name="BinaryReader" fullname="System.IO.BinaryReader" assembly="mscorlib">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Reads primitive data types as binary values in a specific encoding.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>The <see cref="T:System.IO.BinaryReader" /> class provides methods that simplify reading primitive data types from a stream. For example, you can use the <see cref="M:System.IO.BinaryReader.ReadBoolean" /> method to read the next byte as a Boolean value and advance the current position in the stream by one byte. The class includes read methods that support different data types. </para>
      <para>When you create a new instance of the <see cref="T:System.IO.BinaryReader" /> class, you provide the stream to read from, and optionally specify the type of encoding and whether to leave the stream open after disposing the <see cref="T:System.IO.BinaryReader" /> object. If you do not specify an encoding type, UTF-8 is used.</para>
    </remarks>
  </class>
  <class name="BinaryWriter" fullname="System.IO.BinaryWriter" assembly="mscorlib">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Writes primitive types in binary to a stream and supports writing strings in a specific encoding.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>The <see cref="T:System.IO.BinaryWriter" /> class provides methods that simplify writing primitive data types to a stream. For example, you can use the <see cref="M:System.IO.BinaryWriter.Write(System.Boolean)" /> method to write a Boolean value to the stream as a one-byte value. The class includes write methods that support different data types. </para>
      <para>When you create a new instance of the <see cref="T:System.IO.BinaryWriter" /> class, you provide the stream to write to, and optionally specify the type of encoding and whether to leave the stream open after disposing the <see cref="T:System.IO.BinaryWriter" /> object. If you do not specify an encoding type, UTF-8 is used.</para>
      <para>A derived class can override the methods of this class to give unique character encodings.</para>
    </remarks>
  </class>
  <class name="BufferedStream" fullname="System.IO.BufferedStream" assembly="mscorlib">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Adds a buffering layer to read and write operations on another stream. This class cannot be inherited.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>A buffer is a block of bytes in memory used to cache data, thereby reducing the number of calls to the operating system. Buffers improve read and write performance. A buffer can be used for either reading or writing, but never both simultaneously. The <see cref="M:System.IO.BufferedStream.Read(System.Byte[],System.Int32,System.Int32)" /> and <see cref="M:System.IO.BufferedStream.Write(System.Byte[],System.Int32,System.Int32)" /> methods of BufferedStream automatically maintain the buffer.</para>
      <para>BufferedStream can be composed around certain types of streams. It provides implementations for reading and writing bytes to an underlying data source or repository. Use <see cref="T:System.IO.BinaryReader" /> and <see cref="T:System.IO.BinaryWriter" /> for reading and writing other data types. BufferedStream is designed to prevent the buffer from slowing down input and output when the buffer is not needed. If you always read and write for sizes greater than the internal buffer size, then BufferedStream might not even allocate the internal buffer. BufferedStream also buffers reads and writes in a shared buffer. It is assumed that you will almost always be doing a series of reads or writes, but rarely alternate between the two of them.</para>
    </remarks>
  </class>
  <class name="Directory" fullname="System.IO.Directory" assembly="mscorlib">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Exposes static methods for creating, moving, and enumerating through directories and subdirectories. This class cannot be inherited.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Use the <see cref="T:System.IO.Directory" /> class for typical operations such as copying, moving, renaming, creating, and deleting directories. </para>
      <list type="bullet">
        <item>
          <para>To create a directory, use one of the <see cref="M:System.IO.Directory.CreateDirectory(System.String)" /> methods.</para>
        </item>
        <item>
          <para>To delete a directory, use one of the <see cref="M:System.IO.Directory.Delete(System.String)" /> methods.</para>
        </item>
        <item>
          <para>To get or set the current directory for an app, use the <see cref="M:System.IO.Directory.GetCurrentDirectory" /> or <see cref="M:System.IO.Directory.SetCurrentDirectory(System.String)" /> method.</para>
        </item>
        <item>
          <para>To manipulate <see cref="T:System.DateTime" /> information related to the creation, access, and writing of a directory, use methods such as <see cref="M:System.IO.Directory.SetLastAccessTime(System.String,System.DateTime)" /> and <see cref="M:System.IO.Directory.SetCreationTime(System.String,System.DateTime)" />.</para>
        </item>
      </list>
      <para>The static methods of the <see cref="T:System.IO.Directory" /> class perform security checks on all methods. If you are going to reuse an object several times, consider using the corresponding instance method of <see cref="T:System.IO.DirectoryInfo" /> instead, because the security check will not always be necessary.</para>
      <para>If you are performing only one directory-related action, it might be more efficient to use a static <see cref="T:System.IO.Directory" /> method rather than a corresponding <see cref="T:System.IO.DirectoryInfo" /> instance method. Most <see cref="T:System.IO.Directory" /> methods require the path to the directory that you are manipulating. </para>
      <block subset="none" type="note">
        <para>In members that accept a string <paramref name="path" /> parameter, that path must be well-formed or an exception is raised. For example, if a path is fully qualified but begins with a space (" c:\temp"), the path string isn't trimmed, so the path is considered malformed and an exception is raised. In addition, a path or a combination of paths cannot be fully qualified twice. For example, "c:\temp c:\windows" also raises an exception. Ensure that your paths are well-formed when using methods that accept a path string. For more information see <see cref="T:System.IO.Path" />.</para>
      </block>
      <para>In members that accept a path, the path can refer to a file or a directory. You can use a full path, a relative path, or a Universal Naming Convention (UNC) path for a server and share name. For example, all the following are acceptable paths: </para>
      <list type="bullet">
        <item>
          <para>"c:\\MyDir" in C#, or "c:\MyDir" in Visual Basic.</para>
        </item>
        <item>
          <para>"MyDir\\MySubdir" in C#, or "MyDir\MySubDir" in Visual Basic.</para>
        </item>
        <item>
          <para>"\\\\MyServer\\MyShare" in C#, or "\\MyServer\MyShare" in Visual Basic.</para>
        </item>
      </list>
      <para>By default, full read/write access to new directories is granted to all users. However, the app must have the correct security to access existing directories. </para>
      <para>To demand permissions for a directory and all its subdirectories, end the path string with the directory separator character. (For example, "C:\Temp\" grants access to C:\Temp\ and all its subdirectories.) To demand permissions only for a specific directory, end the path string with a period. (For example, "C:\Temp\." grants access only to C:\Temp\, not to its subdirectories.)</para>
      <para>In members that accept a <paramref name="searchPattern" /> parameter, the search string can be any combination of literal characters and two wildcard characters; * and ?. This parameter does not recognize regular expressions. For more information, see the <see cref="M:System.IO.Directory.EnumerateDirectories(System.String,System.String)" /> method or any other method that uses the <paramref name="searchPattern" /> parameter.</para>
      <para>For a list of common I/O tasks, see <format type="text/html"><a href="bf00c380-706a-4e38-b829-454a480629fc">Common I/O Tasks</a></format>.</para>
      <para>
        <see cref="T:System.IO.Directory" /> and <see cref="T:System.IO.DirectoryInfo" /> are not supported for use in win8_appstore_long apps. For information about how to access files and folders in win8_appstore_long apps, see <see cref="http://msdn.microsoft.com/library/windows/apps/hh758319.aspx">Accessing data and files (Windows Store apps)</see>.</para>
    </remarks>
  </class>
  <class name="DirectoryInfo" fullname="System.IO.DirectoryInfo" assembly="mscorlib">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Exposes instance methods for creating, moving, and enumerating through directories and subdirectories. This class cannot be inherited.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Use the <see cref="T:System.IO.DirectoryInfo" /> class for typical operations such as copying, moving, renaming, creating, and deleting directories.</para>
      <para>If you are going to reuse an object several times, consider using the instance method of <see cref="T:System.IO.DirectoryInfo" /> instead of the corresponding static methods of the <see cref="T:System.IO.Directory" /> class, because a security check will not always be necessary.</para>
      <block subset="none" type="note">
        <para>In members that accept a path as an input string, that path must be well-formed or an exception is raised. For example, if a path is fully qualified but begins with a space, the path is not trimmed in methods of the class. Therefore, the path is malformed and an exception is raised. Similarly, a path or a combination of paths cannot be fully qualified twice. For example, "c:\temp c:\windows" also raises an exception in most cases. Ensure that your paths are well-formed when using methods that accept a path string.</para>
      </block>
      <para>In members that accept a path, the path can refer to a file or just a directory. The specified path can also refer to a relative path or a Universal Naming Convention (UNC) path for a server and share name. For example, all the following are acceptable paths: </para>
      <list type="bullet">
        <item>
          <para>"c:\\MyDir\\MyFile.txt" in C#, or "c:\MyDir\MyFile.txt" in Visual Basic.</para>
        </item>
        <item>
          <para>"c:\\MyDir" in C#, or "c:\MyDir" in Visual Basic.</para>
        </item>
        <item>
          <para>"MyDir\\MySubdir" in C#, or "MyDir\MySubDir" in Visual Basic.</para>
        </item>
        <item>
          <para>"\\\\MyServer\\MyShare" in C#, or "\\MyServer\MyShare" in Visual Basic.</para>
        </item>
      </list>
      <para>By default, full read/write access to new directories is granted to all users.</para>
      <para>For a list of common I/O tasks, see <format type="text/html"><a href="bf00c380-706a-4e38-b829-454a480629fc">Common I/O Tasks</a></format>.</para>
    </remarks>
  </class>
  <class name="DirectoryNotFoundException" fullname="System.IO.DirectoryNotFoundException" assembly="mscorlib">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>The exception that is thrown when part of a file or directory cannot be found.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>DirectoryNotFoundException uses the HRESULT COR_E_DIRECTORYNOTFOUND which has the value 0x80070003. Note that DirectoryNotFoundException is also thrown when COM interop programs see the HRESULT STG_E_PATHNOTFOUND, which has the value 0x80030003.</para>
      <para>If your code does not have <see cref="P:System.Security.Permissions.FileIOPermissionAttribute.PathDiscovery" /> permission, the error message for this exception may only contain file or directory names instead of fully qualified paths.</para>
    </remarks>
  </class>
  <class name="DriveInfo" fullname="System.IO.DriveInfo" assembly="mscorlib">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Provides access to information on a drive.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>This class models a drive and provides methods and properties to query for drive information. Use <see cref="T:System.IO.DriveInfo" /> to determine what drives are available, and what type of drives they are. You can also query to determine the capacity and available free space on the drive.</para>
    </remarks>
  </class>
  <class name="DriveNotFoundException" fullname="System.IO.DriveNotFoundException" assembly="mscorlib">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>The exception that is thrown when trying to access a drive or share that is not available.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>The <see cref="T:System.IO.DriveNotFoundException" /> class uses the HRESULT COR_E_DIRECTORYNOTFOUND. This exception can be thrown when a Win32 ERROR_PATH_NOT_FOUND HRESULT error is encountered.</para>
    </remarks>
  </class>
  <class name="DriveType" fullname="System.IO.DriveType" assembly="mscorlib">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Defines constants for drive types, including CDRom, Fixed, Network, NoRootDirectory, Ram, Removable, and Unknown.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>
        <see cref="T:System.IO.DriveType" /> is used by the <see cref="T:System.IO.DriveInfo" /> class to indicate drive type. It can be used with the <see cref="T:System.IO.DriveType" /> property.</para>
    </remarks>
  </class>
  <class name="EndOfStreamException" fullname="System.IO.EndOfStreamException" assembly="mscorlib">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>The exception that is thrown when reading is attempted past the end of a stream.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>EndOfStreamException uses the HRESULT COR_E_ENDOFSTREAM which has the value 0x80070026.</para>
    </remarks>
  </class>
  <class name="File" fullname="System.IO.File" assembly="mscorlib">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Provides static methods for the creation, copying, deletion, moving, and opening of files, and aids in the creation of <see cref="T:System.IO.FileStream" /> objects.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Use the <see cref="T:System.IO.File" /> class for typical operations such as copying, moving, renaming, creating, opening, deleting, and appending to files. You can also use the <see cref="T:System.IO.File" /> class to get and set file attributes or <see cref="T:System.DateTime" /> information related to the creation, access, and writing of a file.</para>
      <para>Many of the <see cref="T:System.IO.File" /> methods return other I/O types when you create or open files. You can use these other types to further manipulate a file. For more information, see specific <see cref="T:System.IO.File" /> members such as <see cref="M:System.IO.File.OpenText(System.String)" />, <see cref="M:System.IO.File.CreateText(System.String)" />, or <see cref="M:System.IO.File.Create(System.String)" />.</para>
      <para>Because all <see cref="T:System.IO.File" /> methods are static, it might be more efficient to use a <see cref="T:System.IO.File" /> method rather than a corresponding <see cref="T:System.IO.FileInfo" /> instance method if you want to perform only one action. All <see cref="T:System.IO.File" /> methods require the path to the file that you are manipulating.</para>
      <para>The static methods of the <see cref="T:System.IO.File" /> class perform security checks on all methods. If you are going to reuse an object several times, consider using the corresponding instance method of <see cref="T:System.IO.FileInfo" /> instead, because the security check will not always be necessary.</para>
      <para>By default, full read/write access to new files is granted to all users.</para>
      <para>The following table describes the enumerations that are used to customize the behavior of various <see cref="T:System.IO.File" /> methods.</para>
      <list type="table">
        <listheader>
          <item>
            <term>
              <para>Enumeration </para>
            </term>
            <description>
              <para>Description </para>
            </description>
          </item>
        </listheader>
        <item>
          <term>
            <para>
              <see cref="T:System.IO.FileAccess" />
            </para>
          </term>
          <description>
            <para>Specifies read and write access to a file. </para>
          </description>
        </item>
        <item>
          <term>
            <para>
              <see cref="T:System.IO.FileShare" />
            </para>
          </term>
          <description>
            <para>Specifies the level of access permitted for a file that is already in use. </para>
          </description>
        </item>
        <item>
          <term>
            <para>
              <see cref="T:System.IO.FileMode" />
            </para>
          </term>
          <description>
            <para>Specifies whether the contents of an existing file are preserved or overwritten, and whether requests to create an existing file cause an exception. </para>
          </description>
        </item>
      </list>
      <block subset="none" type="note">
        <para>In members that accept a path as an input string, that path must be well-formed or an exception is raised. For example, if a path is fully qualified but begins with a space, the path is not trimmed in methods of the class. Therefore, the path is malformed and an exception is raised. Similarly, a path or a combination of paths cannot be fully qualified twice. For example, "c:\temp c:\windows" also raises an exception in most cases. Ensure that your paths are well-formed when using methods that accept a path string.</para>
      </block>
      <para>In members that accept a path, the path can refer to a file or just a directory. The specified path can also refer to a relative path or a Universal Naming Convention (UNC) path for a server and share name. For example, all the following are acceptable paths: </para>
      <list type="bullet">
        <item>
          <para>"c:\\MyDir\\MyFile.txt" in C#, or "c:\MyDir\MyFile.txt" in Visual Basic.</para>
        </item>
        <item>
          <para>"c:\\MyDir" in C#, or "c:\MyDir" in Visual Basic.</para>
        </item>
        <item>
          <para>"MyDir\\MySubdir" in C#, or "MyDir\MySubDir" in Visual Basic.</para>
        </item>
        <item>
          <para>"\\\\MyServer\\MyShare" in C#, or "\\MyServer\MyShare" in Visual Basic.</para>
        </item>
      </list>
      <para>For a list of common I/O tasks, see <format type="text/html"><a href="bf00c380-706a-4e38-b829-454a480629fc">Common I/O Tasks</a></format>.</para>
    </remarks>
  </class>
  <class name="FileAccess" fullname="System.IO.FileAccess" assembly="mscorlib">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Defines constants for read, write, or read/write access to a file.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>For an example of creating a file and writing text to a file, see <format type="text/html"><a href="060CBE06-2ADF-4337-9E7B-961A5C840208">[&lt;topic://cpconwritingtexttofile&gt;]</a></format>. For an example of reading text from a file, see <format type="text/html"><a href="ED180BAA-DFC6-4C69-A725-46E87EDAFB27">[&lt;topic://cpconreadingtextfromfile&gt;]</a></format>. For an example of reading from and writing to a binary file, see <format type="text/html"><a href="E209D949-31E8-44EA-8E38-87F9093F3093">[&lt;topic://cpconReadingWritingToNewlyCreatedDataFile&gt;]</a></format>.</para>
      <para>A FileAccess parameter is specified in many of the constructors for <see cref="T:System.IO.File" />, <see cref="T:System.IO.FileInfo" />, <see cref="T:System.IO.FileStream" />, and other constructors where it is important to control the kind of access users have to a file.</para>
    </remarks>
  </class>
  <class name="FileAttributes" fullname="System.IO.FileAttributes" assembly="mscorlib">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Provides attributes for files and directories.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>You can get attributes for files and directories by calling the <see cref="M:System.IO.File.GetAttributes(System.String)" /> method, and you can set them by calling the <see cref="M:System.IO.File.SetAttributes(System.String,System.IO.FileAttributes)" /> method.</para>
      <para>It is not possible to change the compression status of a <see cref="T:System.IO.File" /> object by using the <see cref="M:System.IO.File.SetAttributes(System.String,System.IO.FileAttributes)" /> method. Instead, you must actually compress the file using either a compression tool or one of the classes in the <see cref="N:System.IO.Compression" /> namespace.</para>
    </remarks>
  </class>
  <class name="FileInfo" fullname="System.IO.FileInfo" assembly="mscorlib">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Provides properties and instance methods for the creation, copying, deletion, moving, and opening of files, and aids in the creation of <see cref="T:System.IO.FileStream" /> objects. This class cannot be inherited.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Use the <see cref="T:System.IO.FileInfo" /> class for typical operations such as copying, moving, renaming, creating, opening, deleting, and appending to files.</para>
      <para>If you are performing multiple operations on the same file, it can be more efficient to use <see cref="T:System.IO.FileInfo" /> instance methods instead of the corresponding static methods of the <see cref="T:System.IO.File" /> class, because a security check will not always be necessary.</para>
      <para>Many of the <see cref="T:System.IO.FileInfo" /> methods return other I/O types when you create or open files. You can use these other types to further manipulate a file. For more information, see specific <see cref="T:System.IO.FileInfo" /> members such as <see cref="M:System.IO.FileInfo.Open(System.IO.FileMode)" />, <see cref="M:System.IO.FileInfo.OpenRead" />, <see cref="M:System.IO.FileInfo.OpenText" />, <see cref="M:System.IO.FileInfo.CreateText" />, or <see cref="M:System.IO.FileInfo.Create" />.</para>
      <para>By default, full read/write access to new files is granted to all users.</para>
      <para>The following table describes the enumerations that are used to customize the behavior of various <see cref="T:System.IO.FileInfo" /> methods.</para>
      <list type="table">
        <listheader>
          <item>
            <term>
              <para>Enumeration </para>
            </term>
            <description>
              <para>Description </para>
            </description>
          </item>
        </listheader>
        <item>
          <term>
            <para>
              <see cref="T:System.IO.FileAccess" />
            </para>
          </term>
          <description>
            <para>Specifies read and write access to a file. </para>
          </description>
        </item>
        <item>
          <term>
            <para>
              <see cref="T:System.IO.FileShare" />
            </para>
          </term>
          <description>
            <para>Specifies the level of access permitted for a file that is already in use. </para>
          </description>
        </item>
        <item>
          <term>
            <para>
              <see cref="T:System.IO.FileMode" />
            </para>
          </term>
          <description>
            <para>Specifies whether the contents of an existing file are preserved or overwritten, and whether requests to create an existing file cause an exception. </para>
          </description>
        </item>
      </list>
      <block subset="none" type="note">
        <para>In members that accept a path as an input string, that path must be well-formed or an exception is raised. For example, if a path is fully qualified but begins with a space, the path is not trimmed in methods of the class. Therefore, the path is malformed and an exception is raised. Similarly, a path or a combination of paths cannot be fully qualified twice. For example, "c:\temp c:\windows" also raises an exception in most cases. Ensure that your paths are well-formed when using methods that accept a path string.</para>
      </block>
      <para>In members that accept a path, the path can refer to a file or just a directory. The specified path can also refer to a relative path or a Universal Naming Convention (UNC) path for a server and share name. For example, all the following are acceptable paths: </para>
      <list type="bullet">
        <item>
          <para>"c:\\MyDir\\MyFile.txt" in C#, or "c:\MyDir\MyFile.txt" in Visual Basic.</para>
        </item>
        <item>
          <para>"c:\\MyDir" in C#, or "c:\MyDir" in Visual Basic.</para>
        </item>
        <item>
          <para>"MyDir\\MySubdir" in C#, or "MyDir\MySubDir" in Visual Basic.</para>
        </item>
        <item>
          <para>"\\\\MyServer\\MyShare" in C#, or "\\MyServer\MyShare" in Visual Basic.</para>
        </item>
      </list>
      <para>The <see cref="T:System.IO.FileInfo" /> class provides the following properties that enable you to retrieve information about a file. For an example of how to use each property, see the property pages. </para>
      <list type="bullet">
        <item>
          <para>The <see cref="P:System.IO.FileInfo.Directory" /> property retrieves an object that represents the parent directory of a file.</para>
        </item>
        <item>
          <para>The <see cref="P:System.IO.FileInfo.DirectoryName" /> property retrieves the full path of the parent directory of a file.</para>
        </item>
        <item>
          <para>The <see cref="P:System.IO.FileInfo.Exists" /> property checks for the presence of a file before operating on it.</para>
        </item>
        <item>
          <para>The <see cref="P:System.IO.FileInfo.IsReadOnly" /> property retrieves or sets a value that specifies whether a file can be modified.</para>
        </item>
        <item>
          <para>The <see cref="P:System.IO.FileInfo.Length" /> retrieves the size of a file.</para>
        </item>
        <item>
          <para>The <see cref="P:System.IO.FileInfo.Name" /> retrieves the name of a file.</para>
        </item>
      </list>
    </remarks>
  </class>
  <class name="FileLoadException" fullname="System.IO.FileLoadException" assembly="mscorlib">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>The exception that is thrown when a managed assembly is found but cannot be loaded.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Represents the error that occurs when a <see cref="T:System.Reflection.Assembly" /> file is found but cannot be loaded.</para>
      <para>The <see cref="T:System.IO.FileNotFoundException" /> exception is thrown when the file fails to load because it cannot be located. If the file is located, but cannot be loaded due to insufficient permissions, a <see cref="T:System.Security.SecurityException" /> is thrown.</para>
      <para>FileLoadException has the default HRESULT of COR_E_FILELOAD, which has the value 0x80131621, but this is not the only possible HRESULT.</para>
      <para>If your code does not have <see cref="P:System.Security.Permissions.FileIOPermissionAttribute.PathDiscovery" /> permission, the error message for this exception may only contain file or directory names instead of fully qualified paths.</para>
      <block subset="none" type="note">
        <para>This exception is not included in the <see cref="http://go.microsoft.com/fwlink/?LinkID=247912">.NET for Windows Store apps</see> or the <format type="text/html"><a href="c31e1663-c164-4e65-b66d-d3aa8750a154">Portable Class Library</a></format>, but it is thrown by some members that are. To catch the exception in that case, write a catch statement for <see cref="T:System.IO.IOException" /> instead.</para>
      </block>
    </remarks>
  </class>
  <class name="FileMode" fullname="System.IO.FileMode" assembly="mscorlib">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Specifies how the operating system should open a file.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>For an example of creating a file and writing text to a file, see <format type="text/html"><a href="060CBE06-2ADF-4337-9E7B-961A5C840208">[&lt;topic://cpconwritingtexttofile&gt;]</a></format>. For an example of reading text from a file, see <format type="text/html"><a href="ED180BAA-DFC6-4C69-A725-46E87EDAFB27">[&lt;topic://cpconreadingtextfromfile&gt;]</a></format>. For an example of reading from and writing to a binary file, see <format type="text/html"><a href="E209D949-31E8-44EA-8E38-87F9093F3093">[&lt;topic://cpconReadingWritingToNewlyCreatedDataFile&gt;]</a></format>.</para>
      <para>A FileMode parameter is specified in many of the constructors for <see cref="T:System.IO.FileStream" />, <see cref="T:System.IO.IsolatedStorage.IsolatedStorageFileStream" />, and in the Open methods of <see cref="T:System.IO.File" /> and <see cref="T:System.IO.FileInfo" /> to control how a file is opened.</para>
      <para>FileMode parameters control whether a file is overwritten, created, opened, or some combination thereof. Use Open to open an existing file. To append to a file, use Append. To truncate a file or create a file if it doesn't exist, use Create.</para>
    </remarks>
  </class>
  <class name="FileNotFoundException" fullname="System.IO.FileNotFoundException" assembly="mscorlib">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>The exception that is thrown when an attempt to access a file that does not exist on disk fails.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>FileNotFoundException uses the HRESULT COR_E_FILENOTFOUND which has the value 0x80070002.</para>
      <para>If your code does not have <see cref="P:System.Security.Permissions.FileIOPermissionAttribute.PathDiscovery" /> permission, the error message for this exception may only contain file or directory names instead of fully qualified paths.</para>
    </remarks>
  </class>
  <class name="FileOptions" fullname="System.IO.FileOptions" assembly="mscorlib">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Represents advanced options for creating a <see cref="T:System.IO.FileStream" /> object.</para>
    </summary>
    <remarks>To be added.</remarks>
  </class>
  <class name="FileShare" fullname="System.IO.FileShare" assembly="mscorlib">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Contains constants for controlling the kind of access other <see cref="T:System.IO.FileStream" /> objects can have to the same file.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>For an example of creating a file and writing text to a file, see <format type="text/html"><a href="060CBE06-2ADF-4337-9E7B-961A5C840208">[&lt;topic://cpconwritingtexttofile&gt;]</a></format>. For an example of reading text from a file, see <format type="text/html"><a href="ED180BAA-DFC6-4C69-A725-46E87EDAFB27">[&lt;topic://cpconreadingtextfromfile&gt;]</a></format>. For an example of reading from and writing to a binary file, see <format type="text/html"><a href="E209D949-31E8-44EA-8E38-87F9093F3093">[&lt;topic://cpconReadingWritingToNewlyCreatedDataFile&gt;]</a></format>.</para>
      <para>A typical use of this enumeration is to define whether two processes can simultaneously read from the same file. For example, if a file is opened and <see cref="F:System.IO.FileShare.Read" /> is specified, other users can open the file for reading but not for writing.</para>
      <para>A <see cref="T:System.IO.FileShare" /> parameter is specified in some of the constructors for <see cref="T:System.IO.FileStream" />, <see cref="T:System.IO.IsolatedStorage.IsolatedStorageFileStream" />, and in some of the Open methods of <see cref="T:System.IO.File" /> and <see cref="T:System.IO.FileInfo" /> to control how a file is opened.</para>
    </remarks>
  </class>
  <class name="FileStream" fullname="System.IO.FileStream" assembly="mscorlib">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Exposes a <see cref="T:System.IO.Stream" /> around a file, supporting both synchronous and asynchronous read and write operations.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Use the <see cref="T:System.IO.FileStream" /> class to read from, write to, open, and close files on a file system, and to manipulate other file-related operating system handles, including pipes, standard input, and standard output. You can use the <see cref="M:System.IO.FileStream.Read(System.Byte[],System.Int32,System.Int32)" />, <see cref="M:System.IO.FileStream.Write(System.Byte[],System.Int32,System.Int32)" />, <see cref="M:System.IO.Stream.CopyTo(System.IO.Stream)" />, and <see cref="M:System.IO.FileStream.Flush" /> methods to perform synchronous operations, or the <see cref="M:System.IO.FileStream.ReadAsync(System.Byte[],System.Int32,System.Int32,System.Threading.CancellationToken)" />, <see cref="M:System.IO.FileStream.WriteAsync(System.Byte[],System.Int32,System.Int32,System.Threading.CancellationToken)" />, <see cref="M:System.IO.Stream.CopyToAsync(System.IO.Stream)" />, and <see cref="M:System.IO.FileStream.FlushAsync(System.Threading.CancellationToken)" /> methods to perform asynchronous operations. Use the asynchronous methods to perform resource-intensive file operations without blocking the main thread. This performance consideration is particularly important in a win8_appname_long app or desktop_appname app where a time-consuming stream operation can block the UI thread and make your app appear as if it is not working. <see cref="T:System.IO.FileStream" /> buffers input and output for better performance.</para>
      <para>The <see cref="P:System.IO.FileStream.IsAsync" /> property detects whether the file handle was opened asynchronously. You specify this value when you create an instance of the <see cref="T:System.IO.FileStream" /> class using a constructor that has an <paramref name="isAsync" />, <paramref name="useAsync" />, or <paramref name="options" /> parameter. When the property is true, the stream utilizes overlapped I/O to perform file operations asynchronously. However, the <see cref="P:System.IO.FileStream.IsAsync" /> property does not have to be true to call the <see cref="M:System.IO.FileStream.ReadAsync(System.Byte[],System.Int32,System.Int32,System.Threading.CancellationToken)" />, <see cref="M:System.IO.FileStream.WriteAsync(System.Byte[],System.Int32,System.Int32,System.Threading.CancellationToken)" />, or <see cref="M:System.IO.Stream.CopyToAsync(System.IO.Stream)" /> method. When the <see cref="P:System.IO.FileStream.IsAsync" /> property is false and you call the asynchronous read and write operations, the UI thread is still not blocked, but the actual I/O operation is performed synchronously.</para>
      <para>The <see cref="M:System.IO.FileStream.Seek(System.Int64,System.IO.SeekOrigin)" /> method supports random access to files. <see cref="M:System.IO.FileStream.Seek(System.Int64,System.IO.SeekOrigin)" /> allows the read/write position to be moved to any position within the file. This is done with byte offset reference point parameters. The byte offset is relative to the seek reference point, which can be the beginning, the current position, or the end of the underlying file, as represented by the three members of the <see cref="T:System.IO.SeekOrigin" /> enumeration.</para>
      <block subset="none" type="note">
        <para>Disk files always support random access. At the time of construction, the <see cref="P:System.IO.FileStream.CanSeek" /> property value is set to true or false depending on the underlying file type.If the underlying file type is FILE_TYPE_DISK, as defined in winbase.h, the <see cref="P:System.IO.FileStream.CanSeek" /> property value is true. Otherwise, the <see cref="P:System.IO.FileStream.CanSeek" /> property value is false.</para>
      </block>
      <para>If a process terminates with part of a file locked or closes a file that has outstanding locks, the behavior is undefined.</para>
      <para>For directory operations and other file operations, see the <see cref="T:System.IO.File" />, <see cref="T:System.IO.Directory" />, and <see cref="T:System.IO.Path" /> classes. The <see cref="T:System.IO.File" /> class is a utility class that has static methods primarily for the creation of <see cref="T:System.IO.FileStream" /> objects based on file paths. The <see cref="T:System.IO.MemoryStream" /> class creates a stream from a byte array and is similar to the <see cref="T:System.IO.FileStream" /> class.</para>
      <para>For a list of common file and directory operations, see <format type="text/html"><a href="bf00c380-706a-4e38-b829-454a480629fc">Common I/O Tasks</a></format>.</para>
      <format type="text/html">
        <h2>Detection of Stream Position Changes</h2>
      </format>
      <para>When a <see cref="T:System.IO.FileStream" /> object does not have an exclusive hold on its handle, another thread could access the file handle concurrently and change the position of the operating system's file pointer that is associated with the file handle. In this case, the cached position in the <see cref="T:System.IO.FileStream" /> object and the cached data in the buffer could be compromised. The <see cref="T:System.IO.FileStream" /> object routinely performs checks on methods that access the cached buffer to ensure that the operating system's handle position is the same as the cached position used by the <see cref="T:System.IO.FileStream" /> object.</para>
      <para>If an unexpected change in the handle position is detected in a call to the <see cref="M:System.IO.FileStream.Read(System.Byte[],System.Int32,System.Int32)" /> method, the .NET Framework discards the contents of the buffer and reads the stream from the file again. This can affect performance, depending on the size of the file and any other processes that could affect the position of the file stream.</para>
      <para>If an unexpected change in the handle position is detected in a call to the <see cref="M:System.IO.FileStream.Write(System.Byte[],System.Int32,System.Int32)" /> method, the contents of the buffer are discarded and an <see cref="T:System.IO.IOException" /> exception is thrown.</para>
      <para>A <see cref="T:System.IO.FileStream" /> object will not have an exclusive hold on its handle when either the <see cref="P:System.IO.FileStream.SafeFileHandle" /> property is accessed to expose the handle or the <see cref="T:System.IO.FileStream" /> object is given the <see cref="P:System.IO.FileStream.SafeFileHandle" /> property in its constructor.</para>
    </remarks>
  </class>
  <class name="FileSystemInfo" fullname="System.IO.FileSystemInfo" assembly="mscorlib">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Provides the base class for both <see cref="T:System.IO.FileInfo" /> and <see cref="T:System.IO.DirectoryInfo" /> objects.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>The <see cref="T:System.IO.FileSystemInfo" /> class contains methods that are common to file and directory manipulation. A <see cref="T:System.IO.FileSystemInfo" /> object can represent either a file or a directory, thus serving as the basis for <see cref="T:System.IO.FileInfo" /> or <see cref="T:System.IO.DirectoryInfo" /> objects. Use this base class when parsing a lot of files and directories.</para>
      <para>A derived class can inherit from <see cref="T:System.IO.FileSystemInfo" /> only if the derived class has the AllAccess permission from the <see cref="T:System.Security.Permissions.FileIOPermissionAccess" /> enumeration.</para>
      <para>In members that accept a path, the path can refer to a file or just a directory. The specified path can also refer to a relative path or a Universal Naming Convention (UNC) path for a server and share name. For example, all the following are acceptable paths: </para>
      <list type="bullet">
        <item>
          <para>"c:\\MyDir\\MyFile.txt" in C#, or "c:\MyDir\MyFile.txt" in Visual Basic.</para>
        </item>
        <item>
          <para>"c:\\MyDir" in C#, or "c:\MyDir" in Visual Basic.</para>
        </item>
        <item>
          <para>"MyDir\\MySubdir" in C#, or "MyDir\MySubDir" in Visual Basic.</para>
        </item>
        <item>
          <para>"\\\\MyServer\\MyShare" in C#, or "\\MyServer\MyShare" in Visual Basic.</para>
        </item>
      </list>
      <para>For a list of common I/O tasks, see <format type="text/html"><a href="bf00c380-706a-4e38-b829-454a480629fc">Common I/O Tasks</a></format>.</para>
    </remarks>
  </class>
  <class name="IOException" fullname="System.IO.IOException" assembly="mscorlib">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>The exception that is thrown when an I/O error occurs.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>
        <see cref="T:System.IO.IOException" /> is the base class for exceptions thrown while accessing information using streams, files and directories.</para>
      <para>The Base Class Library includes the following types, each of which is a derived class of IOException : </para>
      <list type="bullet">
        <item>
          <para>
            <see cref="T:System.IO.DirectoryNotFoundException" />
          </para>
        </item>
        <item>
          <para>
            <see cref="T:System.IO.EndOfStreamException" />
          </para>
        </item>
        <item>
          <para>
            <see cref="T:System.IO.FileNotFoundException" />
          </para>
        </item>
        <item>
          <para>
            <see cref="T:System.IO.FileLoadException" />
          </para>
        </item>
        <item>
          <para>
            <see cref="T:System.IO.PathTooLongException" />
          </para>
        </item>
      </list>
      <para>Where appropriate, use these types instead of IOException.</para>
      <para>
        <see cref="T:System.IO.IOException" /> uses the HRESULT COR_E_IO which has the value 0x80131620.</para>
    </remarks>
  </class>
  <class name="MemoryStream" fullname="System.IO.MemoryStream" assembly="mscorlib">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Creates a stream whose backing store is memory.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>The current position of a stream is the position at which the next read or write operation could take place. The current position can be retrieved or set through the <see cref="M:System.IO.MemoryStream.Seek(System.Int64,System.IO.SeekOrigin)" /> method. When a new instance of <see cref="T:System.IO.MemoryStream" /> is created, the current position is set to zero.</para>
      <para>Memory streams created with an unsigned byte array provide a non-resizable stream of the data. When using a byte array, you can neither append to nor shrink the stream, although you might be able to modify the existing contents depending on the parameters passed into the constructor. Empty memory streams are resizable, and can be written to and read from.</para>
      <para>If a <see cref="T:System.IO.MemoryStream" /> object is added to a ResX file or a .resources file, call the <see cref="M:System.Resources.ResourceManager.GetStream(System.String)" /> method at runtime to retrieve it.</para>
      <para>If a <see cref="T:System.IO.MemoryStream" /> object is serialized to a resource file it will actually be serialized as an <see cref="T:System.IO.UnmanagedMemoryStream" />. This behavior provides better performance, as well as the ability to get a pointer to the data directly, without having to go through <see cref="T:System.IO.Stream" /> methods.</para>
    </remarks>
  </class>
  <class name="Path" fullname="System.IO.Path" assembly="mscorlib">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Performs operations on <see cref="T:System.String" /> instances that contain file or directory path information. These operations are performed in a cross-platform manner.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>The .NET Framework does not support direct access to physical disks through paths that are device names, such as "\\.\PHYSICALDRIVE0 ".</para>
      <para>A path is a string that provides the location of a file or directory. A path does not necessarily point to a location on disk; for example, a path might map to a location in memory or on a device. The exact format of a path is determined by the current platform. For example, on some systems, a path can start with a drive or volume letter, while this element is not present in other systems. On some systems, file paths can contain extensions, which indicate the type of information stored in the file. The format of a file name extension is platform-dependent; for example, some systems limit extensions to three characters, and others do not. The current platform also determines the set of characters used to separate the elements of a path, and the set of characters that cannot be used when specifying paths. Because of these differences, the fields of the Path class as well as the exact behavior of some members of the Path class are platform-dependent.</para>
      <para>A path can contain absolute or relative location information. Absolute paths fully specify a location: the file or directory can be uniquely identified regardless of the current location. Relative paths specify a partial location: the current location is used as the starting point when locating a file specified with a relative path. To determine the current directory, call <see cref="M:System.IO.Directory.GetCurrentDirectory" />.</para>
      <para>Most members of the Path class do not interact with the file system and do not verify the existence of the file specified by a path string. Path class members that modify a path string, such as <see cref="M:System.IO.Path.ChangeExtension(System.String,System.String)" />, have no effect on names of files in the file system. Path members do, however, validate the contents of a specified path string, and throw an <see cref="T:System.ArgumentException" /> exception if the string contains characters that are not valid in path strings, as defined in the characters returned from the <see cref="M:System.IO.Path.GetInvalidPathChars" /> method. For example, on Windows-based desktop platforms, invalid path characters might include quote ("), less than (&lt;), greater than (&gt;), pipe (|), backspace (\b), null (\0), and Unicode characters 16 through 18 and 20 through 25.</para>
      <para>The members of the Path class enable you to quickly and easily perform common operations such as determining whether a file name extension is part of a path, and combining two strings into one path name.</para>
      <para>All members of the Path class are static and can therefore be called without having an instance of a path.</para>
      <block subset="none" type="note">
        <para>In members that accept a path as an input string, that path must be well-formed or an exception is raised. For example, if a path is fully qualified but begins with a space, the path is not trimmed in methods of the class. Therefore, the path is malformed and an exception is raised. Similarly, a path or a combination of paths cannot be fully qualified twice. For example, "c:\temp c:\windows" also raises an exception in most cases. Ensure that your paths are well-formed when using methods that accept a path string.</para>
      </block>
      <para>In members that accept a path, the path can refer to a file or just a directory. The specified path can also refer to a relative path or a Universal Naming Convention (UNC) path for a server and share name. For example, all the following are acceptable paths: </para>
      <list type="bullet">
        <item>
          <para>"c:\\MyDir\\MyFile.txt" in C#, or "c:\MyDir\MyFile.txt" in Visual Basic.</para>
        </item>
        <item>
          <para>"c:\\MyDir" in C#, or "c:\MyDir" in Visual Basic.</para>
        </item>
        <item>
          <para>"MyDir\\MySubdir" in C#, or "MyDir\MySubDir" in Visual Basic.</para>
        </item>
        <item>
          <para>"\\\\MyServer\\MyShare" in C#, or "\\MyServer\MyShare" in Visual Basic.</para>
        </item>
      </list>
      <para>Because all these operations are performed on strings, it is impossible to verify that the results are valid in all scenarios. For example, the <see cref="M:System.IO.Path.GetExtension(System.String)" /> method parses a string that you pass to it and returns the extension from that string. However, this does not mean that a file with that extension exists on the disk.</para>
      <para>For a list of common I/O tasks, see <format type="text/html"><a href="bf00c380-706a-4e38-b829-454a480629fc">Common I/O Tasks</a></format>.</para>
    </remarks>
  </class>
  <class name="PathTooLongException" fullname="System.IO.PathTooLongException" assembly="mscorlib">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>The exception that is thrown when a path or file name is longer than the system-defined maximum length.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>PathTooLongException uses the HRESULT COR_E_PATHTOOLONG, which has the value 0x800700CE.</para>
      <para>If your code does not have <see cref="P:System.Security.Permissions.FileIOPermissionAttribute.PathDiscovery" /> permission, the error message for this exception may contain only file or directory names instead of full paths.</para>
      <para>Full paths must not exceed 260 characters to maintain compatibility with Windows operating systems. For more information about this restriction, see the entry <see cref="http://go.microsoft.com/fwlink/?LinkID=163666">Long Paths in .NET</see> in the BCL Team blog.</para>
      <block subset="none" type="note">
        <para>This exception is not included in the <see cref="http://go.microsoft.com/fwlink/?LinkID=247912">.NET for Windows Store apps</see> or the <format type="text/html"><a href="c31e1663-c164-4e65-b66d-d3aa8750a154">Portable Class Library</a></format>, but it is thrown by some members that are. To catch the exception in that case, write a catch statement for <see cref="T:System.IO.IOException" /> instead.</para>
      </block>
    </remarks>
  </class>
  <class name="SearchOption" fullname="System.IO.SearchOption" assembly="mscorlib">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Specifies whether to search the current directory, or the current directory and all subdirectories. </para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>If you choose <see cref="F:System.IO.SearchOption.AllDirectories" /> in your search and the directory structure contains a link that creates a loop, the search operation enters an infinite loop.</para>
    </remarks>
  </class>
  <class name="SeekOrigin" fullname="System.IO.SeekOrigin" assembly="mscorlib">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Specifies the position in a stream to use for seeking.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>
        <see cref="T:System.IO.SeekOrigin" /> is used by the Seek methods of <see cref="T:System.IO.Stream" />, <see cref="T:System.IO.BufferedStream" />, <see cref="T:System.IO.FileStream" />, <see cref="T:System.IO.MemoryStream" />, <see cref="T:System.IO.BinaryWriter" />, and other classes. The Seek methods take an offset parameter that is relative to the position specified by <see cref="T:System.IO.SeekOrigin" />.</para>
    </remarks>
  </class>
  <class name="Stream" fullname="System.IO.Stream" assembly="mscorlib">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Provides a generic view of a sequence of bytes. This is an abstract class.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>
        <see cref="T:System.IO.Stream" /> is the abstract base class of all streams. A stream is an abstraction of a sequence of bytes, such as a file, an input/output device, an inter-process communication pipe, or a TCP/IP socket. The <see cref="T:System.IO.Stream" /> class and its derived classes provide a generic view of these different types of input and output, and isolate the programmer from the specific details of the operating system and the underlying devices.</para>
      <para>Streams involve three fundamental operations: </para>
      <list type="bullet">
        <item>
          <para>You can read from streams. Reading is the transfer of data from a stream into a data structure, such as an array of bytes.</para>
        </item>
        <item>
          <para>You can write to streams. Writing is the transfer of data from a data structure into a stream.</para>
        </item>
        <item>
          <para>Streams can support seeking. Seeking refers to querying and modifying the current position within a stream. Seek capability depends on the kind of backing store a stream has. For example, network streams have no unified concept of a current position, and therefore typically do not support seeking.</para>
        </item>
      </list>
      <para>Some of the more commonly used streams that inherit from <see cref="T:System.IO.Stream" /> are <see cref="T:System.IO.FileStream" />, and <see cref="T:System.IO.MemoryStream" />.</para>
      <para>Depending on the underlying data source or repository, streams might support only some of these capabilities. You can query a stream for its capabilities by using the <see cref="P:System.IO.Stream.CanRead" />, <see cref="P:System.IO.Stream.CanWrite" />, and <see cref="P:System.IO.Stream.CanSeek" /> properties of the <see cref="T:System.IO.Stream" /> class.</para>
      <para>The <see cref="M:System.IO.Stream.Read(System.Byte[],System.Int32,System.Int32)" /> and <see cref="M:System.IO.Stream.Write(System.Byte[],System.Int32,System.Int32)" /> methods read and write data in a variety of formats. For streams that support seeking, use the <see cref="M:System.IO.Stream.Seek(System.Int64,System.IO.SeekOrigin)" /> and <see cref="M:System.IO.Stream.SetLength(System.Int64)" /> methods and the <see cref="P:System.IO.Stream.Position" /> and <see cref="P:System.IO.Stream.Length" /> properties to query and modify the current position and length of a stream.</para>
      <para>Starting with the net_v45, the <see cref="T:System.IO.Stream" /> class includes async methods to simplify asynchronous operations. An async method contains Async in its name, such as <see cref="M:System.IO.Stream.ReadAsync(System.Byte[],System.Int32,System.Int32)" />, <see cref="M:System.IO.Stream.WriteAsync(System.Byte[],System.Int32,System.Int32)" />, <see cref="M:System.IO.Stream.CopyToAsync(System.IO.Stream)" />, and <see cref="M:System.IO.Stream.FlushAsync(System.Threading.CancellationToken)" />. These methods enable you to perform resource-intensive I/O operations without blocking the main thread. This performance consideration is particularly important in a win8_appname_long app or desktop_appname app where a time-consuming stream operation can block the UI thread and make your app appear as if it is not working. The async methods are used in conjunction with the async and await keywords in Visual Basic and C#.</para>
      <para>When used in a win8_appname_long app, <see cref="T:System.IO.Stream" /> includes two extension methods: <see cref="M:System.IO.WindowsRuntimeStreamExtensions.AsInputStream(System.IO.Stream)" /> and <see cref="M:System.IO.WindowsRuntimeStreamExtensions.AsOutputStream(System.IO.Stream)" />. These methods convert a <see cref="T:System.IO.Stream" /> object to a stream in the wrt. You can also convert a stream in the wrt to a <see cref="T:System.IO.Stream" /> object by using the <see cref="M:System.IO.WindowsRuntimeStreamExtensions.AsStreamForRead(Windows.Storage.Streams.IInputStream)" /> and <see cref="M:System.IO.WindowsRuntimeStreamExtensions.AsStreamForWrite(Windows.Storage.Streams.IOutputStream)" /> methods. For more information, see <format type="text/html"><a href="23a763ea-8348-4244-9f8c-a4280b870b47">How to: Convert Between .NET Framework Streams and Windows Runtime Streams</a></format></para>
      <para>Some stream implementations perform local buffering of the underlying data to improve performance. For such streams, you can use the <see cref="M:System.IO.Stream.Flush" /> or <see cref="M:System.IO.Stream.FlushAsync" /> method to clear any internal buffers and ensure that all data has been written to the underlying data source or repository.</para>
      <para>Disposing a <see cref="T:System.IO.Stream" /> object flushes any buffered data, and essentially calls the <see cref="M:System.IO.Stream.Flush" /> method for you. <see cref="M:System.IO.Stream.Dispose" /> also releases operating system resources such as file handles, network connections, or memory used for any internal buffering. The <see cref="T:System.IO.BufferedStream" /> class provides the capability of wrapping a buffered stream around another stream in order to improve read and write performance.</para>
      <para>If you need a stream with no backing store (also known as a bit bucket), use the <see cref="F:System.IO.Stream.Null" /> field to retrieve an instance of a stream that is designed for this purpose.</para>
    </remarks>
  </class>
  <class name="StreamReader" fullname="System.IO.StreamReader" assembly="mscorlib">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Implements a <see cref="T:System.IO.TextReader" /> that reads characters from a byte stream in a particular encoding.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>
        <see cref="T:System.IO.StreamReader" /> is designed for character input in a particular encoding, whereas the <see cref="T:System.IO.Stream" /> class is designed for byte input and output. Use <see cref="T:System.IO.StreamReader" /> for reading lines of information from a standard text file.</para>
      <para>
        <see cref="T:System.IO.StreamReader" /> defaults to UTF-8 encoding unless specified otherwise, instead of defaulting to the ANSI code page for the current system. UTF-8 handles Unicode characters correctly and provides consistent results on localized versions of the operating system. If you get the current character encoding using the <see cref="P:System.IO.StreamReader.CurrentEncoding" /> property, the value is not reliable until after the first <see cref="M:System.IO.StreamReader.Read" /> method, since encoding auto detection is not done until the first call to a <see cref="M:System.IO.StreamReader.Read" /> method.</para>
      <para>By default, a <see cref="T:System.IO.StreamReader" /> is not thread safe. See <see cref="M:System.IO.TextReader.Synchronized(System.IO.TextReader)" /> for a thread-safe wrapper.</para>
      <para>The <see cref="M:System.IO.StreamReader.Read(System.Char[],System.Int32,System.Int32)" />  and <see cref="M:System.IO.StreamWriter.Write(System.Char[],System.Int32,System.Int32)" />  method overloads read and write the number of characters specified by the <paramref name="count" /> parameter. These are to be distinguished from <see cref="M:System.IO.BufferedStream.Read(System.Byte[],System.Int32,System.Int32)" /> and <see cref="M:System.IO.BufferedStream.Write(System.Byte[],System.Int32,System.Int32)" />, which read and write the number of bytes specified by the <paramref name="count" /> parameter. Use the <see cref="T:System.IO.BufferedStream" /> methods only for reading and writing an integral number of byte array elements.</para>
      <block subset="none" type="note">
        <para>When reading from a <see cref="T:System.IO.Stream" />, it is more efficient to use a buffer that is the same size as the internal buffer of the stream.</para>
      </block>
      <para>For a list of common I/O tasks, see <format type="text/html"><a href="bf00c380-706a-4e38-b829-454a480629fc">Common I/O Tasks</a></format>.</para>
    </remarks>
  </class>
  <class name="StreamWriter" fullname="System.IO.StreamWriter" assembly="mscorlib">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Implements a <see cref="T:System.IO.TextWriter" /> for writing characters to a stream in a particular encoding.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>
        <see cref="T:System.IO.StreamWriter" /> is designed for character output in a particular encoding, whereas classes derived from <see cref="T:System.IO.Stream" /> are designed for byte input and output.</para>
      <para>
        <see cref="T:System.IO.StreamWriter" /> defaults to using an instance of <see cref="T:System.Text.UTF8Encoding" /> unless specified otherwise. This instance of UTF8Encoding is constructed without a byte order mark (BOM), so its <see cref="M:System.Text.Encoding.GetPreamble" /> method returns an empty byte array. The default UTF-8 encoding for this constructor throws an exception on invalid bytes. This behavior is different from the behavior provided by the encoding object in the <see cref="P:System.Text.Encoding.UTF8" /> property. To specify a BOM and determine whether an exception is thrown on invalid bytes, use a constructor that accepts an encoding object as a parameter, such as <see cref="M:System.IO.StreamWriter.#ctor(System.String,System.Boolean,System.Text.Encoding)" /> or <see cref="M:System.IO.StreamWriter.#ctor(System.IO.Stream,System.Text.Encoding)" />.</para>
      <para>By default, a <see cref="T:System.IO.StreamWriter" /> is not thread safe. See <see cref="M:System.IO.TextWriter.Synchronized(System.IO.TextWriter)" /> for a thread-safe wrapper.</para>
      <para>For a list of common I/O tasks, see <format type="text/html"><a href="bf00c380-706a-4e38-b829-454a480629fc">Common I/O Tasks</a></format>.</para>
    </remarks>
  </class>
  <class name="StringReader" fullname="System.IO.StringReader" assembly="mscorlib">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Implements a <see cref="T:System.IO.TextReader" /> that reads from a string.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>The following table lists examples of other typical or related I/O tasks.</para>
      <list type="table">
        <listheader>
          <item>
            <term>
              <para>To do this... </para>
            </term>
            <description>
              <para>See the example in this topic... </para>
            </description>
          </item>
        </listheader>
        <item>
          <term>
            <para>Create a text file. </para>
          </term>
          <description>
            <para>
              <format type="text/html">
                <a href="060CBE06-2ADF-4337-9E7B-961A5C840208">[&lt;topic://cpconwritingtexttofile&gt;]</a>
              </format>
            </para>
          </description>
        </item>
        <item>
          <term>
            <para>Write to a text file. </para>
          </term>
          <description>
            <para>
              <format type="text/html">
                <a href="060CBE06-2ADF-4337-9E7B-961A5C840208">[&lt;topic://cpconwritingtexttofile&gt;]</a>
              </format>
            </para>
          </description>
        </item>
        <item>
          <term>
            <para>Read from a text file. </para>
          </term>
          <description>
            <para>
              <format type="text/html">
                <a href="ED180BAA-DFC6-4C69-A725-46E87EDAFB27">[&lt;topic://cpconreadingtextfromfile&gt;]</a>
              </format>
            </para>
          </description>
        </item>
        <item>
          <term>
            <para>Append text to a file. </para>
          </term>
          <description>
            <para>
              <format type="text/html">
                <a href="74423362-1721-49CB-AA0A-E04005F72A06">[&lt;topic://cpconopeningappendingtologfile&gt;]</a>
              </format>
            </para>
            <para>
              <see cref="M:System.IO.File.AppendText(System.String)" />
            </para>
            <para>
              <see cref="M:System.IO.FileInfo.AppendText" />
            </para>
          </description>
        </item>
        <item>
          <term>
            <para>Get the size of a file. </para>
          </term>
          <description>
            <para>
              <see cref="P:System.IO.FileInfo.Length" />
            </para>
          </description>
        </item>
        <item>
          <term>
            <para>Get the attributes of a file. </para>
          </term>
          <description>
            <para>
              <see cref="M:System.IO.File.GetAttributes(System.String)" />
            </para>
          </description>
        </item>
        <item>
          <term>
            <para>Set the attributes of a file. </para>
          </term>
          <description>
            <para>
              <see cref="M:System.IO.File.SetAttributes(System.String,System.IO.FileAttributes)" />
            </para>
          </description>
        </item>
        <item>
          <term>
            <para>Determine if a file exists. </para>
          </term>
          <description>
            <para>
              <see cref="M:System.IO.File.Exists(System.String)" />
            </para>
          </description>
        </item>
        <item>
          <term>
            <para>Read from a binary file. </para>
          </term>
          <description>
            <para>
              <format type="text/html">
                <a href="E209D949-31E8-44EA-8E38-87F9093F3093">[&lt;topic://cpconReadingWritingToNewlyCreatedDataFile&gt;]</a>
              </format>
            </para>
          </description>
        </item>
        <item>
          <term>
            <para>Write to a binary file. </para>
          </term>
          <description>
            <para>
              <format type="text/html">
                <a href="E209D949-31E8-44EA-8E38-87F9093F3093">[&lt;topic://cpconReadingWritingToNewlyCreatedDataFile&gt;]</a>
              </format>
            </para>
          </description>
        </item>
      </list>
    </remarks>
  </class>
  <class name="StringWriter" fullname="System.IO.StringWriter" assembly="mscorlib">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Implements a <see cref="T:System.IO.TextWriter" /> for writing information to a string. The information is stored in an underlying <see cref="T:System.Text.StringBuilder" />.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>The following table lists examples of other typical or related I/O tasks.</para>
      <list type="table">
        <listheader>
          <item>
            <term>
              <para>To do this... </para>
            </term>
            <description>
              <para>See the example in this topic... </para>
            </description>
          </item>
        </listheader>
        <item>
          <term>
            <para>Create a text file. </para>
          </term>
          <description>
            <para>
              <format type="text/html">
                <a href="060CBE06-2ADF-4337-9E7B-961A5C840208">[&lt;topic://cpconwritingtexttofile&gt;]</a>
              </format>
            </para>
          </description>
        </item>
        <item>
          <term>
            <para>Write to a text file. </para>
          </term>
          <description>
            <para>
              <format type="text/html">
                <a href="060CBE06-2ADF-4337-9E7B-961A5C840208">[&lt;topic://cpconwritingtexttofile&gt;]</a>
              </format>
            </para>
          </description>
        </item>
        <item>
          <term>
            <para>Read from a text file. </para>
          </term>
          <description>
            <para>
              <format type="text/html">
                <a href="ED180BAA-DFC6-4C69-A725-46E87EDAFB27">[&lt;topic://cpconreadingtextfromfile&gt;]</a>
              </format>
            </para>
          </description>
        </item>
        <item>
          <term>
            <para>Append text to a file. </para>
          </term>
          <description>
            <para>
              <format type="text/html">
                <a href="74423362-1721-49CB-AA0A-E04005F72A06">[&lt;topic://cpconopeningappendingtologfile&gt;]</a>
              </format>
            </para>
            <para>
              <see cref="M:System.IO.File.AppendText(System.String)" />
            </para>
            <para>
              <see cref="M:System.IO.FileInfo.AppendText" />
            </para>
          </description>
        </item>
        <item>
          <term>
            <para>Get the size of a file. </para>
          </term>
          <description>
            <para>
              <see cref="P:System.IO.FileInfo.Length" />
            </para>
          </description>
        </item>
        <item>
          <term>
            <para>Get the attributes of a file. </para>
          </term>
          <description>
            <para>
              <see cref="M:System.IO.File.GetAttributes(System.String)" />
            </para>
          </description>
        </item>
        <item>
          <term>
            <para>Set the attributes of a file. </para>
          </term>
          <description>
            <para>
              <see cref="M:System.IO.File.SetAttributes(System.String,System.IO.FileAttributes)" />
            </para>
          </description>
        </item>
        <item>
          <term>
            <para>Determine if a file exists. </para>
          </term>
          <description>
            <para>
              <see cref="M:System.IO.File.Exists(System.String)" />
            </para>
          </description>
        </item>
        <item>
          <term>
            <para>Read from a binary file. </para>
          </term>
          <description>
            <para>
              <format type="text/html">
                <a href="E209D949-31E8-44EA-8E38-87F9093F3093">[&lt;topic://cpconReadingWritingToNewlyCreatedDataFile&gt;]</a>
              </format>
            </para>
          </description>
        </item>
        <item>
          <term>
            <para>Write to a binary file. </para>
          </term>
          <description>
            <para>
              <format type="text/html">
                <a href="E209D949-31E8-44EA-8E38-87F9093F3093">[&lt;topic://cpconReadingWritingToNewlyCreatedDataFile&gt;]</a>
              </format>
            </para>
          </description>
        </item>
      </list>
    </remarks>
  </class>
  <class name="TextReader" fullname="System.IO.TextReader" assembly="mscorlib">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Represents a reader that can read a sequential series of characters.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>
        <see cref="T:System.IO.TextReader" /> is the abstract base class of <see cref="T:System.IO.StreamReader" /> and <see cref="T:System.IO.StringReader" />, which read characters from streams and strings, respectively. Use these derived classes to open a text file for reading a specified range of characters, or to create a reader based on an existing stream. </para>
    </remarks>
  </class>
  <class name="TextWriter" fullname="System.IO.TextWriter" assembly="mscorlib">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Represents a writer that can write a sequential series of characters. This class is abstract.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>
        <see cref="T:System.IO.TextWriter" /> is the abstract base class of <see cref="T:System.IO.StreamWriter" /> and <see cref="T:System.IO.StringWriter" />, which write characters to streams and strings, respectively. Create an instance of <see cref="T:System.IO.TextWriter" /> to write an object to a string, write strings to a file, or to serialize XML. You can also use an instance of <see cref="T:System.IO.TextWriter" /> to write text to a custom backing store using the same APIs you would use for a string or a stream, or to add support for text formatting.</para>
      <para>All the Write methods of <see cref="T:System.IO.TextWriter" /> having primitive data types as parameters write out the values as strings.</para>
      <para>By default, a <see cref="T:System.IO.TextWriter" /> is not thread safe. See <see cref="M:System.IO.TextWriter.Synchronized(System.IO.TextWriter)" /> for a thread-safe wrapper.</para>
      <para>For a list of common I/O tasks, see <format type="text/html"><a href="bf00c380-706a-4e38-b829-454a480629fc">Common I/O Tasks</a></format>.</para>
    </remarks>
  </class>
  <class name="UnmanagedMemoryAccessor" fullname="System.IO.UnmanagedMemoryAccessor" assembly="mscorlib">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Provides random access to unmanaged blocks of memory from managed code.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>The <see cref="M:System.IO.MemoryMappedFiles.MemoryMappedFile.CreateViewAccessor" /> method of a <see cref="T:System.IO.MemoryMappedFiles.MemoryMappedFile" /> object returns the unmanaged blocks of memory for working with views of memory-mapped files.</para>
    </remarks>
  </class>
  <class name="UnmanagedMemoryStream" fullname="System.IO.UnmanagedMemoryStream" assembly="mscorlib">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Provides access to unmanaged blocks of memory from managed code.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>This class supports access to unmanaged memory using the existing stream-based model and does not require that the contents in the unmanaged memory be copied to the heap.</para>
    </remarks>
  </class>
  <class name="HandleInheritability" fullname="System.IO.HandleInheritability" assembly="System.Core">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Specifies whether the underlying handle is inheritable by child processes.</para>
    </summary>
    <remarks>To be added.</remarks>
  </class>
  <class name="PipeException" fullname="System.IO.PipeException" assembly="System.ServiceModel">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Thrown when an error occurs within a named pipe.</para>
    </summary>
    <remarks>To be added.</remarks>
  </class>
  <class name="ErrorEventArgs" fullname="System.IO.ErrorEventArgs" assembly="System">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Provides data for the <see cref="E:System.IO.FileSystemWatcher.Error" /> event.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>
        <see cref="T:System.IO.ErrorEventArgs" /> contains the <see cref="T:System.Exception" /> that caused the <see cref="E:System.IO.FileSystemWatcher.Error" /> event. This class provides the <see cref="M:System.IO.ErrorEventArgs.GetException" /> method to retrieve the exception.</para>
    </remarks>
  </class>
  <class name="ErrorEventHandler" fullname="System.IO.ErrorEventHandler" assembly="System">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Represents the method that will handle the <see cref="E:System.IO.FileSystemWatcher.Error" /> event of a <see cref="T:System.IO.FileSystemWatcher" /> object.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>When you create an <see cref="T:System.IO.ErrorEventHandler" /> delegate, you identify the method that will handle the event. To associate the event with your event-handling method, add an instance of the delegate to the event. The event-handling method is called whenever the event occurs, unless you remove the delegate. For more information about event-handler delegates, see <format type="text/html"><a href="D98FD58B-FA4F-4598-8378-ADDF4355A115">[&lt;topic://cpconEventsDelegates&gt;]</a></format>.</para>
    </remarks>
  </class>
  <class name="FileSystemEventArgs" fullname="System.IO.FileSystemEventArgs" assembly="System">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Provides data for the directory events: <see cref="E:System.IO.FileSystemWatcher.Changed" />, <see cref="E:System.IO.FileSystemWatcher.Created" />, <see cref="E:System.IO.FileSystemWatcher.Deleted" />.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>The <see cref="T:System.IO.FileSystemEventArgs" /> class is passed as a parameter to event handlers for these events: </para>
      <para>The <see cref="E:System.IO.FileSystemWatcher.Changed" /> event occurs when changes are made to the size, system attributes, last write time, last access time, or security permissions in a file or directory in the specified <see cref="P:System.IO.FileSystemWatcher.Path" /> of a <see cref="T:System.IO.FileSystemWatcher" />.</para>
      <para>The <see cref="E:System.IO.FileSystemWatcher.Created" /> event occurs when a file or directory in the specified <see cref="P:System.IO.FileSystemWatcher.Path" /> of a <see cref="T:System.IO.FileSystemWatcher" /> is created.</para>
      <para>The <see cref="E:System.IO.FileSystemWatcher.Deleted" /> event occurs when a file or directory in the specified <see cref="P:System.IO.FileSystemWatcher.Path" /> of a <see cref="T:System.IO.FileSystemWatcher" /> is deleted. For more information, see <see cref="T:System.IO.FileSystemWatcher" />.</para>
    </remarks>
  </class>
  <class name="FileSystemEventHandler" fullname="System.IO.FileSystemEventHandler" assembly="System">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Represents the method that will handle the <see cref="E:System.IO.FileSystemWatcher.Changed" />, <see cref="E:System.IO.FileSystemWatcher.Created" />, or <see cref="E:System.IO.FileSystemWatcher.Deleted" /> event of a <see cref="T:System.IO.FileSystemWatcher" /> class.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>When you create a <see cref="T:System.IO.FileSystemEventHandler" /> delegate, you identify the method that will handle the event. To associate the event with your event handler, add an instance of the delegate to the event. The event handler is called whenever the event occurs, unless you remove the delegate. For more information about event handler delegates, see <format type="text/html"><a href="D98FD58B-FA4F-4598-8378-ADDF4355A115">[&lt;topic://cpconEventsDelegates&gt;]</a></format>.</para>
    </remarks>
  </class>
  <class name="FileSystemWatcher" fullname="System.IO.FileSystemWatcher" assembly="System">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Listens to the file system change notifications and raises events when a directory, or file in a directory, changes.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Use <see cref="T:System.IO.FileSystemWatcher" /> to watch for changes in a specified directory. You can watch for changes in files and subdirectories of the specified directory. You can create a component to watch files on a local computer, a network drive, or a remote computer.</para>
      <para>To watch for changes in all files, set the <see cref="P:System.IO.FileSystemWatcher.Filter" /> property to an empty string ("") or use wildcards ("*.*"). To watch a specific file, set the <see cref="P:System.IO.FileSystemWatcher.Filter" /> property to the file name. For example, to watch for changes in the file MyDoc.txt, set the <see cref="P:System.IO.FileSystemWatcher.Filter" /> property to "MyDoc.txt". You can also watch for changes in a certain type of file. For example, to watch for changes in text files, set the <see cref="P:System.IO.FileSystemWatcher.Filter" /> property to "*.txt".</para>
      <para>There are several types of changes you can watch for in a directory or file. For example, you can watch for changes in Attributes, the LastWrite date and time, or the Size of files or directories. This is done by setting the <see cref="P:System.IO.FileSystemWatcher.NotifyFilter" /> property to one of the <see cref="T:System.IO.NotifyFilters" /> values. For more information on the type of changes you can watch, see <see cref="T:System.IO.NotifyFilters" />.</para>
      <para>You can watch for renaming, deletion, or creation of files or directories. For example, to watch for renaming of text files, set the <see cref="P:System.IO.FileSystemWatcher.Filter" /> property to "*.txt" and call the <see cref="M:System.IO.FileSystemWatcher.WaitForChanged(System.IO.WatcherChangeTypes)" /> method with a <see cref="F:System.IO.WatcherChangeTypes.Renamed" /> specified for its parameter.</para>
      <para>The Windows operating system notifies your component of file changes in a buffer created by the <see cref="T:System.IO.FileSystemWatcher" />. If there are many changes in a short time, the buffer can overflow. This causes the component to lose track of changes in the directory, and it will only provide blanket notification. Increasing the size of the buffer with the <see cref="P:System.IO.FileSystemWatcher.InternalBufferSize" />  property is expensive, as it comes from non-paged memory that cannot be swapped out to disk, so keep the buffer as small yet large enough to not miss any file change events. To avoid a buffer overflow, use the <see cref="P:System.IO.FileSystemWatcher.NotifyFilter" /> and <see cref="P:System.IO.FileSystemWatcher.IncludeSubdirectories" /> properties so you can filter out unwanted change notifications. </para>
      <para>For a list of initial property values for an instance of <see cref="T:System.IO.FileSystemWatcher" />, see the <see cref="M:System.IO.FileSystemWatcher.#ctor" /> constructor.</para>
      <para>Please note the following when using the <see cref="T:System.IO.FileSystemWatcher" /> class.</para>
      <list type="bullet">
        <item>
          <para>Hidden files are not ignored.</para>
        </item>
        <item>
          <para>In some systems, <see cref="T:System.IO.FileSystemWatcher" /> reports changes to files using the short 8.3 file name format. For example, a change to  "LongFileName.LongExtension" could be reported as "LongFil~.Lon".</para>
        </item>
        <item>
          <para>This class contains a link demand and an inheritance demand at the class level that applies to all members. A <see cref="T:System.Security.SecurityException" /> is thrown when either the immediate caller or the derived class does not have full-trust permission. For details about security demands, see <format type="text/html"><a href="a33fd5f9-2de9-4653-a4f0-d9df25082c4d">Link Demands</a></format>.</para>
        </item>
        <item>
          <para>The maximum size you can set for the <see cref="P:System.IO.FileSystemWatcher.InternalBufferSize" /> property for monitoring a directory over the network is 64 KB.</para>
        </item>
      </list>
      <block subset="none" type="note">
        <para> Running <see cref="T:System.IO.FileSystemWatcher" /> on Windows 98 is not supported.</para>
      </block>
      <format type="text/html">
        <h2>Copying and moving folders</h2>
      </format>
      <para>The operating system and <see cref="T:System.IO.FileSystemWatcher" /> object interpret a cut-and-paste action or a move action as a rename action for a folder and its contents. If you cut and paste a folder with files into a folder being watched, the <see cref="T:System.IO.FileSystemWatcher" /> object reports only the folder as new, but not its contents because they are essentially only renamed. </para>
      <para>To be notified that the contents of folders have been moved or copied into a watched folder, provide <see cref="M:System.IO.FileSystemWatcher.OnChanged(System.IO.FileSystemEventArgs)" />  and <see cref="M:System.IO.FileSystemWatcher.OnRenamed(System.IO.RenamedEventArgs)" /> event handler methods as suggested in the following table.</para>
      <list type="table">
        <listheader>
          <item>
            <term>
              <para>Event Handler</para>
            </term>
            <description>
              <para>Events Handled</para>
            </description>
            <description>
              <para>Performs</para>
            </description>
          </item>
        </listheader>
        <item>
          <term>
            <para>
              <see cref="M:System.IO.FileSystemWatcher.OnChanged(System.IO.FileSystemEventArgs)" />
            </para>
          </term>
          <description>
            <para>
              <see cref="E:System.IO.FileSystemWatcher.Changed" />, <see cref="E:System.IO.FileSystemWatcher.Created" />, <see cref="E:System.IO.FileSystemWatcher.Deleted" /></para>
          </description>
          <description>
            <para>Report changes in file attributes, created files, and deleted files.</para>
          </description>
        </item>
        <item>
          <term>
            <para>
              <see cref="M:System.IO.FileSystemWatcher.OnRenamed(System.IO.RenamedEventArgs)" />
            </para>
          </term>
          <description>
            <para>
              <see cref="E:System.IO.FileSystemWatcher.Renamed" />
            </para>
          </description>
          <description>
            <para>List the old and new paths of renamed files and folders, expanding recursively if needed.</para>
          </description>
        </item>
      </list>
      <format type="text/html">
        <h2>Events and Buffer Sizes</h2>
      </format>
      <para>Note that several factors can affect which file system change events are raised, as described by the following:</para>
      <list type="bullet">
        <item>
          <para>Common file system operations might raise more than one event. For example, when a file is moved from one directory to another, several <see cref="M:System.IO.FileSystemWatcher.OnChanged(System.IO.FileSystemEventArgs)" /> and some <see cref="M:System.IO.FileSystemWatcher.OnCreated(System.IO.FileSystemEventArgs)" /> and <see cref="M:System.IO.FileSystemWatcher.OnDeleted(System.IO.FileSystemEventArgs)" /> events might be raised. Moving a file is a complex operation that consists of multiple simple operations, therefore raising multiple events. Likewise, some applications (for example, antivirus software) might cause additional file system events that are detected by <see cref="T:System.IO.FileSystemWatcher" />.</para>
        </item>
        <item>
          <para>The <see cref="T:System.IO.FileSystemWatcher" /> can watch disks as long as they are not switched or removed. The <see cref="T:System.IO.FileSystemWatcher" /> does not raise events for CDs and DVDs, because time stamps and properties cannot change. Remote computers must have one of the required platforms installed for the component to function properly.</para>
        </item>
        <item>
          <para>If multiple <see cref="T:System.IO.FileSystemWatcher" /> objects are watching the same UNC path in Windows XP prior to Service Pack 1, or Windows 2000 SP2 or earlier, then only one of the objects will raise an event. On machines running Windows XP SP1 and newer, Windows 2000 SP3 or newer or Windows Server 2003, all <see cref="T:System.IO.FileSystemWatcher" /> objects will raise the appropriate events.</para>
        </item>
      </list>
      <para>Note that a <see cref="T:System.IO.FileSystemWatcher" /> may miss an event when the buffer size is exceeded. To avoid missing events, follow these guidelines:</para>
      <list type="bullet">
        <item>
          <para>Increase the buffer size by setting the <see cref="P:System.IO.FileSystemWatcher.InternalBufferSize" /> property.  </para>
        </item>
        <item>
          <para>Avoid watching files with long file names, because a long file name contributes to filling up the buffer. Consider renaming these files using shorter names.</para>
        </item>
        <item>
          <para>Keep your event handling code as short as possible.</para>
        </item>
      </list>
    </remarks>
  </class>
  <class name="InternalBufferOverflowException" fullname="System.IO.InternalBufferOverflowException" assembly="System">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>The exception thrown when the internal buffer overflows.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>In a <see cref="T:System.IO.FileSystemWatcher" />, when you are notified of file changes, the system stores those changes in a buffer the component creates and passes to the Application Programming Interfaces (APIs). If there are many changes in a short time, the buffer can easily overflow, resulting in an exception being thrown, which essentially loses all changes. To keep the buffer from overflowing, use the <see cref="P:System.IO.FileSystemWatcher.NotifyFilter" /> and <see cref="P:System.IO.FileSystemWatcher.IncludeSubdirectories" /> properties to filter out your unwanted change notifications. You can also increase the size of the internal buffer through the <see cref="P:System.IO.FileSystemWatcher.InternalBufferSize" /> property. However, increasing the size of the buffer is expensive, so keep the buffer as small as possible.</para>
    </remarks>
  </class>
  <class name="InvalidDataException" fullname="System.IO.InvalidDataException" assembly="System">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>The exception that is thrown when a data stream is in an invalid format.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>An <see cref="T:System.IO.InvalidDataException" /> is thrown when invalid data is detected in the data stream.</para>
    </remarks>
  </class>
  <class name="IODescriptionAttribute" fullname="System.IO.IODescriptionAttribute" assembly="System">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Sets the description visual designers can display when referencing an event, extender, or property.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>For more information about using attributes, see <format type="text/html"><a href="30386922-1E00-4602-9EBF-526B271A8B87">[&lt;topic://cpconExtendingMetadataUsingAttributes&gt;]</a></format>.</para>
    </remarks>
  </class>
  <class name="NotifyFilters" fullname="System.IO.NotifyFilters" assembly="System">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Specifies changes to watch for in a file or folder.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>You can combine the members of this enumeration to watch for more than one kind of change. For example, you can watch for changes in the size of a file or folder, and for changes in security settings. This raises an event anytime there is a change in size or security settings of a file or folder.</para>
    </remarks>
  </class>
  <class name="RenamedEventArgs" fullname="System.IO.RenamedEventArgs" assembly="System">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Provides data for the <see cref="E:System.IO.FileSystemWatcher.Renamed" /> event.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>This class inherits from <see cref="T:System.IO.FileSystemEventArgs" /> and extends it by adding an old name field and an old full path field to specify the previous name and full path of the affected file or directory.</para>
    </remarks>
  </class>
  <class name="RenamedEventHandler" fullname="System.IO.RenamedEventHandler" assembly="System">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Represents the method that will handle the <see cref="E:System.IO.FileSystemWatcher.Renamed" /> event of a <see cref="T:System.IO.FileSystemWatcher" /> class.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>When you create a <see cref="T:System.IO.RenamedEventHandler" /> delegate, you identify the method that will handle the event. To associate the event with your event handler, add an instance of the delegate to the event. The event handler is called whenever the event occurs, unless you remove the delegate. For more information about event handler delegates, see <format type="text/html"><a href="D98FD58B-FA4F-4598-8378-ADDF4355A115">[&lt;topic://cpconEventsDelegates&gt;]</a></format>.</para>
    </remarks>
  </class>
  <class name="WaitForChangedResult" fullname="System.IO.WaitForChangedResult" assembly="System">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Contains information on the change that occurred.</para>
    </summary>
    <remarks>To be added</remarks>
  </class>
  <class name="WatcherChangeTypes" fullname="System.IO.WatcherChangeTypes" assembly="System">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Changes that might occur to a file or directory.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Each <see cref="T:System.IO.WatcherChangeTypes" /> member is associated with an event in <see cref="T:System.IO.FileSystemWatcher" />. For more information on the events, see <see cref="E:System.IO.FileSystemWatcher.Created" />, <see cref="E:System.IO.FileSystemWatcher.Deleted" />, <see cref="E:System.IO.FileSystemWatcher.Changed" />, and <see cref="E:System.IO.FileSystemWatcher.Renamed" />.</para>
    </remarks>
  </class>
</elements>