Summary: A program which any RedHat/Mandrake user can utilize to create a rescue/restore CD.
Summary(fr): Un programme pour les utilisateurs de RedHat/Mandrake pour crer un CD de sauvegarde/restauration
Summary(it): Un programma per utenti RedHat/Mandrake per creare un CD di rescue
Name: mondo
Version: 1.41
Release: 1
License: GPL
Group: Applications/Archiving
Url: http://www.microwerks.net/~hugo/
Source: http://www.microwerks.net/~hugo/download/%{name}-%{version}.tgz
Packager: Hugo Rabson <hugo@firstlinux.net>
BuildRoot: %{_tmppath}/%{name}-%{version}
BuildArch: i386
Requires: mindi >= 0.59, bzip2 >= 0.9, afio, mkisofs, lilo, buffer, binutils
BuildRequires: newt-devel >= 0.50, slang-devel >= 1.4.2

%description
Objective
"""""""""
To produce a program which any RedHat/Mandrake user can utilize to create
a rescue/restore CD (or CDs, if their installation is >2Gb approx.).

%description -l fr
Objectif
""""""""
Mondo a pour but de fournir un programme utilisable par n'importe quel
utilsateur de RedHat/Mandrake pour crer un CD de sauvegarde/restauration
(ou plusieurs CDs, si son installation dpasse les 2Go environ).

%description -l it
Scopo
""""""""
Mondo e' un programma che permette a qualsiasi utente RedHat/Mandrake 
di creare un cd di rescue/restore (o piu' cd qualora l'installazione 
dovesse occupare piu' di 2Gb circa)

%prep
rm -rf $RPM_BUILD_ROOT

%setup -q

%build
./configure --prefix $RPM_BUILD_ROOT --enable-debug
make

%install
mkdir -p $RPM_BUILD_ROOT%{_datadir}/mondo
mkdir -p $RPM_BUILD_ROOT%{_bindir}
mkdir -p $RPM_BUILD_ROOT%{_mandir}/man1
for fname in mondoarchive mondorestore mondo-makefilelist ; do
    install -m 755 mondo/$fname $RPM_BUILD_ROOT%{_bindir}
    install -m 755 mondo/$fname $RPM_BUILD_ROOT%{_datadir}/mondo
done
install -m 755 mondo/mondoarchive.1 $RPM_BUILD_ROOT%{_mandir}/man1
install -m 755 mondo/restore-scripts.tgz $RPM_BUILD_ROOT%{_datadir}/mondo
# Make a link
cd $RPM_BUILD_ROOT%{_bindir}
ln -sf %{_datadir}/mondo/mondoarchive .
ln -sf %{_datadir}/mondo/mondorestore .
ln -sf %{_datadir}/mondo/mondo-makefilelist .

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%doc ChangeLog mondoarchive.1 left.html right.html layout.html
%dir %{_datadir}/mondo
%{_bindir}/mondorestore
%{_bindir}/mondoarchive
%{_bindir}/mondo-makefilelist
%{_datadir}/mondo/mondorestore
%{_datadir}/mondo/restore-scripts.tgz
%{_datadir}/mondo/mondoarchive
%{_datadir}/mondo/mondo-makefilelist
%{_mandir}/man1/mondoarchive.1*

%changelog
* Thu Mar 21 2002 Hugo Rabson <hugo@firstlinux.net> 1.41-1
- record hostname (Krzysztof Dubowik)

* Sun Mar 10 2002 Hugo Rabson <hugo@firstlinux.net> 1.40-7
- if '-L' then test for lzop; abort if not present
- if Mondo cannot figure out which boot loader the user is using,
  tell the user to read the manual and mention -l, -f switches
- abort if ramdisk not available
- updated man page (Mikael Hultgren)
- support multiple -I params (Mikael Hultgren+Randy Delfs)
- mkreiserfs -ff instead of -q (Andy Glass)

* Sun Mar 03 2002 Hugo Rabson <hugo@firstlinux.net> 1.40-6
- incorporated new config.guess, config.sub (Hctor Garca lvarez)
- updated manual to explain tmpfs needs to be in kernel (Mikael Hultgren)
- don't let non-root users run mondoarchive
- allow up to 50 chars in popup_and_get_string()'s input field
- tell user to use 'su -' instead of 'su' if they use 'su' by mistake
- make mondo-makefilelist more SUN-friendly, re: fstab (Andy Glass)
- modified 'Sliced bigfile #n' log entry to say '..#(n+1)'

* Sun Feb 24 2002 Hugo Rabson <hugo@firstlinux.net> 1.40-5
- improved the way Mondo installs itself (Mikael Hultgren)
- updated manpage
- touch /mnt/RESTORING/var/log/pacct after restoring
- added updated docs (Cafeole, Randy Delfs, Stan Benoit et al)
- added pico to restore-scripts.tgz; deprecated some scripts
- if restoring to /dev/ida/* or /dev/cciss/* then drop the 'p'
  before trying to discover the size of the partition itself
- support pathnames containing spaces (KirkJT)
- added -C switch, to treat CD burner almost as a tape streamer
- run post-nuke script if it exists
- put (char*)(&buf) instead of &buf when reading/writing biggiefiles' info

* Sun Feb 17 2002 Hugo Rabson <hugo@firstlinux.net> 1.40-3
- handle one-letter dirs properly (Ian Kent)
- when making ext3 fs, don't specify journal size (Cafeole)
- add tmp.mondo.NNNN to tempdir path, if tempdir is specified by user
- add mondo.scratch.NNN to scratchdir path, if scratchdir is specified by user
- beefed up RAID-related logging a bit
- exclude .journal files properly
- Italian patch (Michael Baldessari)
- let user exclude devices from mountlist with (e.g.) -E /dev/hda1

* Mon Feb 11 2002 Hugo Rabson <hugo@firstlinux.net> 1.40-2
- fixed typo in manpage (Mikael Hultgren)
- exclude "#"*"#" and *~ from tarball and source RPM
- updated manual (Randy Delfs)
- if errors apparently occurred, don't just say, "Errors occurred": ask the
  user to check the logs as a precaution
- put the correct version# in mondo/my-stuff.h
- in Nuke Mode, expand/contract mountlist proportionately to fill hard disks
- fix serious restore-time bug in tape/afio-handling code
- cdrecord is only required if burning CD's
- fixed silly bug in selective restore user interaction subroutine

* Sun Feb 10 2002 Hugo Rabson <hugo@firstlinux.net> 1.40-1
- set partition(s) bootable w/fdisk if appropriate
- cosmetic bugfixes
- changed get_phys_size_of_drive() to read value from fdisk, not dmesg
- if hard disk does not exist then warn user when editing mountlist
- if boot+floppy disk images were not created then don't offer to write them
  to disks; instead, mention the mindi.iso bootable CD images
- exclude each partition's .autofsck from backup
- fixed bug in CD restoration progress form
- changed many tempfilenames from mojo-jojo* to sensible, random names
- exclude /win386.swp from backup (Cafeole)

* Thu Feb 07 2002 Hugo Rabson <hugo@firstlinux.net> 1.38-2
- minor improvements to the NFS-handling code
- mondo-restore now records Mondo's version# in log
- fixed silly bug that makes 'current filelist #' progress form inaccurate
- fix typo in '10 seconds to abort' line; also, made 20 seconds

* Wed Feb 06 2002 Hugo Rabson <hugo@firstlinux.net> 1.38-1
- source code has been beautified (Stan Benoit)
- makefile, Config implemented (Stan Benoit)
- use /tmp/mondo-restore.cfg instead of all kinds of silly /tmp files
  at boot-time; slowly migrating to a proper /tmp/mondo-restore.cfg file
- changed 'retval+=load_raidtab()' to 'load_raidtab()'
- patch to make it easier to install Mondo almost anywhere (Ian Mortimer)
- proper, one-char switches replace the long-winded multi-char switches
  of 1.36 and earlier
- migrating from lots of /tmp files in ramdisk to a single configuration
  file on ramdisk, at /tmp/mondo-restore.cfg
- estimates the number of media required by this backup session
- changed 'retval+=load_raidtab()' to 'load_raidtab()'

* Fri Jan 25 2002 Hugo Rabson <hugo@firstlinux.net> 1.37-1
- proper 'selective restore' interface implemented
- if the user specifies boot loader or device, record those settings
- fixed cdrecord-related bug in .spec file
- if backing up specific paths - e.g. /usr/local/bin - then include
  /usr and /usr/local/ in filelist; don't backup /usr/* but do recreate
  /usr and /usr/local/; this is to help the selective restore subroutine
- user's BIOS is assumed not to be able to handle LILO's sector-seek merging
- switches --broken-bios, --debug and --chunk-size have been removed
- if user calls with --burn-cds 2 (nothing else) then find CDRW and continue
- if CD writer's speed is not specified then assume 2x
- better autodetection of CD writer
- set size is 5MB for tape users and CD users alike
- exclude /root/images/mondo from backup
- abort if PC has <32MB of RAM at backup-time; warn if <64MB

* Sun Jan 20 2002 Hugo Rabson <hugo@firstlinux.net> 1.36-1
- fixed v.minor bug in MakeFilelist()
- in mondo-archive, replaced calls to Die() with calls to FatalError()
- include .spec file in tarball
- if cdrecord v1.8 or older then abort: inadequate for Mondo's needs
- moved misc functions from mondo-archive to mondo-tarme.c
- prettier interface when preparing and formatting boot+data disks
- removed mondo-filelistchop and mondo-checksum from tarball
- when editing mountlist, warn if formats !supported by kernel (B. Hartin)
- don't try to run e2label on filesystems which aren't ext2 or ext3
- don't write to tape if already burning to CD (Kosaku Nagasaka)
- re-enabled and tested some CD-verifying code
- added buffer to RPM/tarball requirements
- set size is 4MB for tape users; 16MB for CD users
- files <16MB aren't chopped
- uses tmpfs for temp storage if backing up to tape
- (rudimentary) selective formatting
- log versions of afio, bzip2, etc.

* Thu Jan 10 2002 Hugo Rabson <hugo@firstlinux.net> 1.35-1
- NFS backup+restore support
- exclude Win2K hiberation file (Paul Rensing)
- fixed filelist.full/filelist.blah typo (Paul Rensing)
- unset TAPE at start of mondo-archive (Norm Crowfoot)
- if bzip is <v0.99 then abort
- if hard disk fills to capacity then abort
- tape support has been rewritten from ground up
- --post-nuke <tarball> will incorporate a tarball of tools and data files
  of the user's choosing in the boot CD/floppies; the tarball must contain
  an executable, 'post-nuke', which will be called at the end of Nuke Mode
- --text-mode forces Mondo Archive to use text only (no newt or ncurses)
- the deprecated scripts have now been disabled
- Mondo now lives in /usr/local/mondo
- boot floppy will use 'safe' LILO calls; boot CD will use 'fast' LILO calls
  unless --broken-bios is supplied in call to Mondo
- cdrecord's buffer is now 4 MB (was 16 MB)
- don't let user change mountlist entry from regular mountpt to 'image'
- mount -t (space was missing in mount_isodir())
- all calls to afio now use blocks of TAPE_BLOCK_SIZE KB and RAM buf of 8 MB
- added Peter Seidler <p.seidler@mail1.stofanet.dk>'s "Petris" game
- set size is now 16MB for CD users and 48MB for tape users
- --exclude-paths now drops the trailing '/' from param(s) if present
- tab-align /etc/fstab after hacking it

* Tue Dec 25 2001 Hugo Rabson <hugo@firstlinux.net> 1.34-1
- if /sbin or /usr/sbin are not in PATH then add them temporarily
- if --broken-bios then force LILO to run in backward-compatible mode
- tape users can boot from a single floppy now
- when archiving/restoring/verifying tape, skip the first 32MB
- fixed bugs in actually_verify_the_tapes()
- fixed some popen/pclose mismatches
- no longer run compare_a_biggiefile() right after restore_a_biggiefile(),
  as it can upset the restoration of biggiefiles which are spread across CD's

* Wed Dec 19 2001 Hugo Rabson <hugo@firstlinux.net> 1.33-8
- added --image-devs <dev> (<...>) switch
- improved --verify switch's code
- fixed bug in unmount_all_devices()
- exclude Windows' win386.swp file, if found
- include version of Mondo/Mindi in error log
- updated the FAQ
- when making differential backup, make sure to exclude nonexistent files
- --use-lzo now applies lzo to big files as well as afio archives
- changed all 'long long's to 'off_t's
- no longer aborts if /etc/lilo.conf does not exist
- moved FAQ's to FAQ file
- archive bigfiles one slice at a time; much less wasteful of space
- abort if user tries to backup a mounted partition as an _image_
  
* Sat Dec 15 2001 Hugo Rabson <hugo@firstlinux.net> 1.33-6
- misc bugfixes

* Fri Dec 14 2001 Hugo Rabson <hugo@firstlinux.net> 1.33-5
- improved error-reporting in the event of boot loader detection failure
- improved tape verification code
- dangerous support for backing up and restoring devices as images

* Thu Dec 13 2001 Hugo Rabson <hugo@firstlinux.net> 1.33-4
- updated FAQ
- limited GRUB support
- when calculating checksums, tell user %done and time remaining
- checksum catalog entry = filesize+mtime+ctime; don't call md5sum or cksum
- compile mondo-filelistchop and mondo-checksum with -O2 optimization
- when writing floppies, ask specifically for floppy #x (Randy Delfs)

* Wed Dec 12 2001 Hugo Rabson <hugo@firstlinux.net> 1.33-3
- supports --boot-loader and --boot-device to let user specify them
- fixed CDRW autodetection bug
- MONDO_PATH was misconfigured; is now "/usr/share/mondo"

* Wed Dec 12 2001 Hugo Rabson <hugo@firstlinux.net> 1.33-1
- don't extrapolate from /etc/raidtab to /tmp/mountlist; editor does it already
- if user changes a partition's device, change it in raidtab too
- do not backup /tmp (somewhere in v1.3x, I stopped excluding /tmp)
- cosmetic fixes to mondo-prep.c and mondo-newt.c
- put quotes around chmod's parameter
- replace several system() calls with run_program_and_log_output() calls
- subtract 5% from max cap() of drives, when evaluating mountlist's sanity
- stablilo-me no longer tries to mark partitions as bootable
- tape users can now use --verify to verify backups w/o rebooting
- checksum calculated for every file backed up - for future expansion
- now, --differential backs up all files changed/added since last full backup

* Sun Dec 09 2001 Hugo Rabson <hugo@firstlinux.net> 1.32-2
- if no RAID devices after editing mountlist then delete raidtab
- don't try to mount RAID partitions (components of RAID dev)
- don't add partitions to mountlist when extrapolating from mountlist
  unless the partitions are not already present in mountlist
- don't format partitions if partitioning failed
- when user selects RAID level, establish whether said level is available

* Sun Dec 09 2001 Hugo Rabson <hugo@firstlinux.net> 1.32-1
- if user creates ISO images, the dest dir is /root/images/mondo now
- log_it() makes sure it only writes one \n on the end of each logged line
- detects if user is using GRUB/LILO/other; aborts if neither LILO nor GRUB
- passes the boot loader's name and device to Mindi, available at boot-time
- if Nuke or Interactive Restore runs w/o error then give user a friendly msg
- let user edit the device field when editing entry in mountlist
- if stablilo-me fails then restore original fstab and lilo.conf files
- added ISO Mode, to let user restore from ISO images in directory
- cosmetic fix to restore/compare phase window
- if backing up to ISO images then offer to write boot floppies too
- cleaned up compare + restore logging
- scratchdir was [path]/mondo.scratch.$$; was [path]/mondo.scratch

* Tue Dec 04 2001 Hugo Rabson <hugo@firstlinux.net> 1.31-1
- exclude each device's lost+found directory
- partition and set type in a 2-stage process (was 1-stage)
- mountlist editor now permits advanced editing of RAID devices
- fixed a silly bug that was causing freeze-up on <1% of systems
- cleaned up Compare Mode's logging a bit, to make it more legible
- exclude ext3's .journal files from backup
- '--my-kernel SUCKS' has been replaced with '--my-kernel FAILSAFE'
- softlink mondo-restore to /usr/bin/ before calling Mindi
- copy mondo-restore to Mondo's temp dir before calling Mindi
- don't try to compress MP3's, MPG's, WMV's or RA's
- cleaned up the C source code a lot
- mondo-tarme and mondo-restore are now compiled as dynamic executables
- now make boot/data floppies at end of backup, not beginning
- backup in alphabetical order now, not reverse-alpha
- cut back on excessively verbose logging at backup-time
- when vacuum-packing a partition, describe it as "(max size)", not "(0 MB)"
- if Compare Mode reports changed files /var/* and /etc/mtab only, then
  tell the user their archives are good despite the differences
- if swap is already mounted, don't abort: just say, 'swap already mounted'

* Wed Nov 28 2001 Hugo Rabson <hugo@firstlinux.net> 1.30-1
- cleaned up the C source code, the backup scripts and the installation scripts
- optimal set size is now 24MB
- scratchdir is /home/mondo.scratch by default
- does not backup ext3 journals anymore

* Thu Nov 15 2001 Hugo Rabson <hugo@firstlinux.net> 1.19-4
- check for presence of decompressor at restore-time; abort if not found
- run 'chmod -R 1777 /mnt/RESTORING/tmp' after restoring
- fixed bug in is_this_device_mounted()

* Sun Nov 11 2001 Hugo Rabson <hugo@firstlinux.net> 1.19-1
- fixed bugs in Compare Mode and mondo-archive's verification phase
- don't modify fstab or lilo.conf unless user wants to
- C code is now compiled without optimizations
- chmod /tmp 1777 before and after restoring data, just in case

* Sun Oct 28 2001 Hugo Rabson <hugo@firstlinux.net> 1.18-1
- fixed cosmetic bug in Mondo's '--help' documentation
- improved the Compare Mode for tape users

* Sat Oct 20 2001 Hugo Rabson <hugo@firstlinux.net> 1.17-3
- works with Red Hat 6.2 now

* Sat Oct 06 2001 Hugo Rabson <hugo@firstlinux.net> 1.16-1
- added pause-for-next-tape

* Mon Sep 03 2001 Hugo Rabson <hugo@firstlinux.net> 1.14-1
- ported mondo-tarme (which used to be a bash script) to C
- dropped mondo-askme






























































































