/* 
 *   Creation Date: <2003/12/17 23:47:39 samuel>
 *   Time-stamp: <2003/12/17 23:47:40 samuel>
 *   
 *	<kbd_sh.h>
 *	
 *	
 *   
 *   Copyright (C) 2003 Samuel Rydh (samuel@ibrium.se)
 *   
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   version 2
 *   
 */

#ifndef _H_KBD_SH
#define _H_KBD_SH

/* OSI_KbdControl selectors */
#define kKbdCntrlActivate	1	/* osi-kbd receives key events */
#define kKbdCntrlSuspend	2	/* default driver receives key events */


/************************************************************************/
/*	keyboard remapping						*/
/************************************************************************/

/* Note: if these constants change, update keycodes.c and the bitmasks below  */
enum { 
	kConsoleKeytable=0,
	kRawXKeytable,
	kVNCKeytable,
	NUM_KEYCODE_TABLES
};

/* 0 means autogenerated */
#define	CONSOLE_RAW_KEYCODE		0x10000
#define	X_RAW_KEYCODE			0x20000
#define VNC_RAW_KEYCODE			0x40000
#define KEYCODE_TYPE_MASK		0x70000

static inline int keycode_index_to_bit( int v ) {
	return 1 << (16+v);
}
static inline int keycode_to_type_index( int type ) {
	int i,b;
	type &= KEYCODE_TYPE_MASK;
	for(b=CONSOLE_RAW_KEYCODE, i=0; b; b=b<<1, i++ )
		if( type & b )
			return i;
	return -1;
}


#endif   /* _H_KBD_SH */
