/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.VolatileImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.Timer;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.jhotdraw.app.EditableComponent;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.CompositeFigureEvent;
import org.jhotdraw.draw.CompositeFigureListener;
import org.jhotdraw.draw.Constrainer;
import org.jhotdraw.draw.DefaultDrawingViewTransferHandler;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FigureAdapter;
import org.jhotdraw.draw.FigureEvent;
import org.jhotdraw.draw.FigureListener;
import org.jhotdraw.draw.FigureSelectionEvent;
import org.jhotdraw.draw.FigureSelectionListener;
import org.jhotdraw.draw.GridConstrainer;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.HandleEvent;
import org.jhotdraw.draw.HandleListener;
import org.jhotdraw.util.ResourceBundleUtil;
import org.jhotdraw.util.ReversedList;

public class DefaultDrawingView
extends JComponent
implements DrawingView,
EditableComponent {
    private static final boolean DEBUG = false;
    private Drawing drawing;
    private Set<Figure> selectedFigures = new LinkedHashSet<Figure>();
    private LinkedList<Handle> selectionHandles = new LinkedList();
    private boolean isConstrainerVisible = false;
    private Constrainer visibleConstrainer = new GridConstrainer(8.0, 8.0);
    private Constrainer invisibleConstrainer = new GridConstrainer();
    private Handle secondaryHandleOwner;
    private Handle activeHandle;
    private LinkedList<Handle> secondaryHandles = new LinkedList();
    private boolean handlesAreValid = true;
    private transient Dimension cachedPreferredSize;
    private double scaleFactor = 1.0;
    private Point translation = new Point(0, 0);
    private int detailLevel;
    private DrawingEditor editor;
    private JLabel emptyDrawingLabel;
    protected BufferedImage backgroundTile;
    private FigureListener handleInvalidator = new FigureAdapter(){

        @Override
        public void figureHandlesChanged(FigureEvent figureEvent) {
            DefaultDrawingView.this.invalidateHandles();
        }
    };
    private transient Rectangle2D.Double cachedDrawingArea;
    public static final String DRAWING_DOUBLE_BUFFERED_PROPERTY = "drawingDoubleBuffered";
    private boolean isDrawingDoubleBuffered = true;
    private VolatileImage drawingBufferV;
    private BufferedImage drawingBufferNV;
    private Rectangle bufferedArea = new Rectangle();
    private Rectangle dirtyArea = new Rectangle(0, 0, -1, -1);
    private boolean paintEnabled = true;
    private static final boolean isWindows;
    private EventHandler eventHandler;

    @Override
    public void repaintHandles() {
        this.validateHandles();
        Rectangle rectangle = null;
        for (Handle handle : this.getSelectionHandles()) {
            if (rectangle == null) {
                rectangle = handle.getDrawingArea();
                continue;
            }
            rectangle.add(handle.getDrawingArea());
        }
        for (Handle handle : this.getSecondaryHandles()) {
            if (rectangle == null) {
                rectangle = handle.getDrawingArea();
                continue;
            }
            rectangle.add(handle.getDrawingArea());
        }
        if (rectangle != null) {
            this.repaint(rectangle);
        }
    }

    protected void drawBackground(Graphics2D graphics2D) {
        graphics2D.setColor(this.getBackground());
        graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    public DefaultDrawingView() {
        this.initComponents();
        this.eventHandler = this.createEventHandler();
        this.setToolTipText("dummy");
        this.setFocusable(true);
        this.addFocusListener(this.eventHandler);
        this.setTransferHandler(new DefaultDrawingViewTransferHandler());
        this.setBackground(new Color(0xB0B0B0));
        this.setOpaque(true);
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (color.getRGB() == 0xFFFFFF || color.getRGB() == -1) {
            new Throwable().printStackTrace();
        }
    }

    protected EventHandler createEventHandler() {
        return new EventHandler();
    }

    private void initComponents() {
        this.setLayout(null);
    }

    @Override
    public Drawing getDrawing() {
        return this.drawing;
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        if (this.getEditor() != null && this.getEditor().getTool() != null) {
            return this.getEditor().getTool().getToolTipText(this, mouseEvent);
        }
        return null;
    }

    public void setEmptyDrawingMessage(String string) {
        String string2;
        String string3 = string2 = this.emptyDrawingLabel == null ? null : this.emptyDrawingLabel.getText();
        if (string == null) {
            this.emptyDrawingLabel = null;
        } else {
            this.emptyDrawingLabel = new JLabel(string);
            this.emptyDrawingLabel.setHorizontalAlignment(0);
        }
        this.firePropertyChange("emptyDrawingMessage", string2, string);
        this.repaint();
    }

    public String getEmptyDrawingMessage() {
        return this.emptyDrawingLabel == null ? null : this.emptyDrawingLabel.getText();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        long l = System.currentTimeMillis();
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.setViewRenderingHints(graphics2D);
        this.drawBackground(graphics2D);
        this.drawCanvas(graphics2D);
        this.drawConstrainer(graphics2D);
        if (this.isDrawingDoubleBuffered()) {
            if (isWindows) {
                this.drawDrawingNonvolatileBuffered(graphics2D);
            } else {
                this.drawDrawingVolatileBuffered(graphics2D);
            }
        } else {
            this.drawDrawing(graphics2D);
        }
        this.drawHandles(graphics2D);
        this.drawTool(graphics2D);
    }

    protected void drawDrawingVolatileBuffered(Graphics2D graphics2D) {
        block20: {
            Rectangle rectangle = this.getVisibleRect();
            Point point = new Point(0, 0);
            if (this.bufferedArea.contains(rectangle) || this.bufferedArea.width >= rectangle.width && this.bufferedArea.height >= rectangle.height) {
                point.x = this.bufferedArea.x - rectangle.x;
                point.y = this.bufferedArea.y - rectangle.y;
                if (point.x > 0) {
                    this.dirtyArea.add(new Rectangle(this.bufferedArea.x - point.x, rectangle.y, point.x + this.bufferedArea.width - rectangle.width, this.bufferedArea.height));
                } else if (point.x < 0) {
                    this.dirtyArea.add(new Rectangle(this.bufferedArea.x + rectangle.width, rectangle.y, -point.x + this.bufferedArea.width - rectangle.width, this.bufferedArea.height));
                }
                if (point.y > 0) {
                    this.dirtyArea.add(new Rectangle(rectangle.x, this.bufferedArea.y - point.y, this.bufferedArea.width, point.y + this.bufferedArea.height - rectangle.height));
                } else if (point.y < 0) {
                    this.dirtyArea.add(new Rectangle(rectangle.x, this.bufferedArea.y + rectangle.height, this.bufferedArea.width, -point.y + this.bufferedArea.height - rectangle.height));
                }
                this.bufferedArea.x = rectangle.x;
                this.bufferedArea.y = rectangle.y;
            } else {
                this.bufferedArea.setBounds(rectangle);
                this.dirtyArea.setBounds(rectangle);
                if (this.drawingBufferV != null && (this.drawingBufferV.getWidth() != rectangle.width || this.drawingBufferV.getHeight() != rectangle.height)) {
                    this.drawingBufferV.flush();
                    this.drawingBufferV = null;
                }
            }
            while (true) {
                int n = this.drawingBufferV == null ? 2 : this.drawingBufferV.validate(this.getGraphicsConfiguration());
                switch (n) {
                    case 2: {
                        try {
                            this.drawingBufferV = this.getGraphicsConfiguration().createCompatibleVolatileImage(rectangle.width, rectangle.height, 3);
                        }
                        catch (OutOfMemoryError outOfMemoryError) {
                            this.drawingBufferV = null;
                        }
                        this.dirtyArea.setBounds(this.bufferedArea);
                        break;
                    }
                    case 1: {
                        this.dirtyArea.setBounds(this.bufferedArea);
                    }
                }
                if (this.drawingBufferV == null) {
                    this.drawDrawing(graphics2D);
                    break block20;
                }
                if (!this.dirtyArea.isEmpty()) {
                    Graphics2D graphics2D2 = this.drawingBufferV.createGraphics();
                    this.setViewRenderingHints(graphics2D2);
                    graphics2D2.setComposite(AlphaComposite.Src);
                    if (point.x != 0 || point.y != 0) {
                        graphics2D2.copyArea(Math.max(0, -point.x), Math.max(0, -point.y), this.drawingBufferV.getWidth() - Math.abs(point.x), this.drawingBufferV.getHeight() - Math.abs(point.y), point.x, point.y);
                        point.y = 0;
                        point.x = 0;
                    }
                    graphics2D2.translate(-this.bufferedArea.x, -this.bufferedArea.y);
                    graphics2D2.clip(this.dirtyArea);
                    graphics2D2.setBackground(new Color(0, true));
                    graphics2D2.clearRect(this.dirtyArea.x, this.dirtyArea.y, this.dirtyArea.width, this.dirtyArea.height);
                    graphics2D2.setComposite(AlphaComposite.SrcOver);
                    this.drawDrawing(graphics2D2);
                    graphics2D2.dispose();
                }
                if (!this.drawingBufferV.contentsLost()) {
                    graphics2D.drawImage(this.drawingBufferV, this.bufferedArea.x, this.bufferedArea.y, null);
                }
                if (!this.drawingBufferV.contentsLost()) break;
                this.dirtyArea.setBounds(this.bufferedArea);
            }
            this.dirtyArea.setSize(-1, -1);
        }
    }

    protected void drawDrawingNonvolatileBuffered(Graphics2D graphics2D) {
        Rectangle rectangle = this.getVisibleRect();
        Point point = new Point(0, 0);
        if (this.bufferedArea.contains(rectangle) || this.bufferedArea.width >= rectangle.width && this.bufferedArea.height >= rectangle.height) {
            point.x = this.bufferedArea.x - rectangle.x;
            point.y = this.bufferedArea.y - rectangle.y;
            if (point.x > 0) {
                this.dirtyArea.add(new Rectangle(this.bufferedArea.x - point.x, rectangle.y, point.x + this.bufferedArea.width - rectangle.width, this.bufferedArea.height));
            } else if (point.x < 0) {
                this.dirtyArea.add(new Rectangle(this.bufferedArea.x + rectangle.width, rectangle.y, -point.x + this.bufferedArea.width - rectangle.width, this.bufferedArea.height));
            }
            if (point.y > 0) {
                this.dirtyArea.add(new Rectangle(rectangle.x, this.bufferedArea.y - point.y, this.bufferedArea.width, point.y + this.bufferedArea.height - rectangle.height));
            } else if (point.y < 0) {
                this.dirtyArea.add(new Rectangle(rectangle.x, this.bufferedArea.y + rectangle.height, this.bufferedArea.width, -point.y + this.bufferedArea.height - rectangle.height));
            }
            this.bufferedArea.x = rectangle.x;
            this.bufferedArea.y = rectangle.y;
        } else {
            this.bufferedArea.setBounds(rectangle);
            this.dirtyArea.setBounds(rectangle);
            if (this.drawingBufferNV != null && (this.drawingBufferNV.getWidth() != rectangle.width || this.drawingBufferNV.getHeight() != rectangle.height)) {
                this.drawingBufferNV.flush();
                this.drawingBufferNV = null;
            }
        }
        int n = this.drawingBufferNV == null ? 2 : 0;
        switch (n) {
            case 2: {
                try {
                    this.drawingBufferNV = this.getGraphicsConfiguration().createCompatibleImage(rectangle.width, rectangle.height, 3);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    this.drawingBufferNV = null;
                }
                this.dirtyArea.setBounds(this.bufferedArea);
            }
        }
        if (this.drawingBufferNV == null) {
            this.drawDrawing(graphics2D);
            return;
        }
        if (!this.dirtyArea.isEmpty()) {
            Graphics2D graphics2D2 = this.drawingBufferNV.createGraphics();
            this.setViewRenderingHints(graphics2D2);
            graphics2D2.setComposite(AlphaComposite.Src);
            if (point.x != 0 || point.y != 0) {
                graphics2D2.copyArea(Math.max(0, -point.x), Math.max(0, -point.y), this.drawingBufferNV.getWidth() - Math.abs(point.x), this.drawingBufferNV.getHeight() - Math.abs(point.y), point.x, point.y);
                point.y = 0;
                point.x = 0;
            }
            graphics2D2.translate(-this.bufferedArea.x, -this.bufferedArea.y);
            graphics2D2.clip(this.dirtyArea);
            graphics2D2.setBackground(new Color(0, true));
            graphics2D2.clearRect(this.dirtyArea.x, this.dirtyArea.y, this.dirtyArea.width, this.dirtyArea.height);
            graphics2D2.setComposite(AlphaComposite.SrcOver);
            this.drawDrawing(graphics2D2);
            graphics2D2.dispose();
        }
        graphics2D.drawImage((Image)this.drawingBufferNV, this.bufferedArea.x, this.bufferedArea.y, null);
        this.dirtyArea.setSize(-1, -1);
    }

    @Override
    public void printComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.drawDrawing(graphics2D);
    }

    protected void setViewRenderingHints(Graphics2D graphics2D) {
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
    }

    protected Rectangle getCanvasViewBounds() {
        int n = -this.translation.x;
        int n2 = -this.translation.y;
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        if (this.getDrawing() != null) {
            Double d = this.getDrawing().get(AttributeKeys.CANVAS_WIDTH);
            Double d2 = this.getDrawing().get(AttributeKeys.CANVAS_HEIGHT);
            if (d != null && d2 != null) {
                Point point = this.drawingToView(new Point2D.Double(d, d2));
                n3 = point.x - n;
                n4 = point.y - n2;
            }
        }
        return new Rectangle(n, n2, n3, n4);
    }

    protected void drawCanvas(Graphics2D graphics2D) {
        Color color;
        Rectangle rectangle = this.getCanvasViewBounds();
        if (this.drawing == null) {
            color = AttributeKeys.CANVAS_FILL_COLOR.getDefaultValue();
        } else {
            color = this.drawing.get(AttributeKeys.CANVAS_FILL_COLOR);
            if (color != null) {
                color = new Color(color.getRGB() & 0xFFFFFF | (int)(this.drawing.get(AttributeKeys.CANVAS_FILL_OPACITY) * 255.0) << 24, true);
            }
        }
        if (color == null || color.getAlpha() != 255) {
            graphics2D.setPaint(this.getBackgroundPaint(rectangle.x, rectangle.y));
            graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        if (color != null) {
            graphics2D.setColor(color);
            graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    protected void drawConstrainer(Graphics2D graphics2D) {
        Shape shape = graphics2D.getClip();
        Rectangle rectangle = this.getCanvasViewBounds();
        graphics2D.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.getConstrainer().draw(graphics2D, this);
        graphics2D.setClip(shape);
    }

    protected void drawDrawing(Graphics2D graphics2D) {
        if (this.drawing != null) {
            if (this.drawing.getChildCount() == 0 && this.emptyDrawingLabel != null) {
                this.emptyDrawingLabel.setBounds(0, 0, this.getWidth(), this.getHeight());
                this.emptyDrawingLabel.paint(graphics2D);
            } else {
                Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
                AffineTransform affineTransform = graphics2D2.getTransform();
                affineTransform.translate(-this.translation.x, -this.translation.y);
                affineTransform.scale(this.scaleFactor, this.scaleFactor);
                graphics2D2.setTransform(affineTransform);
                this.drawing.setFontRenderContext(graphics2D2.getFontRenderContext());
                this.drawing.draw(graphics2D2);
                graphics2D2.dispose();
            }
        }
    }

    protected void drawHandles(Graphics2D graphics2D) {
        if (this.editor != null && this.editor.getActiveView() == this) {
            this.validateHandles();
            for (Handle handle : this.getSelectionHandles()) {
                handle.draw(graphics2D);
            }
            for (Handle handle : this.getSecondaryHandles()) {
                handle.draw(graphics2D);
            }
        }
    }

    protected void drawTool(Graphics2D graphics2D) {
        if (this.editor != null && this.editor.getActiveView() == this && this.editor.getTool() != null) {
            this.editor.getTool().draw(graphics2D);
        }
    }

    @Override
    public void setDrawing(Drawing drawing) {
        Drawing drawing2 = this.drawing;
        if (this.drawing != null) {
            this.drawing.removeCompositeFigureListener(this.eventHandler);
            this.drawing.removeFigureListener(this.eventHandler);
            this.clearSelection();
        }
        this.drawing = drawing;
        if (this.drawing != null) {
            this.drawing.addCompositeFigureListener(this.eventHandler);
            this.drawing.addFigureListener(this.eventHandler);
        }
        this.dirtyArea.add(this.bufferedArea);
        this.firePropertyChange("drawing", drawing2, drawing);
        this.revalidate();
        this.validateViewTranslation();
        this.paintEnabled = false;
        Timer timer = new Timer(10, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DefaultDrawingView.this.repaint();
                DefaultDrawingView.this.paintEnabled = true;
            }
        });
        timer.setRepeats(false);
        timer.start();
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.paintEnabled) {
            super.paint(graphics);
        }
    }

    protected void repaintDrawingArea(Rectangle2D.Double double_) {
        Rectangle rectangle = this.drawingToView(double_);
        rectangle.grow(1, 1);
        this.dirtyArea.add(rectangle);
        this.repaint(rectangle);
    }

    @Override
    public void invalidate() {
        this.invalidateDimension();
        super.invalidate();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this.drawingBufferNV != null) {
            this.drawingBufferNV.flush();
            this.drawingBufferNV = null;
        }
        if (this.drawingBufferNV != null) {
            this.drawingBufferNV.flush();
            this.drawingBufferNV = null;
        }
    }

    @Override
    public void addToSelection(Figure figure) {
        HashSet<Figure> hashSet = new HashSet<Figure>(this.selectedFigures);
        if (this.selectedFigures.add(figure)) {
            figure.addFigureListener(this.handleInvalidator);
            HashSet<Figure> hashSet2 = new HashSet<Figure>(this.selectedFigures);
            Rectangle rectangle = null;
            if (this.handlesAreValid && this.getEditor() != null) {
                for (Handle handle : figure.createHandles(this.detailLevel)) {
                    handle.setView(this);
                    this.selectionHandles.add(handle);
                    handle.addHandleListener(this.eventHandler);
                    if (rectangle == null) {
                        rectangle = handle.getDrawingArea();
                        continue;
                    }
                    rectangle.add(handle.getDrawingArea());
                }
            }
            this.fireSelectionChanged(hashSet, hashSet2);
            if (rectangle != null) {
                this.repaint(rectangle);
            }
        }
    }

    @Override
    public void addToSelection(Collection<Figure> collection) {
        HashSet<Figure> hashSet = new HashSet<Figure>(this.selectedFigures);
        HashSet<Figure> hashSet2 = new HashSet<Figure>(this.selectedFigures);
        boolean bl = false;
        Rectangle rectangle = null;
        for (Figure figure : collection) {
            if (!this.selectedFigures.add(figure)) continue;
            bl = true;
            hashSet2.add(figure);
            figure.addFigureListener(this.handleInvalidator);
            if (!this.handlesAreValid || this.getEditor() == null) continue;
            for (Handle handle : figure.createHandles(this.detailLevel)) {
                handle.setView(this);
                this.selectionHandles.add(handle);
                handle.addHandleListener(this.eventHandler);
                if (rectangle == null) {
                    rectangle = handle.getDrawingArea();
                    continue;
                }
                rectangle.add(handle.getDrawingArea());
            }
        }
        if (bl) {
            this.fireSelectionChanged(hashSet, hashSet2);
            if (rectangle != null) {
                this.repaint(rectangle);
            }
        }
    }

    @Override
    public void removeFromSelection(Figure figure) {
        HashSet<Figure> hashSet = new HashSet<Figure>(this.selectedFigures);
        if (this.selectedFigures.remove(figure)) {
            HashSet<Figure> hashSet2 = new HashSet<Figure>(this.selectedFigures);
            this.invalidateHandles();
            figure.removeFigureListener(this.handleInvalidator);
            this.fireSelectionChanged(hashSet, hashSet2);
            this.repaint();
        }
    }

    @Override
    public void toggleSelection(Figure figure) {
        if (this.selectedFigures.contains(figure)) {
            this.removeFromSelection(figure);
        } else {
            this.addToSelection(figure);
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.setCursor(Cursor.getPredefinedCursor(bl ? 0 : 3));
    }

    @Override
    public void selectAll() {
        HashSet<Figure> hashSet = new HashSet<Figure>(this.selectedFigures);
        this.selectedFigures.clear();
        for (Figure figure : this.drawing.getChildren()) {
            if (!figure.isSelectable()) continue;
            this.selectedFigures.add(figure);
        }
        HashSet<Figure> hashSet2 = new HashSet<Figure>(this.selectedFigures);
        this.invalidateHandles();
        this.fireSelectionChanged(hashSet, (Set<Figure>)hashSet2);
        this.repaint();
    }

    @Override
    public void clearSelection() {
        if (this.getSelectionCount() > 0) {
            HashSet<Figure> hashSet = new HashSet<Figure>(this.selectedFigures);
            this.selectedFigures.clear();
            HashSet<Figure> hashSet2 = new HashSet<Figure>(this.selectedFigures);
            this.invalidateHandles();
            this.fireSelectionChanged(hashSet, hashSet2);
        }
    }

    @Override
    public boolean isFigureSelected(Figure figure) {
        return this.selectedFigures.contains(figure);
    }

    @Override
    public Set<Figure> getSelectedFigures() {
        return Collections.unmodifiableSet(this.selectedFigures);
    }

    @Override
    public int getSelectionCount() {
        return this.selectedFigures.size();
    }

    private List<Handle> getSelectionHandles() {
        this.validateHandles();
        return Collections.unmodifiableList(this.selectionHandles);
    }

    private List<Handle> getSecondaryHandles() {
        this.validateHandles();
        return Collections.unmodifiableList(this.secondaryHandles);
    }

    private void invalidateHandles() {
        if (this.handlesAreValid) {
            this.handlesAreValid = false;
            Rectangle rectangle = null;
            for (Handle handle : this.selectionHandles) {
                handle.removeHandleListener(this.eventHandler);
                if (rectangle == null) {
                    rectangle = handle.getDrawingArea();
                } else {
                    rectangle.add(handle.getDrawingArea());
                }
                handle.dispose();
            }
            for (Handle handle : this.secondaryHandles) {
                handle.removeHandleListener(this.eventHandler);
                if (rectangle == null) {
                    rectangle = handle.getDrawingArea();
                } else {
                    rectangle.add(handle.getDrawingArea());
                }
                handle.dispose();
            }
            this.selectionHandles.clear();
            this.secondaryHandles.clear();
            this.setActiveHandle(null);
            if (rectangle != null) {
                this.repaint(rectangle);
            }
        }
    }

    private void validateHandles() {
        if (!this.handlesAreValid && this.getEditor() != null) {
            this.handlesAreValid = true;
            this.selectionHandles.clear();
            Rectangle rectangle = null;
            while (true) {
                for (Figure figure : this.getSelectedFigures()) {
                    for (Handle handle : figure.createHandles(this.detailLevel)) {
                        handle.setView(this);
                        this.selectionHandles.add(handle);
                        handle.addHandleListener(this.eventHandler);
                        if (rectangle == null) {
                            rectangle = handle.getDrawingArea();
                            continue;
                        }
                        rectangle.add(handle.getDrawingArea());
                    }
                }
                if (this.selectionHandles.size() != 0 || this.detailLevel == 0) break;
                this.detailLevel = 0;
            }
            if (rectangle != null) {
                this.repaint(rectangle);
            }
        }
    }

    @Override
    public Handle findHandle(Point point) {
        this.validateHandles();
        for (Handle handle : new ReversedList<Handle>(this.getSecondaryHandles())) {
            if (!handle.contains(point)) continue;
            return handle;
        }
        for (Handle handle : new ReversedList<Handle>(this.getSelectionHandles())) {
            if (!handle.contains(point)) continue;
            return handle;
        }
        return null;
    }

    @Override
    public Collection<Handle> getCompatibleHandles(Handle handle) {
        this.validateHandles();
        HashSet<Figure> hashSet = new HashSet<Figure>();
        LinkedList<Handle> linkedList = new LinkedList<Handle>();
        hashSet.add(handle.getOwner());
        linkedList.add(handle);
        for (Handle handle2 : this.getSelectionHandles()) {
            if (hashSet.contains(handle2.getOwner()) || !handle2.isCombinableWith(handle)) continue;
            hashSet.add(handle2.getOwner());
            linkedList.add(handle2);
        }
        return linkedList;
    }

    @Override
    public Figure findFigure(Point point) {
        return this.getDrawing().findFigure(this.viewToDrawing(point));
    }

    @Override
    public Collection<Figure> findFigures(Rectangle rectangle) {
        return this.getDrawing().findFigures(this.viewToDrawing(rectangle));
    }

    @Override
    public Collection<Figure> findFiguresWithin(Rectangle rectangle) {
        return this.getDrawing().findFiguresWithin(this.viewToDrawing(rectangle));
    }

    @Override
    public void addFigureSelectionListener(FigureSelectionListener figureSelectionListener) {
        this.listenerList.add(FigureSelectionListener.class, figureSelectionListener);
    }

    @Override
    public void removeFigureSelectionListener(FigureSelectionListener figureSelectionListener) {
        this.listenerList.remove(FigureSelectionListener.class, figureSelectionListener);
    }

    protected void fireSelectionChanged(Set<Figure> set, Set<Figure> set2) {
        if (this.listenerList.getListenerCount() > 0) {
            FigureSelectionEvent figureSelectionEvent = null;
            Object[] objectArray = this.listenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != FigureSelectionListener.class) continue;
                if (figureSelectionEvent == null) {
                    figureSelectionEvent = new FigureSelectionEvent(this, set, set2);
                }
                ((FigureSelectionListener)objectArray[i + 1]).selectionChanged(figureSelectionEvent);
            }
        }
    }

    protected void invalidateDimension() {
        this.cachedPreferredSize = null;
        this.cachedDrawingArea = null;
    }

    @Override
    public Constrainer getConstrainer() {
        return this.isConstrainerVisible() ? this.visibleConstrainer : this.invisibleConstrainer;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.cachedPreferredSize == null) {
            Rectangle2D.Double double_ = this.getDrawingArea();
            Double d = this.getDrawing() == null ? null : this.getDrawing().get(AttributeKeys.CANVAS_WIDTH);
            Double d2 = this.getDrawing() == null ? null : this.getDrawing().get(AttributeKeys.CANVAS_HEIGHT);
            Insets insets = this.getInsets();
            this.cachedPreferredSize = d == null || d2 == null ? new Dimension((int)((Math.max(0.0, double_.x) + double_.width) * this.scaleFactor) + insets.left + insets.right, (int)((Math.max(0.0, double_.y) + double_.height) * this.scaleFactor) + insets.top + insets.bottom) : new Dimension((int)((-Math.min(0.0, double_.x) + Math.max(Math.max(0.0, double_.x) + double_.width + Math.min(0.0, double_.x), d)) * this.scaleFactor) + insets.left + insets.right, (int)((-Math.min(0.0, double_.y) + Math.max(Math.max(0.0, double_.y) + double_.height + Math.min(0.0, double_.y), d2)) * this.scaleFactor) + insets.top + insets.bottom);
        }
        return (Dimension)this.cachedPreferredSize.clone();
    }

    protected Rectangle2D.Double getDrawingArea() {
        if (this.cachedDrawingArea == null) {
            this.cachedDrawingArea = this.drawing != null ? this.drawing.getDrawingArea() : new Rectangle2D.Double();
        }
        return (Rectangle2D.Double)this.cachedDrawingArea.clone();
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.validateViewTranslation();
    }

    private void validateViewTranslation() {
        if (this.getDrawing() == null) {
            this.translation.y = 0;
            this.translation.x = 0;
            return;
        }
        Point point = (Point)this.translation.clone();
        int n = this.getWidth();
        int n2 = this.getHeight();
        Insets insets = this.getInsets();
        Rectangle2D.Double double_ = this.getDrawingArea();
        Rectangle rectangle = new Rectangle((int)(double_.x * this.scaleFactor), (int)(double_.y * this.scaleFactor), (int)(double_.width * this.scaleFactor), (int)(double_.height * this.scaleFactor));
        Double d = this.getDrawing().get(AttributeKeys.CANVAS_WIDTH);
        Double d2 = this.getDrawing().get(AttributeKeys.CANVAS_HEIGHT);
        if (d == null || d2 == null) {
            int n3 = Math.max(n - insets.left - insets.right, (int)((Math.max(0.0, double_.x) + double_.width) * this.scaleFactor));
            int n4 = Math.max(n2 - insets.top - insets.bottom, (int)((Math.max(0.0, double_.y) + double_.height) * this.scaleFactor));
            this.translation.x = insets.top;
            this.translation.y = insets.left;
        } else {
            int n5 = (int)(d * this.scaleFactor);
            int n6 = (int)(d2 * this.scaleFactor);
            if (n5 < n) {
                this.translation.x = insets.left + (n - insets.left - insets.right - n5) / -2;
            }
            if (n6 < n2) {
                this.translation.y = insets.top + (n2 - insets.top - insets.bottom - n6) / -2;
            }
        }
        if (rectangle.y + rectangle.height - this.translation.y > n2 - insets.bottom) {
            this.translation.y = rectangle.y + rectangle.height - (n2 - insets.bottom);
        }
        if (Math.min(0, rectangle.y) - this.translation.y < insets.top) {
            this.translation.y = Math.min(0, rectangle.y) - insets.top;
        }
        if (rectangle.x + rectangle.width - this.translation.x > n - insets.right) {
            this.translation.x = rectangle.x + rectangle.width - (n - insets.right);
        }
        if (Math.min(0, rectangle.x) - this.translation.x < insets.left) {
            this.translation.x = Math.min(0, rectangle.x) - insets.left;
        }
        if (!point.equals(this.translation)) {
            this.bufferedArea.translate(point.x - this.translation.x, point.y - this.translation.y);
            this.fireViewTransformChanged();
        }
    }

    @Override
    public Point drawingToView(Point2D.Double double_) {
        return new Point((int)(double_.x * this.scaleFactor) - this.translation.x, (int)(double_.y * this.scaleFactor) - this.translation.y);
    }

    @Override
    public Rectangle drawingToView(Rectangle2D.Double double_) {
        return new Rectangle((int)(double_.x * this.scaleFactor) - this.translation.x, (int)(double_.y * this.scaleFactor) - this.translation.y, (int)(double_.width * this.scaleFactor), (int)(double_.height * this.scaleFactor));
    }

    @Override
    public Point2D.Double viewToDrawing(Point point) {
        return new Point2D.Double((double)(point.x + this.translation.x) / this.scaleFactor, (double)(point.y + this.translation.y) / this.scaleFactor);
    }

    @Override
    public Rectangle2D.Double viewToDrawing(Rectangle rectangle) {
        return new Rectangle2D.Double((double)(rectangle.x + this.translation.x) / this.scaleFactor, (double)(rectangle.y + this.translation.y) / this.scaleFactor, (double)rectangle.width / this.scaleFactor, (double)rectangle.height / this.scaleFactor);
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public double getScaleFactor() {
        return this.scaleFactor;
    }

    @Override
    public void setScaleFactor(double d) {
        double d2 = this.scaleFactor;
        this.scaleFactor = d;
        this.validateViewTranslation();
        this.dirtyArea.setBounds(this.bufferedArea);
        this.invalidateHandles();
        this.revalidate();
        this.repaint();
        this.firePropertyChange("scaleFactor", d2, d);
    }

    protected void fireViewTransformChanged() {
        for (Handle handle : this.selectionHandles) {
            handle.viewTransformChanged();
        }
        for (Handle handle : this.secondaryHandles) {
            handle.viewTransformChanged();
        }
    }

    @Override
    public void setHandleDetailLevel(int n) {
        if (n != this.detailLevel) {
            this.detailLevel = n;
            this.invalidateHandles();
            this.validateHandles();
        }
    }

    @Override
    public int getHandleDetailLevel() {
        return this.detailLevel;
    }

    @Override
    public AffineTransform getDrawingToViewTransform() {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(-this.translation.x, -this.translation.y);
        affineTransform.scale(this.scaleFactor, this.scaleFactor);
        return affineTransform;
    }

    @Override
    public void delete() {
        LinkedList linkedList = new LinkedList();
        List<Figure> list = this.drawing.sort(this.getSelectedFigures());
        for (Figure figure : list) {
            if (figure.isRemovable()) continue;
            this.getToolkit().beep();
            return;
        }
        Object object = new int[list.size()];
        for (int i = 0; i < ((Object)object).length; ++i) {
            object[i] = this.drawing.indexOf(list.get(i));
        }
        this.clearSelection();
        this.getDrawing().removeAll(list);
        this.getDrawing().fireUndoableEditHappened(new AbstractUndoableEdit((int[])object, list){
            final /* synthetic */ int[] val$deletedFigureIndices;
            final /* synthetic */ List val$deletedFigures;
            {
                this.val$deletedFigureIndices = nArray;
                this.val$deletedFigures = list;
            }

            @Override
            public String getPresentationName() {
                ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
                return resourceBundleUtil.getString("edit.delete.text");
            }

            @Override
            public void undo() throws CannotUndoException {
                super.undo();
                DefaultDrawingView.this.clearSelection();
                Drawing drawing = DefaultDrawingView.this.getDrawing();
                for (int i = 0; i < this.val$deletedFigureIndices.length; ++i) {
                    drawing.add(this.val$deletedFigureIndices[i], (Figure)this.val$deletedFigures.get(i));
                }
                DefaultDrawingView.this.addToSelection(this.val$deletedFigures);
            }

            @Override
            public void redo() throws CannotRedoException {
                super.redo();
                for (int i = 0; i < this.val$deletedFigureIndices.length; ++i) {
                    DefaultDrawingView.this.drawing.remove((Figure)this.val$deletedFigures.get(i));
                }
            }
        });
    }

    @Override
    public void duplicate() {
        List<Figure> list = this.getDrawing().sort(this.getSelectedFigures());
        HashMap<Figure, Figure> hashMap = new HashMap<Figure, Figure>(list.size());
        this.clearSelection();
        final ArrayList<Figure> arrayList = new ArrayList<Figure>(list.size());
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(5.0, 5.0);
        for (Figure figure : list) {
            Figure figure2 = (Figure)figure.clone();
            figure2.transform(affineTransform);
            arrayList.add(figure2);
            hashMap.put(figure, figure2);
            this.drawing.add(figure2);
        }
        for (Figure figure : arrayList) {
            figure.remap(hashMap, false);
        }
        this.addToSelection(arrayList);
        this.getDrawing().fireUndoableEditHappened(new AbstractUndoableEdit(){

            @Override
            public String getPresentationName() {
                ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
                return resourceBundleUtil.getString("edit.duplicate.text");
            }

            @Override
            public void undo() throws CannotUndoException {
                super.undo();
                DefaultDrawingView.this.getDrawing().removeAll(arrayList);
            }

            @Override
            public void redo() throws CannotRedoException {
                super.redo();
                DefaultDrawingView.this.getDrawing().addAll(arrayList);
            }
        });
    }

    @Override
    public void removeNotify(DrawingEditor drawingEditor) {
        this.editor = null;
        this.repaint();
    }

    @Override
    public void addNotify(DrawingEditor drawingEditor) {
        DrawingEditor drawingEditor2 = drawingEditor;
        this.editor = drawingEditor;
        this.firePropertyChange("editor", drawingEditor2, drawingEditor);
        this.invalidateHandles();
        this.repaint();
    }

    @Override
    public void setVisibleConstrainer(Constrainer constrainer) {
        Constrainer constrainer2 = this.visibleConstrainer;
        this.visibleConstrainer = constrainer;
        this.firePropertyChange("visibleConstrainer", constrainer2, constrainer);
    }

    @Override
    public Constrainer getVisibleConstrainer() {
        return this.visibleConstrainer;
    }

    @Override
    public void setInvisibleConstrainer(Constrainer constrainer) {
        Constrainer constrainer2 = this.invisibleConstrainer;
        this.invisibleConstrainer = constrainer;
        this.firePropertyChange("invisibleConstrainer", constrainer2, constrainer);
    }

    @Override
    public Constrainer getInvisibleConstrainer() {
        return this.invisibleConstrainer;
    }

    @Override
    public void setConstrainerVisible(boolean bl) {
        boolean bl2 = this.isConstrainerVisible;
        this.isConstrainerVisible = bl;
        this.firePropertyChange("constrainerVisible", bl2, bl);
        this.repaint();
    }

    @Override
    public boolean isConstrainerVisible() {
        return this.isConstrainerVisible;
    }

    public void setDrawingDoubleBuffered(boolean bl) {
        boolean bl2 = this.isDrawingDoubleBuffered;
        this.isDrawingDoubleBuffered = bl;
        if (!this.isDrawingDoubleBuffered && this.drawingBufferV != null) {
            this.drawingBufferV.flush();
            this.drawingBufferV = null;
        }
        if (!this.isDrawingDoubleBuffered && this.drawingBufferNV != null) {
            this.drawingBufferNV.flush();
            this.drawingBufferNV = null;
        }
        this.firePropertyChange(DRAWING_DOUBLE_BUFFERED_PROPERTY, bl2, bl);
    }

    public boolean isDrawingDoubleBuffered() {
        return this.isDrawingDoubleBuffered;
    }

    protected Paint getBackgroundPaint(int n, int n2) {
        if (this.backgroundTile == null) {
            this.backgroundTile = new BufferedImage(16, 16, 1);
            Graphics2D graphics2D = this.backgroundTile.createGraphics();
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(0, 0, 16, 16);
            graphics2D.setColor(new Color(0xDFDFDF));
            graphics2D.fillRect(0, 0, 8, 8);
            graphics2D.fillRect(8, 8, 8, 8);
            graphics2D.dispose();
        }
        return new TexturePaint(this.backgroundTile, new Rectangle(n, n2, this.backgroundTile.getWidth(), this.backgroundTile.getHeight()));
    }

    @Override
    public DrawingEditor getEditor() {
        return this.editor;
    }

    @Override
    public void setActiveHandle(Handle handle) {
        Handle handle2 = this.activeHandle;
        if (handle2 != null) {
            this.repaint(handle2.getDrawingArea());
        }
        this.activeHandle = handle;
        if (handle != null) {
            this.repaint(handle.getDrawingArea());
        }
        this.firePropertyChange("activeHandle", handle2, handle);
    }

    @Override
    public Handle getActiveHandle() {
        return this.activeHandle;
    }

    static {
        boolean bl = false;
        try {
            if (System.getProperty("os.name").toLowerCase().startsWith("win")) {
                bl = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        isWindows = bl;
    }

    private class EventHandler
    implements FigureListener,
    CompositeFigureListener,
    HandleListener,
    FocusListener {
        private EventHandler() {
        }

        @Override
        public void figureAdded(CompositeFigureEvent compositeFigureEvent) {
            if (DefaultDrawingView.this.drawing.getChildCount() == 1 && DefaultDrawingView.this.getEmptyDrawingMessage() != null) {
                DefaultDrawingView.this.repaint();
            } else {
                DefaultDrawingView.this.repaintDrawingArea(compositeFigureEvent.getInvalidatedArea());
            }
            DefaultDrawingView.this.invalidateDimension();
        }

        @Override
        public void figureRemoved(CompositeFigureEvent compositeFigureEvent) {
            if (DefaultDrawingView.this.drawing.getChildCount() == 0 && DefaultDrawingView.this.getEmptyDrawingMessage() != null) {
                DefaultDrawingView.this.repaint();
            } else {
                DefaultDrawingView.this.repaintDrawingArea(compositeFigureEvent.getInvalidatedArea());
            }
            DefaultDrawingView.this.removeFromSelection(compositeFigureEvent.getChildFigure());
            DefaultDrawingView.this.invalidateDimension();
        }

        @Override
        public void areaInvalidated(FigureEvent figureEvent) {
            DefaultDrawingView.this.repaintDrawingArea(figureEvent.getInvalidatedArea());
            DefaultDrawingView.this.invalidateDimension();
        }

        @Override
        public void areaInvalidated(HandleEvent handleEvent) {
            DefaultDrawingView.this.repaint(handleEvent.getInvalidatedArea());
            DefaultDrawingView.this.invalidateDimension();
        }

        @Override
        public void handleRequestSecondaryHandles(HandleEvent handleEvent) {
            DefaultDrawingView.this.secondaryHandleOwner = handleEvent.getHandle();
            DefaultDrawingView.this.secondaryHandles.clear();
            DefaultDrawingView.this.secondaryHandles.addAll(DefaultDrawingView.this.secondaryHandleOwner.createSecondaryHandles());
            for (Handle handle : DefaultDrawingView.this.secondaryHandles) {
                handle.setView(DefaultDrawingView.this);
                handle.addHandleListener(DefaultDrawingView.this.eventHandler);
            }
            DefaultDrawingView.this.repaint();
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            if (DefaultDrawingView.this.editor != null) {
                DefaultDrawingView.this.editor.setActiveView(DefaultDrawingView.this);
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
        }

        @Override
        public void handleRequestRemove(HandleEvent handleEvent) {
            DefaultDrawingView.this.selectionHandles.remove(handleEvent.getHandle());
            handleEvent.getHandle().dispose();
            DefaultDrawingView.this.invalidateHandles();
            DefaultDrawingView.this.repaint(handleEvent.getInvalidatedArea());
        }

        @Override
        public void attributeChanged(FigureEvent figureEvent) {
            if (figureEvent.getSource() == DefaultDrawingView.this.drawing) {
                AttributeKey attributeKey = figureEvent.getAttribute();
                if (attributeKey.equals(AttributeKeys.CANVAS_HEIGHT) || attributeKey.equals(AttributeKeys.CANVAS_WIDTH)) {
                    DefaultDrawingView.this.validateViewTranslation();
                    DefaultDrawingView.this.repaint();
                } else if (attributeKey.equals(AttributeKeys.CANVAS_FILL_COLOR) || attributeKey.equals(AttributeKeys.CANVAS_FILL_OPACITY)) {
                    DefaultDrawingView.this.repaint();
                } else {
                    DefaultDrawingView.this.repaintDrawingArea(figureEvent.getInvalidatedArea());
                }
            } else {
                DefaultDrawingView.this.repaintDrawingArea(figureEvent.getInvalidatedArea());
            }
        }

        @Override
        public void figureHandlesChanged(FigureEvent figureEvent) {
        }

        @Override
        public void figureChanged(FigureEvent figureEvent) {
            DefaultDrawingView.this.repaintDrawingArea(figureEvent.getInvalidatedArea());
        }

        @Override
        public void figureAdded(FigureEvent figureEvent) {
        }

        @Override
        public void figureRemoved(FigureEvent figureEvent) {
        }

        @Override
        public void figureRequestRemove(FigureEvent figureEvent) {
        }
    }
}

