/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.util;

import org.jhotdraw.framework.JHotDrawRuntimeException;
import org.jhotdraw.util.VersionControlStrategy;
import org.jhotdraw.util.VersionManagement;
import org.jhotdraw.util.VersionRequester;

public class StandardVersionControlStrategy
implements VersionControlStrategy {
    private VersionRequester myVersionRequester;

    public StandardVersionControlStrategy(VersionRequester versionRequester) {
        this.setVersionRequester(versionRequester);
    }

    public void assertCompatibleVersion() {
        String[] stringArray = this.getVersionRequester().getRequiredVersions();
        if (stringArray.length == 0) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!this.isCompatibleVersion(stringArray[i])) continue;
            return;
        }
        this.handleIncompatibleVersions();
    }

    protected void handleIncompatibleVersions() {
        String[] stringArray = this.getVersionRequester().getRequiredVersions();
        StringBuffer stringBuffer = new StringBuffer("[");
        for (int i = 0; i < stringArray.length - 1; ++i) {
            stringBuffer.append(stringArray[i] + ", ");
        }
        if (stringArray.length > 0) {
            stringBuffer.append(stringArray[stringArray.length - 1]);
        }
        stringBuffer.append("]");
        throw new JHotDrawRuntimeException("Incompatible version of JHotDraw found: " + VersionManagement.getJHotDrawVersion() + " (expected: " + stringBuffer + ")");
    }

    protected boolean isCompatibleVersion(String string) {
        return VersionManagement.isCompatibleVersion(string);
    }

    private void setVersionRequester(VersionRequester versionRequester) {
        this.myVersionRequester = versionRequester;
    }

    protected VersionRequester getVersionRequester() {
        return this.myVersionRequester;
    }
}

