/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib.html;

import java.io.Serializable;
import org.jhotdraw.contrib.html.DisposableResourceHolder;

public class StandardDisposableResourceHolder
implements DisposableResourceHolder,
Serializable {
    private Object resource = null;
    private long disposeDelay = 60000L;
    private long lastTimeAccessed = 0L;
    private boolean isLocked = false;

    public StandardDisposableResourceHolder() {
    }

    public StandardDisposableResourceHolder(Object object) {
        this.resource = object;
        this.resetDelay();
    }

    public Object clone() {
        StandardDisposableResourceHolder standardDisposableResourceHolder = new StandardDisposableResourceHolder();
        standardDisposableResourceHolder.setDisposableDelay(this.getDisposableDelay());
        return standardDisposableResourceHolder;
    }

    public Object getResource() throws NullPointerException {
        if (this.resource != null) {
            this.resetDelay();
            return this.resource;
        }
        throw new NullPointerException();
    }

    public void setResource(Object object) {
        this.resource = object;
        this.resetDelay();
    }

    public void setDisposableDelay(long l) {
        this.disposeDelay = l;
    }

    public long getDisposableDelay() {
        return this.disposeDelay;
    }

    public void dispose() {
        this.resource = null;
    }

    public boolean isAvailable() {
        return this.resource != null;
    }

    public void lock() {
        this.isLocked = true;
    }

    public void unlock() {
        this.resetDelay();
        this.isLocked = false;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public long getLastTimeAccessed() {
        return this.lastTimeAccessed;
    }

    public void resetDelay() {
        this.lastTimeAccessed = System.currentTimeMillis();
    }
}

