/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib;

import java.awt.Component;
import java.awt.Container;
import javax.swing.JScrollPane;
import org.jhotdraw.contrib.Desktop;
import org.jhotdraw.contrib.DesktopEventService;
import org.jhotdraw.contrib.DesktopListener;
import org.jhotdraw.framework.DrawingView;

public class JScrollPaneDesktop
extends JScrollPane
implements Desktop {
    private DesktopEventService myDesktopEventService;

    public JScrollPaneDesktop() {
        this.setDesktopEventService(this.createDesktopEventService());
        this.setAlignmentX(0.0f);
        this.setVerticalScrollBarPolicy(22);
        this.setHorizontalScrollBarPolicy(32);
    }

    protected Component createContents(DrawingView drawingView) {
        return (Component)((Object)drawingView);
    }

    public DrawingView getActiveDrawingView() {
        return this.getDesktopEventService().getActiveDrawingView();
    }

    public void addToDesktop(DrawingView drawingView, int n) {
        this.getContainer().add(this.createContents(drawingView));
    }

    public void removeFromDesktop(DrawingView drawingView, int n) {
        this.getDesktopEventService().removeComponent(drawingView);
    }

    public void removeAllFromDesktop(int n) {
        this.getDesktopEventService().removeAllComponents();
    }

    public DrawingView[] getAllFromDesktop(int n) {
        return this.getDesktopEventService().getDrawingViews(this.getComponents());
    }

    public void addDesktopListener(DesktopListener desktopListener) {
        this.getDesktopEventService().addDesktopListener(desktopListener);
    }

    public void removeDesktopListener(DesktopListener desktopListener) {
        this.getDesktopEventService().removeDesktopListener(desktopListener);
    }

    private Container getContainer() {
        return this.getViewport();
    }

    protected DesktopEventService getDesktopEventService() {
        return this.myDesktopEventService;
    }

    private void setDesktopEventService(DesktopEventService desktopEventService) {
        this.myDesktopEventService = desktopEventService;
    }

    protected DesktopEventService createDesktopEventService() {
        return new DesktopEventService(this, this.getContainer());
    }

    public void updateTitle(String string) {
        this.setName(string);
    }
}

