/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.List;
import java.util.ListIterator;
import org.jhotdraw.contrib.Desktop;
import org.jhotdraw.contrib.DesktopEvent;
import org.jhotdraw.contrib.DesktopListener;
import org.jhotdraw.contrib.Helper;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.standard.NullDrawingView;
import org.jhotdraw.util.CollectionsFactory;

public class DesktopEventService {
    private List listeners = CollectionsFactory.current().createList();
    private DrawingView mySelectedView;
    private Container myContainer;
    private Desktop myDesktop;

    public DesktopEventService(Desktop desktop, Container container) {
        this.setDesktop(desktop);
        this.setContainer(container);
        this.getContainer().addContainerListener(this.createComponentListener());
    }

    private void setDesktop(Desktop desktop) {
        this.myDesktop = desktop;
    }

    protected Desktop getDesktop() {
        return this.myDesktop;
    }

    private void setContainer(Container container) {
        this.myContainer = container;
    }

    protected Container getContainer() {
        return this.myContainer;
    }

    public void addComponent(Component component) {
        this.getContainer().add(component);
    }

    public void removeComponent(DrawingView drawingView) {
        Component[] componentArray = this.getContainer().getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (drawingView != Helper.getDrawingView(componentArray[i])) continue;
            this.getContainer().remove(componentArray[i]);
            break;
        }
    }

    public void removeAllComponents() {
        this.getContainer().removeAll();
    }

    public void addDesktopListener(DesktopListener desktopListener) {
        this.listeners.add(desktopListener);
    }

    public void removeDesktopListener(DesktopListener desktopListener) {
        this.listeners.remove(desktopListener);
    }

    protected void fireDrawingViewAddedEvent(DrawingView drawingView) {
        ListIterator listIterator = this.listeners.listIterator(this.listeners.size());
        DesktopEvent desktopEvent = this.createDesktopEvent(this.getActiveDrawingView(), drawingView);
        while (listIterator.hasPrevious()) {
            DesktopListener desktopListener = (DesktopListener)listIterator.previous();
            desktopListener.drawingViewAdded(desktopEvent);
        }
    }

    protected void fireDrawingViewRemovedEvent(DrawingView drawingView) {
        ListIterator listIterator = this.listeners.listIterator(this.listeners.size());
        DesktopEvent desktopEvent = this.createDesktopEvent(this.getActiveDrawingView(), drawingView);
        while (listIterator.hasPrevious()) {
            DesktopListener desktopListener = (DesktopListener)listIterator.previous();
            desktopListener.drawingViewRemoved(desktopEvent);
        }
    }

    protected void fireDrawingViewSelectedEvent(DrawingView drawingView, DrawingView drawingView2) {
        ListIterator listIterator = this.listeners.listIterator(this.listeners.size());
        DesktopEvent desktopEvent = this.createDesktopEvent(drawingView, drawingView2);
        while (listIterator.hasPrevious()) {
            DesktopListener desktopListener = (DesktopListener)listIterator.previous();
            desktopListener.drawingViewSelected(desktopEvent);
        }
    }

    protected DesktopEvent createDesktopEvent(DrawingView drawingView, DrawingView drawingView2) {
        return new DesktopEvent(this.getDesktop(), drawingView2, drawingView);
    }

    public DrawingView[] getDrawingViews(Component[] componentArray) {
        List list = CollectionsFactory.current().createList();
        for (int i = 0; i < componentArray.length; ++i) {
            DrawingView drawingView = Helper.getDrawingView(componentArray[i]);
            if (drawingView == null) continue;
            list.add(drawingView);
        }
        DrawingView[] drawingViewArray = new DrawingView[list.size()];
        list.toArray(drawingViewArray);
        return drawingViewArray;
    }

    public DrawingView getActiveDrawingView() {
        return this.mySelectedView;
    }

    protected void setActiveDrawingView(DrawingView drawingView) {
        this.mySelectedView = drawingView;
    }

    protected ContainerListener createComponentListener() {
        return new ContainerAdapter(){

            public void componentAdded(ContainerEvent containerEvent) {
                DrawingView drawingView = Helper.getDrawingView((Container)containerEvent.getChild());
                DrawingView drawingView2 = DesktopEventService.this.getActiveDrawingView();
                if (drawingView != null) {
                    DesktopEventService.this.fireDrawingViewAddedEvent(drawingView);
                    DesktopEventService.this.setActiveDrawingView(drawingView);
                    DesktopEventService.this.fireDrawingViewSelectedEvent(drawingView2, DesktopEventService.this.getActiveDrawingView());
                }
            }

            public void componentRemoved(ContainerEvent containerEvent) {
                DrawingView drawingView = Helper.getDrawingView((Container)containerEvent.getChild());
                if (drawingView != null) {
                    DrawingView drawingView2 = DesktopEventService.this.getActiveDrawingView();
                    DesktopEventService.this.setActiveDrawingView(NullDrawingView.getManagedDrawingView(drawingView2.editor()));
                    DesktopEventService.this.fireDrawingViewSelectedEvent(drawingView2, DesktopEventService.this.getActiveDrawingView());
                    DesktopEventService.this.fireDrawingViewRemovedEvent(drawingView);
                }
            }
        };
    }
}

