/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.applet;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.URL;
import java.util.StringTokenizer;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jhotdraw.figures.AttributeFigure;
import org.jhotdraw.figures.GroupCommand;
import org.jhotdraw.figures.UngroupCommand;
import org.jhotdraw.framework.Drawing;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureAttributeConstant;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.framework.Tool;
import org.jhotdraw.framework.ViewChangeListener;
import org.jhotdraw.standard.BufferedUpdateStrategy;
import org.jhotdraw.standard.ChangeAttributeCommand;
import org.jhotdraw.standard.DeleteCommand;
import org.jhotdraw.standard.DuplicateCommand;
import org.jhotdraw.standard.SelectionTool;
import org.jhotdraw.standard.SimpleUpdateStrategy;
import org.jhotdraw.standard.StandardDrawing;
import org.jhotdraw.standard.StandardDrawingView;
import org.jhotdraw.standard.ToolButton;
import org.jhotdraw.util.ColorMap;
import org.jhotdraw.util.CommandButton;
import org.jhotdraw.util.CommandChoice;
import org.jhotdraw.util.Filler;
import org.jhotdraw.util.Iconkit;
import org.jhotdraw.util.PaletteButton;
import org.jhotdraw.util.PaletteLayout;
import org.jhotdraw.util.PaletteListener;
import org.jhotdraw.util.StandardVersionControlStrategy;
import org.jhotdraw.util.StorableInput;
import org.jhotdraw.util.UndoManager;
import org.jhotdraw.util.VersionControlStrategy;
import org.jhotdraw.util.VersionManagement;
import org.jhotdraw.util.VersionRequester;

public class DrawApplet
extends JApplet
implements DrawingEditor,
PaletteListener,
VersionRequester {
    private transient Drawing fDrawing;
    private transient Tool fTool;
    private transient DrawingView fView;
    private transient ToolButton fDefaultToolButton;
    private transient ToolButton fSelectedToolButton;
    private transient boolean fSimpleUpdate;
    private transient JButton fUpdateButton;
    private transient JComboBox fFrameColor;
    private transient JComboBox fFillColor;
    private transient JComboBox fTextColor;
    private transient JComboBox fArrowChoice;
    private transient JComboBox fFontChoice;
    private transient UndoManager myUndoManager;
    static String fgUntitled = "untitled";
    private static final String fgDrawPath = "/org/jhotdraw/";
    public static final String IMAGES = "/org/jhotdraw/images/";
    static /* synthetic */ Class class$org$jhotdraw$applet$DrawApplet;

    public void init() {
        this.createIconkit();
        this.getVersionControlStrategy().assertCompatibleVersion();
        this.setUndoManager(new UndoManager());
        this.getContentPane().setLayout(new BorderLayout());
        this.fView = this.createDrawingView();
        JPanel jPanel = this.createAttributesPanel();
        this.createAttributeChoices(jPanel);
        this.getContentPane().add("North", jPanel);
        JPanel jPanel2 = this.createToolPalette();
        this.createTools(jPanel2);
        this.getContentPane().add("West", jPanel2);
        this.getContentPane().add("Center", (Component)((Object)this.view()));
        JPanel jPanel3 = this.createButtonPanel();
        this.createButtons(jPanel3);
        this.getContentPane().add("South", jPanel3);
        this.initDrawing();
        this.setupAttributes();
    }

    public void addViewChangeListener(ViewChangeListener viewChangeListener) {
    }

    public void removeViewChangeListener(ViewChangeListener viewChangeListener) {
    }

    protected Iconkit createIconkit() {
        return new Iconkit(this);
    }

    protected JPanel createAttributesPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new PaletteLayout(2, new Point(2, 2), false));
        return jPanel;
    }

    protected void createAttributeChoices(JPanel jPanel) {
        jPanel.add(new JLabel("Fill"));
        this.fFillColor = this.createColorChoice(FigureAttributeConstant.FILL_COLOR);
        jPanel.add(this.fFillColor);
        jPanel.add(new JLabel("Text"));
        this.fTextColor = this.createColorChoice(FigureAttributeConstant.TEXT_COLOR);
        jPanel.add(this.fTextColor);
        jPanel.add(new JLabel("Pen"));
        this.fFrameColor = this.createColorChoice(FigureAttributeConstant.FRAME_COLOR);
        jPanel.add(this.fFrameColor);
        jPanel.add(new JLabel("Arrow"));
        CommandChoice commandChoice = new CommandChoice();
        this.fArrowChoice = commandChoice;
        FigureAttributeConstant figureAttributeConstant = FigureAttributeConstant.ARROW_MODE;
        commandChoice.addItem(new ChangeAttributeCommand("none", figureAttributeConstant, new Integer(0), this));
        commandChoice.addItem(new ChangeAttributeCommand("at Start", figureAttributeConstant, new Integer(1), this));
        commandChoice.addItem(new ChangeAttributeCommand("at End", figureAttributeConstant, new Integer(2), this));
        commandChoice.addItem(new ChangeAttributeCommand("at Both", figureAttributeConstant, new Integer(3), this));
        jPanel.add(this.fArrowChoice);
        jPanel.add(new JLabel("Font"));
        this.fFontChoice = this.createFontChoice();
        jPanel.add(this.fFontChoice);
    }

    protected JComboBox createColorChoice(FigureAttributeConstant figureAttributeConstant) {
        CommandChoice commandChoice = new CommandChoice();
        for (int i = 0; i < ColorMap.size(); ++i) {
            commandChoice.addItem(new ChangeAttributeCommand(ColorMap.name(i), figureAttributeConstant, ColorMap.color(i), this));
        }
        return commandChoice;
    }

    protected JComboBox createFontChoice() {
        CommandChoice commandChoice = new CommandChoice();
        String[] stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        for (int i = 0; i < stringArray.length; ++i) {
            commandChoice.addItem(new ChangeAttributeCommand(stringArray[i], FigureAttributeConstant.FONT_NAME, stringArray[i], this));
        }
        return commandChoice;
    }

    protected JPanel createButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new PaletteLayout(2, new Point(2, 2), false));
        return jPanel;
    }

    protected void createButtons(JPanel jPanel) {
        jPanel.add(new Filler(24, 20));
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem(fgUntitled);
        String string = this.getParameter("DRAWINGS");
        if (string == null) {
            string = "";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            jComboBox.addItem(stringTokenizer.nextToken());
        }
        if (jComboBox.getItemCount() > 1) {
            jPanel.add(jComboBox);
        } else {
            jPanel.add(new JLabel(fgUntitled));
        }
        jComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    DrawApplet.this.loadDrawing((String)itemEvent.getItem());
                }
            }
        });
        jPanel.add(new Filler(6, 20));
        JButton jButton = new CommandButton(new DeleteCommand("Delete", this));
        jPanel.add(jButton);
        jButton = new CommandButton(new DuplicateCommand("Duplicate", this));
        jPanel.add(jButton);
        jButton = new CommandButton(new GroupCommand("Group", this));
        jPanel.add(jButton);
        jButton = new CommandButton(new UngroupCommand("Ungroup", this));
        jPanel.add(jButton);
        jButton = new JButton("Help");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DrawApplet.this.showHelp();
            }
        });
        jPanel.add(jButton);
        this.fUpdateButton = new JButton("Simple Update");
        this.fUpdateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DrawApplet.this.fSimpleUpdate) {
                    DrawApplet.this.setBufferedDisplayUpdate();
                } else {
                    DrawApplet.this.setSimpleDisplayUpdate();
                }
            }
        });
    }

    protected JPanel createToolPalette() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new PaletteLayout(2, new Point(2, 2)));
        return jPanel;
    }

    protected void createTools(JPanel jPanel) {
        Tool tool = this.createSelectionTool();
        this.fDefaultToolButton = this.createToolButton("/org/jhotdraw/images/SEL", "Selection Tool", tool);
        jPanel.add(this.fDefaultToolButton);
    }

    protected Tool createSelectionTool() {
        return new SelectionTool(this);
    }

    protected ToolButton createToolButton(String string, String string2, Tool tool) {
        return new ToolButton(this, string, string2, tool);
    }

    protected Drawing createDrawing() {
        return new StandardDrawing();
    }

    protected DrawingView createDrawingView() {
        return new StandardDrawingView(this, 410, 370);
    }

    public void paletteUserSelected(PaletteButton paletteButton) {
        ToolButton toolButton = (ToolButton)paletteButton;
        this.setTool(toolButton.tool(), toolButton.name());
        this.setSelected(toolButton);
    }

    public void paletteUserOver(PaletteButton paletteButton, boolean bl) {
        if (bl) {
            this.showStatus(paletteButton.name());
        } else if (this.fSelectedToolButton != null) {
            this.showStatus(this.fSelectedToolButton.name());
        }
    }

    public Drawing drawing() {
        return this.fDrawing;
    }

    public Tool tool() {
        return this.fTool;
    }

    public DrawingView view() {
        return this.fView;
    }

    public DrawingView[] views() {
        return new DrawingView[]{this.view()};
    }

    public void toolDone() {
        this.setTool(this.fDefaultToolButton.tool(), this.fDefaultToolButton.name());
        this.setSelected(this.fDefaultToolButton);
    }

    public void figureSelectionChanged(DrawingView drawingView) {
        this.setupAttributes();
    }

    public void viewSelectionChanged(DrawingView drawingView, DrawingView drawingView2) {
    }

    private void initDrawing() {
        this.fDrawing = this.createDrawing();
        this.view().setDrawing(this.fDrawing);
        this.toolDone();
    }

    private void setTool(Tool tool, String string) {
        if (this.fTool != null) {
            this.fTool.deactivate();
        }
        this.fTool = tool;
        if (this.fTool != null) {
            this.showStatus(string);
            this.fTool.activate();
        }
    }

    private void setSelected(ToolButton toolButton) {
        if (this.fSelectedToolButton != null) {
            this.fSelectedToolButton.reset();
        }
        this.fSelectedToolButton = toolButton;
        if (this.fSelectedToolButton != null) {
            this.fSelectedToolButton.select();
        }
    }

    protected void loadDrawing(String string) {
        if (string == fgUntitled) {
            this.fDrawing.release();
            this.initDrawing();
            return;
        }
        String string2 = this.getParameter(string);
        if (string2 != null) {
            this.readDrawing(string2);
        }
    }

    private void readDrawing(String string) {
        this.toolDone();
        String string2 = this.guessType(string);
        if (string2.equals("storable")) {
            this.readFromStorableInput(string);
        } else if (string2.equals("serialized")) {
            this.readFromObjectInput(string);
        } else {
            this.showStatus("Unknown file type");
        }
    }

    private void readFromStorableInput(String string) {
        try {
            URL uRL = new URL(this.getCodeBase(), string);
            InputStream inputStream = uRL.openStream();
            StorableInput storableInput = new StorableInput(inputStream);
            this.fDrawing.release();
            this.fDrawing = (Drawing)storableInput.readStorable();
            this.view().setDrawing(this.fDrawing);
        }
        catch (IOException iOException) {
            this.initDrawing();
            this.showStatus("Error:" + iOException);
        }
    }

    private void readFromObjectInput(String string) {
        try {
            URL uRL = new URL(this.getCodeBase(), string);
            InputStream inputStream = uRL.openStream();
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            this.fDrawing.release();
            this.fDrawing = (Drawing)objectInputStream.readObject();
            this.view().setDrawing(this.fDrawing);
        }
        catch (IOException iOException) {
            this.initDrawing();
            this.showStatus("Error: " + iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.initDrawing();
            this.showStatus("Class not found: " + classNotFoundException);
        }
    }

    private String guessType(String string) {
        if (string.endsWith(".draw")) {
            return "storable";
        }
        if (string.endsWith(".ser")) {
            return "serialized";
        }
        return "unknown";
    }

    private void setupAttributes() {
        Color color = (Color)AttributeFigure.getDefaultAttribute(FigureAttributeConstant.FRAME_COLOR);
        Color color2 = (Color)AttributeFigure.getDefaultAttribute(FigureAttributeConstant.FILL_COLOR);
        Integer n = (Integer)AttributeFigure.getDefaultAttribute(FigureAttributeConstant.ARROW_MODE);
        String string = (String)AttributeFigure.getDefaultAttribute(FigureAttributeConstant.FONT_NAME);
        FigureEnumeration figureEnumeration = this.view().selection();
        while (figureEnumeration.hasNextFigure()) {
            Figure figure = figureEnumeration.nextFigure();
            color = (Color)figure.getAttribute(FigureAttributeConstant.FRAME_COLOR);
            color2 = (Color)figure.getAttribute(FigureAttributeConstant.FILL_COLOR);
            n = (Integer)figure.getAttribute(FigureAttributeConstant.ARROW_MODE);
            string = (String)figure.getAttribute(FigureAttributeConstant.FONT_NAME);
        }
        this.fFrameColor.setSelectedIndex(ColorMap.colorIndex(color));
        this.fFillColor.setSelectedIndex(ColorMap.colorIndex(color2));
        if (n != null) {
            this.fArrowChoice.setSelectedIndex(n);
        }
        if (string != null) {
            this.fFontChoice.setSelectedItem(string);
        }
    }

    protected void setSimpleDisplayUpdate() {
        this.view().setDisplayUpdate(new SimpleUpdateStrategy());
        this.fUpdateButton.setText("Simple Update");
        this.fSimpleUpdate = true;
    }

    protected void setBufferedDisplayUpdate() {
        this.view().setDisplayUpdate(new BufferedUpdateStrategy());
        this.fUpdateButton.setText("Buffered Update");
        this.fSimpleUpdate = false;
    }

    protected void showHelp() {
        try {
            String string = this.getClass().getName().replace('.', '/');
            URL uRL = new URL(this.getCodeBase(), string + "Help.html");
            this.getAppletContext().showDocument(uRL, "Help");
        }
        catch (IOException iOException) {
            this.showStatus("Help file not found");
        }
    }

    protected void setUndoManager(UndoManager undoManager) {
        this.myUndoManager = undoManager;
    }

    public UndoManager getUndoManager() {
        return this.myUndoManager;
    }

    protected VersionControlStrategy getVersionControlStrategy() {
        return new StandardVersionControlStrategy(this);
    }

    public String[] getRequiredVersions() {
        String[] stringArray = new String[]{VersionManagement.getPackageVersion((class$org$jhotdraw$applet$DrawApplet == null ? (class$org$jhotdraw$applet$DrawApplet = DrawApplet.class$("org.jhotdraw.applet.DrawApplet")) : class$org$jhotdraw$applet$DrawApplet).getPackage())};
        return stringArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

