/*
 * Decompiled with CFR 0.152.
 */
package com.wombatinvasion.pmwikidraw;

import com.wombatinvasion.pmwikidraw.ColorPaletteChangeAttributeCommand;
import com.wombatinvasion.pmwikidraw.CommandButton;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import org.jhotdraw.figures.AttributeFigure;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.FigureAttributeConstant;
import org.jhotdraw.util.PaletteListener;
import org.jhotdraw.util.UndoableCommand;

public class PaletteCommandButton
extends CommandButton {
    private final FigureAttributeConstant constant;
    private final UndoableCommand undoableColourChanger;
    private final ColorPaletteChangeAttributeCommand colourChanger;

    public PaletteCommandButton(PaletteListener paletteListener, String string, String string2, FigureAttributeConstant figureAttributeConstant, DrawingEditor drawingEditor) {
        super(paletteListener, string, string2);
        this.constant = figureAttributeConstant;
        this.colourChanger = new ColorPaletteChangeAttributeCommand("Select...", figureAttributeConstant, drawingEditor);
        this.undoableColourChanger = new UndoableCommand(this.colourChanger);
        this.setCommand(this.colourChanger);
    }

    protected void paintChildren(Graphics graphics) {
        graphics.setColor(Color.lightGray);
        graphics.fill3DRect(2, 2, graphics.getClipBounds().width - 4, graphics.getClipBounds().height - 4, true);
        Object object = AttributeFigure.getDefaultAttribute(this.constant);
        if (object == null || !(object instanceof Color)) {
            object = Color.black;
        }
        graphics.setColor((Color)object);
        if (this.constant == FigureAttributeConstant.FILL_COLOR) {
            graphics.fillRect(6, 6, graphics.getClipBounds().width - 12, graphics.getClipBounds().height - 12);
        } else if (this.constant == FigureAttributeConstant.TEXT_COLOR) {
            graphics.setColor(Color.black);
            graphics.drawString("A", graphics.getClipBounds().width / 2 - 4, graphics.getClipBounds().height - 10);
            graphics.setColor((Color)object);
            graphics.fillRect(6, graphics.getClipBounds().height - 8, graphics.getClipBounds().width - 12, 4);
        } else {
            graphics.drawRect(6, 6, graphics.getClipBounds().width - 12, graphics.getClipBounds().height - 12);
        }
        super.paintChildren(graphics);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.isEnabled() && SwingUtilities.isRightMouseButton(mouseEvent)) {
            super.mouseClicked(mouseEvent);
        } else {
            this.colourChanger.setOnlyChangeMode(true);
            this.undoableColourChanger.execute();
            this.colourChanger.setOnlyChangeMode(false);
        }
    }
}

